/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.f3p.adempiere.util.ModelFactory;
import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MCharge;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPNGEntryType;
import org.compiere.model.MPNGEntryTypeJrLine;
import org.compiere.model.MPNGInvoice;
import org.compiere.model.MPNGInvoiceLine;
import org.compiere.model.MPNGJournalLine;
import org.compiere.model.MPNGJrLineInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MProcess;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PNGSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_CashLine;
import org.compiere.model.X_PNG_Journal;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class MPNGJournal
extends X_PNG_Journal
implements DocAction,
DocOptions {
    public static final String CASHBOOK_NAME_PREFIX = "PNG_CMC_";
    public static final String MSG_CONVUBALANCEDJOURNAL = "@PNG_ConvUnbalancedJournal@";
    public static final String MSG_NOCURRENCYBALANCELINE = "@PNG_NoCurrencyBalanceLine@";
    public static final String Q_HASCURRENCYCONVDIFF = "select C_Invoice.c_invoice_id  from PNG_JrLine_Invoice, PNG_JournalLine, PNG_Journal, C_Invoice, C_Conversion_Rate c, C_Conversion_Rate a   where PNG_Journal.png_journal_id = ?   and PNG_JournalLine.png_journal_id = PNG_Journal.png_journal_id   and PNG_JrLine_Invoice.png_journalline_id = PNG_JournalLine.png_journalline_id    and C_Invoice.c_invoice_id = PNG_JrLine_Invoice.c_invoice_id    and C_Invoice.c_currency_id = PNG_Journal.c_currency_id    and C_Invoice.dateacct <> PNG_Journal.dateacct    and c.c_currency_id = c_invoice.c_currency_id    and c.c_currency_id_to = ?    and c.validfrom <= PNG_Journal.dateacct    and c.validto >= PNG_Journal.dateacct    and c.ad_client_id in (0,PNG_Journal.ad_client_id)    and a.c_currency_id = c_invoice.c_currency_id    and a.c_currency_id_to = ?    and a.validfrom <= C_Invoice.dateacct    and a.validto >= C_Invoice.dateacct    and a.ad_client_id in (0,PNG_Journal.ad_client_id)    and c.dividerate <> a.dividerate union all  select C_Invoice.c_invoice_id  from PNG_JrLine_Invoice, PNG_JournalLine, PNG_Journal, C_Invoice  where PNG_Journal.png_journal_id = ?    and PNG_JournalLine.png_journal_id = PNG_Journal.png_journal_id    and PNG_JrLine_Invoice.png_journalline_id = PNG_JournalLine.png_journalline_id    and C_Invoice.c_invoice_id = PNG_JrLine_Invoice.c_invoice_id    and C_Invoice.c_currency_id <> PNG_Journal.c_currency_id ";
    private static final long serialVersionUID = -4987843018650715500L;
    private int m_iAcctSchema_Currency_ID = -1;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MDocType m_docType = null;

    public MPNGJournal(Properties ctx, int PNG_Journal_ID, String trxName) {
        super(ctx, PNG_Journal_ID, trxName);
        if (PNG_Journal_ID == 0) {
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPostingType("A");
            this.setTotalCr(Env.ZERO);
            this.setTotalDr(Env.ZERO);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MPNGJournal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPNGJournal(MPNGJournal original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setC_AcctSchema_ID(original.getC_AcctSchema_ID());
        this.setGL_Budget_ID(original.getGL_Budget_ID());
        this.setGL_Category_ID(original.getGL_Category_ID());
        this.setPostingType(original.getPostingType());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setControlAmt(original.getControlAmt());
        this.setC_Currency_ID(original.getC_Currency_ID());
        this.setC_ConversionType_ID(original.getC_ConversionType_ID());
        this.setCurrencyRate(original.getCurrencyRate());
    }

    public static MPNGJournal get(Properties ctx, int PNG_Journal_ID, String sTrx) {
        Query qET = new Query(ctx, "PNG_Journal", "PNG_Journal_ID= ?", sTrx);
        qET.setParameters(PNG_Journal_ID);
        return (MPNGJournal)qET.first();
    }

    public MPNGJournalLine[] getLines(boolean requery) {
        String whereClause = "PNG_Journal_ID=?";
        List<MPNGJournalLine> list = new Query(this.getCtx(), "PNG_JournalLine", "PNG_Journal_ID=?", this.get_TrxName()).setParameters(this.getPNG_Journal_ID()).setOrderBy("Line").list();
        MPNGJournalLine[] retValue = new MPNGJournalLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPNGInvoice[] getInvoices(boolean requery) {
        String whereClause = "PNG_Journal_ID=?";
        List<MPNGInvoice> list = new Query(this.getCtx(), "PNG_Invoice", "PNG_Journal_ID=?", this.get_TrxName()).setParameters(this.getPNG_Journal_ID()).setOrderBy("Line").list();
        MPNGInvoice[] retValue = new MPNGInvoice[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public void setDateAcct(Timestamp DateAcct) {
        super.setDateAcct(DateAcct);
    }

    public void setCurrency(int C_Currency_ID, int C_ConversionType_ID, BigDecimal CurrencyRate) {
        if (C_Currency_ID != 0) {
            this.setC_Currency_ID(C_Currency_ID);
        }
        if (C_ConversionType_ID != 0) {
            this.setC_ConversionType_ID(C_ConversionType_ID);
        }
        if (CurrencyRate != null && CurrencyRate.compareTo(Env.ZERO) == 0) {
            this.setCurrencyRate(CurrencyRate);
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        int noLine = 0;
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE PNG_Journal_ID=" + this.getPNG_Journal_ID();
        this.isInvoice();
        if (this.isJournal() || this.isCashJournal()) {
            noLine = DB.executeUpdate("UPDATE PNG_JournalLine " + set, this.get_TrxName());
        }
        this.log.fine(String.valueOf(processed) + " - Lines=" + noLine);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        return true;
    }

    @Override
    public String prepareIt() {
        MAcctSchemaGL png_gl;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        BigDecimal AmtSourceDr = this.getTotalDr();
        BigDecimal AmtSourceCr = this.getTotalCr();
        if (Env.ZERO.compareTo(this.getControlAmt()) != 0 && this.getControlAmt().compareTo(this.getTotalDr()) != 0) {
            this.m_processMsg = "@ControlAmtError@";
            return "IN";
        }
        if (!(AmtSourceDr.compareTo(AmtSourceCr) == 0 || (png_gl = MAcctSchemaGL.get(this.getCtx(), this.getC_AcctSchema_ID())) != null && png_gl.isUseSuspenseBalancing())) {
            this.m_processMsg = "@UnbalancedJornal@";
            return "IN";
        }
        if (!(this.getTotalConvDr().compareTo(this.getTotalConvCr()) == 0 || (png_gl = MAcctSchemaGL.get(this.getCtx(), this.getC_AcctSchema_ID())) != null && png_gl.isUseSuspenseBalancing())) {
            this.m_processMsg = MSG_CONVUBALANCEDJOURNAL;
            return "IN";
        }
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        if (this.isJournal()) {
            this.autoFillBPJournalLines();
            MJournalBatch batch = this.createJournal();
            batch.processIt("CO");
            batch.saveEx();
            if (!"CO".equals(batch.getDocStatus())) {
                this.m_processMsg = batch.getProcessMsg();
                return batch.getDocStatus();
            }
            this.m_processMsg = this.checkTargetPosting(batch);
            if (this.m_processMsg != null) {
                throw new AdempiereException(this.m_processMsg);
            }
            this.setGL_JournalBatch_ID(batch.get_ID());
        }
        if (this.isCashJournal()) {
            MPNGJournalLine[] mLines = this.getLines(true);
            if (mLines.length == 0) {
                throw new AdempiereException("Nessuna riga");
            }
            MPNGJournalLine[] mPNGJournalLineArray = this.getLines(true);
            int n = mPNGJournalLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPNGJournalLine mLine = mPNGJournalLineArray[n2];
                if (mLine.isInvEntryCr() && mLine.getAmtToAllocCr().signum() != 0 || mLine.isInvEntryDr() && mLine.getAmtToAllocDr().signum() != 0) {
                    throw new AdempiereException("Linea da allocare non completamente allocata a partite: " + mLine.getLine());
                }
                ++n2;
            }
            if (this.isCurrencyBalancingCheckNeeded() && this.getCurrencyBalanceLine() == null && this.getConvDRCRDiff().signum() != 0) {
                this.m_processMsg = MSG_NOCURRENCYBALANCELINE;
                return "IN";
            }
            this.autoFillBPJournalLines();
            MCash mCash = this.createCash();
            this.setC_Cash_ID(mCash.getC_Cash_ID());
            this.saveEx();
            boolean bRes = mCash.processIt("CO");
            mCash.saveEx();
            if (!bRes) {
                this.m_processMsg = mCash.getProcessMsg();
                mCash.setDocStatus("IN");
            } else {
                MCashLine[] mCashLines;
                this.m_processMsg = this.checkTargetPosting(mCash);
                if (this.m_processMsg != null) {
                    throw new AdempiereException(this.m_processMsg);
                }
                MCashLine[] mCashLineArray = mCashLines = mCash.getLines(true);
                int n3 = mCashLines.length;
                int n4 = 0;
                while (n4 < n3) {
                    MCashLine mLine = mCashLineArray[n4];
                    if (mLine.getC_Payment_ID() > 0 && !Util.isEmpty(mLine.getDescription(), true)) {
                        MPayment mPayment = ModelFactory.getPayment(this.getCtx(), mLine.getC_Payment_ID(), this.get_TrxName());
                        mPayment.setDocumentNo(mLine.getDescription());
                        mPayment.saveEx();
                    }
                    ++n4;
                }
            }
        }
        if (this.isInvoice()) {
            MInvoice invoice = this.createInvoice();
            invoice.processIt("CO");
            invoice.saveEx();
            if (!"CO".equals(invoice.getDocStatus())) {
                this.m_processMsg = invoice.getProcessMsg();
                return invoice.getDocStatus();
            }
            this.m_processMsg = this.checkTargetPosting(invoice);
            if (this.m_processMsg != null) {
                throw new AdempiereException(this.m_processMsg);
            }
            this.setC_Invoice_ID(invoice.getC_Invoice_ID());
            String numVat = invoice.get_ValueAsString("VATLedgerNo");
            String setf = " SET VATLedgerNo = '" + numVat + "' WHERE PNG_Journal_ID=" + this.getPNG_Journal_ID();
            DB.executeUpdate("UPDATE PNG_Invoice " + setf, this.get_TrxName());
        }
        if (this.isPayment()) {
            List payments = new Query(this.getCtx(), "C_Payment", "PNG_Journal_ID =? ", this.get_TrxName()).setParameters(this.getPNG_Journal_ID()).list();
            for (MPayment payment : payments) {
                payment.processIt("CO");
                payment.saveEx();
                if (!"CO".equals(payment.getDocStatus())) {
                    this.m_processMsg = payment.getProcessMsg();
                    return payment.getDocStatus();
                }
                this.m_processMsg = this.checkTargetPosting(payment);
                if (this.m_processMsg == null) continue;
                throw new AdempiereException(this.m_processMsg);
            }
        }
        this.setProcessed(true);
        this.setDocAction("RE");
        return "CO";
    }

    protected String checkTargetPosting(PO po) {
        if (MClient.isClientAccountingImmediate()) {
            po.load(this.get_TrxName());
            boolean bIsPosted = po.get_ValueAsBoolean("Posted");
            if (!bIsPosted && po instanceof DocAction) {
                return DocumentEngine.postImmediate(Env.getCtx(), po.getAD_Client_ID(), po.get_Table_ID(), po.get_ID(), true, po.get_TrxName());
            }
        }
        return null;
    }

    private void getDocType() {
        if (this.m_docType == null || this.m_docType.get_ID() != this.getC_DocType_ID()) {
            this.m_docType = new MDocType(this.getCtx(), this.getC_DocType_ID(), this.get_TrxName());
        }
    }

    public MPNGEntryType getEntryType() {
        Query qET = new Query(this.getCtx(), "PNG_EntryType", "PNG_EntryType_ID= ?", this.get_TrxName());
        qET.setParameters(this.getPNG_EntryType_ID());
        return (MPNGEntryType)qET.first();
    }

    public MPNGJournalLine getCurrencyBalanceLine() {
        MPNGJournalLine mDiffLine = null;
        MPNGJournalLine[] mPNGJournalLineArray = this.getLines(false);
        int n = mPNGJournalLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPNGJournalLine mPNGLine = mPNGJournalLineArray[n2];
            if (mPNGLine.isCopyDiff()) {
                mDiffLine = mPNGLine;
                break;
            }
            ++n2;
        }
        return mDiffLine;
    }

    public int getAcctSchema_Currency_ID() {
        if (this.m_iAcctSchema_Currency_ID <= 0) {
            this.m_iAcctSchema_Currency_ID = this.getC_AcctSchema().getC_Currency_ID();
        }
        return this.m_iAcctSchema_Currency_ID;
    }

    public boolean isCurrencyBalancingCheckNeeded() {
        if (this.isCashJournal() || this.isJournal() && this.getAcctSchema_Currency_ID() != this.getC_Currency_ID() && !super.isConvInput() && this.getLines(false).length > 1) {
            CPreparedStatement pstmt = DB.prepareStatement(Q_HASCURRENCYCONVDIFF, this.get_TrxName());
            ResultSet rs = null;
            boolean bAtLeastOne = false;
            try {
                try {
                    pstmt.setInt(1, this.getPNG_Journal_ID());
                    pstmt.setInt(2, this.getAcctSchema_Currency_ID());
                    pstmt.setInt(3, this.getAcctSchema_Currency_ID());
                    pstmt.setInt(4, this.getPNG_Journal_ID());
                    rs = pstmt.executeQuery();
                    bAtLeastOne = rs.next();
                }
                catch (SQLException e) {
                    throw new AdempiereException(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
            return !bAtLeastOne;
        }
        return false;
    }

    public BigDecimal getConvDRCRDiff() {
        BigDecimal bdCR = Env.ZERO;
        BigDecimal bdDR = Env.ZERO;
        int From_C_Currency_ID = this.getC_Currency_ID();
        int To_C_Currency_ID = this.getAcctSchema_Currency_ID();
        int C_ConversionType_ID = this.getC_ConversionType_ID();
        Timestamp tsConvDate = this.getDateAcct();
        MPNGJournalLine[] mPNGJournalLineArray = this.getLines(false);
        int n = mPNGJournalLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            BigDecimal bdConv;
            BigDecimal bdConv2;
            MPNGJrLineInvoice mJrLine;
            int n3;
            int n4;
            MPNGJrLineInvoice[] mPNGJrLineInvoiceArray;
            MPNGJournalLine mLine = mPNGJournalLineArray[n2];
            if (mLine.isInvEntryCr()) {
                mPNGJrLineInvoiceArray = mLine.getInvoiceLines(false);
                n4 = mPNGJrLineInvoiceArray.length;
                n3 = 0;
                while (n3 < n4) {
                    mJrLine = mPNGJrLineInvoiceArray[n3];
                    bdConv2 = MConversionRate.convert(this.getCtx(), mJrLine.getAmount(), From_C_Currency_ID, To_C_Currency_ID, tsConvDate, C_ConversionType_ID, this.getAD_Client_ID(), this.getAD_Org_ID());
                    bdCR = bdCR.add(bdConv2);
                    ++n3;
                }
            } else {
                bdConv = MConversionRate.convert(this.getCtx(), mLine.getAmtSourceCr(), From_C_Currency_ID, To_C_Currency_ID, tsConvDate, C_ConversionType_ID, this.getAD_Client_ID(), this.getAD_Org_ID());
                bdCR = bdCR.add(bdConv);
            }
            if (mLine.isInvEntryDr()) {
                mPNGJrLineInvoiceArray = mLine.getInvoiceLines(false);
                n4 = mPNGJrLineInvoiceArray.length;
                n3 = 0;
                while (n3 < n4) {
                    mJrLine = mPNGJrLineInvoiceArray[n3];
                    bdConv2 = MConversionRate.convert(this.getCtx(), mJrLine.getAmount(), From_C_Currency_ID, To_C_Currency_ID, tsConvDate, C_ConversionType_ID, this.getAD_Client_ID(), this.getAD_Org_ID());
                    bdDR = bdDR.add(bdConv2);
                    ++n3;
                }
            } else {
                bdConv = MConversionRate.convert(this.getCtx(), mLine.getAmtSourceDr(), From_C_Currency_ID, To_C_Currency_ID, tsConvDate, C_ConversionType_ID, this.getAD_Client_ID(), this.getAD_Org_ID());
                bdDR = bdDR.add(bdConv);
            }
            ++n2;
        }
        return bdCR.subtract(bdDR);
    }

    public boolean isJournal() {
        this.getDocType();
        return this.m_docType.getDocBaseType().equals("GLJ") || this.m_docType.getDocBaseType().equals("GLD");
    }

    public boolean isPayment() {
        this.getDocType();
        return this.m_docType.getDocBaseType().equals("APP") || this.m_docType.getDocBaseType().equals("CMA");
    }

    public boolean isInvoice() {
        this.getDocType();
        return this.m_docType.getDocBaseType().equals("API") || this.m_docType.getDocBaseType().equals("APC") || this.m_docType.getDocBaseType().equals("ARI") || this.m_docType.getDocBaseType() == "ARC";
    }

    public boolean isCashJournal() {
        this.getDocType();
        return this.m_docType.getDocBaseType().equals("CMC");
    }

    public MInvoice createInvoice() {
        MPNGInvoice pngInvoice = MPNGInvoice.getOfPNGJournal(this);
        MInvoice realinvoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        realinvoice.setAD_Client_ID(pngInvoice.getAD_Client_ID());
        realinvoice.setAD_Org_ID(pngInvoice.getAD_Org_ID());
        realinvoice.setC_BPartner_ID(pngInvoice.getC_BPartner_ID());
        realinvoice.setC_BPartner_Location_ID(pngInvoice.getC_BPartner_Location_ID());
        realinvoice.setC_Charge_ID(pngInvoice.getC_Charge_ID());
        realinvoice.setC_Currency_ID(pngInvoice.getC_Currency_ID());
        realinvoice.setC_DocType_ID(this.getC_DocType_ID());
        realinvoice.setC_PaymentTerm_ID(pngInvoice.getC_PaymentTerm_ID());
        realinvoice.setC_Project_ID(pngInvoice.getC_Project_ID());
        realinvoice.setDateAcct(pngInvoice.getDateAcct());
        realinvoice.setDateInvoiced(pngInvoice.getDateInvoiced());
        realinvoice.setC_DocTypeTarget_ID(this.getC_DocType_ID());
        realinvoice.setC_PaymentTerm_ID(pngInvoice.getC_PaymentTerm_ID());
        realinvoice.setPaymentRule(pngInvoice.getPaymentRule());
        realinvoice.setSalesRep_ID(pngInvoice.getSalesRep_ID());
        realinvoice.setM_PriceList_ID(pngInvoice.getM_PriceList_ID());
        realinvoice.set_Value("VATLedgerDate", (Object)pngInvoice.getVATLedgerDate());
        String sDocNo = pngInvoice.getDocumentNo();
        if (!StringUtils.isEmpty(sDocNo)) {
            realinvoice.setDocumentNo(sDocNo);
        }
        MPNGJournal j = new MPNGJournal(this.getCtx(), pngInvoice.getPNG_Journal_ID(), this.get_TrxName());
        realinvoice.setIsSOTrx(j.isSOTrx());
        realinvoice.setDescription(j.getDescription());
        realinvoice.saveEx();
        MPNGInvoiceLine[] mPNGInvoiceLineArray = pngInvoice.getLines(true);
        int n = mPNGInvoiceLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPNGInvoiceLine fromLine = mPNGInvoiceLineArray[n2];
            MInvoiceLine iline = new MInvoiceLine(realinvoice);
            iline.setC_Activity_ID(fromLine.getC_Activity_ID());
            iline.setC_Project_ID(fromLine.getC_Project_ID());
            iline.setDescription(fromLine.getDescription());
            iline.setLineNetAmt(fromLine.getLineNetAmt());
            iline.setLineTotalAmt(fromLine.getLineTotalAmt());
            iline.setTaxAmt(fromLine.getTaxAmt());
            iline.setC_Activity_ID(fromLine.getC_Activity_ID());
            iline.setC_Tax_ID(fromLine.getC_Tax_ID());
            iline.setQty(Env.ONE);
            iline.setPriceEntered(fromLine.getLineNetAmt());
            iline.setPriceActual(fromLine.getLineNetAmt());
            iline.setC_Charge_ID(fromLine.getC_Charge_ID());
            iline.saveEx();
            if (fromLine.isFixedAssetInvoice()) {
                MAssetAddition add = this.createAssetAddition(pngInvoice, fromLine);
                add.processIt("CO");
            }
            ++n2;
        }
        return realinvoice;
    }

    public MAssetAddition createAssetAddition(MPNGInvoice pngInvoice, MPNGInvoiceLine pngILine) {
        if (!pngILine.isFixedAssetInvoice()) {
            return null;
        }
        MAsset asset = new MAsset(this.getCtx(), 0, this.get_TrxName());
        asset.setIsOwned(true);
        asset.setIsInPosession(true);
        asset.setA_Asset_CreateDate(pngInvoice.getDateInvoiced());
        asset.setDescription(pngILine.getDescription());
        MAssetGroup mAssetGroup = new MAssetGroup(this.getCtx(), pngILine.getA_Asset_Group_ID(), this.get_TrxName());
        MAssetGroupAcct mAssetGroupAcc = (MAssetGroupAcct)new Query(this.getCtx(), "A_Asset_Group_Acct", "A_Asset_Group_ID = ?", this.get_TrxName()).setParameters(mAssetGroup.getA_Asset_Group_ID()).first();
        asset.setAssetGroup(mAssetGroup);
        asset.setC_BPartner_ID(pngInvoice.getC_BPartner_ID());
        MBPartner bp = new MBPartner(this.getCtx(), pngInvoice.getC_BPartner_ID(), null);
        String name = "";
        name = String.valueOf(name) + bp.getName() + "-" + pngInvoice.getDocumentNo();
        this.log.fine("name=" + name);
        asset.setName(name);
        asset.saveEx();
        MAssetAddition addition = new MAssetAddition(this.getCtx(), 0, this.get_TrxName());
        addition.setA_Asset_ID(asset.get_ID());
        addition.setAD_Org_ID(asset.getAD_Org_ID());
        addition.setPostingType(this.getPostingType());
        addition.setA_SourceType("MAN");
        addition.setSourceAmt(pngILine.getLineNetAmt());
        addition.setC_Charge_ID(pngILine.getC_Charge_ID());
        addition.setC_Currency_ID(this.getC_Currency_ID());
        addition.setC_ConversionType_ID(this.getC_ConversionType_ID());
        addition.setDateDoc(pngInvoice.getDateInvoiced());
        addition.setDateAcct(this.getDateAcct());
        addition.setDeltaUseLifeYears(mAssetGroupAcc.getUseLifeYears());
        addition.setDeltaUseLifeYears_F(mAssetGroupAcc.getUseLifeYears_F());
        addition.saveEx();
        return addition;
    }

    public MJournalBatch createJournal() {
        MJournalBatch batch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        batch.setAD_Client_ID(this.getAD_Client_ID());
        batch.setAD_Org_ID(this.getAD_Org_ID());
        batch.setC_Currency_ID(this.getC_Currency_ID());
        batch.setC_DocType_ID(this.getC_DocType_ID());
        batch.setGL_Category_ID(this.getGL_Category_ID());
        batch.setDescription(this.getDescription());
        batch.setDateDoc(this.getDateAcct());
        batch.setDateAcct(this.getDateAcct());
        batch.setC_Period_ID(this.retrivePeriod());
        batch.saveEx();
        MJournal realJournal = new MJournal(batch);
        realJournal.setAD_Client_ID(this.getAD_Client_ID());
        realJournal.setAD_Org_ID(this.getAD_Org_ID());
        realJournal.setC_AcctSchema_ID(this.getC_AcctSchema_ID());
        realJournal.setC_DocType_ID(this.getC_DocType_ID());
        realJournal.setC_Currency_ID(this.getC_Currency_ID());
        realJournal.setC_ConversionType_ID(this.getC_ConversionType_ID());
        realJournal.setCurrencyRate(this.getCurrencyRate());
        realJournal.setControlAmt(this.getControlAmt());
        realJournal.setDateAcct(this.getDateAcct());
        realJournal.setDateDoc(this.getDateAcct());
        realJournal.setDescription(this.getDescription());
        realJournal.setGL_Category_ID(this.getGL_Category_ID());
        realJournal.setPostingType(this.getPostingType());
        realJournal.setTotalDr(this.getTotalDr());
        realJournal.setTotalCr(this.getTotalCr());
        realJournal.setGL_JournalBatch_ID(batch.get_ID());
        realJournal.saveEx();
        MAccount acct = null;
        MPNGJournalLine[] mPNGJournalLineArray = this.getLines(true);
        int n = mPNGJournalLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MJournalLine jline;
            MPNGJournalLine fromline = mPNGJournalLineArray[n2];
            if (fromline.getAmtSourceDr().signum() != 0) {
                jline = new MJournalLine(realJournal);
                jline.setAD_Client_ID(fromline.getAD_Client_ID());
                jline.setAD_Org_ID(fromline.getAD_Org_ID());
                jline.setAmtSourceCr(Env.ZERO);
                jline.setAmtAcctCr(Env.ZERO);
                jline.setAmtSourceDr(fromline.getAmtAcctDr());
                jline.setAmtAcctDr(fromline.getAmtSourceDr());
                jline.setC_Currency_ID(realJournal.getC_Currency_ID());
                jline.setC_ConversionType_ID(realJournal.getC_ConversionType_ID());
                jline.setCurrencyRate(realJournal.getCurrencyRate());
                jline.setQty(Env.ONE);
                jline.setDateAcct(fromline.getDateAcct());
                jline.setDescription(fromline.getDescription());
                acct = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()), this.getC_AcctSchema_ID(), fromline.getAccountDr_ID(), 0, 0, fromline.getC_BPartnerDr_ID(), 0, 0, 0, fromline.getC_SalesRegionDr_ID(), fromline.getC_ProjectDr_ID(), fromline.getC_CampaignDr_ID(), fromline.getC_ActivityDr_ID(), fromline.getUser1Dr_ID(), fromline.getUser2Dr_ID(), 0, 0);
                acct.save();
                jline.setC_ValidCombination_ID(acct.get_ID());
                jline.saveEx();
            }
            if (fromline.getAmtSourceCr().signum() != 0) {
                jline = new MJournalLine(realJournal);
                jline.setAD_Client_ID(fromline.getAD_Client_ID());
                jline.setAD_Org_ID(fromline.getAD_Org_ID());
                jline.setAmtSourceDr(Env.ZERO);
                jline.setAmtAcctDr(Env.ZERO);
                jline.setAmtSourceCr(fromline.getAmtAcctCr());
                jline.setAmtAcctCr(fromline.getAmtSourceCr());
                jline.setC_ConversionType_ID(realJournal.getC_ConversionType_ID());
                jline.setCurrencyRate(realJournal.getCurrencyRate());
                jline.setC_Currency_ID(realJournal.getC_Currency_ID());
                jline.setQty(Env.ONE);
                jline.setDateAcct(fromline.getDateAcct());
                jline.setDescription(fromline.getDescription());
                acct = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()), this.getC_AcctSchema_ID(), fromline.getAccountCr_ID(), 0, 0, fromline.getC_BPartnerCr_ID(), 0, 0, 0, fromline.getC_SalesRegionCr_ID(), fromline.getC_ProjectCr_ID(), fromline.getC_CampaignCr_ID(), fromline.getC_ActivityCr_ID(), fromline.getUser1Cr_ID(), fromline.getUser2Cr_ID(), 0, 0);
                acct.save();
                jline.setC_ValidCombination_ID(acct.get_ID());
                jline.saveEx();
            }
            ++n2;
        }
        return batch;
    }

    public MCashBook getOrCreateCashBook() {
        Query qCashBook = new Query(this.getCtx(), "C_CashBook", "Name LIKE 'PNG_CMC_%' AND C_Currency_ID = ?", this.get_TrxName());
        qCashBook.setParameters(this.getC_Currency_ID()).setApplyAccessFilter(true).setClient_ID().setOnlyActiveRecords(true);
        MCashBook mCashBook = (MCashBook)qCashBook.first();
        if (mCashBook == null) {
            MCurrency mCurrency = MCurrency.get(this.getCtx(), this.getC_Currency_ID());
            mCashBook = new MCashBook(this.getCtx(), 0, this.get_TrxName());
            mCashBook.setC_Currency_ID(this.getC_Currency_ID());
            mCashBook.setName(CASHBOOK_NAME_PREFIX + mCurrency.getISO_Code());
            mCashBook.saveEx();
        }
        return mCashBook;
    }

    public MCash createCash() {
        MCash mCash = new MCash(this.getOrCreateCashBook(), this.getDateAcct());
        mCash.setDescription(this.getDescription());
        mCash.setDateAcct(this.getDateAcct());
        mCash.setDocStatus("DR");
        mCash.setDocAction("CO");
        mCash.saveEx();
        MTax mTaxDefault = MTax.get(this.getCtx(), Env.getContextAsInt(this.getCtx(), "#C_Tax_ID"));
        MPNGJournalLine[] mPNGJournalLineArray = this.getLines(true);
        int n = mPNGJournalLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MCashLine mCashLine;
            MPNGJournalLine mJournalLine = mPNGJournalLineArray[n2];
            if (!mJournalLine.isInvEntryDr() && mJournalLine.getAmtSourceDr().signum() > 0) {
                mCashLine = mJournalLine.createCashLine(mCash, mTaxDefault, true);
                mCashLine.setLine(mJournalLine.getLine() * 1000);
                mCashLine.saveEx();
                mJournalLine.setC_CashLineDr_ID(mCashLine.getC_CashLine_ID());
                mJournalLine.saveEx();
            }
            if (!mJournalLine.isInvEntryCr() && mJournalLine.getAmtSourceCr().signum() > 0) {
                mCashLine = mJournalLine.createCashLine(mCash, mTaxDefault, false);
                mCashLine.setLine(mJournalLine.getLine() * 1000 + 500);
                mCashLine.saveEx();
                mJournalLine.setC_CashLineCr_ID(mCashLine.getC_CashLine_ID());
                mJournalLine.saveEx();
            }
            if (mJournalLine.isInvEntryDr() || mJournalLine.isInvEntryCr()) {
                int iLineNo = mJournalLine.isInvEntryDr() ? mJournalLine.getLine() * 1000 : mJournalLine.getLine() * 1000 + 500;
                MPNGJrLineInvoice[] mPNGJrLineInvoiceArray = mJournalLine.getInvoiceLines(true);
                int n3 = mPNGJrLineInvoiceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MPNGJrLineInvoice mJrInvLine = mPNGJrLineInvoiceArray[n4];
                    MCashLine mCashLine2 = new MCashLine(mCash);
                    mCashLine2.setLine(++iLineNo);
                    mCashLine2.setDescription(mJournalLine.getDescription());
                    mCashLine2.setCashType("I");
                    mCashLine2.setC_Invoice_ID(mJrInvLine.getC_Invoice_ID());
                    mCashLine2.setC_Currency_ID(this.getC_Currency_ID());
                    mCashLine2.setAmount(mJrInvLine.getAmount());
                    mCashLine2.setDiscountAmt(mJrInvLine.getDiscountAmt());
                    mCashLine2.setWriteOffAmt(mJrInvLine.getWriteOffAmt());
                    mCashLine2.saveEx(this.get_TrxName());
                    mCashLine2.setC_Currency_ID(this.getC_Currency_ID());
                    mCashLine2.saveEx(this.get_TrxName());
                    mJrInvLine.setC_CashLine_ID(mCashLine2.getC_CashLine_ID());
                    mJrInvLine.saveEx(this.get_TrxName());
                    ++n4;
                }
            }
            ++n2;
        }
        return mCash;
    }

    public int retrivePeriod() {
        int C_Period_ID;
        block7: {
            Timestamp DateAcct = this.getDateAcct();
            if (DateAcct == null) {
                DateAcct = new Timestamp(System.currentTimeMillis());
            }
            C_Period_ID = 0;
            String sql = "SELECT C_Period_ID FROM C_Period WHERE C_Year_ID IN \t(SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID =  (SELECT C_Calendar_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)) AND ? BETWEEN StartDate AND EndDate AND IsActive='Y' AND PeriodType='S'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setTimestamp(2, DateAcct);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        C_Period_ID = rs.getInt(1);
                    }
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return C_Period_ID;
    }

    @Override
    public boolean voidIt() {
        return false;
    }

    @Override
    public boolean closeIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseAccrualIt() {
        boolean ok_reverse;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean bl = ok_reverse = this.reverseAccrualIt(this.getPNG_Journal_ID()) != null;
        if (!ok_reverse) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_reverse;
    }

    public MPNGJournal reverseAccrualIt(int PNG_JournalBatch_ID) {
        this.log.info(this.toString());
        MPNGJournal reverse = new MPNGJournal(this);
        reverse.setDateAcct(reverse.getDateAcct());
        String description = reverse.getDescription();
        description = description == null ? "** " + this.getDocumentNo() + " **" : String.valueOf(description) + " ** " + this.getDocumentNo() + " **";
        reverse.setDescription(description);
        if (!reverse.save()) {
            return null;
        }
        reverse.copyLinesFrom(this, null, 'C');
        if (!reverse.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reverse.getProcessMsg();
            return null;
        }
        reverse.setDocStatus("RE");
        reverse.setDocAction("--");
        if (!reverse.save()) {
            return null;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return reverse;
    }

    public int copyLinesFrom(MPNGJournal fromJournal, Timestamp dateAcct, char typeCR) {
        if (this.isProcessed() || fromJournal == null) {
            return 0;
        }
        int count = 0;
        MPNGJournalLine[] fromLines = fromJournal.getLines(false);
        int i = 0;
        while (i < fromLines.length) {
            MPNGJournalLine toLine = new MPNGJournalLine(this.getCtx(), 0, fromJournal.get_TrxName());
            PO.copyValues(fromLines[i], toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toLine.setPNG_Journal_ID(this.getPNG_Journal_ID());
            if (dateAcct != null) {
                toLine.setDateAcct(dateAcct);
            }
            if (typeCR == 'C') {
                toLine.setAmtSourceDr(fromLines[i].getAmtSourceDr().negate());
                toLine.setAmtSourceCr(fromLines[i].getAmtSourceCr().negate());
            } else if (typeCR == 'R') {
                toLine.setAmtSourceDr(fromLines[i].getAmtSourceCr());
                toLine.setAmtSourceCr(fromLines[i].getAmtSourceDr());
            }
            toLine.setIsGenerated(true);
            toLine.setProcessed(false);
            if (toLine.save()) {
                ++count;
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - JournalLines=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public static MPNGJournal copyFrom(MPNGJournal from, MPNGJournal to) {
        if (from.getPNG_Journal_ID() == 0) {
            throw new IllegalArgumentException("From Journal Batch not found GL_JournalBatch_ID=");
        }
        Timestamp dateact = to.getDateAcct();
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.setDateAcct(dateact);
        to.setPostingType("A");
        to.setTotalCr(Env.ZERO);
        to.setC_Cash_ID(0);
        to.setC_Invoice_ID(0);
        to.setGL_JournalBatch_ID(0);
        to.setTotalDr(Env.ZERO);
        to.setIsApproved(false);
        to.setIsPrinted(false);
        to.setPosted(false);
        to.setProcessed(false);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        if (!to.save()) {
            throw new IllegalStateException("Could not create Journal ");
        }
        int count = 0;
        if (to.isJournal() || to.isCashJournal()) {
            count = to.copyLineFrom(from, to.getDateAcct(), 'x');
        }
        if (count == 0) {
            throw new IllegalStateException("Could not create Journal  Details");
        }
        return to;
    }

    public int copyLineFrom(MPNGJournal fromJournal, Timestamp dateAcct, char typeCR) {
        if (this.isProcessed() || fromJournal == null) {
            return 0;
        }
        int count = 0;
        MPNGJournalLine[] fromLines = fromJournal.getLines(false);
        int i = 0;
        while (i < fromLines.length) {
            MPNGJournalLine toLine = new MPNGJournalLine(this.getCtx(), 0, fromJournal.get_TrxName());
            PO.copyValues(fromLines[i], toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toLine.setPNG_Journal_ID(this.getPNG_Journal_ID());
            if (dateAcct != null) {
                toLine.setDateAcct(dateAcct);
            }
            if (typeCR == 'C') {
                toLine.setAmtSourceDr(fromLines[i].getAmtSourceDr().negate());
                toLine.setAmtSourceCr(fromLines[i].getAmtSourceCr().negate());
            } else if (typeCR == 'R') {
                toLine.setAmtSourceDr(fromLines[i].getAmtSourceCr());
                toLine.setAmtSourceCr(fromLines[i].getAmtSourceDr());
            }
            toLine.setIsGenerated(false);
            toLine.setProcessed(false);
            toLine.setC_Period_ID(this.retrivePeriod());
            if (toLine.save()) {
                ++count;
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - JournalLines=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    public boolean reActivateIt() {
        int n;
        PO[] pOArray;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.isJournal()) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            MJournalBatch journal = new MJournalBatch(this.getCtx(), this.getGL_JournalBatch_ID(), this.get_TrxName());
            journal.processIt("RE");
            journal.deleteEx(true, this.get_TrxName());
            this.setGL_JournalBatch_ID(0);
            this.setDocAction("CO");
            this.setPosted(false);
            this.setProcessed(false);
            this.saveEx();
        }
        if (this.isInvoice()) {
            MPNGInvoice pngInvoice = MPNGInvoice.getOfPNGJournal(this);
            int nInvoice = this.getC_Invoice_ID();
            this.setC_Invoice_ID(0);
            MInvoice invoice = new MInvoice(this.getCtx(), nInvoice, this.get_TrxName());
            invoice.processIt("RC");
            invoice.saveEx();
            pngInvoice.setDocAction("CO");
            this.setPosted(false);
            this.setProcessed(false);
            this.saveEx();
            MProcess process = (MProcess)new Query(this.getCtx(), "AD_Process", "value = 'InvoiceDeleteREVO'", this.get_TrxName()).first();
            MPInstance instance = new MPInstance(process, nInvoice);
            pOArray = instance.getParameters();
            n = pOArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPInstancePara ip = pOArray[n2];
                if (ip.getParameterName().equals("C_Invoice_ID")) {
                    ip.setParameter("C_Invoice_ID", nInvoice);
                    if (ip.save()) break;
                    return false;
                }
                ++n2;
            }
            ProcessInfo pi = new ProcessInfo("InvoiceDeleteREVO", process.getAD_Process_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
            if (!process.processItWithoutTrxClose(pi, Trx.get(this.get_TrxName(), false))) {
                return false;
            }
            this.setDocAction("CO");
            this.setPosted(false);
            this.setProcessed(false);
            this.saveEx();
        }
        if (this.isPayment()) {
            List payments = new Query(this.getCtx(), "C_Payment", "PNG_Journal_ID =? ", this.get_TrxName()).setParameters(this.getPNG_Journal_ID()).list();
            for (MPayment payment : payments) {
                this.DeleteAllocation(payment.getC_Payment_ID());
                payment.processIt("RC");
                int revID = payment.getReversal_ID();
                payment.setReversal_ID(0);
                payment.setDocStatus("IP");
                payment.setProcessed(false);
                payment.saveEx();
                MPayment reversal = new MPayment(this.getCtx(), revID, this.get_TrxName());
                this.DeleteAllocation(payment.getC_Payment_ID());
                MFactAcct.deleteEx(MPayment.Table_ID, reversal.getC_Payment_ID(), this.get_TrxName());
                reversal.setReversal_ID(0);
                reversal.deleteEx(true);
                MFactAcct.deleteEx(MPayment.Table_ID, payment.getC_Payment_ID(), this.get_TrxName());
                this.setDocAction("CO");
                this.setPosted(false);
                this.setProcessed(false);
                this.saveEx();
            }
            this.setDocAction("CO");
            this.setPosted(false);
            this.setProcessed(false);
            this.saveEx();
        }
        if (this.isCashJournal()) {
            MPNGJournalLine[] mJournalLines;
            Query qAllocation = new Query(this.getCtx(), "C_AllocationHdr", "C_AllocationHdr_ID IN (select c_allocationhdr_id  from c_allocationline,c_cashline  where c_allocationline.c_cashline_id=c_cashline.c_cashline_id  and c_cashline.c_cash_id = ?) ", this.get_TrxName());
            qAllocation.setParameters(this.getC_Cash_ID());
            List lstAllocations = qAllocation.list();
            for (MAllocationHdr mAllocation : lstAllocations) {
                Query qFacts = new Query(this.getCtx(), "Fact_Acct", " AD_Table_ID = ? AND Record_ID = ?", this.get_TrxName());
                qFacts.setParameters(MAllocationHdr.Table_ID, mAllocation.getC_AllocationHdr_ID());
                List lstFacts = qFacts.list();
                Iterator iterator = lstFacts.iterator();
                while (iterator.hasNext()) {
                    MFactAcct mFactLine = (MFactAcct)iterator.next();
                    mFactLine.deleteEx(true);
                }
                mAllocation.deleteEx(true);
            }
            Query qFacts = new Query(this.getCtx(), "Fact_Acct", " AD_Table_ID = ? AND Record_ID = ?", this.get_TrxName());
            qFacts.setParameters(MCash.Table_ID, this.getC_Cash_ID());
            List lstFacts = qFacts.list();
            for (MFactAcct mFactLine : lstFacts) {
                mFactLine.deleteEx(true);
            }
            MCash mCash = new MCash(this.getCtx(), this.getC_Cash_ID(), this.get_TrxName());
            pOArray = mCash.getLines(true);
            n = pOArray.length;
            int mFactLine = 0;
            while (mFactLine < n) {
                PO mLine = pOArray[mFactLine];
                int C_Payment_ID = ((X_C_CashLine)mLine).getC_Payment_ID();
                MPNGJournalLine.clearCashLineFromJournalLines(((X_C_CashLine)mLine).getC_CashLine_ID(), this.get_TrxName());
                mLine.deleteEx(true);
                if (C_Payment_ID > 0) {
                    MPayment mPayment = ModelFactory.getPayment(this.getCtx(), C_Payment_ID, this.get_TrxName());
                    mPayment.deleteEx(true);
                }
                ++mFactLine;
            }
            MPNGJournalLine[] mPNGJournalLineArray = mJournalLines = this.getLines(true);
            int n3 = mJournalLines.length;
            n = 0;
            while (n < n3) {
                MPNGJournalLine line = mPNGJournalLineArray[n];
                line.setProcessed(false);
                line.saveEx();
                ++n;
            }
            this.setC_Cash_ID(-1);
            this.setDocAction("CO");
            this.setPosted(false);
            this.setProcessed(false);
            this.saveEx();
            mCash.deleteEx(true);
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    private boolean DeleteAllocation(int C_Payment_ID) {
        MAllocationLine all = (MAllocationLine)new Query(this.getCtx(), "C_AllocationLine", "C_Payment_ID = ?", this.get_TrxName()).setParameters(C_Payment_ID).first();
        MAllocationHdr allHdr = new MAllocationHdr(this.getCtx(), all.getC_AllocationHdr_ID(), this.get_TrxName());
        MProcess process = (MProcess)new Query(this.getCtx(), "AD_Process", "value = 'C_Allocation_Reset'", this.get_TrxName()).first();
        MPInstance instance = new MPInstance(process, allHdr.getC_AllocationHdr_ID());
        MPInstancePara[] mPInstanceParaArray = instance.getParameters();
        int n = mPInstanceParaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPInstancePara ip = mPInstanceParaArray[n2];
            if (ip.getParameterName().equals("C_AllocationHdr_ID")) {
                ip.setParameter("C_AllocationHdr_ID", allHdr.getC_AllocationHdr_ID());
                if (ip.save()) break;
                return false;
            }
            ++n2;
        }
        ProcessInfo pi = new ProcessInfo("AllocationReset", process.getAD_Process_ID());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        return process.processItWithoutTrxClose(pi, Trx.get(this.get_TrxName(), false));
    }

    public MBankAccount getBankAccount(int Account_ID) {
        String sql = "SELECT b.C_BankAccount_ID FROM C_BankAccount b inner join C_BankAccount_Acct a on (b.C_BankAccount_ID = a.C_BankAccount_ID) WHERE (a.B_Asset_Acct=? OR a.B_Intransit_Acct=?) AND b.C_Currency_ID = ?";
        int C_AcctSchema_ID = this.getC_AcctSchema_ID();
        MBankAccount mBankAccount = null;
        MAcctSchema as = MAcctSchema.get(this.getCtx(), C_AcctSchema_ID);
        MAccount acct = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()), as.getC_AcctSchema_ID(), Account_ID, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        acct.saveEx();
        int C_ValidCombination_ID = acct.getC_ValidCombination_ID();
        int C_BankAccount_ID = DB.getSQLValueEx(this.get_TrxName(), "SELECT b.C_BankAccount_ID FROM C_BankAccount b inner join C_BankAccount_Acct a on (b.C_BankAccount_ID = a.C_BankAccount_ID) WHERE (a.B_Asset_Acct=? OR a.B_Intransit_Acct=?) AND b.C_Currency_ID = ?", C_ValidCombination_ID, C_ValidCombination_ID, this.getC_Currency_ID());
        if (C_BankAccount_ID <= 0) {
            acct = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), 0, as.getC_AcctSchema_ID(), Account_ID, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            acct.saveEx();
            C_ValidCombination_ID = acct.getC_ValidCombination_ID();
            C_BankAccount_ID = DB.getSQLValueEx(this.get_TrxName(), "SELECT b.C_BankAccount_ID FROM C_BankAccount b inner join C_BankAccount_Acct a on (b.C_BankAccount_ID = a.C_BankAccount_ID) WHERE (a.B_Asset_Acct=? OR a.B_Intransit_Acct=?) AND b.C_Currency_ID = ?", C_ValidCombination_ID, C_ValidCombination_ID, this.getC_Currency_ID());
        }
        if (C_BankAccount_ID > 0) {
            mBankAccount = MBankAccount.get(this.getCtx(), C_BankAccount_ID);
        }
        return mBankAccount;
    }

    public void autoFillBPJournalLines() {
        if (PNGSysConfig.isJournalLinesAutoFillBP(this.getAD_Client_ID(), this.getAD_Org_ID()) && (this.isCashJournal() || this.isJournal())) {
            MPNGJournalLine[] mJLines;
            HashSet<Integer> setBP = new HashSet<Integer>();
            MPNGJournalLine[] mPNGJournalLineArray = mJLines = this.getLines(false);
            int n = mJLines.length;
            int n2 = 0;
            while (n2 < n) {
                MPNGJournalLine mLine = mPNGJournalLineArray[n2];
                if (mLine.getAccountCr_ID() > 0 && mLine.getC_BPartnerCr_ID() > 0) {
                    setBP.add(mLine.getC_BPartnerCr_ID());
                }
                if (mLine.getAccountDr_ID() > 0 && mLine.getC_BPartnerDr_ID() > 0) {
                    setBP.add(mLine.getC_BPartnerDr_ID());
                }
                ++n2;
            }
            if (setBP.size() == 1) {
                int C_BPartner_ID = -1;
                for (Integer iID : setBP) {
                    C_BPartner_ID = iID;
                }
                MPNGJournalLine[] mPNGJournalLineArray2 = mJLines;
                int n3 = mJLines.length;
                int n4 = 0;
                while (n4 < n3) {
                    MPNGJournalLine mLine = mPNGJournalLineArray2[n4];
                    boolean bChanged = false;
                    if (mLine.getAccountCr_ID() > 0 && mLine.getC_BPartnerCr_ID() <= 0) {
                        mLine.setC_BPartnerCr_ID(C_BPartner_ID);
                        bChanged = true;
                    }
                    if (mLine.getAccountDr_ID() > 0 && mLine.getC_BPartnerDr_ID() <= 0) {
                        mLine.setC_BPartnerDr_ID(C_BPartner_ID);
                        bChanged = true;
                    }
                    if (bChanged) {
                        mLine.saveEx();
                    }
                    ++n4;
                }
            }
        }
    }

    public MCharge getOrCreateCharge(int Account_ID, int C_Tax_ID) {
        String sqlCharge = "SELECT c_charge_id FROM C_Charge_Acct c WHERE c.ch_expense_acct=?";
        MCharge charge = null;
        int C_AcctSchema_ID = this.getC_AcctSchema_ID();
        MTax tax = MTax.get(this.getCtx(), C_Tax_ID);
        MAcctSchema as = MAcctSchema.get(this.getCtx(), C_AcctSchema_ID);
        MAccount acct = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()), as.getC_AcctSchema_ID(), Account_ID, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        acct.saveEx();
        int C_Charge_ID = DB.getSQLValue(this.get_TrxName(), "SELECT c_charge_id FROM C_Charge_Acct c WHERE c.ch_expense_acct=?", acct.getC_ValidCombination_ID());
        if (C_Charge_ID < 0) {
            acct = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), 0, as.getC_AcctSchema_ID(), Account_ID, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            acct.saveEx();
            C_Charge_ID = DB.getSQLValue(this.get_TrxName(), "SELECT c_charge_id FROM C_Charge_Acct c WHERE c.ch_expense_acct=?", acct.getC_ValidCombination_ID());
        }
        if (C_Charge_ID < 0) {
            charge = new MCharge(this.getCtx(), 0, this.get_TrxName());
            charge.setC_TaxCategory_ID(tax.getC_TaxCategory_ID());
            charge.setAD_Client_ID(Env.getAD_Client_ID(this.getCtx()));
            charge.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
            charge.setDescription(acct.getDescription());
            charge.setName(acct.getAccount().getName());
            charge.saveEx();
            StringBuffer sql2 = new StringBuffer("UPDATE C_Charge_Acct ");
            sql2.append("SET CH_Expense_Acct=").append(acct.getC_ValidCombination_ID());
            sql2.append(", CH_Revenue_Acct=").append(acct.getC_ValidCombination_ID());
            sql2.append(" WHERE C_Charge_ID=").append(charge.getC_Charge_ID());
            sql2.append(" AND C_AcctSchema_ID=").append(C_AcctSchema_ID);
            int noAffectedRows = DB.executeUpdate(sql2.toString(), this.get_TrxName());
            if (noAffectedRows != 1) {
                this.log.log(Level.SEVERE, "Update #" + noAffectedRows + "\n" + sql2.toString());
            }
        } else {
            charge = MCharge.get(this.getCtx(), C_Charge_ID);
        }
        return charge;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "TotalDr")).append("=").append(this.getTotalDr()).append(" ").append(Msg.translate(this.getCtx(), "TotalCR")).append("=").append(this.getTotalCr());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getDocumentNo() {
        return Integer.toString(this.getPNG_Journal_ID());
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getTotalDr();
    }

    @Override
    public boolean isConvInput() {
        if (super.isConvInput() && this.isCashJournal() || this.isJournal()) {
            return this.getAcctSchema_Currency_ID() != this.getC_Currency_ID();
        }
        return false;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setISConvInput(this.isConvInput());
        return super.beforeSave(newRecord);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success && (this.isJournal() || this.isCashJournal())) {
            MPNGEntryType mEntryType = this.getEntryType();
            List<MPNGEntryTypeJrLine> mLines = mEntryType.getLines();
            for (MPNGEntryTypeJrLine mDefault : mLines) {
                MPNGJournalLine mJournalLine = new MPNGJournalLine(this, mDefault);
                mJournalLine.saveEx();
            }
        }
        if (!newRecord) {
            MPNGJournalLine[] mLines = this.getLines(true);
            boolean bIsConvInputChanged = this.is_ValueChanged("ISConvInput") || this.is_ValueChanged("PNGConversionRate");
            MPNGJournalLine[] mPNGJournalLineArray = mLines;
            int n = mLines.length;
            int n2 = 0;
            while (n2 < n) {
                MPNGJournalLine mLine = mPNGJournalLineArray[n2];
                mLine.setDateAcct(this.getDateAcct());
                if (bIsConvInputChanged) {
                    mLine.updateAmtConversion(this);
                }
                mLine.saveEx();
                ++n2;
            }
        }
        return super.afterSave(newRecord, success);
    }

    public static boolean isGeneratedCash(Properties ctx, int C_Cash_ID, String sTrx) {
        return MPNGJournal.getForCash(ctx, C_Cash_ID, sTrx) != null;
    }

    public static MPNGJournal getForCash(Properties ctx, int C_Cash_ID, String sTrx) {
        Query qJournal = new Query(ctx, "PNG_Journal", "C_Cash_ID = ?", sTrx);
        qJournal.setParameters(C_Cash_ID);
        return (MPNGJournal)qJournal.first();
    }

    public static boolean isGeneratedCashLine(Properties ctx, int C_CashLine_ID, String sTrx) {
        X_C_CashLine mLine = new X_C_CashLine(ctx, C_CashLine_ID, sTrx);
        return MPNGJournal.isGeneratedCash(ctx, mLine.getC_Cash_ID(), sTrx);
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
            options[index++] = "PR";
            options[index++] = "CL";
        } else if (docStatus.equals("CO")) {
            options[index++] = "VO";
            options[index++] = "RE";
        }
        return index;
    }
}

