/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MLITInvoiceWithholding;
import org.compiere.model.MPNGInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_LIT_WithholdingCalc;
import org.compiere.model.X_LIT_WithholdingRule;
import org.compiere.model.X_LIT_WithholdingType;
import org.compiere.model.X_PNG_InvoiceWithholding;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPNGInvoiceWithholding
extends X_PNG_InvoiceWithholding {
    private static final long serialVersionUID = -6295369154511680329L;
    private static CLogger s_log = CLogger.getCLogger(MLITInvoiceWithholding.class);

    public MPNGInvoiceWithholding(Properties ctx, int MPNGInvoiceWithholding_ID, String trxName) {
        super(ctx, MPNGInvoiceWithholding_ID, trxName);
    }

    public MPNGInvoiceWithholding(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.log.fine("New=" + newRecord);
        if (this.getLIT_WithholdingRule_ID() > 0) {
            MPayment pay;
            X_LIT_WithholdingRule wr = new X_LIT_WithholdingRule(this.getCtx(), this.getLIT_WithholdingRule_ID(), this.get_TrxName());
            X_LIT_WithholdingCalc wc = new X_LIT_WithholdingCalc(this.getCtx(), wr.getLIT_WithholdingCalc_ID(), this.get_TrxName());
            this.setIsCalcOnPayment(!wc.isCalcOnInvoice());
            this.setIsProRataOnUnderpayment(wc.isProRataOnUnderpayment());
            if (this.isProRataOnUnderpayment() && this.getC_Payment_ID() > 0 && (pay = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName())).isPrepayment()) {
                this.setIsProRataOnUnderpayment(false);
            }
        } else {
            X_LIT_WithholdingType wt = new X_LIT_WithholdingType(this.getCtx(), this.getLIT_WithholdingType_ID(), this.get_TrxName());
            this.setIsCalcOnPayment(wt.isSOTrx());
            this.setIsProRataOnUnderpayment(false);
        }
        if (this.getC_AllocationLine_ID() <= 0 && this.getPNG_Invoice_ID() > 0) {
            MPNGInvoice inv = new MPNGInvoice(this.getCtx(), this.getPNG_Invoice_ID(), this.get_TrxName());
            this.setDateAcct(inv.getDateAcct());
            this.setDateTrx(inv.getDateInvoiced());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || this.getPNG_Invoice_ID() == 0) {
            return success;
        }
        return MPNGInvoice.updateHeaderWithholding(this.getPNG_Invoice_ID(), this.get_TrxName());
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success || this.getPNG_Invoice_ID() == 0) {
            return success;
        }
        return MPNGInvoice.updateHeaderWithholding(this.getPNG_Invoice_ID(), this.get_TrxName());
    }

    public static BigDecimal getCreditNoteWithholdingAmt(String trxName, int PNG_Invoice_ID) {
        String sql = "SELECT COALESCE (SUM (TaxAmt), 0) FROM PNG_InvoiceWithholding WHERE IsActive = 'Y' AND IsCalcOnPayment = 'Y' AND IsProRataOnUnderpayment = 'Y' AND Processed = 'N' AND PNG_Invoice_ID IN (SELECT PNG_INVOICE_ID FROM C_ALLOCATIONLINE WHERE C_ALLOCATIONHDR_ID IN (SELECT DISTINCT C_ALLOCATIONHDR_ID FROM C_ALLOCATIONLINE WHERE PNG_INVOICE_ID=?)  AND C_INVOICE_ID<>?)";
        BigDecimal tot = DB.getSQLValueBD(trxName, sql, PNG_Invoice_ID, PNG_Invoice_ID);
        if (tot == null) {
            tot = Env.ZERO;
        }
        return tot;
    }

    public static BigDecimal getOpenWithholdingAmt(String trxName, int PNG_Invoice_ID, String isCalcOnPayment, String isProRataOnUnderpayment) {
        BigDecimal tot;
        int id = PNG_Invoice_ID;
        if (id == 0) {
            return Env.ZERO;
        }
        String sql = "SELECT COALESCE (SUM (TaxAmt), 0) FROM PNG_InvoiceWithholding WHERE IsActive = 'Y' AND Processed = 'N' AND C_AllocationLine_ID IS NULL AND ";
        if (PNG_Invoice_ID != 0) {
            sql = String.valueOf(sql) + "PNG_Invoice_ID = ? ";
        }
        if (isCalcOnPayment != null) {
            sql = String.valueOf(sql) + "AND IsCalcOnPayment = '" + isCalcOnPayment + "' ";
        }
        if (isProRataOnUnderpayment != null) {
            sql = String.valueOf(sql) + "AND IsProRataOnUnderpayment = '" + isProRataOnUnderpayment + "' ";
        }
        if ((tot = DB.getSQLValueBD(trxName, sql, id)) == null) {
            tot = Env.ZERO;
        }
        return tot;
    }

    public static BigDecimal[] getProRataWithholdingAmt(String trxName, int C_Invoice_ID, int LIT_WithholdingType_ID, int LIT_WithholdingRule_ID, int C_Tax_ID) {
        return MPNGInvoiceWithholding.getProRataWithholdingAmt(trxName, 0, C_Invoice_ID, LIT_WithholdingType_ID, LIT_WithholdingRule_ID, C_Tax_ID);
    }

    public static BigDecimal[] getProRataWithholdingAmt(String trxName, int C_Order_ID, int PNG_Invoice_ID, int LIT_WithholdingType_ID, int LIT_WithholdingRule_ID, int C_Tax_ID) {
        BigDecimal[] tot;
        block17: {
            int id;
            tot = new BigDecimal[]{Env.ZERO, Env.ZERO};
            int n = id = PNG_Invoice_ID != 0 ? PNG_Invoice_ID : C_Order_ID;
            if (id == 0) {
                return tot;
            }
            StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM (TaxBaseAmt), 0), COALESCE(SUM (TaxAmt), 0) FROM PNG_InvoiceWithholding WHERE IsActive = 'Y' AND IsCalcOnPayment = 'Y' AND IsProRataOnUnderpayment = 'Y' AND ");
            if (PNG_Invoice_ID != 0) {
                sql.append("PNG_Invoice_ID = ? ");
            } else {
                sql.append("C_Order_ID = ? ");
            }
            if (LIT_WithholdingType_ID != 0) {
                sql.append(" AND LIT_WithholdingType_ID = ? ");
            }
            if (LIT_WithholdingRule_ID != 0) {
                sql.append(" AND LIT_WithholdingRule_ID = ? ");
            }
            if (C_Tax_ID != 0) {
                sql.append(" AND C_Tax_ID = ? ");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            try {
                try {
                    int pn = 1;
                    pstmt.setInt(pn, id);
                    if (LIT_WithholdingType_ID != 0) {
                        pstmt.setInt(++pn, LIT_WithholdingType_ID);
                    }
                    if (LIT_WithholdingRule_ID != 0) {
                        pstmt.setInt(++pn, LIT_WithholdingRule_ID);
                    }
                    if (C_Tax_ID != 0) {
                        pstmt.setInt(++pn, C_Tax_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        tot[0] = rs.getBigDecimal(1);
                        tot[1] = rs.getBigDecimal(2);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (tot[0] == null) {
            tot[0] = Env.ZERO;
        }
        if (tot[1] == null) {
            tot[1] = Env.ZERO;
        }
        return tot;
    }

    public static MAccount getPrepaymentAcct(MAcctSchema as) {
        MAcctSchemaDefault asd = as.getAcctSchemaDefault();
        int idacct = 0;
        Object oo = asd.get_Value("T_PrepaymentWithholding_Acct");
        if (oo != null) {
            if (oo instanceof Integer) {
                idacct = (Integer)oo;
            }
            try {
                idacct = Integer.parseInt(oo.toString());
            }
            catch (NumberFormatException ex) {
                idacct = 0;
            }
        }
        if (idacct > 0) {
            return MAccount.get(as.getCtx(), idacct);
        }
        return null;
    }
}

