/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MPNGInvoice;
import org.compiere.model.MPNGInvoiceLine;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.model.X_PNG_InvoiceTax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPNGInvoiceTax
extends X_PNG_InvoiceTax {
    private static final long serialVersionUID = 1284035132105646747L;
    private static CLogger s_log = CLogger.getCLogger(MInvoiceTax.class);
    private MTax m_tax = null;
    private Integer m_precision = null;

    public static MPNGInvoiceTax get(MPNGInvoiceLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MPNGInvoiceTax retValue = null;
        if (line == null || line.getPNG_Invoice_ID() == 0) {
            return null;
        }
        int C_Tax_ID = line.getC_Tax_ID();
        boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
        if (isOldTax) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                return null;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            s_log.warning("C_Tax_ID=0");
            return null;
        }
        retValue = (MPNGInvoiceTax)new Query(line.getCtx(), "PNG_InvoiceTax", "PNG_Invoice_ID=? AND C_Tax_ID=?", trxName).setParameters(line.getPNG_Invoice_ID(), C_Tax_ID).firstOnly();
        if (retValue != null) {
            retValue.set_TrxName(trxName);
            retValue.setPrecision(precision);
            s_log.fine("(old=" + oldTax + ") " + retValue);
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        MPNGInvoice i = new MPNGInvoice(line.getCtx(), line.getPNG_Invoice_ID(), null);
        retValue = new MPNGInvoiceTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg(line);
        retValue.setPNG_Invoice_ID(line.getPNG_Invoice_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(i.isTaxIncluded());
        s_log.fine("(new) " + retValue);
        return retValue;
    }

    public MPNGInvoiceTax(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setTaxAmt(Env.ZERO);
        this.setTaxBaseAmt(Env.ZERO);
        this.setIsTaxIncluded(false);
    }

    public MPNGInvoiceTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = new Integer(precision);
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public boolean calculateTaxFromLines() {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        boolean documentLevel = this.getTax().isDocumentLevel();
        MTax tax = this.getTax();
        String sql = "SELECT il.LineNetAmt, COALESCE(il.TaxAmt,0), j.IsSOTrx FROM PNG_InvoiceLine il INNER JOIN PNG_Invoice i ON (il.PNG_Invoice_ID=i.PNG_Invoice_ID)  INNER JOIN PNG_Journal j ON (j.PNG_Journal_ID=i.PNG_Journal_ID) WHERE il.PNG_Invoice_ID=? AND il.C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getPNG_Invoice_ID());
                pstmt.setInt(2, this.getC_Tax_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal baseAmt = rs.getBigDecimal(1);
                    taxBaseAmt = taxBaseAmt.add(baseAmt);
                    BigDecimal amt = rs.getBigDecimal(2);
                    if (amt == null) {
                        amt = Env.ZERO;
                    }
                    boolean isSOTrx = "Y".equals(rs.getString(3));
                    if (documentLevel || amt.signum() == 0 || isSOTrx) {
                        amt = documentLevel || baseAmt.signum() == 0 ? Env.ZERO : tax.calculateTax(baseAmt, this.isTaxIncluded(), this.getPrecision());
                    }
                    taxAmt = taxAmt.add(amt);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (documentLevel || taxAmt.signum() == 0) {
            taxAmt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision());
        }
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            this.setTaxBaseAmt(taxBaseAmt);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPNGInvoiceTax[");
        sb.append("PNG_Invoice_ID=").append(this.getPNG_Invoice_ID()).append(",C_Tax_ID=").append(this.getC_Tax_ID()).append(", Base=").append(this.getTaxBaseAmt()).append(",Tax=").append(this.getTaxAmt()).append("]");
        return sb.toString();
    }
}

