/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MCharge;
import org.compiere.model.MPNGInvoice;
import org.compiere.model.MPNGInvoiceTax;
import org.compiere.model.MPNGJournal;
import org.compiere.model.MTax;
import org.compiere.model.X_PNG_InvoiceLine;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPNGInvoiceLine
extends X_PNG_InvoiceLine {
    private static final long serialVersionUID = -1834105166526985369L;
    private Integer m_precision = null;
    private MPNGInvoice m_parent = null;
    private boolean m_IsSOTrx = true;
    private boolean m_TaxInc = false;

    public MPNGInvoiceLine(Properties ctx, int PNG_InvoiceLine_ID, String trxName) {
        super(ctx, PNG_InvoiceLine_ID, trxName);
    }

    public MPNGInvoiceLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setInvoice(MPNGInvoice invoice) {
        this.m_parent = invoice;
        this.m_precision = new Integer(invoice.getPrecision());
        MPNGJournal journal = new MPNGJournal(this.getCtx(), invoice.getPNG_Journal_ID(), this.get_TrxName());
        this.m_IsSOTrx = journal.isSOTrx();
        this.m_TaxInc = invoice.get_ValueAsBoolean("IsTaxIncluded");
    }

    public void setTaxAmt() {
        BigDecimal TaxAmt = Env.ZERO;
        if (this.getC_Tax_ID() == 0) {
            return;
        }
        MTax tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        if (tax.isDocumentLevel() && this.m_IsSOTrx) {
            return;
        }
        TaxAmt = tax.calculateTax(this.getLineNetAmt(), this.m_TaxInc, this.getPrecision());
        if (this.m_TaxInc) {
            this.setLineTotalAmt(this.getLineNetAmt());
        } else {
            this.setLineTotalAmt(this.getLineNetAmt().add(TaxAmt));
        }
        super.setTaxAmt(TaxAmt);
    }

    public void setQtyInvoiced() {
        super.setQtyInvoiced(Env.ONE);
    }

    public void setQtyEntered() {
        super.setQtyEntered(Env.ONE);
    }

    @Override
    public void setC_Charge_ID(int charge_id) {
        super.setC_Charge_ID(charge_id);
    }

    public void setpriceactual() {
        BigDecimal PriceActual = this.getLineNetAmt();
        if (PriceActual != null) {
            super.setPriceActual(PriceActual);
        }
    }

    private boolean updatePNGInvoiceTax(boolean oldTax) {
        MPNGInvoiceTax tax = MPNGInvoiceTax.get(this, this.getPrecision(), oldTax, this.get_TrxName());
        if (tax != null) {
            int iCount;
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            boolean bSave = true;
            if (tax.getTaxAmt().signum() == 0 && (iCount = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT('ok') FROM PNG_InvoiceLine l WHERE l.PNG_Invoice_ID = ? AND l.C_Tax_ID = ? AND  l.IsDescription = 'N' AND l.IsActive='Y'", this.getPNG_Invoice_ID(), tax.getC_Tax_ID())) == 0) {
                bSave = false;
                if (!tax.is_new() && !tax.delete(false, this.get_TrxName())) {
                    return false;
                }
            }
            if (bSave && !tax.save(this.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    public int getPrecision() {
        if (this.m_precision != null) {
            return this.m_precision;
        }
        int inv_id = this.getPNG_Invoice_ID();
        MPNGInvoice inv = new MPNGInvoice(this.getCtx(), inv_id, this.get_TrxName());
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN PNG_Journal x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.PNG_Journal_ID=?";
        int i = DB.getSQLValue(this.get_TrxName(), sql, inv.getPNG_Journal_ID());
        if (i < 0) {
            this.log.warning("getPrecision = " + i + " - set to 2");
            i = 2;
        }
        this.m_precision = new Integer(i);
        return this.m_precision;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && this.is_ValueChanged("C_Tax_ID") && !this.updatePNGInvoiceTax(true)) {
            return false;
        }
        if (!this.updateHeaderTax()) {
            return false;
        }
        MPNGInvoice invoice = new MPNGInvoice(this.getCtx(), this.getPNG_Invoice_ID(), this.get_TrxName());
        MPNGJournal journal = new MPNGJournal(this.getCtx(), invoice.getPNG_Journal_ID(), this.get_TrxName());
        if (journal.isInvoice()) {
            if (journal.isSOTrx()) {
                String sql = new String("UPDATE PNG_Journal j SET TotalDr = (select grandtotal from PNG_Invoice inv  WHERE inv.IsActive='Y' AND j.PNG_Journal_ID=inv.PNG_Journal_ID)  , TotalCr = (select grandtotal from PNG_Invoice inv  WHERE inv.IsActive='Y' AND j.PNG_Journal_ID=inv.PNG_Journal_ID) WHERE PNG_Journal_ID=" + invoice.getPNG_Journal_ID());
                int no = DB.executeUpdate(sql, this.get_TrxName());
                this.log.fine("Lines -> #" + no);
            } else {
                String sql = new String("UPDATE PNG_Journal j SET TotalCr = (select grandtotal from PNG_Invoice inv  WHERE inv.IsActive='Y' AND j.PNG_Journal_ID=inv.PNG_Journal_ID)  , TotalDr = (select grandtotal from PNG_Invoice inv  WHERE inv.IsActive='Y' AND j.PNG_Journal_ID=inv.PNG_Journal_ID) WHERE PNG_Journal_ID=" + invoice.getPNG_Journal_ID());
                int no = DB.executeUpdate(sql, this.get_TrxName());
                this.log.fine("Lines -> #" + no);
            }
        }
        return true;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MPNGInvoice inv = new MPNGInvoice(this.getCtx(), this.getPNG_Invoice_ID(), this.get_TrxName());
        MPNGJournal jl = new MPNGJournal(this.getCtx(), inv.getPNG_Journal_ID(), this.get_TrxName());
        MCharge charge = jl.getOrCreateCharge(this.getAccount_ID(), this.getC_Tax_ID());
        this.setC_Charge_ID(charge.getC_Charge_ID());
        return true;
    }

    private boolean updateHeaderTax() {
        if (this.isProcessed() && !this.is_ValueChanged("Processed")) {
            return true;
        }
        if (!this.updatePNGInvoiceTax(false)) {
            return false;
        }
        String sql = "UPDATE PNG_Invoice i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM PNG_InvoiceLine il WHERE i.PNG_Invoice_ID=il.PNG_Invoice_ID) WHERE PNG_Invoice_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{this.getPNG_Invoice_ID()}, this.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdateEx(sql = this.m_TaxInc ? "UPDATE PNG_Invoice i  SET GrandTotal=TotalLines WHERE PNG_Invoice_ID=?" : "UPDATE PNG_Invoice i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM PNG_InvoiceTax it WHERE i.PNG_Invoice_ID=it.PNG_Invoice_ID) WHERE PNG_Invoice_ID=?", new Object[]{this.getPNG_Invoice_ID()}, this.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }

    public MPNGInvoice getParent() {
        return this.m_parent;
    }
}

