/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import org.compiere.model.MDocType;
import org.compiere.model.MMPMaintain;
import org.compiere.model.MMPOT;
import org.compiere.model.MMPOTResource;
import org.compiere.model.MMPOTTask;
import org.compiere.model.Query;
import org.compiere.model.X_MP_Maintain;
import org.compiere.model.X_MP_Maintain_Resource;
import org.compiere.model.X_MP_Maintain_Task;
import org.compiere.model.X_MP_OT;
import org.compiere.util.Env;

public class MPGenerateOT {
    private String m_trx;

    public boolean createOT(int MP_ID, Timestamp Datetrx, String description, int Asset_ID, String trxName) {
        this.m_trx = trxName;
        MMPOT newOT = new MMPOT(Env.getCtx(), 0, trxName);
        newOT.setDateTrx(Datetrx);
        newOT.setDescription(description);
        newOT.setA_Asset_ID(Asset_ID);
        newOT.setMP_Maintain_ID(MP_ID);
        newOT.setDocStatus("DR");
        newOT.setDocAction("CO");
        newOT.setC_DocType_ID(MDocType.getOfDocBaseType(Env.getCtx(), "MOF")[0].getC_DocType_ID());
        if (!newOT.save()) {
            return false;
        }
        if (!this.createOTTaskDetail(MP_ID, newOT, trxName)) {
            return false;
        }
        List list = new Query(Env.getCtx(), "MP_Maintain", "IsChild=? AND MP_MaintainParent_ID=?", trxName).setParameters("Y", MP_ID).list();
        for (X_MP_Maintain mnt : list) {
            this.createOTTaskDetail(mnt.getMP_Maintain_ID(), newOT, trxName);
            this.lookChilds(mnt.getMP_Maintain_ID(), newOT, trxName);
        }
        return true;
    }

    public void lookChilds(int MP_ID, X_MP_OT OT, String trxName) {
        List list = new Query(Env.getCtx(), "MP_Maintain", "MP_MaintainParent_ID", trxName).setParameters(MP_ID).list();
        for (X_MP_Maintain main : list) {
            this.createOTTaskDetail(main.getMP_Maintain_ID(), OT, trxName);
            this.lookChilds(main.getMP_Maintain_ID(), OT, trxName);
        }
    }

    public boolean createOTTaskDetail(int MP_ID, X_MP_OT OT, String trxName) {
        List list = new Query(Env.getCtx(), "MP_Maintain_Task", "MP_Maintain_ID=?", trxName).setParameters(MP_ID).list();
        for (X_MP_Maintain_Task task : list) {
            MMPOTTask ta = new MMPOTTask(Env.getCtx(), 0, trxName);
            ta.setAD_Org_ID(task.getAD_Org_ID());
            ta.setMP_Maintain_ID(task.getMP_Maintain_ID());
            ta.setMP_OT_ID(OT.getMP_OT_ID());
            ta.setDescription(task.getDescription());
            ta.setDuration(task.getDuration());
            ta.setC_UOM_ID(task.getC_UOM_ID());
            ta.setStatus("NS");
            ta.saveEx();
            this.createOTResourceDetail(task.getMP_Maintain_Task_ID(), ta.getMP_OT_Task_ID(), trxName);
        }
        this.updateMP(MP_ID, OT.getDateTrx(), OT.getDescription());
        return true;
    }

    public boolean createOTResourceDetail(int oldTask_ID, int newTask_ID, String trxName) {
        List list = new Query(Env.getCtx(), "MP_Maintain_Resource", "MP_Maintain_Task_ID=?", trxName).setParameters(oldTask_ID).list();
        for (X_MP_Maintain_Resource res : list) {
            MMPOTResource re = new MMPOTResource(Env.getCtx(), 0, trxName);
            re.setAD_Org_ID(res.getAD_Org_ID());
            re.setMP_OT_Task_ID(newTask_ID);
            re.setCostAmt(res.getCostAmt());
            re.setS_Resource_ID(res.getS_Resource_ID());
            re.setM_BOM_ID(res.getM_BOM_ID());
            re.setResourceQty(res.getResourceQty());
            re.setResourceType(res.getResourceType());
            re.set_ValueOfColumn("M_Product_ID", (Object)res.getM_Product_ID());
            re.saveEx();
        }
        return true;
    }

    public void updateMP(int MP_ID, Timestamp Datetrx, String description) {
        MMPMaintain mp = new MMPMaintain(Env.getCtx(), MP_ID, this.m_trx);
        mp.setdatelastrunmp(Datetrx);
        mp.setDateLastRun(Datetrx);
        if (mp.getProgrammingType().equals("C")) {
            mp.setDateNextRun(new Timestamp(Datetrx.getTime() + mp.getInterval().longValue() * 86400000L));
        } else {
            mp.setnextmp(mp.getInterval().add(mp.getlastmp()).setScale(2, 6));
            mp.setlastmp(new BigDecimal(Float.parseFloat(description.split(":")[description.split(":").length - 1].replace(',', '.'))).setScale(2, 6));
        }
        mp.save();
    }
}

