/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPGroup;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.model.X_M_MatchPO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MMatchPO
extends X_M_MatchPO {
    private static final long serialVersionUID = 7189366329684552916L;
    private static CLogger s_log = CLogger.getCLogger(MMatchPO.class);
    private boolean m_isInvoiceLineChange = false;
    private boolean m_isInOutLineChange = false;
    private MOrderLine m_oLine = null;
    private MInvoiceLine m_iLine = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MMatchPO[] get(Properties ctx, int C_OrderLine_ID, int C_InvoiceLine_ID, String trxName) {
        if (C_OrderLine_ID == 0 || C_InvoiceLine_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=? AND C_InvoiceLine_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_OrderLine_ID);
            pstmt.setInt(2, C_InvoiceLine_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchPO(ctx, rs, trxName));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MMatchPO[] getInOut(Properties ctx, int M_InOut_ID, String trxName) {
        if (M_InOut_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO m INNER JOIN M_InOutLine l ON (m.M_InOutLine_ID=l.M_InOutLine_ID) WHERE l.M_InOut_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_InOut_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchPO(ctx, rs, trxName));
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MMatchPO[] getInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        if (C_Invoice_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO mi INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID) WHERE il.C_Invoice_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_Invoice_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchPO(ctx, rs, trxName));
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MMatchPO[] getOrderLine(Properties ctx, int C_OrderLine_ID, String trxName) {
        if (C_OrderLine_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_OrderLine_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchPO(ctx, rs, trxName));
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MMatchPO create(MInvoiceLine iLine, MInOutLine sLine, Timestamp dateTrx, BigDecimal qty) {
        String trxName = null;
        Properties ctx = null;
        int C_OrderLine_ID = 0;
        if (iLine != null) {
            trxName = iLine.get_TrxName();
            ctx = iLine.getCtx();
            C_OrderLine_ID = iLine.getC_OrderLine_ID();
        }
        if (sLine != null) {
            trxName = sLine.get_TrxName();
            ctx = sLine.getCtx();
            C_OrderLine_ID = sLine.getC_OrderLine_ID();
        }
        MMatchPO retValue = null;
        String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_OrderLine_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MMatchPO mpo = new MMatchPO(ctx, rs, trxName);
                if (qty.compareTo(mpo.getQty()) != 0) continue;
                if (iLine != null) {
                    if (mpo.getC_InvoiceLine_ID() != 0 && mpo.getC_InvoiceLine_ID() != iLine.getC_InvoiceLine_ID()) continue;
                    mpo.setC_InvoiceLine_ID(iLine);
                    if (iLine.getM_AttributeSetInstance_ID() != 0) {
                        if (mpo.getM_AttributeSetInstance_ID() == 0) {
                            mpo.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
                        } else if (mpo.getM_AttributeSetInstance_ID() != iLine.getM_AttributeSetInstance_ID()) continue;
                    }
                }
                if (sLine != null) {
                    if (mpo.getM_InOutLine_ID() != 0 && mpo.getM_InOutLine_ID() != sLine.getM_InOutLine_ID()) continue;
                    mpo.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                    if (sLine.getM_AttributeSetInstance_ID() != 0) {
                        if (mpo.getM_AttributeSetInstance_ID() == 0) {
                            mpo.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                        } else if (mpo.getM_AttributeSetInstance_ID() != sLine.getM_AttributeSetInstance_ID()) continue;
                    }
                }
                retValue = mpo;
                break;
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue == null) {
            if (sLine != null) {
                retValue = new MMatchPO(sLine, dateTrx, qty);
                if (iLine != null) {
                    retValue.setC_InvoiceLine_ID(iLine);
                }
            } else if (iLine != null) {
                retValue = new MMatchPO(iLine, dateTrx, qty);
            }
        }
        return retValue;
    }

    public MMatchPO(Properties ctx, int M_MatchPO_ID, String trxName) {
        super(ctx, M_MatchPO_ID, trxName);
        if (M_MatchPO_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MMatchPO(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchPO(MInOutLine sLine, Timestamp dateTrx, BigDecimal qty) {
        this(sLine.getCtx(), 0, sLine.get_TrxName());
        this.setClientOrg(sLine);
        this.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(sLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    public MMatchPO(MInvoiceLine iLine, Timestamp dateTrx, BigDecimal qty) {
        this(iLine.getCtx(), 0, iLine.get_TrxName());
        this.setClientOrg(iLine);
        this.setC_InvoiceLine_ID(iLine);
        if (iLine.getC_OrderLine_ID() != 0) {
            this.setC_OrderLine_ID(iLine.getC_OrderLine_ID());
        }
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(iLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    public void setC_InvoiceLine_ID(MInvoiceLine line) {
        this.m_iLine = line;
        if (line == null) {
            this.setC_InvoiceLine_ID(0);
        } else {
            this.setC_InvoiceLine_ID(line.getC_InvoiceLine_ID());
        }
    }

    @Override
    public void setC_InvoiceLine_ID(int C_InvoiceLine_ID) {
        int old = this.getC_InvoiceLine_ID();
        if (old != C_InvoiceLine_ID) {
            super.setC_InvoiceLine_ID(C_InvoiceLine_ID);
            this.m_isInvoiceLineChange = true;
        }
    }

    public MInvoiceLine getInvoiceLine() {
        if (this.m_iLine == null && this.getC_InvoiceLine_ID() != 0) {
            this.m_iLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        }
        return this.m_iLine;
    }

    @Override
    public void setM_InOutLine_ID(int M_InOutLine_ID) {
        int old = this.getM_InOutLine_ID();
        if (old != M_InOutLine_ID) {
            super.setM_InOutLine_ID(M_InOutLine_ID);
            this.m_isInOutLineChange = true;
        }
    }

    public void setC_OrderLine_ID(MOrderLine line) {
        this.m_oLine = line;
        if (line == null) {
            this.setC_OrderLine_ID(0);
        } else {
            this.setC_OrderLine_ID(line.getC_OrderLine_ID());
        }
    }

    public MOrderLine getOrderLine() {
        if (this.m_oLine == null && this.getC_OrderLine_ID() != 0 || this.getC_OrderLine_ID() != this.m_oLine.getC_OrderLine_ID()) {
            this.m_oLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
        }
        return this.m_oLine;
    }

    public BigDecimal getInvoicePriceActual() {
        int orderCurrency_ID;
        MInvoiceLine iLine = this.getInvoiceLine();
        MInvoice invoice = iLine.getParent();
        MOrder order = this.getOrderLine().getParent();
        BigDecimal priceActual = iLine.getPriceActual();
        int invoiceCurrency_ID = invoice.getC_Currency_ID();
        if (invoiceCurrency_ID != (orderCurrency_ID = order.getC_Currency_ID())) {
            priceActual = MConversionRate.convert(this.getCtx(), priceActual, invoiceCurrency_ID, orderCurrency_ID, invoice.getDateInvoiced(), invoice.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        }
        return priceActual;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String err;
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp ts = this.getNewerDateAcct();
            if (ts == null) {
                ts = this.getDateTrx();
            }
            this.setDateAcct(ts);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
        }
        if (newRecord && this.getC_InvoiceLine_ID() == 0) {
            MMatchInv[] mpi = MMatchInv.getInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            for (int i2 = 0; i2 < mpi.length; ++i2) {
                if (mpi[i2].getC_InvoiceLine_ID() == 0 || mpi[i2].getM_AttributeSetInstance_ID() != this.getM_AttributeSetInstance_ID()) continue;
                this.setC_InvoiceLine_ID(mpi[i2].getC_InvoiceLine_ID());
                break;
            }
        }
        if (this.getC_OrderLine_ID() == 0) {
            MInOutLine iol;
            MInvoiceLine il = null;
            if (this.getC_InvoiceLine_ID() != 0 && (il = this.getInvoiceLine()).getC_OrderLine_ID() != 0) {
                this.setC_OrderLine_ID(il.getC_OrderLine_ID());
            }
            if (this.getC_OrderLine_ID() == 0 && this.getM_InOutLine_ID() != 0 && (iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName())).getC_OrderLine_ID() != 0) {
                this.setC_OrderLine_ID(iol.getC_OrderLine_ID());
                if (il != null) {
                    il.setC_OrderLine_ID(iol.getC_OrderLine_ID());
                    il.save();
                }
            }
        }
        if (this.getC_OrderLine_ID() != 0 && this.getC_InvoiceLine_ID() != 0 && (newRecord || this.is_ValueChanged("C_OrderLine_ID") || this.is_ValueChanged("C_InvoiceLine_ID"))) {
            BigDecimal invPrice;
            BigDecimal poPrice = this.getOrderLine().getPriceActual();
            BigDecimal difference = poPrice.subtract(invPrice = this.getInvoicePriceActual());
            if (difference.signum() != 0) {
                difference = difference.multiply(this.getQty());
                this.setPriceMatchDifference(difference);
                MBPGroup group = MBPGroup.getOfBPartner(this.getCtx(), this.getOrderLine().getC_BPartner_ID());
                BigDecimal mt = group.getPriceMatchTolerance();
                if (mt != null && mt.signum() != 0) {
                    BigDecimal poAmt = poPrice.multiply(this.getQty());
                    BigDecimal maxTolerance = poAmt.multiply(mt);
                    maxTolerance = maxTolerance.abs().divide(Env.ONEHUNDRED, 2, 4);
                    boolean ok = (difference = difference.abs()).compareTo(maxTolerance) <= 0;
                    this.log.config("Difference=" + this.getPriceMatchDifference() + ", Max=" + maxTolerance + " => " + ok);
                    this.setIsApproved(ok);
                }
            } else {
                this.setPriceMatchDifference(difference);
                this.setIsApproved(true);
            }
        }
        if ((newRecord || this.m_isInOutLineChange) && (err = this.createMatchPOCostDetail()) != null && err.length() > 0) {
            s_log.warning(err);
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success && this.getC_OrderLine_ID() != 0) {
            MInOutLine iol;
            MOrderLine orderLine = this.getOrderLine();
            if (this.m_isInOutLineChange && (newRecord || this.getM_InOutLine_ID() != this.get_ValueOldAsInt("M_InOutLine_ID"))) {
                if (this.getM_InOutLine_ID() != 0) {
                    orderLine.setQtyDelivered(orderLine.getQtyDelivered().add(this.getQty()));
                } else {
                    orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(this.getQty()));
                }
                orderLine.setDateDelivered(this.getDateTrx());
            }
            if (this.m_isInvoiceLineChange && (newRecord || this.getC_InvoiceLine_ID() != this.get_ValueOldAsInt("C_InvoiceLine_ID"))) {
                if (this.getC_InvoiceLine_ID() != 0) {
                    orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().add(this.getQty()));
                } else {
                    orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(this.getQty()));
                }
                orderLine.setDateInvoiced(this.getDateTrx());
            }
            if (orderLine.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0 && (iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName())).getMovementQty().compareTo(orderLine.getQtyOrdered()) == 0) {
                orderLine.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
            }
            return orderLine.save();
        }
        return success;
    }

    public Timestamp getNewerDateAcct() {
        String sql;
        Timestamp invoiceDate = null;
        Timestamp shipDate = null;
        if (this.getC_InvoiceLine_ID() != 0) {
            sql = "SELECT i.DateAcct FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_InvoiceLine_ID=?";
            invoiceDate = DB.getSQLValueTS(null, sql, this.getC_InvoiceLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
            shipDate = DB.getSQLValueTS(null, sql, this.getM_InOutLine_ID());
        }
        if (invoiceDate == null) {
            return shipDate;
        }
        if (shipDate == null) {
            return invoiceDate;
        }
        if (invoiceDate.after(shipDate)) {
            return invoiceDate;
        }
        return shipDate;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "MXP", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(Table_ID, this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success && this.getC_OrderLine_ID() != 0) {
            this.deleteMatchPOCostDetail();
            MOrderLine orderLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
            if (this.getM_InOutLine_ID() != 0) {
                orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(this.getQty()));
            }
            if (this.getC_InvoiceLine_ID() != 0) {
                orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(this.getQty()));
            }
            return orderLine.save(this.get_TrxName());
        }
        return success;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MMatchPO[");
        sb.append(this.get_ID()).append(",Qty=").append(this.getQty()).append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID()).append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID()).append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolidate(Properties ctx) {
        String sql = "SELECT * FROM M_MatchPO po WHERE EXISTS (SELECT 1 FROM M_MatchPO x WHERE po.C_OrderLine_ID=x.C_OrderLine_ID AND po.Qty=x.Qty GROUP BY C_OrderLine_ID, Qty HAVING COUNT(*) = 2)  AND AD_Client_ID=?ORDER BY C_OrderLine_ID, M_InOutLine_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int success = 0;
        int errors = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MMatchPO po1 = new MMatchPO(ctx, rs, null);
                if (!rs.next()) continue;
                MMatchPO po2 = new MMatchPO(ctx, rs, null);
                if (po1.getM_InOutLine_ID() == 0 || po1.getC_InvoiceLine_ID() != 0 || po2.getM_InOutLine_ID() != 0 || po2.getC_InvoiceLine_ID() == 0) continue;
                String s1 = "UPDATE M_MatchPO SET C_InvoiceLine_ID=" + po2.getC_InvoiceLine_ID() + " WHERE M_MatchPO_ID=" + po1.getM_MatchPO_ID();
                int no1 = DB.executeUpdate(s1, null);
                if (no1 != 1) {
                    ++errors;
                    s_log.warning("Not updated M_MatchPO_ID=" + po1.getM_MatchPO_ID());
                    continue;
                }
                String s2 = "DELETE FROM Fact_Acct WHERE AD_Table_ID=473 AND Record_ID=?";
                int no2 = DB.executeUpdate(s2, po2.getM_MatchPO_ID(), null);
                String s3 = "DELETE FROM M_MatchPO WHERE M_MatchPO_ID=?";
                int no3 = DB.executeUpdate(s3, po2.getM_MatchPO_ID(), null);
                if (no2 == 0 && no3 == 1) {
                    ++success;
                    continue;
                }
                s_log.warning("M_MatchPO_ID=" + po2.getM_MatchPO_ID() + " - Deleted=" + no2 + ", Acct=" + no3);
                ++errors;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (errors != 0 || success != 0) {
            s_log.info("Success #" + success + " - Error #" + errors);
        }
    }

    private String createMatchPOCostDetail() {
        if (this.getM_InOutLine_ID() != 0) {
            MOrderLine oLine = this.getOrderLine();
            MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
            for (int asn = 0; asn < acctschemas.length; ++asn) {
                MAcctSchema as = acctschemas[asn];
                if (as.isSkipOrg(this.getAD_Org_ID())) continue;
                BigDecimal poCost = oLine.getPriceCost();
                if (poCost == null || poCost.signum() == 0) {
                    MTax tax;
                    poCost = oLine.getPriceActual();
                    int C_Tax_ID = oLine.getC_Tax_ID();
                    if (oLine.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                        int stdPrecision = MCurrency.getStdPrecision(this.getCtx(), oLine.getC_Currency_ID());
                        BigDecimal costTax = tax.calculateTax(poCost, true, stdPrecision);
                        this.log.fine("Costs=" + poCost + " - Tax=" + costTax);
                        poCost = poCost.subtract(costTax);
                    }
                }
                MInOutLine receiptLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                MInOut inOut = receiptLine.getParent();
                boolean isReturnTrx = inOut.getMovementType().equals("V-");
                MMatchPO[] mPO = MMatchPO.getOrderLine(this.getCtx(), oLine.getC_OrderLine_ID(), this.get_TrxName());
                BigDecimal tQty = Env.ZERO;
                BigDecimal tAmt = Env.ZERO;
                for (int i2 = 0; i2 < mPO.length; ++i2) {
                    if (mPO[i2].getM_AttributeSetInstance_ID() != this.getM_AttributeSetInstance_ID() || mPO[i2].getM_MatchPO_ID() == this.get_ID()) continue;
                    BigDecimal qty = isReturnTrx ? mPO[i2].getQty().negate() : mPO[i2].getQty();
                    tQty = tQty.add(qty);
                    tAmt = tAmt.add(poCost.multiply(qty));
                }
                poCost = poCost.multiply(this.getQty());
                tAmt = tAmt.add(isReturnTrx ? poCost.negate() : poCost);
                tQty = tQty.add(isReturnTrx ? this.getQty().negate() : this.getQty());
                if (oLine.getC_Currency_ID() != as.getC_Currency_ID()) {
                    BigDecimal rate;
                    MOrder order = oLine.getParent();
                    Timestamp dateAcct = order.getDateAcct();
                    MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
                    String costingMethod = product.getCostingMethod(as);
                    if ("A".equals(costingMethod) || "p".equals(costingMethod)) {
                        dateAcct = inOut.getDateAcct();
                    }
                    if ((rate = MConversionRate.getRate(order.getC_Currency_ID(), as.getC_Currency_ID(), dateAcct, order.getC_ConversionType_ID(), oLine.getAD_Client_ID(), oLine.getAD_Org_ID())) == null) {
                        return "Purchase Order not convertible - " + as.getName();
                    }
                    if ((poCost = poCost.multiply(rate)).scale() > as.getCostingPrecision()) {
                        poCost = poCost.setScale(as.getCostingPrecision(), 4);
                    }
                    if ((tAmt = tAmt.multiply(rate)).scale() > as.getCostingPrecision()) {
                        tAmt = tAmt.setScale(as.getCostingPrecision(), 4);
                    }
                }
                MCostDetail.createOrder(as, oLine.getAD_Org_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), oLine.getC_OrderLine_ID(), 0, tAmt, tQty, oLine.getDescription(), this.get_TrxName());
            }
        }
        return "";
    }

    private String deleteMatchPOCostDetail() {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        for (int asn = 0; asn < acctschemas.length; ++asn) {
            MCostDetail cd;
            MAcctSchema as = acctschemas[asn];
            if (as.isSkipOrg(this.getAD_Org_ID()) || (cd = MCostDetail.get(this.getCtx(), "C_OrderLine_ID=?", this.getC_OrderLine_ID(), this.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.get_TrxName())) == null) continue;
            if (cd.getQty().compareTo(Env.ZERO) > 0) {
                MClient client;
                BigDecimal price = cd.getAmt().divide(cd.getQty(), 12, 4);
                cd.setDeltaAmt(price.multiply(this.getQty().negate()));
                cd.setDeltaQty(this.getQty().negate());
                cd.setProcessed(false);
                cd.setAmt(price.multiply(cd.getQty().subtract(this.getQty())));
                cd.setQty(cd.getQty().subtract(this.getQty()));
                if (!cd.isProcessed() && (client = MClient.get(this.getCtx(), this.getAD_Client_ID())).isCostImmediate()) {
                    cd.process();
                }
            }
            if (cd.getQty().compareTo(Env.ZERO) != 0) continue;
            cd.setProcessed(false);
            cd.delete(true);
        }
        return "";
    }
}

