/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.model.X_M_MatchInv;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MMatchInv
extends X_M_MatchInv {
    private static final long serialVersionUID = 3668871839074170205L;
    private static CLogger s_log = CLogger.getCLogger(MMatchInv.class);

    public static MMatchInv[] get(Properties ctx, int M_InOutLine_ID, int C_InvoiceLine_ID, String trxName) {
        if (M_InOutLine_ID <= 0 || C_InvoiceLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "M_InOutLine_ID=? AND C_InvoiceLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "M_InOutLine_ID=? AND C_InvoiceLine_ID=?", trxName).setParameters(M_InOutLine_ID, C_InvoiceLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        if (C_InvoiceLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "C_InvoiceLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", whereClause, trxName).setParameters(C_InvoiceLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInOut(Properties ctx, int M_InOut_ID, String trxName) {
        if (M_InOut_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)", trxName).setParameters(M_InOut_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        if (C_Invoice_ID == 0) {
            return new MMatchInv[0];
        }
        String whereClause = " EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", " EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)", trxName).setParameters(C_Invoice_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public MMatchInv(Properties ctx, int M_MatchInv_ID, String trxName) {
        super(ctx, M_MatchInv_ID, trxName);
        if (M_MatchInv_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MMatchInv(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchInv(MInvoiceLine iLine, Timestamp dateTrx, BigDecimal qty) {
        this(iLine.getCtx(), 0, iLine.get_TrxName());
        this.setClientOrg(iLine);
        this.setC_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(iLine.getM_InOutLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(iLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp ts = this.getNewerDateAcct();
            if (ts == null) {
                ts = this.getDateTrx();
            }
            this.setDateAcct(ts);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        String err;
        if (newRecord && success && (err = this.createMatchInvCostDetail()) != null && err.length() > 0) {
            s_log.warning(err);
            return false;
        }
        return success;
    }

    public Timestamp getNewerDateAcct() {
        String sql = "SELECT i.DateAcct FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_InvoiceLine_ID=?";
        Timestamp invoiceDate = DB.getSQLValueTS(this.get_TrxName(), sql, this.getC_InvoiceLine_ID());
        sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
        Timestamp shipDate = DB.getSQLValueTS(this.get_TrxName(), sql, this.getM_InOutLine_ID());
        if (invoiceDate == null) {
            return shipDate;
        }
        if (shipDate == null) {
            return invoiceDate;
        }
        if (invoiceDate.after(shipDate)) {
            return invoiceDate;
        }
        return shipDate;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "MXI", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(Table_ID, this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.deleteMatchInvCostDetail();
            MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
            int C_OrderLine_ID = iLine.getC_OrderLine_ID();
            if (C_OrderLine_ID == 0) {
                MInOutLine ioLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                C_OrderLine_ID = ioLine.getC_OrderLine_ID();
            }
            if (C_OrderLine_ID == 0) {
                return success;
            }
            MMatchPO[] mPO = MMatchPO.get(this.getCtx(), C_OrderLine_ID, this.getC_InvoiceLine_ID(), this.get_TrxName());
            for (int i2 = 0; i2 < mPO.length; ++i2) {
                if (mPO[i2].getM_InOutLine_ID() == 0) {
                    mPO[i2].delete(true);
                    continue;
                }
                mPO[i2].setC_InvoiceLine_ID(null);
                mPO[i2].save();
            }
        }
        return success;
    }

    private String createMatchInvCostDetail() {
        MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        for (int asn = 0; asn < acctschemas.length; ++asn) {
            MAcctSchema as = acctschemas[asn];
            if (as.isSkipOrg(this.getAD_Org_ID())) continue;
            BigDecimal LineNetAmt = invoiceLine.getLineNetAmt();
            BigDecimal multiplier = this.getQty().divide(invoiceLine.getQtyInvoiced(), 12, 4).abs();
            if (multiplier.compareTo(Env.ONE) != 0) {
                LineNetAmt = LineNetAmt.multiply(multiplier);
            }
            MMatchInv[] mInv = MMatchInv.getInvoiceLine(this.getCtx(), invoiceLine.getC_InvoiceLine_ID(), this.get_TrxName());
            BigDecimal tQty = Env.ZERO;
            BigDecimal tAmt = Env.ZERO;
            for (int i2 = 0; i2 < mInv.length; ++i2) {
                if (!mInv[i2].isPosted() || mInv[i2].getM_MatchInv_ID() == this.get_ID()) continue;
                tQty = tQty.add(mInv[i2].getQty());
                multiplier = mInv[i2].getQty().divide(invoiceLine.getQtyInvoiced(), 12, 4).abs();
                tAmt = tAmt.add(invoiceLine.getLineNetAmt().multiply(multiplier));
            }
            tAmt = tAmt.add(LineNetAmt);
            MInvoice invoice = invoiceLine.getParent();
            if (as.getC_Currency_ID() != invoice.getC_Currency_ID() && (tAmt = MConversionRate.convert(this.getCtx(), tAmt, invoice.getC_Currency_ID(), as.getC_Currency_ID(), invoice.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID())) == null) {
                return "AP Invoice not convertible - " + as.getName();
            }
            MInOutLine receiptLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            MInOut receipt = receiptLine.getParent();
            tQty = receipt.getMovementType().equals("V-") ? tQty.add(this.getQty().negate()) : tQty.add(this.getQty());
            MCostDetail.createInvoice(as, this.getAD_Org_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), invoiceLine.getC_InvoiceLine_ID(), 0, tAmt, tQty, this.getDescription(), this.get_TrxName());
        }
        return "";
    }

    private String deleteMatchInvCostDetail() {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        for (int asn = 0; asn < acctschemas.length; ++asn) {
            MClient client;
            MCostDetail cd;
            MAcctSchema as = acctschemas[asn];
            if (as.isSkipOrg(this.getAD_Org_ID()) || (cd = MCostDetail.get(this.getCtx(), "C_InvoiceLine_ID=?", this.getC_InvoiceLine_ID(), this.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.get_TrxName())) == null) continue;
            MInOut receipt = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName()).getParent();
            BigDecimal qty = this.getQty();
            if (receipt.getMovementType().equals("V-")) {
                qty = this.getQty().negate();
            }
            BigDecimal price = null;
            price = cd.getQty().compareTo(Env.ZERO) == 0 ? Env.ZERO : cd.getAmt().divide(cd.getQty(), 12, 4);
            cd.setDeltaAmt(price.multiply(qty.negate()));
            cd.setDeltaQty(qty.negate());
            cd.setProcessed(false);
            cd.setAmt(price.multiply(cd.getQty().subtract(qty)));
            cd.setQty(cd.getQty().subtract(qty));
            if (!cd.isProcessed() && (client = MClient.get(this.getCtx(), this.getAD_Client_ID())).isCostImmediate()) {
                cd.process();
            }
            if (cd.getQty().compareTo(Env.ZERO) != 0) continue;
            cd.setProcessed(false);
            cd.delete(true);
        }
        return "";
    }

    public static MMatchInv[] getInOutLine(Properties ctx, int M_InOutLine_ID, String trxName) {
        if (M_InOutLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "M_InOutLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "M_InOutLine_ID=?", trxName).setParameters(M_InOutLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }
}

