/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.compiere.model.MLookupInfo;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;

public class MLookupCache {
    private static CLogger s_log = CLogger.getCLogger(MLookupCache.class);
    private static CCache<String, HashMap> s_loadedLookups = new CCache("MLookupCache", 50);

    protected static void loadStart(MLookupInfo info) {
    }

    protected static void loadEnd(MLookupInfo info, HashMap lookup, int TabNo) {
        if (info.IsValidated && lookup.size() > 0) {
            s_loadedLookups.put(MLookupCache.getKey(info, TabNo), lookup);
        }
    }

    private static String getKey(MLookupInfo info, int TabNo) {
        if (info == null) {
            return String.valueOf(System.currentTimeMillis());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(info.WindowNo).append('-').append(TabNo).append(":").append(info.KeyColumn).append(info.AD_Reference_Value_ID).append(info.Query).append(info.ValidationCode);
        return sb.toString();
    }

    protected static boolean loadFromCache(MLookupInfo info, HashMap<Object, Object> lookupTarget, int TabNo) {
        String key = MLookupCache.getKey(info, TabNo);
        HashMap cache = s_loadedLookups.get(key);
        if (cache == null) {
            return false;
        }
        if (cache.size() == 0) {
            s_loadedLookups.remove(key);
            return false;
        }
        for (Object cacheKey : cache.keySet()) {
            Object cacheData = cache.get(cacheKey);
            lookupTarget.put(cacheKey, cacheData);
        }
        s_log.fine("#" + lookupTarget.size());
        return true;
    }

    public static void cacheReset(int WindowNo) {
        String key = String.valueOf(String.valueOf(WindowNo)) + ":";
        int startNo = s_loadedLookups.size();
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String info : s_loadedLookups.keySet()) {
            if (info == null || !info.startsWith(key)) continue;
            toDelete.add(info);
        }
        int i = 0;
        while (i < toDelete.size()) {
            s_loadedLookups.remove(toDelete.get(i));
            ++i;
        }
        int endNo = s_loadedLookups.size();
        s_log.fine("WindowNo=" + WindowNo + " - " + startNo + " -> " + endNo);
    }

    private MLookupCache() {
    }
}

