/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.model.X_LIT_DocTypeExt;
import org.compiere.model.X_LIT_Invoice_Auto;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MLITInvoiceAuto
extends X_LIT_Invoice_Auto {
    public static final String COLUMN_NAME_LIT_DOC_TYPE_EXT_ID = "LIT_DocTypeExt_ID";
    public static final String COLUMN_NAME_VAT_LEDGER_DATE = "VATLedgerDate";
    private static CLogger s_log = CLogger.getCLogger(MLITInvoiceAuto.class);

    public MLITInvoiceAuto(Properties ctx, int LIT_Invoice_Auto_ID, String trxName) {
        super(ctx, LIT_Invoice_Auto_ID, trxName);
    }

    public MLITInvoiceAuto(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MLITInvoiceAuto get(MInvoice invoice, String trxName) {
        PO retValue;
        block10: {
            retValue = null;
            if (invoice == null || invoice.getC_Invoice_ID() == 0) {
                return null;
            }
            String sql = "SELECT * FROM LIT_Invoice_Auto WHERE C_Invoice_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, invoice.getC_Invoice_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MLITInvoiceAuto(invoice.getCtx(), rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            retValue = new MLITInvoiceAuto(invoice.getCtx(), 0, trxName);
            retValue.setClientOrg(invoice);
            ((X_LIT_Invoice_Auto)retValue).setC_Invoice_ID(invoice.getC_Invoice_ID());
            Timestamp tsVATLedgerDate = (Timestamp)invoice.get_Value(COLUMN_NAME_VAT_LEDGER_DATE);
            ((X_LIT_Invoice_Auto)retValue).setVATLedgerDate(tsVATLedgerDate);
            ((X_LIT_Invoice_Auto)retValue).setDateInvoiced(invoice.getDateInvoiced());
            int iC_DocTypeTarget_ID = invoice.getC_DocTypeTarget_ID();
            if (iC_DocTypeTarget_ID > 0) {
                MDocType docType = MDocType.get(invoice.getCtx(), iC_DocTypeTarget_ID);
                int iLIT_DocTypeExt_ID = 0;
                Integer ii = (Integer)docType.get_Value(COLUMN_NAME_LIT_DOC_TYPE_EXT_ID);
                if (ii != null) {
                    iLIT_DocTypeExt_ID = ii;
                }
                X_LIT_DocTypeExt docTypeExt = new X_LIT_DocTypeExt(invoice.getCtx(), iLIT_DocTypeExt_ID, trxName);
                int iC_DocTypeAutoInvoice_ID = docTypeExt.getC_DocTypeAutoInvoice_ID();
                ((X_LIT_Invoice_Auto)retValue).setC_DocTypeAutoInvoice_ID(iC_DocTypeAutoInvoice_ID);
            }
            s_log.fine("(new) " + retValue);
        }
        retValue.set_TrxName(trxName);
        return retValue;
    }
}

