/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.f3p.adempiere.paymentterm.model.F3PMPaySchedule;
import com.f3p.adempiere.paymentterm.model.F3PMPaymentTerm;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySchedule;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.WSTMBPEsclMese;
import org.compiere.model.X_C_InvoicePaySchedule;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MInvoicePaySchedule
extends X_C_InvoicePaySchedule {
    private static final long serialVersionUID = -1529278048406862670L;
    private static CLogger s_log = CLogger.getCLogger(MInvoicePaySchedule.class);
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private MInvoice m_parent = null;

    public static MInvoicePaySchedule[] getInvoicePaySchedule(Properties ctx, int C_Invoice_ID, int C_InvoicePaySchedule_ID, String trxName) {
        String sql = "SELECT * FROM C_InvoicePaySchedule ips ";
        sql = C_Invoice_ID != 0 ? String.valueOf(sql) + "WHERE C_Invoice_ID=? " : String.valueOf(sql) + "WHERE EXISTS (SELECT * FROM C_InvoicePaySchedule x WHERE x.C_InvoicePaySchedule_ID=? AND ips.C_Invoice_ID=x.C_Invoice_ID) ";
        sql = String.valueOf(sql) + "ORDER BY DueDate";
        ArrayList<MInvoicePaySchedule> list = new ArrayList<MInvoicePaySchedule>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            if (C_Invoice_ID != 0) {
                pstmt.setInt(1, C_Invoice_ID);
            } else {
                pstmt.setInt(1, C_InvoicePaySchedule_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInvoicePaySchedule(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getInvoicePaySchedule", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MInvoicePaySchedule[] retValue = new MInvoicePaySchedule[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MInvoicePaySchedule(Properties ctx, int C_InvoicePaySchedule_ID, String trxName) {
        super(ctx, C_InvoicePaySchedule_ID, trxName);
        if (C_InvoicePaySchedule_ID == 0) {
            this.setIsValid(false);
        }
    }

    public MInvoicePaySchedule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoicePaySchedule(MInvoice invoice, MPaySchedule paySchedule) {
        super(invoice.getCtx(), 0, invoice.get_TrxName());
        this.m_parent = invoice;
        this.setClientOrg(invoice);
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setC_PaySchedule_ID(paySchedule.getC_PaySchedule_ID());
        String sPaymentRule = F3PMPaySchedule.getPaymentRule(paySchedule);
        if (sPaymentRule == null) {
            this.set_ValueOfColumn("PaymentRule", (Object)invoice.getPaymentRule());
        } else {
            this.set_ValueOfColumn("PaymentRule", (Object)sPaymentRule);
        }
        int scale = MCurrency.getStdPrecision(this.getCtx(), invoice.getC_Currency_ID());
        String TipoCalc = F3PMPaySchedule.getWSTTipoCalc(paySchedule);
        BigDecimal due = invoice.getGrandTotal();
        BigDecimal dueImpo = invoice.getTotalLines();
        BigDecimal dueIva = due.subtract(dueImpo);
        if (due.compareTo(Env.ZERO) == 0) {
            this.setDueAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsValid(false);
        } else {
            BigDecimal discount;
            if (TipoCalc.equals("T") || TipoCalc.isEmpty() || TipoCalc.equals("")) {
                due = due.multiply(paySchedule.getPercentage()).divide(HUNDRED, scale, 4);
                this.setDueAmt(due);
                discount = due.multiply(paySchedule.getDiscount()).divide(HUNDRED, scale, 4);
                this.setDiscountAmt(discount);
                this.setIsValid(true);
            }
            if (TipoCalc.equals("I")) {
                dueImpo = dueImpo.multiply(paySchedule.getPercentage()).divide(HUNDRED, scale, 4);
                this.setDueAmt(dueImpo);
                discount = dueImpo.multiply(paySchedule.getDiscount()).divide(HUNDRED, scale, 4);
                this.setDiscountAmt(discount);
                this.setIsValid(true);
            }
            if (TipoCalc.equals("S")) {
                this.setDueAmt(dueIva);
                discount = dueIva.multiply(paySchedule.getDiscount()).divide(HUNDRED, scale, 4);
                this.setDiscountAmt(discount);
                this.setIsValid(true);
            }
            if (TipoCalc.equals("R")) {
                dueImpo = dueImpo.multiply(paySchedule.getPercentage()).divide(HUNDRED, scale, 4);
                this.setDueAmt(dueImpo.add(dueIva));
                discount = dueImpo.multiply(paySchedule.getDiscount()).divide(HUNDRED, scale, 4);
                this.setDiscountAmt(discount.add(dueIva));
                this.setIsValid(true);
            }
        }
        MPaymentTerm payTerm = paySchedule.getParent();
        int mese_escl = F3PMPaymentTerm.getMeseEsclusione(payTerm);
        int gg_mese_escl = F3PMPaymentTerm.getGiornoMeseEsclusione(payTerm);
        int mese_escl2 = F3PMPaymentTerm.getMeseEsclusione2(payTerm);
        int gg_mese_escl2 = F3PMPaymentTerm.getGiornoMeseEsclusione2(payTerm);
        int wst_giornofisso = 0;
        if (invoice.isSOTrx()) {
            int C_BPartner_ID = invoice.getC_BPartner_ID();
            MBPartner bp = new MBPartner(invoice.getCtx(), C_BPartner_ID, invoice.get_TrxName());
            if (WSTMBPEsclMese.getGiornoFisso(bp) > 0) {
                wst_giornofisso = WSTMBPEsclMese.getGiornoFisso(bp);
            }
            if (WSTMBPEsclMese.getMeseEsclusione(bp) > 0) {
                mese_escl = WSTMBPEsclMese.getMeseEsclusione(bp);
                gg_mese_escl = WSTMBPEsclMese.getGiornoMeseEsclusione(bp);
                mese_escl2 = WSTMBPEsclMese.getMeseEsclusione2(bp);
                gg_mese_escl2 = WSTMBPEsclMese.getGiornoMeseEsclusione2(bp);
            }
        }
        if (paySchedule.isDueFixed()) {
            String sql = "SELECT paymenttermduedate(?, ?) FROM C_PAYMENTTERM WHERE C_PAYMENTTERM_ID = ?";
            Timestamp startDate = DB.getSQLValueTS(invoice.get_TrxName(), sql, payTerm.getC_PaymentTerm_ID(), invoice.getDateInvoiced(), payTerm.getC_PaymentTerm_ID());
            int months = paySchedule.getFixMonthOffset();
            Calendar calDate = GregorianCalendar.getInstance();
            calDate.setTime(startDate);
            calDate.add(2, months);
            int iMonthDay = payTerm.getFixMonthDay();
            if (iMonthDay > calDate.get(5)) {
                iMonthDay = Math.min(iMonthDay, calDate.getActualMaximum(5));
                calDate.set(5, iMonthDay);
            }
            if (wst_giornofisso > 0) {
                calDate.set(5, wst_giornofisso);
            }
            Timestamp dueDate = TimeUtil.getDay(calDate.getTimeInMillis());
            int mesedue = dueDate.getMonth() + 1;
            if (mese_escl != 0 && mesedue == mese_escl) {
                if (mese_escl == 12) {
                    dueDate.setYear(dueDate.getYear() + 1);
                    dueDate.setMonth(0);
                    dueDate.setDate(gg_mese_escl);
                } else {
                    dueDate.setMonth(mese_escl);
                    dueDate.setDate(gg_mese_escl);
                }
            }
            if (mese_escl2 != 0 && mesedue == mese_escl2) {
                if (mese_escl2 == 12) {
                    dueDate.setYear(dueDate.getYear() + 1);
                    dueDate.setMonth(0);
                    dueDate.setDate(gg_mese_escl2);
                } else {
                    dueDate.setMonth(mese_escl2 + 1);
                    dueDate.setDate(gg_mese_escl2);
                }
            }
            this.setDueDate(dueDate);
        } else {
            Timestamp dueDate = TimeUtil.addDays(invoice.getDateInvoiced(), paySchedule.getNetDays());
            this.setDueDate(dueDate);
            if (wst_giornofisso > 0) {
                dueDate.setDate(wst_giornofisso);
            }
            int mesedue = dueDate.getMonth() + 1;
            if (mese_escl != 0 && mesedue == mese_escl) {
                if (mese_escl == 12) {
                    dueDate.setYear(dueDate.getYear() + 1);
                    dueDate.setMonth(0);
                    dueDate.setDate(gg_mese_escl);
                } else {
                    dueDate.setMonth(mese_escl + 1);
                    dueDate.setDate(gg_mese_escl);
                }
            }
            if (mese_escl2 != 0 && mesedue == mese_escl2) {
                if (mese_escl2 == 12) {
                    dueDate.setYear(dueDate.getYear() + 1);
                    dueDate.setMonth(0);
                    dueDate.setDate(gg_mese_escl2);
                } else {
                    dueDate.setMonth(mese_escl2 + 1);
                    dueDate.setDate(gg_mese_escl2);
                }
            }
            this.setDueDate(dueDate);
        }
        Timestamp discountDate = TimeUtil.addDays(invoice.getDateInvoiced(), paySchedule.getDiscountDays());
        this.setDiscountDate(discountDate);
    }

    public MInvoice getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setParent(MInvoice parent) {
        this.m_parent = parent;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoicePaySchedule[");
        sb.append(this.get_ID()).append("-Due=" + this.getDueDate() + "/" + this.getDueAmt()).append(";Discount=").append(this.getDiscountDate() + "/" + this.getDiscountAmt()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("DueAmt")) {
            this.log.fine("beforeSave");
            this.setIsValid(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.is_ValueChanged("DueAmt")) {
            this.log.fine("afterSave");
            this.getParent();
            this.m_parent.validatePaySchedule();
            this.m_parent.save();
        }
        return success;
    }
}

