/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.Query;
import org.compiere.model.X_C_DunningRun;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MDunningRun
extends X_C_DunningRun {
    private static final long serialVersionUID = 6858939271415643483L;
    private MDunningRunEntry[] m_entries = null;
    private MDunningLevel[] m_levels = null;

    public MDunningRun(Properties ctx, int C_DunningRun_ID, String trxName) {
        super(ctx, C_DunningRun_ID, trxName);
        if (C_DunningRun_ID == 0) {
            this.setDunningDate(new Timestamp(System.currentTimeMillis()));
            this.setProcessed(false);
        }
    }

    public MDunningRun(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDunningLevel[] getLevels() {
        if (this.m_levels != null) {
            return this.m_levels;
        }
        List<MDunningLevel> levels = this.getC_DunningLevel_ID() > 0 ? new Query(this.getCtx(), "C_DunningLevel", "C_Dunning_ID=? AND C_DunningLevel_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getC_Dunning_ID(), this.getC_DunningLevel_ID()).setOrderBy("DaysAfterDue DESC, C_DunningLevel_ID").list() : new Query(this.getCtx(), "C_DunningLevel", "C_Dunning_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getC_Dunning_ID()).setOrderBy("DaysAfterDue DESC, C_DunningLevel_ID").list();
        this.m_levels = new MDunningLevel[levels.size()];
        levels.toArray(this.m_levels);
        return this.m_levels;
    }

    public MDunningRunEntry[] getEntries(boolean requery) {
        return this.getEntries(requery, false);
    }

    public MDunningRunEntry[] getEntries(boolean requery, boolean onlyInvoices) {
        if (this.m_entries != null && !requery) {
            return this.m_entries;
        }
        String sql = "SELECT * FROM C_DunningRunEntry WHERE C_DunningRun_ID=? ORDER BY C_DunningLevel_ID, C_DunningRunEntry_ID";
        ArrayList<MDunningRunEntry> list = new ArrayList<MDunningRunEntry>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_DunningRun_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MDunningRunEntry thisEntry = new MDunningRunEntry(this.getCtx(), rs, this.get_TrxName());
                if (onlyInvoices && thisEntry.hasInvoices()) continue;
                list.add(new MDunningRunEntry(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_entries = new MDunningRunEntry[list.size()];
        list.toArray(this.m_entries);
        return this.m_entries;
    }

    public boolean deleteEntries(boolean force) {
        boolean ok;
        this.getEntries(true);
        for (MDunningRunEntry entry : this.m_entries) {
            entry.delete(force);
        }
        boolean bl = ok = this.getEntries(true).length == 0;
        if (ok) {
            this.m_entries = null;
        }
        return ok;
    }

    public MDunningRunEntry getEntry(int C_BPartner_ID, int C_Currency_ID, int SalesRep_ID, int C_DunningLevel_ID) {
        int C_BPartnerRelated_ID = C_BPartner_ID;
        this.getEntries(false);
        for (int i2 = 0; i2 < this.m_entries.length; ++i2) {
            MDunningRunEntry entry = this.m_entries[i2];
            if (entry.getC_BPartner_ID() != C_BPartnerRelated_ID || entry.getC_DunningLevel_ID() != C_DunningLevel_ID) continue;
            return entry;
        }
        MDunningRunEntry entry = new MDunningRunEntry(this);
        MBPartner bp = new MBPartner(this.getCtx(), C_BPartnerRelated_ID, this.get_TrxName());
        entry.setBPartner(bp, true);
        if (entry.getSalesRep_ID() == 0) {
            entry.setSalesRep_ID(SalesRep_ID);
        }
        entry.setC_Currency_ID(C_Currency_ID);
        entry.setC_DunningLevel_ID(C_DunningLevel_ID);
        this.m_entries = null;
        return entry;
    }
}

