/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.List;
import java.util.Properties;
import org.compiere.model.I_A_Depreciation_Table_Detail;
import org.compiere.model.Query;
import org.compiere.model.X_A_Depreciation_Table_Detail;
import org.compiere.model.X_A_Depreciation_Table_Header;
import org.compiere.util.CCache;

public class MDepreciationTableHeader
extends X_A_Depreciation_Table_Header {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, MDepreciationTableHeader> s_cache = new CCache("A_Depreciation_Table_Header", 10, 0);
    protected List<X_A_Depreciation_Table_Detail> m_lstDetails = null;
    protected int m_iGreatestPeriod = -1;

    public MDepreciationTableHeader(Properties ctx, int A_Depreciation_Table_Header_ID, String trxName) {
        super(ctx, A_Depreciation_Table_Header_ID, trxName);
    }

    public static MDepreciationTableHeader get(Properties ctx, int A_Depreciation_Table_Header_ID) {
        if (A_Depreciation_Table_Header_ID <= 0) {
            return null;
        }
        MDepreciationTableHeader o = s_cache.get(A_Depreciation_Table_Header_ID);
        if (o != null) {
            return o;
        }
        o = new MDepreciationTableHeader(ctx, A_Depreciation_Table_Header_ID, null);
        if (o.get_ID() > 0) {
            s_cache.put(A_Depreciation_Table_Header_ID, o);
            return o;
        }
        return null;
    }

    public int getGreatestPeriod() {
        return this.m_iGreatestPeriod;
    }

    public List<X_A_Depreciation_Table_Detail> getDetails(String sTrxName) {
        if (this.m_lstDetails == null) {
            Query q = new Query(this.getCtx(), "A_Depreciation_Table_Detail", "A_Depreciation_Table_Header_ID = ?", sTrxName);
            q.setOnlyActiveRecords(true);
            q.setParameters(this.getA_Depreciation_Table_Header_ID());
            this.m_lstDetails = q.list();
            if (this.m_lstDetails != null) {
                for (X_A_Depreciation_Table_Detail detail : this.m_lstDetails) {
                    if (detail.getA_Period() <= this.m_iGreatestPeriod) continue;
                    this.m_iGreatestPeriod = detail.getA_Period();
                }
            }
        }
        return this.m_lstDetails;
    }

    public I_A_Depreciation_Table_Detail getDetailByPeriod(int iPeriod, String sTrxName) {
        X_A_Depreciation_Table_Detail retDetail = null;
        for (X_A_Depreciation_Table_Detail detail : this.getDetails(sTrxName)) {
            if (detail.getA_Period() != iPeriod) continue;
            retDetail = detail;
            break;
        }
        return retDetail;
    }
}

