/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Logger;
import org.compiere.model.I_A_Depreciation_Table_Detail;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationTableHeader;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.Query;
import org.compiere.model.X_A_Depreciation;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import ro.arhipac.adempiere.fa.exceptions.AssetNotImplementedException;
import ro.arhipac.adempiere.fa.exceptions.AssetNotSupportedException;

public class MDepreciation
extends X_A_Depreciation {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, MDepreciation> s_cache = new CCache("A_Depreciation", 5);
    private static CCache<String, MDepreciation> s_cache_forType = new CCache("A_Depreciation_DepreciationType", 5);
    private static Logger s_log = CLogger.getCLogger(MDepreciation.class);
    private static final int m_precision = 2;
    private static final BigDecimal BD_12 = BigDecimal.valueOf(12L);

    public MDepreciation(Properties ctx, int A_Depreciation_ID, String trxName) {
        super(ctx, A_Depreciation_ID, trxName);
    }

    public MDepreciation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private static void addToCache(MDepreciation depr) {
        if (depr == null) {
            return;
        }
        s_cache.put(depr.get_ID(), depr);
        String key = "" + depr.getAD_Client_ID() + "_" + depr.getDepreciationType();
        s_cache_forType.put(key, depr);
    }

    public static MDepreciation get(Properties ctx, int A_Depreciation_ID) {
        MDepreciation depr = s_cache.get(A_Depreciation_ID);
        if (depr != null) {
            return depr;
        }
        depr = new MDepreciation(ctx, A_Depreciation_ID, null);
        if (depr.get_ID() > 0) {
            MDepreciation.addToCache(depr);
        } else {
            depr = null;
        }
        return depr;
    }

    public static MDepreciation get(Properties ctx, String depreciationType) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String key = "" + AD_Client_ID + "_" + depreciationType;
        MDepreciation depr = s_cache_forType.get(key);
        if (depr != null) {
            return depr;
        }
        String whereClause = "DepreciationType=? AND AD_Client_ID IN (0,?)";
        depr = (MDepreciation)new Query(ctx, "A_Depreciation", "DepreciationType=? AND AD_Client_ID IN (0,?)", null).setOrderBy("AD_Client_ID DESC").setParameters(depreciationType, AD_Client_ID).firstOnly();
        MDepreciation.addToCache(depr);
        return depr;
    }

    public static int getPrecision() {
        return 2;
    }

    public boolean requireLastPeriodAdjustment() {
        return !"ARH_ZERO".equals(this.getDepreciationType());
    }

    public BigDecimal invoke(MDepreciationWorkfile assetwk, MAssetAcct assetAcct, int A_Current_Period, BigDecimal Accum_Dep) {
        String depreciationType = this.getDepreciationType();
        BigDecimal retValue = null;
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("Entering: DepreciationType=" + depreciationType + ", assetwk=" + assetwk + ", assetacct=" + assetAcct + ", A_Current_Period=" + A_Current_Period + ", Accum_Dep=" + Accum_Dep);
        }
        if (!this.canInvoke(assetwk, assetAcct, A_Current_Period, Accum_Dep)) {
            return BigDecimal.ZERO;
        }
        if (depreciationType.equalsIgnoreCase("SL")) {
            retValue = this.apply_SL(assetwk, assetAcct, A_Current_Period, Accum_Dep);
        } else if (depreciationType.equalsIgnoreCase("ARH_VAR")) {
            retValue = this.apply_ARH_VAR(assetwk, assetAcct, A_Current_Period, Accum_Dep);
        } else if (depreciationType.equalsIgnoreCase("ARH_AD1")) {
            retValue = this.apply_ARH_AD1(assetwk, assetAcct, A_Current_Period, Accum_Dep);
        } else if (depreciationType.equalsIgnoreCase("ARH_AD2")) {
            retValue = this.apply_ARH_AD2(assetwk, assetAcct, A_Current_Period, Accum_Dep);
        } else if (depreciationType.equalsIgnoreCase("ARH_ZERO")) {
            retValue = this.apply_ARH_ZERO(assetwk, assetAcct, A_Current_Period, Accum_Dep);
        } else if (depreciationType.equalsIgnoreCase("TAB")) {
            retValue = this.applyF3P_Table(assetwk, assetAcct, A_Current_Period, Accum_Dep);
        } else {
            throw new AssetNotSupportedException("DepreciationType", depreciationType);
        }
        if (retValue == null) {
            retValue = BigDecimal.ZERO;
        }
        retValue = retValue.setScale(MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("Leaving: retValue=" + retValue);
        }
        return retValue;
    }

    public boolean canInvoke(MDepreciationWorkfile assetwk, MAssetAcct assetAcct, int A_Current_Period, BigDecimal Accum_Dep) {
        boolean ok;
        if (assetwk == null) {
            this.log.warning("@NotFound@ @A_Depreciation_Workfile_ID@");
            return false;
        }
        int offset = this.getFixMonthOffset();
        int lifePeriods = assetwk.getUseLifeMonths(assetwk.isFiscal());
        boolean bl = ok = offset <= A_Current_Period;
        if (CLogMgt.isLevelFinest()) {
            this.log.finest("A_Current_Period=" + A_Current_Period + ", lifePeriods=" + lifePeriods + " (offset=" + offset + ") ==> OK=" + ok);
        }
        return ok;
    }

    private BigDecimal apply_ARH_ZERO(MDepreciationWorkfile wk, MAssetAcct assetAcct, int A_Current_Period, BigDecimal Accum_Dep) {
        return Env.ZERO;
    }

    private BigDecimal apply_SL(MDepreciationWorkfile wk, MAssetAcct assetAcct, int A_Current_Period, BigDecimal Accum_Dep) {
        BigDecimal remainingPeriods = new BigDecimal(wk.getRemainingPeriods(A_Current_Period - 1));
        BigDecimal remainingAmt = wk.getRemainingCost(Accum_Dep);
        BigDecimal amtPerPeriod = Env.ZERO;
        if (remainingPeriods.signum() != 0) {
            amtPerPeriod = remainingAmt.divide(remainingPeriods, MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        }
        if (CLogMgt.isLevelFinest()) {
            this.log.finest("currentPeriod=" + A_Current_Period + ", remainingAmt=" + remainingAmt + ", remainingPeriods=" + remainingPeriods + " => amtPerPeriod=" + amtPerPeriod);
        }
        return amtPerPeriod;
    }

    private BigDecimal apply_ARH_VAR(MDepreciationWorkfile wk, MAssetAcct acct, int A_Current_Period, BigDecimal Accum_Dep) {
        BigDecimal amt = wk.getActualCost();
        BigDecimal varPercent = acct.getA_Depreciation_Variable_Perc(wk.isFiscal()).setScale(MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        BigDecimal assetExp = BigDecimal.ZERO;
        if (A_Current_Period == 0) {
            assetExp = amt.multiply(varPercent);
        } else if (A_Current_Period >= 12) {
            BigDecimal remainingAmt = wk.getRemainingCost(Accum_Dep);
            BigDecimal remainingPeriods = new BigDecimal(wk.getRemainingPeriods(A_Current_Period));
            assetExp = remainingAmt.divide(remainingPeriods, MDepreciation.getPrecision(), RoundingMode.HALF_UP);
            if (CLogMgt.isLevelFinest()) {
                this.log.fine("remainingAmt=" + remainingAmt + ", remainingPeriods=" + remainingPeriods + " => assetExp=" + assetExp);
            }
        }
        return assetExp;
    }

    private BigDecimal apply_ARH_AD1(MDepreciationWorkfile wk, MAssetAcct assetAcct, int A_Current_Period, BigDecimal Accum_Dep) {
        BigDecimal assetAmt = wk.getActualCost();
        int A_Life_Period = wk.getA_Life_Period();
        int A_Current_Year = A_Current_Period / 12;
        int A_Life_Year = A_Life_Period / 12;
        BigDecimal coef_K = MDepreciation.get_AD_K(A_Life_Year);
        BigDecimal coef_sl = BigDecimal.ONE.divide(new BigDecimal(A_Life_Year), MDepreciation.getPrecision() + 2, RoundingMode.DOWN);
        BigDecimal coef_ad1 = coef_sl.multiply(coef_K);
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("assetAmt=" + assetAmt + ", A_Life_Period=" + A_Life_Period);
            this.log.fine("A_Current_Year=" + A_Current_Year + ", A_Life_Year=" + A_Life_Year);
            this.log.fine("coef_K=" + coef_K + ", coef_sl=" + coef_sl + ", coef_ad1=" + coef_ad1);
        }
        BigDecimal amtPerYear = BigDecimal.ZERO;
        boolean is_SL = false;
        BigDecimal amt_sl = BigDecimal.ZERO;
        BigDecimal amt_r = assetAmt;
        for (int curr_year = 0; curr_year <= A_Current_Year; ++curr_year) {
            if (!is_SL) {
                int A_RemainingLife_Year = A_Life_Year - curr_year;
                BigDecimal amt_ad1 = amt_r.multiply(coef_ad1);
                amt_sl = amt_r.divide(new BigDecimal(A_RemainingLife_Year), MDepreciation.getPrecision(), RoundingMode.HALF_UP);
                if (CLogMgt.isLevelFinest()) {
                    s_log.fine("amt_r=" + amt_r + ", amt_ad1=amt_r*coef_ad1=" + amt_ad1 + ", amt_sl=amt_r/A_RemainingLife_Year=" + amt_sl + ", A_Current_Year=" + A_Current_Year + ", A_RemainingLife_Year=" + A_RemainingLife_Year);
                }
                if (curr_year == 0 || amt_ad1.compareTo(amt_sl) >= 0) {
                    amtPerYear = amt_ad1;
                } else {
                    amtPerYear = amt_sl;
                    is_SL = true;
                    s_log.fine("*** SE TRECE PE LINIARA cu amt_sl= " + amt_sl + " ***");
                }
            } else {
                amtPerYear = amt_sl;
                s_log.fine("* liniara *");
            }
            amt_r = amt_r.subtract(amtPerYear);
            if (!CLogMgt.isLevelFinest()) continue;
            s_log.fine("year=" + curr_year + ", amtPerYear=" + amtPerYear + ", amt_r=" + amt_r);
        }
        if (CLogMgt.isLevelFinest()) {
            s_log.fine("amt_r=" + amt_r + ", amtPerYear=" + amtPerYear);
        }
        BigDecimal assetExp = this.getPeriodExp(A_Current_Period, amtPerYear);
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("assetExp=" + assetExp);
        }
        return assetExp;
    }

    private BigDecimal apply_ARH_AD2(MDepreciationWorkfile wk, MAssetAcct assetAcct, int A_Current_Period, BigDecimal Accum_Dep) {
        throw new AssetNotImplementedException("AD2");
    }

    private static BigDecimal get_AD_K(int A_Life_Year) {
        if (A_Life_Year < 2) {
            throw new IllegalArgumentException("@A_Life_Year@ = " + A_Life_Year + " < 2");
        }
        if (A_Life_Year <= 5) {
            return new BigDecimal(1.5);
        }
        if (A_Life_Year <= 10) {
            return new BigDecimal(2.0);
        }
        return new BigDecimal(2.5);
    }

    protected BigDecimal getPeriodExp(int A_Current_Period, BigDecimal amtPerYear) {
        BigDecimal amtPerMonth = amtPerYear.divide(BD_12, MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        BigDecimal adj = BigDecimal.ZERO;
        BigDecimal assetExp = amtPerMonth;
        if (A_Current_Period % 12 == 11) {
            adj = amtPerYear.subtract(amtPerMonth.multiply(BD_12));
            assetExp = assetExp.add(adj).setScale(MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        }
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("amtPerYear=" + amtPerYear + ", amtPerMonth=" + amtPerMonth + ", adj=" + adj + " => assetExp=" + assetExp);
        }
        return assetExp;
    }

    protected BigDecimal applyF3P_Table(MDepreciationWorkfile wk, MAssetAcct assetAcct, int A_Current_Period, BigDecimal Accum_Dep) {
        MDepreciationTableHeader tableHeader = null;
        BigDecimal retValue = null;
        String sTableRateType = null;
        I_A_Depreciation_Table_Detail detail = null;
        tableHeader = wk.isFiscal() ? MDepreciationTableHeader.get(this.getCtx(), assetAcct.getA_Depreciation_Table_Hdr_F_ID()) : MDepreciationTableHeader.get(this.getCtx(), assetAcct.getA_Depreciation_Table_Header_ID());
        if (tableHeader.getA_Term().equals("PR")) {
            detail = tableHeader.getDetailByPeriod(A_Current_Period, this.get_TrxName());
            retValue = wk.getA_Asset_Cost();
        } else if (tableHeader.getA_Term().equals("YR")) {
            Timestamp dateAcct = wk.getAcctDateForDepreciationPeriod(A_Current_Period);
            int iDepreciationPeriod = TimeUtil.getCalendar(dateAcct).get(2) + 1;
            if (iDepreciationPeriod == tableHeader.getF3P_Depreciation_Period()) {
                Calendar calStart = TimeUtil.getCalendar(wk.getAsset(false).getAssetServiceDate());
                Calendar calEnd = TimeUtil.getCalendar(dateAcct);
                int iPeriod = calEnd.get(1) - calStart.get(1);
                if (iPeriod == tableHeader.getGreatestPeriod()) {
                    retValue = wk.getActualCost().subtract(Accum_Dep);
                } else {
                    detail = tableHeader.getDetailByPeriod(iPeriod, this.get_TrxName());
                    if (detail != null) {
                        retValue = wk.getA_Asset_Cost();
                    }
                }
            }
        } else {
            throw new AssetNotImplementedException(tableHeader.getA_Term());
        }
        if (retValue != null && detail != null) {
            sTableRateType = detail.getA_Table_Rate_Type();
            if (sTableRateType == null) {
                sTableRateType = tableHeader.getA_Table_Rate_Type();
            }
            if (sTableRateType.equals("AM")) {
                retValue = detail.getA_Depreciation_Rate();
            } else if (sTableRateType.equals("RT")) {
                retValue = retValue.multiply(detail.getA_Depreciation_Rate());
            }
        }
        return retValue;
    }
}

