/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Column;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.X_AD_Column;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MColumn
extends X_AD_Column {
    private static final long serialVersionUID = 6543789555737635129L;
    private static CCache<Integer, MColumn> s_cache = new CCache("AD_Column", 20);
    private static CLogger s_log = CLogger.getCLogger(MColumn.class);

    public static I_AD_Column setAD_Column(Properties ctx, I_AD_Column column, String trxName) {
        String entityType;
        String columnName;
        MTable table = (MTable)column.getAD_Table();
        M_Element element = new M_Element(ctx, column.getAD_Element_ID(), trxName);
        if (element.getAD_Reference_ID() == 13 && !(columnName = String.valueOf(table.get_TableName()) + "_ID").equals(element.getColumnName())) {
            column.setAD_Reference_ID(19);
        }
        if (!"D".equals(entityType = column.getAD_Table().getEntityType())) {
            column.setEntityType(entityType);
        }
        if (column.getColumnName() == null || column.getColumnName().length() <= 0) {
            column.setColumnName(element.getColumnName());
        }
        if (column.getFieldLength() <= 0) {
            column.setFieldLength(element.getFieldLength());
        }
        if (column.getAD_Reference_ID() <= 0) {
            column.setAD_Reference_ID(element.getAD_Reference_ID());
        }
        if (column.getAD_Reference_Value_ID() <= 0) {
            column.setAD_Reference_Value_ID(element.getAD_Reference_Value_ID());
        }
        if (column.getName() == null || column.getName().length() <= 0) {
            column.setName(element.getName());
        }
        if (column.getDescription() == null || column.getDescription().length() <= 0) {
            column.setDescription(element.getDescription());
        }
        if (column.getHelp() == null || column.getHelp().length() <= 0) {
            column.setHelp(element.getHelp());
        }
        if (column.getColumnName().equals("Name") || column.getColumnName().equals("Value")) {
            column.setIsIdentifier(true);
            int seqNo = DB.getSQLValue(trxName, "SELECT MAX(SeqNo) FROM AD_Column WHERE AD_Table_ID=? AND IsIdentifier='Y'", column.getAD_Table_ID());
            column.setSeqNo(seqNo + 1);
        }
        return column;
    }

    public static MColumn get(Properties ctx, int AD_Column_ID) {
        Integer key = new Integer(AD_Column_ID);
        MColumn retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MColumn(ctx, AD_Column_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static String getColumnName(Properties ctx, int AD_Column_ID) {
        MColumn col = MColumn.get(ctx, AD_Column_ID);
        if (col.get_ID() == 0) {
            return null;
        }
        return col.getColumnName();
    }

    public MColumn(Properties ctx, int AD_Column_ID, String trxName) {
        super(ctx, AD_Column_ID, trxName);
        if (AD_Column_ID == 0) {
            this.setIsAlwaysUpdateable(false);
            this.setIsEncrypted(false);
            this.setIsIdentifier(false);
            this.setIsKey(false);
            this.setIsMandatory(false);
            this.setIsParent(false);
            this.setIsSelectionColumn(false);
            this.setIsTranslated(false);
            this.setIsUpdateable(true);
            this.setVersion(Env.ZERO);
        }
    }

    public MColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MColumn(MTable parent, String columnName, int length, int AD_Reference, String defaultValue) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
        this.setColumnName(columnName);
        M_Element AD_Element = M_Element.get(this.getCtx(), columnName);
        if (AD_Element != null) {
            this.setAD_Element_ID(AD_Element.get_ID());
        }
        this.setName(columnName);
        this.setIsActive(true);
        this.setVersion(Env.ONE);
        this.setIsMandatory(true);
        this.setIsAllowLogging(true);
        this.setFieldLength(length);
        this.setAD_Reference_ID(AD_Reference);
        this.setDefaultValue(defaultValue);
        this.setUpdateable(false);
    }

    public boolean isStandardColumn() {
        String columnName = this.getColumnName();
        return columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("IsActive") || columnName.startsWith("Created") || columnName.startsWith("Updated");
    }

    public boolean isVirtualColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0;
    }

    public boolean isEncrypted() {
        String s = this.getIsEncrypted();
        return "Y".equals(s);
    }

    public void setIsEncrypted(boolean IsEncrypted) {
        this.setIsEncrypted(IsEncrypted ? "Y" : "N");
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int cnt;
        int displayType;
        if (newRecord) {
            MColumn.setAD_Column(this.getCtx(), this, this.get_TrxName());
        }
        if (DisplayType.isLOB(displayType = this.getAD_Reference_ID())) {
            if (this.getFieldLength() != 0) {
                this.setFieldLength(0);
            }
        } else if (this.getFieldLength() == 0) {
            if (DisplayType.isID(displayType)) {
                this.setFieldLength(10);
            } else if (DisplayType.isNumeric(displayType)) {
                this.setFieldLength(14);
            } else if (DisplayType.isDate(displayType)) {
                this.setFieldLength(7);
            } else {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "FieldLength"));
                return false;
            }
        }
        if (this.isIdentifier() && (cnt = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Column WHERE AD_Table_ID=? AND AD_Column_ID!=? AND IsIdentifier='Y' AND SeqNo=?", this.getAD_Table_ID(), this.getAD_Column_ID(), this.getSeqNo())) > 0) {
            this.log.saveError("SaveErrorNotUnique", Msg.getElement(this.getCtx(), "SeqNo"));
            return false;
        }
        if (this.isVirtualColumn()) {
            if (this.isMandatory()) {
                this.setIsMandatory(false);
            }
            if (this.isUpdateable()) {
                this.setIsUpdateable(false);
            }
        }
        if (this.isParent() || this.isKey()) {
            this.setIsUpdateable(false);
        }
        if (this.isAlwaysUpdateable() && !this.isUpdateable()) {
            this.setIsAlwaysUpdateable(false);
        }
        if (this.isEncrypted()) {
            int dt = this.getAD_Reference_ID();
            if (this.isKey() || this.isParent() || this.isStandardColumn() || this.isVirtualColumn() || this.isIdentifier() || this.isTranslated() || DisplayType.isLookup(dt) || DisplayType.isLOB(dt) || "DocumentNo".equalsIgnoreCase(this.getColumnName()) || "Value".equalsIgnoreCase(this.getColumnName()) || "Name".equalsIgnoreCase(this.getColumnName())) {
                this.log.warning("Encryption not sensible - " + this.getColumnName());
                this.setIsEncrypted(false);
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0) {
            M_Element element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            this.setColumnName(element.getColumnName());
            this.setName(element.getName());
            this.setDescription(element.getDescription());
            this.setHelp(element.getHelp());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help"))) {
            StringBuffer sql = new StringBuffer("UPDATE AD_Field SET Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(" WHERE AD_Column_ID=").append(this.get_ID()).append(" AND IsCentrallyMaintained='Y'");
            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("afterSave - Fields updated #" + no);
        }
        return success;
    }

    public String getSQLAdd(MTable table) {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("ALTER TABLE ").append(table.getTableName()).append(" ADD ").append(this.getSQLDDL());
        String constraint = this.getConstraint(table.getTableName());
        if (constraint != null && constraint.length() > 0) {
            sql.append("; ").append("ALTER TABLE ").append(table.getTableName()).append(" ADD ").append(constraint);
        }
        return sql.toString();
    }

    public String getSQLDDL() {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuffer sql = new StringBuffer(this.getColumnName()).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            sql.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!this.isMandatory()) {
                sql.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        if (this.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(this.getColumnName()).append(" IN ('Y','N'))");
        }
        if (this.isMandatory()) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    public String getSQLModify(MTable table, boolean setNullOption) {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlBase = new StringBuffer("ALTER TABLE ").append(table.getTableName()).append(" MODIFY ").append(this.getColumnName());
        StringBuffer sqlDefault = new StringBuffer(sqlBase).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            sqlDefault.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!this.isMandatory()) {
                sqlDefault.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        sql.append(sqlDefault);
        if (this.isMandatory() && defaultValue != null && defaultValue.length() > 0) {
            StringBuffer sqlSet = new StringBuffer("UPDATE ").append(table.getTableName()).append(" SET ").append(this.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(this.getColumnName()).append(" IS NULL");
            sql.append("; ").append(sqlSet);
        }
        if (setNullOption) {
            StringBuffer sqlNull = new StringBuffer(sqlBase);
            if (this.isMandatory()) {
                sqlNull.append(" NOT NULL");
            } else {
                sqlNull.append(" NULL");
            }
            sql.append("; ").append(sqlNull);
        }
        return sql.toString();
    }

    public String getSQLDataType() {
        String columnName = this.getColumnName();
        int dt = this.getAD_Reference_ID();
        return DisplayType.getSQLDataType(dt, columnName, this.getFieldLength());
    }

    public String getConstraint(String tableName) {
        if (this.isKey()) {
            String constraintName = tableName.length() > 26 ? String.valueOf(tableName.substring(0, 26)) + "_Key" : String.valueOf(tableName) + "_Key";
            return "CONSTRAINT " + constraintName + " PRIMARY KEY (" + this.getColumnName() + ")";
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MColumn[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }

    public static int getColumn_ID(String TableName, String columnName) {
        int m_table_id = MTable.getTable_ID(TableName);
        if (m_table_id == 0) {
            return 0;
        }
        int retValue = 0;
        String SQL = "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID = ?  AND columnname = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, m_table_id);
            pstmt.setString(2, columnName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, SQL, e);
            retValue = -1;
        }
        return retValue;
    }

    public static int getTable_ID(Properties ctx, int AD_Column_ID, String trxName) {
        String sqlStmt = "SELECT AD_Table_ID FROM AD_Column WHERE AD_Column_ID=?";
        return DB.getSQLValue(trxName, sqlStmt, AD_Column_ID);
    }

    public String syncDatabase() {
        String string;
        MTable table = new MTable(this.getCtx(), this.getAD_Table_ID(), this.get_TrxName());
        if (table.isView()) {
            return "Cannot sync view";
        }
        table.set_TrxName(this.get_TrxName());
        if (table.get_ID() == 0) {
            throw new AdempiereException("@NotFound@ @AD_Table_ID@ " + this.getAD_Table_ID());
        }
        Connection conn = null;
        try {
            conn = DB.getConnectionRO();
            DatabaseMetaData md = conn.getMetaData();
            String catalog = DB.getDatabase().getCatalog();
            String schema = DB.getDatabase().getSchema();
            String tableName = table.getTableName();
            if (md.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            int noColumns = 0;
            String sql = null;
            ResultSet rs = md.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                ++noColumns;
                String columnName = rs.getString("COLUMN_NAME");
                if (!columnName.equalsIgnoreCase(this.getColumnName())) continue;
                boolean notNull = rs.getInt("NULLABLE") == 0;
                sql = this.getSQLModify(table, this.isMandatory() ^ notNull);
                break;
            }
            rs.close();
            rs = null;
            if (noColumns == 0) {
                sql = table.getSQLCreate();
            } else if (sql == null) {
                sql = this.getSQLAdd(table);
            }
            if (sql == null) {
                return "No sql";
            }
            boolean no = false;
            if (sql.indexOf("; ") == -1) {
                DB.executeUpdateEx(sql, this.get_TrxName());
            } else {
                String[] statements = sql.split("; ");
                int i = 0;
                while (i < statements.length) {
                    DB.executeUpdateEx(statements[i], this.get_TrxName());
                    ++i;
                }
            }
            string = sql;
        }
        catch (SQLException e) {
            throw new AdempiereException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    public static boolean isSuggestSelectionColumn(String columnName, boolean caseSensitive) {
        if (Util.isEmpty(columnName, true)) {
            return false;
        }
        if (columnName.equals("Value") || !caseSensitive && columnName.equalsIgnoreCase("Value")) {
            return true;
        }
        if (columnName.equals("Name") || !caseSensitive && columnName.equalsIgnoreCase("Name")) {
            return true;
        }
        if (columnName.equals("DocumentNo") || !caseSensitive && columnName.equalsIgnoreCase("DocumentNo")) {
            return true;
        }
        if (columnName.equals("Description") || !caseSensitive && columnName.equalsIgnoreCase("Description")) {
            return true;
        }
        return columnName.indexOf("Name") != -1 || !caseSensitive && columnName.toUpperCase().indexOf("Name".toUpperCase()) != -1;
    }
}

