/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_ClientShare;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MClientShare
extends X_AD_ClientShare {
    private static final long serialVersionUID = -8104352403537353753L;
    private static CCache<String, Boolean> s_shares = new CCache("AD_ClientShare", 10, 120);
    private static CLogger s_log = CLogger.getCLogger(MClientShare.class);
    private MTable m_table = null;

    public static boolean isClientLevelOnly(int AD_Client_ID, int AD_Table_ID) {
        Boolean share = MClientShare.isShared(AD_Client_ID, AD_Table_ID);
        if (share != null) {
            return share;
        }
        return false;
    }

    public static boolean isOrgLevelOnly(int AD_Client_ID, int AD_Table_ID) {
        Boolean share = MClientShare.isShared(AD_Client_ID, AD_Table_ID);
        if (share != null) {
            return share == false;
        }
        return false;
    }

    private static Boolean isShared(int AD_Client_ID, int AD_Table_ID) {
        if (s_shares.isEmpty()) {
            String sql = "SELECT AD_Client_ID, AD_Table_ID, ShareType FROM AD_ClientShare WHERE ShareType<>'x' AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    int Client_ID = rs.getInt(1);
                    int table_ID = rs.getInt(2);
                    String key = Client_ID + "_" + table_ID;
                    String ShareType = rs.getString(3);
                    if (ShareType.equals("C")) {
                        s_shares.put(key, Boolean.TRUE);
                        continue;
                    }
                    if (!ShareType.equals("O")) continue;
                    s_shares.put(key, Boolean.FALSE);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (s_shares.isEmpty()) {
                s_shares.put("0_0", Boolean.TRUE);
            }
        }
        String key = AD_Client_ID + "_" + AD_Table_ID;
        return s_shares.get(key);
    }

    public MClientShare(Properties ctx, int AD_ClientShare_ID, String trxName) {
        super(ctx, AD_ClientShare_ID, trxName);
    }

    public MClientShare(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isClientLevelOnly() {
        return this.getShareType().equals("C");
    }

    public boolean isOrgLevelOnly() {
        return this.getShareType().equals("O");
    }

    public MTable getTable() {
        if (this.m_table == null) {
            this.m_table = MTable.get(this.getCtx(), this.getAD_Table_ID());
        }
        return this.m_table;
    }

    public String getTableName() {
        return this.getTable().getTableName();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.isActive()) {
            this.setDataToLevel();
            this.listChildRecords();
        }
        return true;
    }

    public String setDataToLevel() {
        String info = "-";
        if (this.isClientLevelOnly()) {
            StringBuffer sql = new StringBuffer("UPDATE ").append(this.getTableName()).append(" SET AD_Org_ID=0 WHERE AD_Org_ID<>0 AND AD_Client_ID=?");
            int no = DB.executeUpdate(sql.toString(), this.getAD_Client_ID(), this.get_TrxName());
            info = this.getTableName() + " set to Shared #" + no;
            this.log.info(info);
        } else if (this.isOrgLevelOnly()) {
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ").append(this.getTableName()).append(" WHERE AD_Org_ID=0 AND AD_Client_ID=?");
            int no = DB.getSQLValue(this.get_TrxName(), sql.toString(), this.getAD_Client_ID());
            info = this.getTableName() + " Shared records #" + no;
            this.log.info(info);
        }
        return info;
    }

    public String listChildRecords() {
        StringBuffer info = new StringBuffer();
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE AccessLevel='3' AND IsView='N' AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.IsParent='Y' AND c.ColumnName IN (SELECT ColumnName FROM AD_Column cc WHERE cc.IsKey='Y' AND cc.AD_Table_ID=?))";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_Table_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Table_ID = rs.getInt(1);
                String TableName = rs.getString(2);
                if (info.length() != 0) {
                    info.append(", ");
                }
                info.append(TableName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.info(info.toString());
        return info.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }
}

