/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MChart;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_ChartDatasource;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public class MChartDatasource
extends X_AD_ChartDatasource {
    private static final long serialVersionUID = 5108909995064477463L;

    public MChartDatasource(Properties ctx, int AD_ChartDatasource_ID, String trxName) {
        super(ctx, AD_ChartDatasource_ID, trxName);
    }

    public MChartDatasource(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void addData(MChart parent) {
        String where;
        String category;
        String value = this.getValueColumn();
        String unit = "D";
        if (!parent.isTimeSeries()) {
            category = this.getCategoryColumn();
        } else {
            if (parent.getTimeUnit().equals("W")) {
                unit = "W";
            } else if (parent.getTimeUnit().equals("M")) {
                unit = "MM";
            } else if (parent.getTimeUnit().equals("Q")) {
                unit = "Q";
            } else if (parent.getTimeUnit().equals("Y")) {
                unit = "Y";
            }
            category = " TRUNC(" + this.getDateColumn() + ", '" + unit + "') ";
        }
        String series = DB.TO_STRING(this.getName());
        boolean hasSeries = false;
        if (this.getSeriesColumn() != null) {
            series = this.getSeriesColumn();
            hasSeries = true;
        }
        if (!Util.isEmpty(where = this.getWhereClause())) {
            where = Env.parseContext(this.getCtx(), parent.getWindowNo(), where, true);
        }
        boolean hasWhere = false;
        String sql = "SELECT " + value + ", " + category + ", " + series + " FROM " + this.getFromClause();
        if (!Util.isEmpty(where)) {
            sql = String.valueOf(sql) + " WHERE " + where;
            hasWhere = true;
        }
        Timestamp currentDate = Env.getContextAsDate(this.getCtx(), "#Date");
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        int scope = parent.getTimeScope();
        int offset = this.getTimeOffset();
        if (parent.isTimeSeries() && scope != 0) {
            startDate = this.increment(currentDate, parent.getTimeUnit(), offset += -scope);
            endDate = this.increment(startDate, parent.getTimeUnit(), scope);
        }
        if (startDate != null && endDate != null) {
            sql = String.valueOf(sql) + (hasWhere ? " AND " : " WHERE ");
            sql = String.valueOf(sql) + category + ">=TRUNC(" + DB.TO_DATE(new Timestamp(startDate.getTime())) + ", '" + unit + "') AND ";
            sql = String.valueOf(sql) + category + "<=TRUNC(" + DB.TO_DATE(new Timestamp(endDate.getTime())) + ", '" + unit + "') ";
        }
        MRole role = MRole.getDefault(this.getCtx(), false);
        sql = role.addAccessSQL(sql, null, true, false);
        sql = hasSeries ? String.valueOf(sql) + " GROUP BY " + series + ", " + category + " ORDER BY " + series + ", " + category : String.valueOf(sql) + " GROUP BY " + category + " ORDER BY " + category;
        this.log.log(Level.FINE, sql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        TimeSeries tseries = null;
        Dataset dataset = parent.getDataset();
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(2);
                    String seriesName = rs.getString(3);
                    if (seriesName == null) {
                        seriesName = this.getName();
                    }
                    String queryWhere = "";
                    if (hasWhere) {
                        queryWhere = String.valueOf(queryWhere) + where + " AND ";
                    }
                    queryWhere = String.valueOf(queryWhere) + series + " = " + DB.TO_STRING(seriesName) + " AND " + category + " = ";
                    if (parent.isTimeSeries() && dataset instanceof TimeSeriesCollection) {
                        if (tseries == null || !tseries.getKey().equals(seriesName)) {
                            if (tseries != null) {
                                ((TimeSeriesCollection)dataset).addSeries(tseries);
                            }
                            tseries = new TimeSeries((Comparable)((Object)seriesName));
                        }
                        Date date = rs.getDate(2);
                        Day period = null;
                        if (parent.getTimeUnit().equals("D")) {
                            period = new Day((java.util.Date)date);
                        } else if (parent.getTimeUnit().equals("W")) {
                            period = new Week((java.util.Date)date);
                        } else if (parent.getTimeUnit().equals("M")) {
                            period = new Month((java.util.Date)date);
                        } else if (parent.getTimeUnit().equals("Q")) {
                            period = new Quarter((java.util.Date)date);
                        } else if (parent.getTimeUnit().equals("Y")) {
                            period = new Year((java.util.Date)date);
                        }
                        tseries.add((RegularTimePeriod)period, (Number)rs.getBigDecimal(1));
                        key = period.toString();
                        queryWhere = String.valueOf(queryWhere) + DB.TO_DATE(new Timestamp(date.getTime()));
                    } else {
                        queryWhere = String.valueOf(queryWhere) + DB.TO_STRING(key);
                    }
                    MQuery query = new MQuery(this.getAD_Table_ID());
                    String keyCol = MTable.get(this.getCtx(), this.getAD_Table_ID()).getKeyColumns()[0];
                    String whereClause = String.valueOf(keyCol) + " IN (SELECT " + this.getKeyColumn() + " FROM " + this.getFromClause() + " WHERE " + queryWhere + " )";
                    query.addRestriction(whereClause.toString());
                    query.setRecordCount(1);
                    HashMap<String, MQuery> map = parent.getQueries();
                    if (dataset instanceof DefaultPieDataset) {
                        ((DefaultPieDataset)dataset).setValue((Comparable)((Object)key), (Number)rs.getBigDecimal(1));
                        map.put(key, query);
                        continue;
                    }
                    if (dataset instanceof DefaultCategoryDataset) {
                        ((DefaultCategoryDataset)dataset).addValue((Number)rs.getBigDecimal(1), (Comparable)((Object)seriesName), (Comparable)((Object)key));
                        map.put(String.valueOf(seriesName) + "__" + key, query);
                        continue;
                    }
                    if (!(dataset instanceof TimeSeriesCollection)) continue;
                    map.put(String.valueOf(seriesName) + "__" + key, query);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (tseries != null) {
            ((TimeSeriesCollection)dataset).addSeries(tseries);
        }
    }

    private java.util.Date increment(java.util.Date lastDate, String timeUnit, int qty) {
        if (lastDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastDate);
        if (timeUnit.equals("D")) {
            cal.add(6, qty);
        } else if (timeUnit.equals("W")) {
            cal.add(3, qty);
        } else if (timeUnit.equals("M")) {
            cal.add(2, qty);
        } else if (timeUnit.equals("Q")) {
            cal.add(2, 3 * qty);
        } else if (timeUnit.equals("Y")) {
            cal.add(1, qty);
        }
        return cal.getTime();
    }

    private String formatDate(java.util.Date date, String timeUnit) {
        String key = null;
        String unitFormat = "yyyy-MM-dd";
        if (timeUnit.equals("W")) {
            unitFormat = "yyyy-w";
        } else if (timeUnit.equals("M")) {
            unitFormat = "yyyy-MMM";
        } else if (timeUnit.equals("Q")) {
            unitFormat = "yyyy-MM";
        } else if (timeUnit.equals("Y")) {
            unitFormat = "yyyy";
        }
        SimpleDateFormat format = new SimpleDateFormat(unitFormat);
        key = format.format(date);
        if (timeUnit.equals("Q")) {
            key = this.convertToQuarter(format.format(date));
        }
        return key;
    }

    private String convertToQuarter(String month) {
        if (month.length() != 7) {
            return month;
        }
        String mm = month.substring(5, 7);
        int mon = Integer.parseInt(mm);
        return String.valueOf(month.substring(0, 5)) + "Q" + (mon / 3 + 1);
    }

    public MQuery getZoomQuery(MChart parent, String value, String category2) {
        String category;
        MQuery query = new MQuery(this.getAD_Table_ID());
        if (!parent.isTimeSeries()) {
            category = this.getCategoryColumn();
        } else {
            String unit = "D";
            if (parent.getTimeUnit().equals("W")) {
                unit = "W";
            } else if (parent.getTimeUnit().equals("M")) {
                unit = "MM";
            } else if (parent.getTimeUnit().equals("Q")) {
                unit = "Q";
            } else if (parent.getTimeUnit().equals("Y")) {
                unit = "Y";
            }
            category = " TRUNC(" + this.getDateColumn() + ", '" + unit + "') ";
        }
        String where = this.getWhereClause();
        if (!Util.isEmpty(where)) {
            where = Env.parseContext(Env.getCtx(), parent.getWindowNo(), where, true);
        }
        String series = DB.TO_STRING(this.getName());
        if (this.getSeriesColumn() != null) {
            series = this.getSeriesColumn();
        }
        String sql = "SELECT " + this.getKeyColumn() + "," + category + "," + series + " FROM " + this.getFromClause();
        if (!Util.isEmpty(where)) {
            sql = String.valueOf(sql) + " WHERE " + where;
        }
        sql = String.valueOf(sql) + " GROUP BY " + series + ", " + category + "," + this.getKeyColumn() + " ORDER BY " + series + ", " + category + "," + this.getKeyColumn();
        StringBuffer includedIds = new StringBuffer();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String key = rs.getString(2);
                    if (parent.isTimeSeries()) {
                        Date date = rs.getDate(2);
                        String unit = "yyyy-MM-dd";
                        if (parent.getTimeUnit().equals("W")) {
                            unit = "yyyy-w";
                        } else if (parent.getTimeUnit().equals("M")) {
                            unit = "yyyy-MMM";
                        } else if (parent.getTimeUnit().equals("Q")) {
                            unit = "yyyy-MM";
                        } else if (parent.getTimeUnit().equals("Y")) {
                            unit = "yyyy";
                        }
                        SimpleDateFormat format = new SimpleDateFormat(unit);
                        key = format.format(date);
                        if (parent.getTimeUnit().equals("Q")) {
                            key = this.convertToQuarter(format.format(date));
                        }
                    }
                    if (!value.equals(key)) continue;
                    if (includedIds.length() > 0) {
                        includedIds.append(",");
                    }
                    includedIds.append(id);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (includedIds.length() == 0) {
            return MQuery.getNoRecordQuery(query.getTableName(), false);
        }
        return query;
    }
}

