/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.X_C_Charge;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCharge
extends X_C_Charge {
    private static final long serialVersionUID = 630271473830196435L;
    private static CCache<Integer, MCharge> s_cache = new CCache("C_Charge", 10);
    private static CLogger s_log = CLogger.getCLogger(MCharge.class);

    @Deprecated
    public static MAccount getAccount(int C_Charge_ID, MAcctSchema as, BigDecimal amount) {
        return MCharge.getAccount(C_Charge_ID, as, amount, null);
    }

    public static MAccount getAccount(int C_Charge_ID, MAcctSchema as, BigDecimal amount, String sTrx) {
        String sql;
        int Account_ID;
        if (C_Charge_ID == 0 || as == null) {
            return null;
        }
        String acctName = "Ch_Expense_Acct";
        if (amount != null && amount.signum() < 0) {
            acctName = "Ch_Revenue_Acct";
        }
        if ((Account_ID = DB.getSQLValueEx(sTrx, sql = "SELECT " + acctName + " FROM C_Charge_Acct WHERE C_Charge_ID=? AND C_AcctSchema_ID=?", C_Charge_ID, as.get_ID())) <= 0) {
            s_log.severe("NO account for C_Charge_ID=" + C_Charge_ID);
            return null;
        }
        MAccount acct = MAccount.get(as.getCtx(), sTrx, Account_ID);
        return acct;
    }

    public static MCharge get(Properties ctx, int C_Charge_ID) {
        Integer key = new Integer(C_Charge_ID);
        MCharge retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCharge(ctx, C_Charge_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MCharge(Properties ctx, int C_Charge_ID, String trxName) {
        super(ctx, C_Charge_ID, trxName);
        if (C_Charge_ID == 0) {
            this.setChargeAmt(Env.ZERO);
            this.setIsSameCurrency(false);
            this.setIsSameTax(false);
            this.setIsTaxIncluded(false);
        }
    }

    public MCharge(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Accounting("C_Charge_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        return this.delete_Accounting("C_Charge_Acct");
    }
}

