/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MAssetType;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Group;
import org.compiere.util.CCache;
import org.compiere.util.DB;

public class MAssetGroup
extends X_A_Asset_Group {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, MAssetGroup> s_cache = new CCache("A_Asset_Group", 10, 0);

    public MAssetGroup(Properties ctx, int A_Asset_Group_ID, String trxName) {
        super(ctx, A_Asset_Group_ID, trxName);
    }

    public MAssetGroup(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MAssetGroup get(Properties ctx, int A_Asset_Group_ID) {
        if (A_Asset_Group_ID <= 0) {
            return null;
        }
        MAssetGroup ag = s_cache.get(A_Asset_Group_ID);
        if (ag != null) {
            return ag;
        }
        ag = new MAssetGroup(ctx, A_Asset_Group_ID, null);
        if (ag != null && ag.get_ID() != A_Asset_Group_ID) {
            ag = null;
        }
        return ag;
    }

    public static int getDefault_ID(SetGetModel m) {
        int AD_Client_ID = SetGetUtil.get_AttrValueAsInt(m, "AD_Client_ID");
        int A_AssetType_ID = SetGetUtil.get_AttrValueAsInt(m, "A_Asset_Type_ID");
        String sql = "SELECT A_Asset_Group_ID FROM A_Asset_Group WHERE AD_Client_ID=? AND NVL(A_Asset_Type_ID,0) IN (0,?) ORDER BY IsDefault DESC, A_Asset_Group_ID ASC";
        int id = DB.getSQLValueEx(null, "SELECT A_Asset_Group_ID FROM A_Asset_Group WHERE AD_Client_ID=? AND NVL(A_Asset_Type_ID,0) IN (0,?) ORDER BY IsDefault DESC, A_Asset_Group_ID ASC", AD_Client_ID, A_AssetType_ID);
        return id;
    }

    public static void updateAsset(SetGetModel m, int A_Asset_Group_ID) {
        MAssetType type = MAssetType.get(m.getCtx(), m.get_AttrValue("A_Asset_Type_ID"));
        if (type == null) {
            return;
        }
        if (A_Asset_Group_ID > 0) {
            if (!type.isFixedAsset()) {
                return;
            }
            MAssetGroup assetGrp = MAssetGroup.get(m.getCtx(), A_Asset_Group_ID);
            int A_Asset_Class_ID = assetGrp.getA_Asset_Class_ID();
            if (A_Asset_Class_ID > 0) {
                m.set_AttrValue("A_Asset_Class_ID", A_Asset_Class_ID);
            }
        } else {
            A_Asset_Group_ID = MAssetGroup.getDefault_ID(SetGetUtil.wrap(m));
            m.set_AttrValue("A_Asset_Group_ID", A_Asset_Group_ID);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MAssetType type = MAssetType.get(this.getCtx(), this.getA_Asset_Type_ID());
        if (type != null) {
            type.update(SetGetUtil.wrap(this), newRecord);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int default_id;
        if (!success) {
            return false;
        }
        if (newRecord && (default_id = MAssetGroup.getDefault_ID(SetGetUtil.wrap(this))) > 0 && default_id != this.get_ID()) {
            for (MAssetGroupAcct acct : MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), default_id)) {
                MAssetGroupAcct newAcct = acct.copy(this);
                newAcct.saveEx(this.get_TrxName());
            }
        }
        return true;
    }
}

