/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.I_A_Asset_Disposed;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetType;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Disposed;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import ro.arhipac.adempiere.fa.exceptions.AssetAlreadyDepreciatedException;
import ro.arhipac.adempiere.fa.exceptions.AssetException;
import ro.arhipac.adempiere.fa.exceptions.AssetNotImplementedException;
import ro.arhipac.adempiere.fa.exceptions.AssetNotSupportedException;
import ro.arhipac.adempiere.fa.exceptions.AssetStatusChangedException;

public class MAssetDisposed
extends X_A_Asset_Disposed
implements DocAction {
    private static final long serialVersionUID = 1763997880662445638L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MAssetDisposed(Properties ctx, int A_Asset_Disposed_ID, String trxName) {
        super(ctx, A_Asset_Disposed_ID, trxName);
        if (A_Asset_Disposed_ID == 0) {
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MAssetDisposed(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAsset getAsset() {
        return MAsset.get(this.getCtx(), this.getA_Asset_ID(), null);
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLD", this.getAD_Org_ID());
        this.saveEx();
        MAssetDisposed.updateFromAsset(this);
        if (this.is_Changed()) {
            throw new AssetStatusChangedException();
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        this.setDocAction("CO");
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        MAsset asset = this.getAsset();
        this.log.fine("asset=" + asset);
        if (!this.isDisposal()) {
            String method = this.getA_Activation_Method();
            if (!method.equals("AA")) throw new AssetNotSupportedException("A_Activation_Method", method);
            asset.changeStatus("AC", this.getDateDoc());
        } else {
            String method = this.getA_Disposed_Method();
            if ("PR".equals(method)) {
                asset.changeStatus("PR", this.getDateDoc());
            } else if ("S_".equals(method) || "T1".equals(method)) {
                asset.changeStatus("DI", null);
                this.setA_Disposal_Amt(this.getA_Asset_Cost());
                this.setA_Accumulated_Depr_Delta(this.getA_Accumulated_Depr());
                this.setExpense(this.getA_Disposal_Amt().subtract(this.getA_Accumulated_Depr_Delta()));
                this.createDisposal();
            } else if ("PD".equals(method)) {
                this.createDisposal();
            } else {
                if (!"SL".equals(method)) throw new AssetNotSupportedException("A_Disposed_Method", method);
                if (this.getA_Disposal_Amt().equals(this.getA_Asset_Cost())) {
                    asset.changeStatus("SO", null);
                } else {
                    asset.changeStatus("AC", null);
                }
                this.createDisposal();
            }
        }
        asset.saveEx(this.get_TrxName());
        valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean reverseAccrualIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean reActivateIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public String getSummary() {
        return new StringBuffer().append(this.getDocumentNo()).append("/").append(this.getDateDoc()).toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema().getC_Currency_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
        }
        if (newRecord || this.is_ValueChanged("DateAcct")) {
            this.setC_Period_ID(MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID()).get_ID());
        }
        if (this.getA_Disposed_Date() == null) {
            this.setA_Disposed_Date(this.getDateAcct());
        }
        if (!MAssetType.isFixedAsset(this.getA_Asset_ID())) {
            throw new AssetException("Asset-ul nu este mijloc fix!");
        }
        return true;
    }

    public static void updateFromAsset(I_A_Asset_Disposed bean) {
        int asset_id = bean.getA_Asset_ID();
        SetGetUtil.copyValues(SetGetUtil.wrap(bean), "A_Asset", asset_id, new String[]{"IsDisposed", "A_Asset_Status", "AD_Org_ID"});
        MDepreciationWorkfile wk = MDepreciationWorkfile.get(Env.getCtx(), asset_id, bean.getPostingType(), null);
        if (wk != null) {
            bean.setA_Asset_Cost(wk.getA_Asset_Cost());
            bean.setA_Accumulated_Depr(wk.getA_Accumulated_Depr());
        } else {
            bean.setA_Asset_Cost(Env.ZERO);
            bean.setA_Accumulated_Depr(Env.ZERO);
        }
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    public boolean isDisposal() {
        return !this.isDisposed();
    }

    public static void setA_Disposal_Amt(I_A_Asset_Disposed bean) {
        int precision = 2;
        BigDecimal A_Asset_Cost = bean.getA_Asset_Cost();
        BigDecimal A_Disposal_Amt = bean.getA_Disposal_Amt();
        BigDecimal coef = Env.ZERO;
        if (A_Asset_Cost.signum() != 0) {
            coef = A_Disposal_Amt.divide(A_Asset_Cost, 12, RoundingMode.HALF_UP);
        }
        BigDecimal A_Accumulated_Depr = bean.getA_Accumulated_Depr();
        BigDecimal A_Accumulated_Depr_Delta = A_Accumulated_Depr.multiply(coef).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal Expense = A_Disposal_Amt.subtract(A_Accumulated_Depr_Delta);
        bean.setA_Accumulated_Depr_Delta(A_Accumulated_Depr_Delta);
        bean.setExpense(Expense);
    }

    private void createDisposal() {
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        assetwk.adjustCost(this.getA_Disposal_Amt().negate(), Env.ZERO, false);
        assetwk.adjustAccumulatedDepr(this.getA_Accumulated_Depr_Delta().negate(), this.getA_Accumulated_Depr_Delta().negate(), false);
        assetwk.saveEx();
        assetwk.buildDepreciation();
        List<MDepreciationExp> list = MDepreciationExp.getNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        for (MDepreciationExp ex : list) {
            ex.deleteEx(false);
        }
    }
}

