/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.FA.feature.UseLifeImpl;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MAssetProduct;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MFactAcct;
import org.compiere.model.MIFixedAsset;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Addition;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProjectClose;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import ro.arhipac.adempiere.fa.exceptions.AssetAlreadyDepreciatedException;
import ro.arhipac.adempiere.fa.exceptions.AssetException;
import ro.arhipac.adempiere.fa.exceptions.AssetNotImplementedException;
import ro.arhipac.adempiere.fa.exceptions.AssetNotSupportedException;
import ro.arhipac.adempiere.util.POCacheLocal;

public class MAssetAddition
extends X_A_Asset_Addition
implements DocAction {
    private static final long serialVersionUID = 1L;
    private static CLogger s_log = CLogger.getCLogger(MAssetAddition.class);
    private final POCacheLocal<MMatchInv> m_cacheMatchInv = POCacheLocal.newInstance(this, MMatchInv.class);
    private final POCacheLocal<MIFixedAsset> m_cacheIFixedAsset = POCacheLocal.newInstance(this, MIFixedAsset.class);
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private final POCacheLocal<MAsset> m_cacheAsset = POCacheLocal.newInstance(this, MAsset.class);

    public MAssetAddition(Properties ctx, int A_Asset_Addition_ID, String trxName) {
        super(ctx, A_Asset_Addition_ID, trxName);
        if (A_Asset_Addition_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetAddition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setA_CreateAsset();
        if (this.isA_CreateAsset() && this.getA_QTY_Current().signum() == 0) {
            this.setA_QTY_Current(Env.ONE);
        }
        if (this.getC_Currency_ID() <= 0) {
            this.setC_Currency_ID(MClient.get(this.getCtx()).getAcctSchema().getC_Currency_ID());
        }
        if (this.getC_ConversionType_ID() <= 0) {
            this.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
        }
        this.getDateAcct();
        this.setAssetValueAmt();
        if (this.isA_CreateAsset()) {
            this.setA_CapvsExp("Cap");
        }
        this.setIsApproved();
        return true;
    }

    public static MAssetAddition createAsset(MMatchInv match) {
        MAssetAddition assetAdd = new MAssetAddition(match);
        assetAdd.dump();
        MAsset asset = assetAdd.createAsset();
        asset.dump();
        List<MAssetGroupAcct> lstGroupAcct = MAssetGroupAcct.forA_Asset_Group_ID(assetAdd.getCtx(), asset.getA_Asset_Group_ID());
        for (MAssetGroupAcct groupAcct : lstGroupAcct) {
            if (!groupAcct.getPostingType().equals(assetAdd.getPostingType())) continue;
            assetAdd.setDeltaUseLifeYears(groupAcct.getUseLifeYears());
            assetAdd.setDeltaUseLifeYears_F(groupAcct.getUseLifeYears_F());
        }
        assetAdd.saveEx();
        return assetAdd;
    }

    public static MAssetAddition createAsset(MIFixedAsset ifa) {
        MAssetAddition assetAdd = new MAssetAddition(ifa);
        assetAdd.dump();
        MAsset asset = assetAdd.createAsset();
        asset.dump();
        assetAdd.saveEx();
        return assetAdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MAsset createAsset() {
        MAsset asset = null;
        if (this.getA_Asset_ID() > 0) return this.getA_Asset(false);
        String sourceType = this.getA_SourceType();
        if ("INV".equals(sourceType)) {
            asset = new MAsset(this.getMatchInv(false));
            asset.saveEx();
            this.setA_Asset(asset);
            return asset;
        } else if ("IMP".equals(sourceType)) {
            asset = new MAsset(this.getI_FixedAsset(false));
            asset.saveEx();
            this.setA_Asset(asset);
            return asset;
        } else {
            if (!"PRJ".equals(sourceType)) throw new AssetNotSupportedException("A_SourceType", sourceType);
            throw new AssetNotImplementedException("@FA_Error_Addition_From_Project@");
        }
    }

    private MAssetAddition(MMatchInv match) {
        this(match.getCtx(), 0, match.get_TrxName());
        this.setM_MatchInv(match);
    }

    private MAssetAddition(MIFixedAsset ifa) {
        this(ifa.getCtx(), 0, ifa.get_TrxName());
        this.log.finest("Entering: ifa=" + ifa);
        this.setAD_Org_ID(ifa.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("IMP");
        this.setM_Product_ID(ifa.getM_Product_ID());
        this.setSourceAmt(ifa.getA_Asset_Cost());
        this.setDateDoc(ifa.getAssetServiceDate());
        this.setM_Locator_ID(ifa.getM_Locator_ID());
        this.setA_Accumulated_Depr(ifa.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(ifa.getA_Accumulated_Depr_F());
        this.setDeltaUseLifeYears(ifa.getUseLifeMonths() / 12);
        this.setDeltaUseLifeYears_F(ifa.getUseLifeMonths_F() / 12);
        Timestamp dateAcct = ifa.getDateAcct();
        if (dateAcct != null) {
            dateAcct = UseLifeImpl.getDateAcct(dateAcct, 1);
            this.log.fine("DateAcct=" + dateAcct);
            this.setDateAcct(dateAcct);
        }
        this.setI_FixedAsset(ifa);
    }

    private MMatchInv getMatchInv(boolean requery) {
        return this.m_cacheMatchInv.get(requery);
    }

    private void setM_MatchInv(MMatchInv mi) {
        this.setAD_Org_ID(mi.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("INV");
        this.setM_MatchInv_ID(mi.get_ID());
        MAssetAddition.setM_MatchInv(SetGetUtil.wrap(this), mi.getM_MatchInv_ID());
        this.m_cacheMatchInv.set(mi);
    }

    public static boolean setM_MatchInv(SetGetModel model, int M_MatchInv_ID) {
        boolean newRecord = false;
        String trxName = model.get_TrxName();
        if (model instanceof PO) {
            PO po = (PO)((Object)model);
            newRecord = po.is_new();
        }
        if (CLogMgt.isLevelFine()) {
            s_log.fine("Entering: model=" + model + ", M_MatchInv_ID=" + M_MatchInv_ID + ", newRecord=" + newRecord + ", trxName=" + trxName);
        }
        String qMatchInv_select = "SELECT  C_Invoice_ID, C_InvoiceLine_ID, M_InOutLine_ID, M_Product_ID, M_AttributeSetInstance_ID, Qty AS A_QTY_Current, InvoiceLine AS Line, M_Locator_ID, A_CapVsExp, MatchNetAmt AS AssetAmtEntered, MatchNetAmt AS AssetSourceAmt, C_Currency_ID, C_ConversionType_ID, MovementDate AS DateDoc";
        String qMatchInv_from = " FROM M_MatchInv_ARH WHERE M_MatchInv_ID=";
        String query = "SELECT  C_Invoice_ID, C_InvoiceLine_ID, M_InOutLine_ID, M_Product_ID, M_AttributeSetInstance_ID, Qty AS A_QTY_Current, InvoiceLine AS Line, M_Locator_ID, A_CapVsExp, MatchNetAmt AS AssetAmtEntered, MatchNetAmt AS AssetSourceAmt, C_Currency_ID, C_ConversionType_ID, MovementDate AS DateDoc";
        if (newRecord) {
            query = query + ", A_Asset_ID, A_CreateAsset";
        }
        query = query + " FROM M_MatchInv_ARH WHERE M_MatchInv_ID=" + M_MatchInv_ID;
        SetGetUtil.updateColumns(model, null, query, trxName);
        int C_InvoiceLine_ID = SetGetUtil.get_AttrValueAsInt(model, "C_InvoiceLine_ID");
        MAssetAddition.setTaxAmount(model, C_InvoiceLine_ID);
        BigDecimal bdEnteredAmount = SetGetUtil.get_AttrValueAsBigDecimal(model, "AssetAmtEntered");
        BigDecimal bdTaxAmount = SetGetUtil.get_AttrValueAsBigDecimal(model, "AssetSourceTaxAmt");
        SetGetUtil.set_AttrValueEx(model, "AssetSourceAmt", bdEnteredAmount.add(bdTaxAmount));
        if (CLogMgt.isLevelFine()) {
            s_log.fine("Leaving: RETURN TRUE");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setTaxAmount(SetGetModel model, int C_InvoiceLine_ID) {
        String SQL_TAX_RATE = "select issalestax, rate from C_Tax  where C_Tax_ID = ? \t\t\tand issummary = 'N' \t\t\tand issalestax = 'Y'  union all  select issalestax, rate from C_Tax  where Parent_Tax_ID = ?  and isactive = 'Y'  and issalestax = 'Y' ";
        String SQL_TAX_ID = "select C_Tax_ID FROM C_InvoiceLine WHERe C_InvoiceLine_ID = ? ";
        String trxName = model.get_TrxName();
        int C_Tax_ID = DB.getSQLValue(trxName, "select C_Tax_ID FROM C_InvoiceLine WHERe C_InvoiceLine_ID = ? ", C_InvoiceLine_ID);
        if (C_Tax_ID <= 0) {
            C_Tax_ID = Env.getContextAsInt(model.getCtx(), "C_Tax_ID");
        }
        CPreparedStatement pstmt = DB.prepareStatement("select issalestax, rate from C_Tax  where C_Tax_ID = ? \t\t\tand issummary = 'N' \t\t\tand issalestax = 'Y'  union all  select issalestax, rate from C_Tax  where Parent_Tax_ID = ?  and isactive = 'Y'  and issalestax = 'Y' ", trxName);
        ResultSet rs = null;
        BigDecimal bdRate = Env.ZERO;
        try {
            pstmt.setInt(1, C_Tax_ID);
            pstmt.setInt(2, C_Tax_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                bdRate = bdRate.add(rs.getBigDecimal("rate"));
            }
        }
        catch (SQLException e) {
            s_log.severe(e.getMessage());
            bdRate = null;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
        }
        BigDecimal bdEnteredAmount = SetGetUtil.get_AttrValueAsBigDecimal(model, "AssetAmtEntered");
        int iPrecision = 2;
        int C_Currency_ID = SetGetUtil.get_AttrValueAsInt(model, "C_Currency_ID");
        if (C_Currency_ID > 0) {
            iPrecision = MCurrency.getStdPrecision(model.getCtx(), C_Currency_ID);
        }
        BigDecimal bdTax = bdEnteredAmount.multiply(bdRate.divide(new BigDecimal(100)));
        bdTax = bdTax.setScale(iPrecision, RoundingMode.HALF_UP);
        SetGetUtil.set_AttrValueEx(model, "AssetSourceTaxAmt", bdTax);
    }

    public void setTaxAmount() {
        MAssetAddition.setTaxAmount(SetGetUtil.wrap(this), this.getC_InvoiceLine_ID());
    }

    public MIFixedAsset getI_FixedAsset(boolean requery) {
        return this.m_cacheIFixedAsset.get(requery);
    }

    private void setI_FixedAsset(MIFixedAsset ifa) {
        this.setI_FixedAsset_ID(ifa.get_ID());
        this.m_cacheIFixedAsset.set(ifa);
    }

    private void setAssetValueAmt() {
        this.getDateAcct();
        MConversionRateUtil.convertBase(SetGetUtil.wrap(this), "DateAcct", "AssetSourceAmt", "AssetValueAmt", null);
    }

    public void setSourceAmt(BigDecimal amt) {
        this.setAssetAmtEntered(amt);
        this.setAssetSourceAmt(amt);
    }

    public void setIsApproved() {
        if (!this.isProcessed()) {
            String str = Env.getContext(this.getCtx(), "#IsCanApproveOwnDoc");
            boolean isApproved = "Y".equals(str);
            this.log.fine("#IsCanApproveOwnDoc=" + str + "=" + isApproved);
            this.setIsApproved(isApproved);
        }
    }

    @Override
    public Timestamp getDateAcct() {
        Timestamp dateAcct = super.getDateAcct();
        if (dateAcct == null) {
            dateAcct = this.getDateDoc();
            this.setDateAcct(dateAcct);
        }
        return dateAcct;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return false;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLJ", this.getAD_Org_ID());
        MAsset asset = this.getA_Asset(true);
        if (!this.isA_CreateAsset() && !asset.isDepreciated()) {
            this.m_processMsg = "@AssetIsNotDepreciating@";
            return "IN";
        }
        if (this.isA_CreateAsset() && this.hasZeroValues()) {
            throw new AssetException("@FA_Error_Create_ZeroValues@");
        }
        if (this.isA_CreateAsset() && !"NW".equals(asset.getA_Asset_Status())) {
            throw new AssetException("@FA_Error_Asset_Not_New@");
        }
        if ("PRJ".equals(this.getA_SourceType())) {
            if (this.getC_Project_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"C_Project_ID"});
            }
            String whereClause = "C_Project_ID=? AND DocStatus IN ('IP','CO','CL') AND A_Asset_Addition_ID<>?";
            List list = new Query(this.getCtx(), "A_Asset_Addition", "C_Project_ID=? AND DocStatus IN ('IP','CO','CL') AND A_Asset_Addition_ID<>?", this.get_TrxName()).setParameters(this.getC_Project_ID(), this.get_ID()).list();
            if (list.size() > 0) {
                StringBuffer sb = new StringBuffer("Nu se poate crea PIF din acest proiect pentru c\u00c4\u0192 exist\u00c4\u0192 deja alte PIF-uri finalizate pentru acest proiect. Vezi ");
                for (MAssetAddition aa : list) {
                    sb.append(aa.getDocumentInfo()).append("; ");
                }
                throw new AssetException(sb.toString());
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.checkCreateASI();
        MAsset asset = this.getA_Asset(!this.m_justPrepared);
        this.log.fine("asset=" + asset);
        boolean bAllowAccumulateDeprAlways = MSysConfig.getBooleanValue("FA_ADDITION_ALLOW_ACCDEPR_ALWAYS", false);
        if (!(bAllowAccumulateDeprAlways || this.getA_Accumulated_Depr().signum() == 0 && this.getA_Accumulated_Depr_F().signum() == 0 && this.getA_Period_Start() <= 0 && !this.isA_Accumulated_Depr_Adjust() || asset.getA_Asset_Status() == null || asset.getA_Asset_Status().equals("NW"))) {
            throw new AssetException("@FA_Error_Addition_AssetAlreadyCreated@");
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetwk == null) {
            assetwk = new MDepreciationWorkfile(asset, this.getPostingType(), null);
        }
        this.log.fine("workfile: " + assetwk);
        if (!this.isA_CreateAsset() && assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MDepreciationExp.checkExistsNotProcessedEntries(assetwk.getCtx(), assetwk.getA_Asset_ID(), this.getDateAcct(), assetwk.getPostingType(), assetwk.get_TrxName());
        assetwk.adjustCost(this.getAssetValueAmt(), this.getA_QTY_Current(), this.isA_CreateAsset());
        assetwk.adjustUseLife(this.getDeltaUseLifeYears(), this.getDeltaUseLifeYears_F(), this.isA_CreateAsset());
        assetwk.setDateAcct(this.getDateAcct());
        assetwk.setProcessed(true);
        assetwk.saveEx();
        MAssetChange.createAddition(this, assetwk);
        if (this.isA_CreateAsset() && this.getM_Locator_ID() > 0) {
            asset.setM_Locator_ID(this.getM_Locator_ID());
        }
        this.updateA_Asset_Product(false);
        if (this.isA_CreateAsset()) {
            asset.setAssetServiceDate(this.getDateDoc());
        }
        asset.changeStatus("AC", this.getDateAcct());
        asset.saveEx();
        if (this.isA_Accumulated_Depr_Adjust()) {
            Collection<MDepreciationExp> expenses = MDepreciationExp.createDepreciation(assetwk, 0, this.getDateAcct(), this.getA_Accumulated_Depr(), this.getA_Accumulated_Depr_F(), null, null, null, null);
            for (MDepreciationExp exp : expenses) {
                exp.setA_Asset_Addition_ID(this.getA_Asset_Addition_ID());
                exp.process();
            }
            if (this.isA_CreateAsset() && this.isA_Accumulated_Depr_Adjust()) {
                assetwk.setA_Current_Period(this.getA_Period_Start());
                assetwk.setDateAcct(TimeUtil.addMonths(this.getDateAcct(), 1));
                assetwk.saveEx();
            }
        }
        assetwk.buildDepreciation();
        assetwk.setA_Current_Period();
        assetwk.saveEx();
        this.updateSourceDocument(false);
        this.setProcessed(true);
        this.setDocAction("CL");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.reverseIt(false);
        String errmsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (errmsg != null) {
            this.m_processMsg = errmsg;
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private void reverseIt(boolean isReActivate) {
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.setDocAction("--");
            throw new AssetException("Document Closed: " + this.getDocStatus());
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetwk == null) {
            throw new AssetException("@NotFound@ @A_DepreciationWorkfile_ID");
        }
        if (assetwk.isFullyDepreciated()) {
            throw new AssetNotImplementedException("@FA_Error_Addition_AssetFullyDepreciated@");
        }
        if (!this.isA_CreateAsset() && assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        assetwk.adjustCost(this.getAssetValueAmt().negate(), this.getA_QTY_Current().negate(), false);
        assetwk.adjustUseLife(0 - this.getDeltaUseLifeYears(), 0 - this.getDeltaUseLifeYears_F(), false);
        assetwk.saveEx();
        String whereClause = "A_Asset_Addition_ID=? AND PostingType=?";
        List list = new Query(this.getCtx(), "A_Depreciation_Exp", "A_Asset_Addition_ID=? AND PostingType=?", this.get_TrxName()).setParameters(this.get_ID(), assetwk.getPostingType()).setOrderBy("DateAcct DESC, A_Depreciation_Exp_ID DESC").list();
        for (MDepreciationExp depexp : list) {
            depexp.deleteEx(true);
        }
        if (this.isA_CreateAsset()) {
            assetwk.deleteEx(true);
        } else {
            assetwk.setA_Current_Period();
            assetwk.saveEx();
            assetwk.buildDepreciation();
        }
        this.updateA_Asset_Product(true);
        if (this.isA_CreateAsset()) {
            MAsset asset = this.getA_Asset(true);
            asset.changeStatus("NW", this.getDateAcct());
            asset.saveEx();
            if (!isReActivate) {
                this.setA_CreateAsset(false);
            }
        }
        MFactAcct.deleteEx(this.get_Table_ID(), this.get_ID(), this.get_TrxName());
        this.updateSourceDocument(true);
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        throw new AssetNotImplementedException("reverseCorrectIt");
    }

    @Override
    public boolean reverseAccrualIt() {
        throw new AssetNotImplementedException("reverseAccrualIt");
    }

    @Override
    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.reverseIt(true);
        String errmsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (errmsg != null) {
            this.m_processMsg = errmsg;
            return false;
        }
        this.setProcessed(false);
        this.setDocAction("CO");
        return true;
    }

    @Override
    public String getSummary() {
        MAsset asset = this.getA_Asset(false);
        StringBuffer sb = new StringBuffer();
        sb.append("@DocumentNo@ #").append(this.getDocumentNo()).append(": @A_CreateAsset@=@").append(this.isA_CreateAsset() ? "Y" : "N").append("@");
        if (asset != null) {
            sb.append(", @A_Asset_ID@=").append(asset.getName());
        }
        return Msg.parseTranslation(this.getCtx(), sb.toString());
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getAssetValueAmt();
    }

    public MAsset getA_Asset(boolean requery) {
        return this.m_cacheAsset.get(requery);
    }

    private void setA_Asset(MAsset asset) {
        this.setA_Asset_ID(asset.getA_Asset_ID());
        this.m_cacheAsset.set(asset);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        this.updateSourceDocument(false);
        return true;
    }

    private void updateSourceDocument(boolean isReversalParam) {
        String sourceType;
        boolean isReversal = isReversalParam;
        String docStatus = this.getDocStatus();
        if (!isReversal && ("RE".equals(docStatus) || "VO".equals(docStatus))) {
            isReversal = true;
        }
        if ("INV".equals(sourceType = this.getA_SourceType()) && this.isProcessed()) {
            int C_InvoiceLine_ID = this.getC_InvoiceLine_ID();
            MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.get_TrxName());
            invoiceLine.setA_Processed(!isReversal);
            invoiceLine.setA_Asset_ID(isReversal ? 0 : this.getA_Asset_ID());
            invoiceLine.saveEx();
        } else if ("PRJ".equals(sourceType) && this.isProcessed()) {
            if (!isReversal) {
                int project_id = this.getC_Project_ID();
                ProcessInfo pi = new ProcessInfo("", 0, MProject.Table_ID, project_id);
                pi.setAD_Client_ID(this.getAD_Client_ID());
                pi.setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
                ProjectClose proc = new ProjectClose();
                proc.startProcess(this.getCtx(), pi, Trx.get(this.get_TrxName(), false));
                if (pi.isError()) {
                    throw new AssetException(pi.getSummary());
                }
            }
        } else if ("IMP".equals(sourceType) && !this.isProcessed()) {
            MIFixedAsset ifa;
            if (this.is_new() && this.getI_FixedAsset_ID() > 0 && (ifa = this.getI_FixedAsset(false)) != null) {
                ifa.setI_IsImported(true);
                ifa.setA_Asset_ID(this.getA_Asset_ID());
                ifa.saveEx(this.get_TrxName());
            }
        } else if ("MAN".equals(sourceType) && this.isProcessed()) {
            this.log.fine("Nothing to do");
        }
    }

    private void checkCreateASI() {
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MAttributeSetInstance asi = null;
        if (product != null && this.getM_AttributeSetInstance_ID() == 0) {
            asi = new MAttributeSetInstance(this.getCtx(), 0, this.get_TrxName());
            asi.setAD_Org_ID(0);
            asi.setM_AttributeSet_ID(product.getM_AttributeSet_ID());
            asi.saveEx();
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
    }

    private void updateA_Asset_Product(boolean isReversal) {
        if (this.getM_Product_ID() <= 0) {
            return;
        }
        MAssetProduct assetProduct = MAssetProduct.getCreate(this.getCtx(), this.getA_Asset_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
        if (assetProduct.get_ID() <= 0 && isReversal) {
            this.log.warning("No Product found " + this + " [IGNORE]");
            return;
        }
        BigDecimal adjQty = this.getA_QTY_Current();
        if (isReversal) {
            adjQty = adjQty.negate();
        }
        assetProduct.addA_Qty_Current(this.getA_QTY_Current());
        assetProduct.saveEx();
        if (this.isA_CreateAsset()) {
            MAsset asset = this.getA_Asset(false);
            assetProduct.updateAsset(asset);
            asset.saveEx();
        }
    }

    public boolean hasZeroValues() {
        return this.getDeltaUseLifeYears() <= 0 || this.getDeltaUseLifeYears_F() <= 0 || this.getDeltaUseLifeYears() != this.getDeltaUseLifeYears_F() || this.getAssetValueAmt().signum() <= 0;
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo() + "/" + this.getDateDoc();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("@DocumentNo@: " + this.getDocumentNo());
        MAsset asset = this.getA_Asset(false);
        if (asset != null && asset.get_ID() > 0) {
            sb.append(", @A_Asset_ID@: ").append(asset.getName());
        }
        return sb.toString();
    }

    private void setA_CreateAsset() {
        if ("VO".equals(this.getDocStatus())) {
            this.setA_CreateAsset(false);
        } else {
            String sql = "SELECT COUNT(*) FROM A_Asset_Addition WHERE A_Asset_ID=? AND A_CreateAsset='Y' AND DocStatus<>'VO' AND IsActive='Y' AND A_Asset_Addition_ID<>?";
            int cnt = DB.getSQLValueEx(null, "SELECT COUNT(*) FROM A_Asset_Addition WHERE A_Asset_ID=? AND A_CreateAsset='Y' AND DocStatus<>'VO' AND IsActive='Y' AND A_Asset_Addition_ID<>?", this.getA_Asset_ID(), this.getA_Asset_Addition_ID());
            if (this.isA_CreateAsset()) {
                if (cnt >= 1) {
                    this.setA_CreateAsset(false);
                }
            } else if (cnt == 0) {
                this.setA_CreateAsset(true);
            }
        }
    }
}

