/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetClass;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MAssetType;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MIFixedAsset;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.MProductDownload;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MAsset
extends X_A_Asset
implements MAssetType.Model {
    public static final int CHANGETYPE_setAssetGroup = Table_ID * 100 + 1;
    public static final String COLUMNNAME_NextMaintenanceDate = "NextMaintenanceDate";
    private int m_UseLifeMonths_F = 0;
    private int m_A_Current_Period = 0;
    private Timestamp m_DateAcct = null;
    private int m_A_Depreciation_ID = 0;
    private int m_A_Depreciation_F_ID = 0;
    private BigDecimal m_A_Asset_Cost = Env.ZERO;
    private BigDecimal m_A_Accumulated_Depr = Env.ZERO;
    private BigDecimal m_A_Accumulated_Depr_F = Env.ZERO;
    private MProduct m_product = null;

    public static MAsset getFromShipment(Properties ctx, int M_InOutLine_ID, String trxName) {
        String whereClause = "M_InOutLine_ID=?";
        MAsset retValue = (MAsset)new Query(ctx, "A_Asset", "M_InOutLine_ID=?", trxName).setParameters(M_InOutLine_ID).first();
        return retValue;
    }

    public static MAsset get(Properties ctx, int A_Asset_ID, String trxName) {
        return (MAsset)MTable.get(ctx, "A_Asset").getPO(A_Asset_ID, trxName);
    }

    public static Collection<MAsset> forASI(Properties ctx, int M_Product_ID, int M_ASI_ID) {
        ArrayList<Object> params = new ArrayList<Object>();
        String whereClause = "M_AttributeSetInstance_ID=?";
        params.add(M_ASI_ID);
        if (M_Product_ID > 0) {
            whereClause = String.valueOf(whereClause) + " AND M_Product_ID=?";
            params.add(M_Product_ID);
        }
        return new Query(ctx, "A_Asset", whereClause, null).setParameters(params).list();
    }

    public MAsset(Properties ctx, int A_Asset_ID, String trxName) {
        super(ctx, A_Asset_ID, trxName);
        if (A_Asset_ID == 0) {
            this.setA_Asset_Status("NW");
            this.setA_Asset_Type("MFX");
            this.setA_Asset_Type_ID(1);
        }
    }

    public MAsset(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected MAsset(MMatchInv match) {
        this(match.getCtx(), 0, match.get_TrxName());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), match.getC_InvoiceLine_ID(), this.get_TrxName());
        MInvoice invoice = invoiceLine.getParent();
        MInOutLine inoutLine = new MInOutLine(this.getCtx(), match.getM_InOutLine_ID(), this.get_TrxName());
        MInOut inout = inoutLine.getParent();
        this.setA_Asset_CreateDate(inout.getMovementDate());
        this.setDescription(inoutLine.getDescription());
        int A_Asset_Group_ID = invoiceLine.getA_Asset_Group_ID();
        if (A_Asset_Group_ID <= 0) {
            MProduct product = MProduct.get(this.getCtx(), invoiceLine.getM_Product_ID());
            A_Asset_Group_ID = product.getA_Asset_Group_ID();
        }
        if (A_Asset_Group_ID <= 0) {
            throw new AdempiereException("@Invalid@: @A_Asset_Group@");
        }
        MAssetGroup mAssetGroup = new MAssetGroup(this.getCtx(), A_Asset_Group_ID, this.get_TrxName());
        this.setAssetGroup(mAssetGroup);
        this.setHelp(Msg.getMsg(MClient.get(this.getCtx()).getAD_Language(), "CreatedFromInvoiceLine", new Object[]{invoice.getDocumentNo(), invoiceLine.getLine()}));
        MProduct product = MProduct.get(this.getCtx(), inoutLine.getM_Product_ID());
        MBPartner bp = new MBPartner(this.getCtx(), inout.getC_BPartner_ID(), null);
        String name = "";
        if (inoutLine.getM_Product_ID() > 0) {
            name = String.valueOf(name) + product.getName() + "-";
            this.setM_Product_ID(inoutLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(inoutLine.getM_AttributeSetInstance_ID());
        }
        name = String.valueOf(name) + bp.getName() + "-" + invoice.getDocumentNo();
        this.log.fine("name=" + name);
        this.setName(name);
    }

    protected MAsset(MIFixedAsset ifa) {
        this(ifa.getCtx(), 0, ifa.get_TrxName());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        String inventoryNo = ifa.getInventoryNo();
        if (inventoryNo != null) {
            inventoryNo = inventoryNo.trim();
            this.setInventoryNo(inventoryNo);
            this.setValue(inventoryNo);
        }
        this.setA_Asset_CreateDate(ifa.getAssetServiceDate());
        this.setAssetServiceDate(ifa.getAssetServiceDate());
        this.setA_Asset_Class_ID(ifa.getA_Asset_Class_ID());
        MProduct product = ifa.getProduct();
        if (product != null) {
            this.setM_Product_ID(product.getM_Product_ID());
            MAssetGroup mAssetGroup = new MAssetGroup(ifa.getCtx(), ifa.getA_Asset_Group_ID(), ifa.get_TrxName());
            this.setAssetGroup(mAssetGroup);
        }
        this.setUseLifeMonths(ifa.getUseLifeMonths());
        this.setUseLifeMonths_F(ifa.getUseLifeMonths_F());
        this.setA_Depreciation_ID(ifa.getA_Depreciation_ID());
        this.setA_Depreciation_F_ID(ifa.getA_Depreciation_ID());
        this.setA_Asset_Cost(ifa.getA_Asset_Cost());
        this.setA_Accumulated_Depr(ifa.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(ifa.getA_Accumulated_Depr_F());
        this.setA_Current_Period(ifa.getA_Current_Period());
        this.setDateAcct(ifa.getDateAcct());
        if (ifa.isFullyDepreciated()) {
            this.setA_Current_Period(ifa.getA_Last_Period());
        }
        this.setIsDepreciated(ifa.isDepreciating());
        if (ifa.getC_BPartnerSR_ID() > 0) {
            this.setC_BPartnerSR_ID(this.getC_BPartnerSR_ID());
        }
        this.setName(ifa.getName());
        this.setDescription(ifa.getDescription());
    }

    public MAsset(MInOut shipment, MInOutLine shipLine, int deliveryCount) {
        this(shipment.getCtx(), 0, shipment.get_TrxName());
        this.setClientOrg(shipment);
        this.setValueNameDescription(shipment, shipLine, deliveryCount);
        this.setAssetServiceDate(shipment.getMovementDate());
        this.setIsOwned(false);
        this.setC_BPartner_ID(shipment.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(shipment.getC_BPartner_Location_ID());
        this.setAD_User_ID(shipment.getAD_User_ID());
        MProduct product = shipLine.getProduct();
        this.setM_Product_ID(product.getM_Product_ID());
        this.setA_Asset_Group_ID(product.getA_Asset_Group_ID());
        MAssetType mAssetType = MAssetType.get(this.getCtx(), this.getAssetGroup().getA_Asset_Type_ID());
        this.setA_Asset_Type_ID(this.getAssetGroup().getA_Asset_Type_ID());
        mAssetType.update(SetGetUtil.wrap(this), true);
        this.setGuaranteeDate(TimeUtil.addDays(shipment.getMovementDate(), product.getGuaranteeDays()));
        this.setVersionNo(product.getVersionNo());
        if (shipLine.getM_AttributeSetInstance_ID() != 0) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), shipLine.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
            this.setLot(asi.getLot());
            this.setSerNo(asi.getSerNo());
        }
        this.setHelp(shipLine.getDescription());
        if (deliveryCount == 0) {
            this.setQty(shipLine.getMovementQty());
        } else {
            this.setQty(BigDecimal.ONE);
        }
        this.setM_InOutLine_ID(shipLine.getM_InOutLine_ID());
        MAssetGroup ag = MAssetGroup.get(this.getCtx(), this.getA_Asset_Group_ID());
        if (!ag.isCreateAsActive()) {
            this.setIsActive(false);
        }
    }

    public MAsset(MInventory inventory, MInventoryLine invLine, BigDecimal qty, BigDecimal costs) {
        super(invLine.getCtx(), 0, invLine.get_TrxName());
        this.setClientOrg(invLine);
        MProduct product = MProduct.get(this.getCtx(), invLine.getM_Product_ID());
        MAssetGroup assetGroup = MAssetGroup.get(invLine.getCtx(), invLine.getA_Asset_Group_ID());
        if (assetGroup == null) {
            assetGroup = MAssetGroup.get(invLine.getCtx(), product.getA_Asset_Group_ID());
        }
        this.setAssetGroup(assetGroup);
        this.setName(product.getName());
        this.setHelp(invLine.getDescription());
        this.setAssetServiceDate(inventory.getMovementDate());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setM_Product_ID(product.getM_Product_ID());
        this.setVersionNo(product.getVersionNo());
        if (invLine.getM_AttributeSetInstance_ID() != 0) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), invLine.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setASI(asi);
        }
        this.setSerNo(invLine.getSerNo());
        this.setQty(qty);
        this.setA_Asset_Cost(costs);
        if (inventory.getC_Activity_ID() > 0) {
            this.setC_Activity_ID(inventory.getC_Activity_ID());
        }
        if (MAssetType.isFixedAsset(this)) {
            this.setA_Asset_Status("NW");
        } else {
            this.setA_Asset_Status("AC");
            this.setProcessed(true);
        }
    }

    public void setAssetGroup(MAssetGroup assetGroup) {
        this.setA_Asset_Group_ID(assetGroup.getA_Asset_Group_ID());
        this.setA_Asset_Type_ID(assetGroup.getA_Asset_Type_ID());
        MAssetType assetType = MAssetType.get(this.getCtx(), assetGroup.getA_Asset_Type_ID());
        assetType.update(SetGetUtil.wrap(this), true);
    }

    public MAssetGroup getAssetGroup() {
        return MAssetGroup.get(this.getCtx(), this.getA_Asset_Group_ID());
    }

    public void setASI(MAttributeSetInstance asi) {
        this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        this.setLot(asi.getLot());
        this.setSerNo(asi.getSerNo());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String invNo;
        if (newRecord) {
            this.setProcessed(false);
            this.setA_Asset_Status("NW");
        }
        if (this.getA_Parent_Asset_ID() <= 0) {
            this.setA_Parent_Asset_ID(this.getA_Asset_ID());
        }
        if ((invNo = this.getInventoryNo()) != null) {
            this.setInventoryNo(invNo.trim());
        }
        if (this.getA_Asset_Group_ID() <= 0) {
            this.setA_Asset_Group_ID(MAssetGroup.getDefault_ID(SetGetUtil.wrap(this)));
        }
        if (this.getA_Asset_Class_ID() <= 0 && this.getA_Asset_Group_ID() > 0) {
            MAssetGroup.updateAsset(SetGetUtil.wrap(this), this.getA_Asset_Group_ID());
        }
        if (this.is_ValueChanged("C_BPartner_Location_ID") && this.getC_BPartner_Location_ID() > 0) {
            SetGetUtil.copyValues(SetGetUtil.wrap(this), "C_BPartner_Location", this.getC_BPartner_Location_ID(), new String[]{"C_Location_ID"});
        }
        if (this.getM_Product_ID() > 0 && this.getM_AttributeSetInstance_ID() <= 0) {
            MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), 0, product.getM_AttributeSet_ID(), this.get_TrxName());
            asi.setSerNo(this.getSerNo());
            asi.setDescription();
            asi.saveEx();
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        this.updateStatus();
        MAssetType.validate(this);
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        String invNo;
        if (!success) {
            return success;
        }
        if (this.getA_Parent_Asset_ID() <= 0) {
            int A_Asset_ID = this.getA_Asset_ID();
            this.setA_Parent_Asset_ID(A_Asset_ID);
            DB.executeUpdateEx("UPDATE A_Asset SET A_Parent_Asset_ID=A_Asset_ID WHERE A_Asset_ID=" + A_Asset_ID, this.get_TrxName());
            this.log.fine("A_Parent_Asset_ID=" + this.getA_Parent_Asset_ID());
        }
        if ((invNo = this.getInventoryNo()) == null || invNo.trim().length() == 0) {
            invNo = "" + this.get_ID();
            this.setInventoryNo(invNo);
            DB.executeUpdateEx("UPDATE A_Asset SET InventoryNo=" + DB.TO_STRING(invNo) + " WHERE A_Asset_ID=" + this.getA_Asset_ID(), this.get_TrxName());
            this.log.fine("InventoryNo=" + this.getInventoryNo());
        }
        if (newRecord) {
            for (MAssetGroupAcct assetgrpacct : MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), this.getA_Asset_Group_ID())) {
                MAssetAcct assetacct = new MAssetAcct(this, assetgrpacct);
                assetacct.saveEx(this.get_TrxName());
                MDepreciationWorkfile assetwk = new MDepreciationWorkfile(this, assetacct.getPostingType(), assetgrpacct);
                assetwk.saveEx(this.get_TrxName());
                MAssetChange.createAndSave(this.getCtx(), "CRT", new PO[]{this, assetwk, assetacct}, null);
            }
        } else {
            MAssetChange.createAndSave(this.getCtx(), "UPD", new PO[]{this}, null);
        }
        if (!newRecord && this.is_ValueChanged("IsDepreciated")) {
            String sql = "UPDATE A_Depreciation_Workfile SET IsDepreciated=? WHERE A_Asset_ID=?";
            DB.executeUpdateEx("UPDATE A_Depreciation_Workfile SET IsDepreciated=? WHERE A_Asset_ID=?", new Object[]{this.isDepreciated(), this.getA_Asset_ID()}, this.get_TrxName());
        }
        return true;
    }

    public MAssetDelivery confirmDelivery(EMail email, int AD_User_ID) {
        this.setVersionNo(this.getProductVersionNo());
        MAssetDelivery ad = new MAssetDelivery(this, email, AD_User_ID);
        return ad;
    }

    @Override
    protected boolean beforeDelete() {
        String sql = "DELETE FROM A_Asset_Addition WHERE Processed=? AND A_Asset_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{false, this.getA_Asset_ID()}, this.get_TrxName());
        this.log.info("@A_Asset_Addition@ @Deleted@ #" + no);
        sql = "UPDATE C_InvoiceLine SET  A_Asset_ID=?,A_Processed=? WHERE A_Asset_ID=?";
        Object[] objectArray = new Object[3];
        objectArray[1] = false;
        objectArray[2] = this.getA_Asset_ID();
        no = DB.executeUpdateEx("UPDATE C_InvoiceLine SET  A_Asset_ID=?,A_Processed=? WHERE A_Asset_ID=?", objectArray, this.get_TrxName());
        this.log.info("@C_InvoiceLine@ @Updated@ #" + no);
        return true;
    }

    public void updateStatus() {
        MAssetClass assetClass;
        String status = this.getA_Asset_Status();
        this.setProcessed(!status.equals("NW"));
        this.setIsDisposed(status.equals("DI") || status.equals("SO"));
        this.setIsFullyDepreciated(status.equals("DP"));
        if (this.isFullyDepreciated() || status.equals("DI")) {
            this.setIsDepreciated(false);
        }
        if ((assetClass = MAssetClass.get(this.getCtx(), this.getA_Asset_Class_ID())) != null && assetClass.isDepreciated()) {
            this.setIsDepreciated(true);
        }
        if (status.equals("AC") || this.getAssetActivationDate() == null) {
            this.setAssetActivationDate(this.getAssetServiceDate());
        }
    }

    public void changeStatus(String newStatus, Timestamp date) {
        String status = this.getA_Asset_Status();
        if (CLogMgt.isLevelFinest()) {
            this.log.finest("Entering: " + status + "->" + newStatus + ", date=" + date);
        }
        if (date == null) {
            date = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (newStatus.equals("AC")) {
            this.setAssetActivationDate(date);
        }
        if (newStatus.equals("PR")) {
            this.setAssetDisposalDate(date);
            Collection<MDepreciationWorkfile> workFiles = MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
            for (MDepreciationWorkfile assetwk : workFiles) {
                assetwk.truncDepreciation();
                assetwk.saveEx();
            }
        }
        if (newStatus.equals("DI")) {
            this.setAssetDisposalDate(date);
        }
        this.setA_Asset_Status(newStatus);
    }

    public int getUseLifeMonths_F() {
        return this.m_UseLifeMonths_F;
    }

    public void setUseLifeMonths_F(int UseLifeMonths_F) {
        this.m_UseLifeMonths_F = UseLifeMonths_F;
    }

    public int getA_Current_Period() {
        return this.m_A_Current_Period;
    }

    public void setA_Current_Period(int A_Current_Period) {
        this.m_A_Current_Period = A_Current_Period;
    }

    public Timestamp getDateAcct() {
        return this.m_DateAcct;
    }

    public void setDateAcct(Timestamp DateAcct) {
        this.m_DateAcct = DateAcct;
    }

    public int getA_Depreciation_ID() {
        return this.m_A_Depreciation_ID;
    }

    public void setA_Depreciation_ID(int A_Depreciation_ID) {
        this.m_A_Depreciation_ID = A_Depreciation_ID;
    }

    public int getA_Depreciation_F_ID() {
        return this.m_A_Depreciation_F_ID;
    }

    public void setA_Depreciation_F_ID(int A_Depreciation_F_ID) {
        this.m_A_Depreciation_F_ID = A_Depreciation_F_ID;
    }

    public BigDecimal getA_Asset_Cost() {
        return this.m_A_Asset_Cost;
    }

    public void setA_Asset_Cost(BigDecimal A_Asset_Cost) {
        this.m_A_Asset_Cost = A_Asset_Cost;
    }

    public BigDecimal getA_Accumulated_Depr() {
        return this.m_A_Accumulated_Depr;
    }

    public void setA_Accumulated_Depr(BigDecimal A_Accumulated_Depr) {
        this.m_A_Accumulated_Depr = A_Accumulated_Depr;
    }

    public BigDecimal getA_Accumulated_Depr_F() {
        return this.m_A_Accumulated_Depr_F;
    }

    public void setA_Accumulated_Depr_F(BigDecimal A_Accumulated_Depr_F) {
        this.m_A_Accumulated_Depr_F = A_Accumulated_Depr_F;
    }

    public void setValueNameDescription(MInOut shipment, MInOutLine line, int deliveryCount) {
        MProduct product = line.getProduct();
        MBPartner partner = shipment.getBPartner();
        this.setValueNameDescription(shipment, deliveryCount, product, partner);
    }

    public void setValueNameDescription(MInOut shipment, int deliveryCount, MProduct product, MBPartner partner) {
        String value;
        String documentNo = "_" + shipment.getDocumentNo();
        if (deliveryCount > 1) {
            documentNo = String.valueOf(documentNo) + "_" + deliveryCount;
        }
        if ((value = String.valueOf(partner.getValue()) + "_" + product.getValue()).length() > 40 - documentNo.length()) {
            value = String.valueOf(value.substring(0, 40 - documentNo.length())) + documentNo;
        }
        this.setValue(value);
        String name = String.valueOf(partner.getName()) + " - " + product.getName();
        if (name.length() > 60) {
            name = name.substring(0, 60);
        }
        this.setName(name);
        String description = product.getDescription();
        this.setDescription(description);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public BigDecimal getQty() {
        BigDecimal qty = super.getQty();
        if (qty == null || qty.compareTo(Env.ZERO) == 0) {
            this.setQty(Env.ONE);
        }
        return super.getQty();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAsset[").append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    public MAssetDelivery[] getDeliveries() {
        String whereClause = "A_Asset_ID=?";
        List<MAssetDelivery> list = new Query(this.getCtx(), "A_Asset_Delivery", "A_Asset_ID=?", this.get_TrxName()).setParameters(this.getA_Asset_ID()).setOrderBy("Created DESC").list();
        MAssetDelivery[] retValue = new MAssetDelivery[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int getDeliveryCount() {
        String sql = "SELECT COUNT(*) FROM A_Asset_Delivery WHERE A_Asset_ID=?";
        return DB.getSQLValue(this.get_TrxName(), sql, this.getA_Asset_ID());
    }

    public boolean isDownloadable() {
        if (!this.isActive()) {
            return false;
        }
        Timestamp guarantee = this.getGuaranteeDate();
        if (guarantee == null) {
            return false;
        }
        guarantee = TimeUtil.getDay(guarantee);
        Timestamp now = TimeUtil.getDay(System.currentTimeMillis());
        if (!now.after(guarantee)) {
            this.getProduct();
            return this.m_product != null && this.m_product.hasDownloads();
        }
        return false;
    }

    public String getProductVersionNo() {
        return this.getProduct().getVersionNo();
    }

    public int getProductR_MailText_ID() {
        return this.getProduct().getR_MailText_ID();
    }

    private MProduct getProduct() {
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public MProductDownload[] getProductDownloads() {
        if (this.m_product == null) {
            this.getProduct();
        }
        if (this.m_product != null) {
            return this.m_product.getProductDownloads(false);
        }
        return null;
    }

    public String[] getDownloadNames() {
        MProductDownload[] dls = this.getProductDownloads();
        if (dls != null && dls.length > 0) {
            String[] retValue = new String[dls.length];
            int i = 0;
            while (i < retValue.length) {
                retValue[i] = dls[i].getName();
                ++i;
            }
            this.log.fine("#" + dls.length);
            return retValue;
        }
        return new String[0];
    }

    public String[] getDownloadURLs() {
        MProductDownload[] dls = this.getProductDownloads();
        if (dls != null && dls.length > 0) {
            String[] retValue = new String[dls.length];
            int i = 0;
            while (i < retValue.length) {
                String url = dls[i].getDownloadURL();
                int pos = Math.max(url.lastIndexOf(47), url.lastIndexOf(92));
                if (pos != -1) {
                    url = url.substring(pos + 1);
                }
                retValue[i] = url;
                ++i;
            }
            return retValue;
        }
        return new String[0];
    }

    public Timestamp getNextMaintenanceDate() {
        if (this.get_ColumnIndex("NextMaintenenceDate") >= 0) {
            return this.getNextMaintenenceDate();
        }
        return (Timestamp)this.get_Value(COLUMNNAME_NextMaintenanceDate);
    }

    public void setNextMaintenanceDate(Timestamp NextMaintenanceDate) {
        if (this.get_ColumnIndex("NextMaintenenceDate") >= 0) {
            this.setNextMaintenenceDate(NextMaintenanceDate);
        } else {
            this.set_ValueOfColumn(COLUMNNAME_NextMaintenanceDate, (Object)NextMaintenanceDate);
        }
    }
}

