/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridTab;
import org.compiere.model.MSequence;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Sequence;
import org.compiere.model.X_AD_Sequence_No;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Trx;

public class LIT_Sequence
extends MSequence {
    private static final Level LOGLEVEL = Level.ALL;
    private static CLogger s_log = CLogger.getCLogger(LIT_Sequence.class);

    public LIT_Sequence(Properties ctx, int AD_Sequence_ID, String trxName) {
        super(ctx, AD_Sequence_ID, trxName);
    }

    public static String getPreliminaryNoByYear(GridTab tab, int AD_Sequence_ID, String dateColumn, String trxName) {
        SimpleDateFormat sdf;
        String calendarYear;
        String sql;
        int next;
        if (AD_Sequence_ID == 0) {
            throw new IllegalArgumentException("Sequence ID not specified");
        }
        X_AD_Sequence sq = new X_AD_Sequence(Env.getCtx(), AD_Sequence_ID, trxName);
        Date d = (Date)tab.getValue(dateColumn);
        if (d == null) {
            d = new Date();
        }
        if ((next = DB.getSQLValue(trxName, sql = "select CurrentNext From AD_Sequence_No Where AD_Sequence_ID = ? and CalendarYear = ?", AD_Sequence_ID, calendarYear = (sdf = new SimpleDateFormat("yyyy")).format(d))) < 0) {
            next = LIT_Sequence.createSequenceByYear(Env.getCtx(), AD_Sequence_ID, calendarYear, trxName);
        }
        StringBuffer doc = new StringBuffer();
        if (sq.getPrefix() != null && sq.getPrefix().length() > 0) {
            doc.append(LIT_Sequence.parseVariable(sq.getPrefix(), tab, trxName, false));
        }
        if (sq.getDecimalPattern() != null && sq.getDecimalPattern().length() > 0) {
            doc.append(new DecimalFormat(sq.getDecimalPattern()).format(next));
        } else {
            doc.append(next);
        }
        if (sq.getSuffix() != null && sq.getSuffix().length() > 0) {
            doc.append(LIT_Sequence.parseVariable(sq.getSuffix(), tab, trxName, false));
        }
        String documentNo = doc.toString();
        return documentNo;
    }

    public static synchronized int createSequenceByYear(Properties ctx, int AD_Sequence_ID, String year, String trxName) {
        if (AD_Sequence_ID == 0) {
            throw new IllegalArgumentException("Sequence ID not specified");
        }
        X_AD_Sequence sq = new X_AD_Sequence(Env.getCtx(), AD_Sequence_ID, trxName);
        X_AD_Sequence_No sqy = new X_AD_Sequence_No(Env.getCtx(), 0, trxName);
        sqy.setAD_Sequence_ID(AD_Sequence_ID);
        sqy.setCalendarYear(year);
        sqy.setCurrentNext(sq.getStartNo());
        if (sqy.save()) {
            return sq.getStartNo();
        }
        return -2;
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized String getDocumentNo(int AD_Client_ID, int AD_Sequence_ID, String trxName, PO po) {
        block46: {
            block45: {
                block44: {
                    if (AD_Sequence_ID == 0) {
                        throw new IllegalArgumentException("Sequence ID not specified");
                    }
                    adempiereSys = Ini.isPropertyBool("AdempiereSys");
                    if (adempiereSys && AD_Client_ID > 11) {
                        adempiereSys = false;
                    }
                    if (CLogMgt.isLevel(LIT_Sequence.LOGLEVEL)) {
                        LIT_Sequence.s_log.log(LIT_Sequence.LOGLEVEL, String.valueOf(AD_Sequence_ID) + " - AdempiereSys=" + adempiereSys + " [" + trxName + "]");
                    }
                    pstmt = null;
                    rs = null;
                    isStartNewYear = false;
                    dateColumn = null;
                    if (!adempiereSys) {
                        startNewYearSQL = "SELECT StartNewYear, DateColumn FROM AD_Sequence WHERE AD_Sequence_ID = ? AND IsActive = 'Y' AND IsTableID = 'N' AND IsAutoSequence='Y' AND AD_Client_ID = ?";
                        try {
                            try {
                                pstmt = DB.prepareStatement(startNewYearSQL, trxName);
                                pstmt.setInt(1, AD_Sequence_ID);
                                pstmt.setInt(2, AD_Client_ID);
                                rs = pstmt.executeQuery();
                                if (rs.next()) {
                                    isStartNewYear = "Y".equals(rs.getString(1));
                                    dateColumn = rs.getString(2);
                                }
                            }
                            catch (Exception e) {
                                LIT_Sequence.s_log.log(Level.SEVERE, "(Table) [" + trxName + "]", e);
                                DB.close(rs, pstmt);
                                break block44;
                            }
                        }
                        catch (Throwable var11_12) {
                            DB.close(rs, pstmt);
                            throw var11_12;
                        }
                        DB.close(rs, pstmt);
                    }
                }
                selectSQL = null;
                selectSQL = !DB.isOracle() ? (isStartNewYear ? "SELECT y.CurrentNext, s.CurrentNextSys, s.IncrementNo, s.Prefix, s.Suffix, s.DecimalPattern FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.AD_Sequence_ID = ? AND s.AD_Client_ID = ? AND y.CalendarYear = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' ORDER BY s.AD_Client_ID DESC FOR UPDATE OF y" : "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, DecimalPattern FROM AD_Sequence WHERE AD_Sequence_ID = ? AND AD_Client_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ORDER BY AD_Client_ID DESC FOR UPDATE OF AD_Sequence") : (isStartNewYear != false ? "SELECT y.CurrentNext, s.CurrentNextSys, s.IncrementNo, Prefix, Suffix, DecimalPattern FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.AD_Sequence_ID = ? AND s.AD_Client_ID = ? AND y.CalendarYear = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' ORDER BY s.AD_Client_ID DESC" : "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, DecimalPattern FROM AD_Sequence WHERE AD_Sequence_ID = ? AND AD_Client_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ORDER BY AD_Client_ID DESC");
                conn = null;
                trx = trxName == null ? null : Trx.get(trxName, true);
                incrementNo = 0;
                next = -1;
                prefix = "";
                suffix = "";
                decimalPattern = "";
                calendarYear = "";
                conn = trx != null ? trx.getConnection() : DB.getConnectionID();
                if (conn != null) break block45;
                DB.close(rs, pstmt);
                try {
                    if (trx == null && conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    LIT_Sequence.s_log.log(Level.SEVERE, "(Sequence) - finish", e);
                }
                return null;
            }
            try {
                try {
                    if (isStartNewYear) {
                        if (po != null && dateColumn != null && dateColumn.length() > 0) {
                            docDate = (Date)po.get_Value(dateColumn);
                            sdf = new SimpleDateFormat("yyyy");
                            calendarYear = sdf.format(docDate);
                        } else {
                            sdf = new SimpleDateFormat("yyyy");
                            calendarYear = sdf.format(new Date());
                        }
                    }
                    pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
                    pstmt.setInt(1, AD_Sequence_ID);
                    pstmt.setInt(2, AD_Client_ID);
                    if (isStartNewYear) {
                        pstmt.setString(3, calendarYear);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        prefix = rs.getString(4);
                        suffix = rs.getString(5);
                        decimalPattern = rs.getString(6);
                        incrementNo = rs.getInt(3);
                        updateSQL = null;
                        try {
                            if (adempiereSys) {
                                updateSQL = conn.prepareStatement("UPDATE AD_Sequence SET CurrentNextSys = CurrentNextSys + ? WHERE AD_Sequence_ID = ?");
                                next = rs.getInt(2);
                            } else {
                                sql = isStartNewYear != false ? "UPDATE AD_Sequence_No SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ? AND CalendarYear = ?" : "UPDATE AD_Sequence SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ?";
                                updateSQL = conn.prepareStatement(sql);
                                next = rs.getInt(1);
                            }
                            updateSQL.setInt(1, incrementNo);
                            updateSQL.setInt(2, AD_Sequence_ID);
                            if (isStartNewYear) {
                                updateSQL.setString(3, calendarYear);
                            }
                            updateSQL.executeUpdate();
                        }
                        catch (Throwable var20_27) {
                            DB.close(updateSQL);
                            throw var20_27;
                        }
                        DB.close(updateSQL);
                    } else if (isStartNewYear) {
                        next = LIT_Sequence.createSequenceByYear(Env.getCtx(), AD_Sequence_ID, calendarYear, trxName);
                    } else {
                        LIT_Sequence.s_log.severe("(Sequence) - no record found - " + AD_Sequence_ID);
                        next = -2;
                    }
                    if (trx != null) break block46;
                    conn.commit();
                }
                catch (Exception e) {
                    LIT_Sequence.s_log.log(Level.SEVERE, "(Sequence) [" + trxName + "]", e);
                    next = -2;
                    DB.close(rs, pstmt);
                    try {
                        if (trx != null || conn == null) ** GOTO lbl137
                        conn.close();
                        conn = null;
                    }
                    catch (Exception e) {
                        LIT_Sequence.s_log.log(Level.SEVERE, "(Sequence) - finish", e);
                    }
                }
            }
            catch (Throwable var21_28) {
                DB.close(rs, pstmt);
                try {
                    if (trx == null && conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    LIT_Sequence.s_log.log(Level.SEVERE, "(Sequence) - finish", e);
                }
                throw var21_28;
            }
        }
        DB.close(rs, pstmt);
        try {
            if (trx == null && conn != null) {
                conn.close();
                conn = null;
            }
        }
        catch (Exception e) {
            LIT_Sequence.s_log.log(Level.SEVERE, "(Sequence) - finish", e);
        }
lbl137:
        // 5 sources

        if (next < 0) {
            return null;
        }
        doc = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            doc.append(Env.parseVariable(prefix, po, trxName, false));
        }
        if (decimalPattern != null && decimalPattern.length() > 0) {
            doc.append(new DecimalFormat(decimalPattern).format(next));
        } else {
            doc.append(next);
        }
        if (suffix != null && suffix.length() > 0) {
            doc.append(Env.parseVariable(suffix, po, trxName, false));
        }
        documentNo = doc.toString();
        LIT_Sequence.s_log.finer(String.valueOf(documentNo) + " (" + incrementNo + ")" + " - Sequence=" + AD_Sequence_ID + " [" + trx + "]");
        return documentNo;
    }

    public static String parseVariable(String expression, GridTab tab, String trxName, boolean keepUnparseable) {
        if (expression == null || expression.length() == 0) {
            return "";
        }
        String inStr = new String(expression);
        StringBuffer outStr = new StringBuffer();
        int i = inStr.indexOf(64);
        while (i != -1) {
            outStr.append(inStr.substring(0, i));
            inStr = inStr.substring(i + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                s_log.log(Level.SEVERE, "No second tag: " + inStr);
                return "";
            }
            String token = inStr.substring(0, j);
            String format = "";
            int f = token.indexOf(60);
            if (f > 0 && token.endsWith(">")) {
                format = token.substring(f + 1, token.length() - 1);
                token = token.substring(0, f);
            }
            if (token.startsWith("#") || token.startsWith("$")) {
                Properties ctx = Env.getCtx();
                String v = Env.getContext(ctx, token);
                if (v != null && v.length() > 0) {
                    outStr.append(v);
                } else if (keepUnparseable) {
                    outStr.append("@" + token + "@");
                }
            } else if (tab != null) {
                Object v = tab.getValue(token);
                if (v != null) {
                    if (format != null && format.length() > 0) {
                        Format df;
                        if (v instanceof Integer && token.endsWith("_ID")) {
                            int tblIndex = format.indexOf(".");
                            String table = tblIndex > 0 ? format.substring(0, tblIndex) : token.substring(0, token.length() - 3);
                            String column = tblIndex > 0 ? format.substring(tblIndex + 1) : format;
                            outStr.append(DB.getSQLValueString(trxName, "select " + column + " from  " + table + " where " + table + "_id = ?", (Integer)v));
                        } else if (v instanceof Date) {
                            df = new SimpleDateFormat(format);
                            outStr.append(((DateFormat)df).format((Date)v));
                        } else if (v instanceof Number) {
                            df = new DecimalFormat(format);
                            outStr.append(((NumberFormat)df).format(((Number)v).doubleValue()));
                        } else {
                            MessageFormat mf = new MessageFormat(format);
                            outStr.append(mf.format(v));
                        }
                    } else {
                        outStr.append(v.toString());
                    }
                } else if (keepUnparseable) {
                    outStr.append("@" + token + "@");
                }
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }
}

