/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.f3p.commons.Utils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MContactInterest;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_I_BPartner;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ImportBPartner
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private Timestamp m_DateValue = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_BPartner WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_BPartner SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Reset=" + no);
        ModelValidationEngine.get().fireImportValidate(this, null, null, 10);
        sql = new StringBuffer("UPDATE I_BPartner i SET GroupValue=(SELECT MAX(Value) FROM C_BP_Group g WHERE g.IsDefault='Y' AND g.AD_Client_ID=i.AD_Client_ID) ");
        sql.append("WHERE GroupValue IS NULL AND C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Group Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BP_Group_ID=(SELECT C_BP_Group_ID FROM C_BP_Group g WHERE i.GroupValue=g.Value AND g.AD_Client_ID=i.AD_Client_ID) WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Group=" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Group, ' WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Group=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c WHERE i.CountryCode=c.CountryCode AND c.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Country_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Country=" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Country, ' WHERE C_Country_ID IS NULL AND (City IS NOT NULL OR Address1 IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Country=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i Set RegionName=(SELECT MAX(Name) FROM C_Region r WHERE r.IsDefault='Y' AND r.C_Country_ID=i.C_Country_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) ");
        sql.append("WHERE RegionName IS NULL AND C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Region Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r WHERE r.Name=i.RegionName AND r.C_Country_ID=i.C_Country_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Region=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Region, ' WHERE C_Region_ID IS NULL  AND EXISTS (SELECT * FROM C_Country c WHERE c.C_Country_ID=i.C_Country_ID AND c.HasRegion='Y') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Region=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_Greeting_ID=(SELECT C_Greeting_ID FROM C_Greeting g WHERE i.BPContactGreeting=g.Name AND g.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Greeting_ID IS NULL AND BPContactGreeting IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Greeting=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Greeting, ' WHERE C_Greeting_ID IS NULL AND BPContactGreeting IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Greeting=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u WHERE i.EMail=u.EMail AND u.AD_Client_ID=i.AD_Client_ID) WHERE i.EMail IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found EMail User=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Value IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found BPartner=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET AD_User_ID=(SELECT AD_User_ID FROM AD_User c WHERE i.ContactName=c.Name AND i.C_BPartner_ID=c.C_BPartner_ID AND c.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NOT NULL AND AD_User_ID IS NULL AND ContactName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found Contact=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BPartner_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID) WHERE i.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=i.AD_Client_ID AND (i.Address1=l.Address1 OR (i.Address1 IS NULL AND l.Address1 IS NULL)) AND (i.Address2=l.Address2 OR (i.Address2 IS NULL AND l.Address2 IS NULL)) AND (i.City=l.City OR (i.City IS NULL AND l.City IS NULL)) AND (i.Postal=l.Postal OR (i.Postal IS NULL AND l.Postal IS NULL)) AND (i.Postal_Add=l.Postal_Add OR (l.Postal_Add IS NULL AND l.Postal_Add IS NULL)) AND i.C_Region_ID=l.C_Region_ID AND i.C_Country_ID=l.C_Country_ID) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found Location=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET R_InterestArea_ID=(SELECT R_InterestArea_ID FROM R_InterestArea ia WHERE i.InterestAreaName=ia.Name AND ia.AD_Client_ID=i.AD_Client_ID) WHERE R_InterestArea_ID IS NULL AND InterestAreaName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Interest Area=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm t WHERE t.name =i.C_PaymentTerm_name AND t.AD_Client_ID=i.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL  and  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set C_PaymentTerm_ID =" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET po_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm t WHERE t.name =i.PO_PaymentTerm_name AND t.AD_Client_ID=i.AD_Client_ID) WHERE po_PaymentTerm_ID IS NULL  and  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set po_PaymentTerm_ID =" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET m_discountschema_id=(SELECT m_discountschema_id FROM m_discountschema t WHERE t.name =i.m_discountschema_name AND t.AD_Client_ID=i.AD_Client_ID) WHERE m_discountschema_id IS NULL  and  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set m_discountschema_id =" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET po_discountschema_id=(SELECT m_discountschema_id FROM m_discountschema t WHERE t.name =i.po_discountschema_name AND t.AD_Client_ID=i.AD_Client_ID) WHERE po_discountschema_id IS NULL  and  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set po_discountschema_id =" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET m_shipper_id=(SELECT m_shipper_id FROM m_shipper t WHERE t.name =i.shippername AND t.AD_Client_ID=i.AD_Client_ID) WHERE m_shipper_id IS NULL  and  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set m_shipper_id =" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET m_shipper2_id=(SELECT m_shipper_id FROM m_shipper t WHERE t.name =i.shipper2name AND t.AD_Client_ID=i.AD_Client_ID) WHERE m_shipper2_id IS NULL  and  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set m_shipper2_id =" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET po_shipper_id=(SELECT m_shipper_id FROM m_shipper t WHERE t.name =i.po_shippername AND t.AD_Client_ID=i.AD_Client_ID) WHERE po_shipper_id IS NULL  and  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set po_shipper_id =" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET po_shipper2_id=(SELECT m_shipper_id FROM m_shipper t WHERE t.name =i.po_shipper2name AND t.AD_Client_ID=i.AD_Client_ID) WHERE po_shipper2_id IS NULL  and  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set po_shipper2_id =" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Value is mandatory, ' WHERE Value IS NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Value is mandatory=" + no);
        ModelValidationEngine.get().fireImportValidate(this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuffer("SELECT * FROM I_BPartner WHERE I_IsImported='N'").append(clientCheck);
        sql.append(" ORDER BY Value, I_BPartner_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                rs = pstmt.executeQuery();
                String Old_BPValue = "";
                MBPartner bp = null;
                MBPartnerLocation bpl = null;
                while (true) {
                    MUser user;
                    X_I_BPartner impBP;
                    block67: {
                        String name;
                        block69: {
                            block71: {
                                block72: {
                                    block70: {
                                        MLocation location;
                                        block68: {
                                            String New_BPValue;
                                            block66: {
                                                if (!rs.next()) {
                                                    DB.close(rs, pstmt);
                                                    break;
                                                }
                                                New_BPValue = rs.getString("Value");
                                                impBP = new X_I_BPartner(this.getCtx(), rs, this.get_TrxName());
                                                this.log.fine("I_BPartner_ID=" + impBP.getI_BPartner_ID() + ", C_BPartner_ID=" + impBP.getC_BPartner_ID() + ", C_BPartner_Location_ID=" + impBP.getC_BPartner_Location_ID() + ", AD_User_ID=" + impBP.getAD_User_ID());
                                                if (!New_BPValue.equals(Old_BPValue)) {
                                                    bp = null;
                                                    if (impBP.getC_BPartner_ID() == 0) {
                                                        bp = new MBPartner(impBP);
                                                        bp.setIsProspect(impBP.isProspect());
                                                        if (impBP.getName() != null) {
                                                            bp.setName(impBP.getName());
                                                            bp.setName2(impBP.getName2());
                                                        }
                                                        if (impBP.getDUNS() != null) {
                                                            bp.setDUNS(impBP.getDUNS());
                                                        }
                                                        if (impBP.getTaxID() != null) {
                                                            bp.setTaxID(impBP.getTaxID());
                                                        }
                                                        if (impBP.getFiscalcode() != null) {
                                                            bp.set_ValueOfColumn("fiscalcode", (Object)impBP.getFiscalcode());
                                                        }
                                                        if (impBP.getNAICS() != null) {
                                                            bp.setNAICS(impBP.getNAICS());
                                                        }
                                                        if (impBP.getDescription() != null) {
                                                            bp.setDescription(impBP.getDescription());
                                                        }
                                                        if (impBP.getC_BP_Group_ID() != 0) {
                                                            bp.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
                                                        }
                                                        bp.setPaymentRule(impBP.getPaymentRule());
                                                        bp.setPaymentRulePO(impBP.getPaymentRulePO());
                                                        bp.setC_PaymentTerm_ID(impBP.getC_PaymentTerm_ID());
                                                        bp.setPO_PaymentTerm_ID(impBP.getPO_PaymentTerm_ID());
                                                        bp.setM_DiscountSchema_ID(impBP.getM_DiscountSchema_ID());
                                                        bp.setPO_DiscountSchema_ID(impBP.getPO_DiscountSchema_ID());
                                                        bp.setM_PriceList_ID(impBP.getM_PriceList_ID());
                                                        bp.setPO_PriceList_ID(impBP.getPO_PriceList_ID());
                                                        bp.setFlatDiscount(impBP.getFlatDiscount());
                                                        bp.set_ValueOfColumn("bp_porto", (Object)impBP.getBP_porto());
                                                        bp.set_ValueOfColumn("po_bp_porto", (Object)impBP.getPO_BP_porto());
                                                        bp.set_ValueOfColumn("m_shipper_id", (Object)impBP.getM_Shipper());
                                                        bp.set_ValueOfColumn("m_shipper2_id", (Object)impBP.getM_Shipper2());
                                                        bp.set_ValueOfColumn("po_shipper_id", (Object)impBP.getPO_Shipper());
                                                        bp.set_ValueOfColumn("po_shipper2_id", (Object)impBP.getPO_Shipper2());
                                                        bp.set_ValueOfColumn("bp_vs_date_ese", (Object)impBP.getBP_Vs_date_ese());
                                                        bp.set_ValueOfColumn("bp_vs_num_ese", (Object)impBP.getBP_Vs_num_ese());
                                                        bp.set_ValueOfColumn("bp_ns_date_ese", (Object)impBP.getBP_Ns_date_ese());
                                                        bp.set_ValueOfColumn("bp_ns_num_ese", (Object)impBP.getBP_Ns_num_ese());
                                                        this.setTypeOfBPartner(impBP, bp);
                                                        ModelValidationEngine.get().fireImportValidate(this, impBP, bp, 40);
                                                        if (bp.save()) {
                                                            impBP.setC_BPartner_ID(bp.getC_BPartner_ID());
                                                            this.log.finest("Insert BPartner - " + bp.getC_BPartner_ID());
                                                            ++noInsert;
                                                            break block66;
                                                        } else {
                                                            sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPartner, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                                            DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                                            continue;
                                                        }
                                                    }
                                                    bp = new MBPartner(this.getCtx(), impBP.getC_BPartner_ID(), this.get_TrxName());
                                                    if (impBP.getName() != null) {
                                                        bp.setName(impBP.getName());
                                                        bp.setName2(impBP.getName2());
                                                    }
                                                    if (impBP.getDUNS() != null) {
                                                        bp.setDUNS(impBP.getDUNS());
                                                    }
                                                    if (impBP.getTaxID() != null) {
                                                        bp.setTaxID(impBP.getTaxID());
                                                    }
                                                    if (impBP.getFiscalcode() != null) {
                                                        bp.set_ValueOfColumn("fiscalcode", (Object)impBP.getFiscalcode());
                                                    }
                                                    if (impBP.getNAICS() != null) {
                                                        bp.setNAICS(impBP.getNAICS());
                                                    }
                                                    if (impBP.getDescription() != null) {
                                                        bp.setDescription(impBP.getDescription());
                                                    }
                                                    if (impBP.getC_BP_Group_ID() != 0) {
                                                        bp.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
                                                    }
                                                    bp.setPaymentRule(impBP.getPaymentRule());
                                                    bp.setPaymentRulePO(impBP.getPaymentRulePO());
                                                    bp.setC_PaymentTerm_ID(impBP.getC_PaymentTerm_ID());
                                                    bp.setPO_PaymentTerm_ID(impBP.getPO_PaymentTerm_ID());
                                                    bp.setM_DiscountSchema_ID(impBP.getM_DiscountSchema_ID());
                                                    bp.setPO_DiscountSchema_ID(impBP.getPO_DiscountSchema_ID());
                                                    bp.setM_PriceList_ID(impBP.getM_PriceList_ID());
                                                    bp.setPO_PriceList_ID(impBP.getPO_PriceList_ID());
                                                    bp.setFlatDiscount(impBP.getFlatDiscount());
                                                    bp.set_ValueOfColumn("bp_porto", (Object)impBP.getBP_porto());
                                                    bp.set_ValueOfColumn("po_bp_porto", (Object)impBP.getPO_BP_porto());
                                                    bp.set_ValueOfColumn("m_shipper_id", (Object)impBP.getM_Shipper());
                                                    bp.set_ValueOfColumn("m_shipper2_id", (Object)impBP.getM_Shipper2());
                                                    bp.set_ValueOfColumn("po_shipper_id", (Object)impBP.getPO_Shipper());
                                                    bp.set_ValueOfColumn("po_shipper2_id", (Object)impBP.getPO_Shipper2());
                                                    bp.set_ValueOfColumn("bp_vs_date_ese", (Object)impBP.getBP_Vs_date_ese());
                                                    bp.set_ValueOfColumn("bp_vs_num_ese", (Object)impBP.getBP_Vs_num_ese());
                                                    bp.set_ValueOfColumn("bp_ns_date_ese", (Object)impBP.getBP_Ns_date_ese());
                                                    bp.set_ValueOfColumn("bp_ns_num_ese", (Object)impBP.getBP_Ns_num_ese());
                                                    ModelValidationEngine.get().fireImportValidate(this, impBP, bp, 40);
                                                    this.setTypeOfBPartner(impBP, bp);
                                                    if (bp.save()) {
                                                        this.log.finest("Update BPartner - " + bp.getC_BPartner_ID());
                                                        ++noUpdate;
                                                    } else {
                                                        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BPartner, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                                        DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                                        continue;
                                                    }
                                                }
                                            }
                                            Old_BPValue = New_BPValue;
                                            bpl = null;
                                            if (impBP.getC_BPartner_Location_ID() == 0) break block68;
                                            bpl = new MBPartnerLocation(this.getCtx(), impBP.getC_BPartner_Location_ID(), this.get_TrxName());
                                            location = new MLocation(this.getCtx(), bpl.getC_Location_ID(), this.get_TrxName());
                                            location.setC_Country_ID(impBP.getC_Country_ID());
                                            location.setC_Region_ID(impBP.getC_Region_ID());
                                            location.setCity(impBP.getCity());
                                            location.setAddress1(impBP.getAddress1());
                                            location.setAddress2(impBP.getAddress2());
                                            location.setPostal(impBP.getPostal());
                                            location.setPostal_Add(impBP.getPostal_Add());
                                            if (!location.save()) {
                                                this.log.warning("Location not updated");
                                            } else {
                                                bpl.setC_Location_ID(location.getC_Location_ID());
                                            }
                                            if (impBP.getPhone() != null) {
                                                bpl.setPhone(impBP.getPhone());
                                            }
                                            if (impBP.getPhone2() != null) {
                                                bpl.setPhone2(impBP.getPhone2());
                                            }
                                            if (impBP.getFax() != null) {
                                                bpl.setFax(impBP.getFax());
                                            }
                                            if (impBP.getEMail() != null) {
                                                bpl.setISDN(impBP.getEMail());
                                            }
                                            bpl.setIsBillTo(impBP.isBillTo());
                                            bpl.setIsShipTo(impBP.isShipTo());
                                            ModelValidationEngine.get().fireImportValidate(this, impBP, bpl, 40);
                                            bpl.save();
                                            break block69;
                                        }
                                        if (impBP.getC_Country_ID() == 0 || impBP.getAddress1() == null || impBP.getCity() == null) break block69;
                                        location = new MLocation(this.getCtx(), impBP.getC_Country_ID(), impBP.getC_Region_ID(), impBP.getCity(), this.get_TrxName());
                                        location.setAddress1(impBP.getAddress1());
                                        location.setAddress2(impBP.getAddress2());
                                        location.setPostal(impBP.getPostal());
                                        location.setPostal_Add(impBP.getPostal_Add());
                                        if (!location.save()) break block70;
                                        this.log.finest("Insert Location - " + location.getC_Location_ID());
                                        bpl = new MBPartnerLocation(bp);
                                        bpl.setC_Location_ID(location.getC_Location_ID());
                                        bpl.setPhone(impBP.getPhone());
                                        bpl.setPhone2(impBP.getPhone2());
                                        bpl.setFax(impBP.getFax());
                                        bpl.setIsBillTo(impBP.isBillTo());
                                        bpl.setIsShipTo(impBP.isShipTo());
                                        ModelValidationEngine.get().fireImportValidate(this, impBP, bpl, 40);
                                        if (!bpl.save()) break block71;
                                        break block72;
                                    }
                                    this.rollback();
                                    --noInsert;
                                    sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert Location, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                    DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                    continue;
                                }
                                this.log.finest("Insert BP Location - " + bpl.getC_BPartner_Location_ID());
                                impBP.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                                break block69;
                            }
                            this.rollback();
                            --noInsert;
                            sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPLocation, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                            DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                            continue;
                        }
                        user = null;
                        if (impBP.getAD_User_ID() != 0) {
                            user = new MUser(this.getCtx(), impBP.getAD_User_ID(), this.get_TrxName());
                            if (user.getC_BPartner_ID() == 0) {
                                user.setC_BPartner_ID(bp.getC_BPartner_ID());
                            } else if (user.getC_BPartner_ID() != bp.getC_BPartner_ID()) {
                                this.rollback();
                                --noInsert;
                                sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'BP of User <> BP, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                continue;
                            }
                            if (impBP.getC_Greeting_ID() != 0) {
                                user.setC_Greeting_ID(impBP.getC_Greeting_ID());
                            }
                            if ((name = impBP.getContactName()) == null || name.length() == 0) {
                                name = impBP.getEMail();
                            }
                            user.setName(name);
                            if (impBP.getTitle() != null) {
                                user.setTitle(impBP.getTitle());
                            }
                            if (impBP.getContactDescription() != null) {
                                user.setDescription(impBP.getContactDescription());
                            }
                            if (impBP.getComments() != null) {
                                user.setComments(impBP.getComments());
                            }
                            if (impBP.getPhone() != null) {
                                user.setPhone(impBP.getPhone());
                            }
                            if (impBP.getPhone2() != null) {
                                user.setPhone2(impBP.getPhone2());
                            }
                            if (impBP.getFax() != null) {
                                user.setFax(impBP.getFax());
                            }
                            if (impBP.getEMail() != null) {
                                user.setEMail(impBP.getEMail());
                            }
                            if (impBP.getBirthday() != null) {
                                user.setBirthday(impBP.getBirthday());
                            }
                            if (bpl != null) {
                                user.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                            }
                            ModelValidationEngine.get().fireImportValidate(this, impBP, user, 40);
                            if (user.save()) {
                                this.log.finest("Update BP Contact - " + user.getAD_User_ID());
                                break block67;
                            } else {
                                this.rollback();
                                --noInsert;
                                sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BP Contact, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                continue;
                            }
                        }
                        if (impBP.getContactName() != null || impBP.getEMail() != null) {
                            user = new MUser(bp);
                            if (impBP.getC_Greeting_ID() != 0) {
                                user.setC_Greeting_ID(impBP.getC_Greeting_ID());
                            }
                            if ((name = impBP.getContactName()) == null || name.length() == 0) {
                                name = impBP.getEMail();
                            }
                            user.setName(name);
                            user.setTitle(impBP.getTitle());
                            user.setDescription(impBP.getContactDescription());
                            user.setComments(impBP.getComments());
                            user.setPhone(impBP.getPhone());
                            user.setPhone2(impBP.getPhone2());
                            user.setFax(impBP.getFax());
                            user.setEMail(impBP.getEMail());
                            user.setBirthday(impBP.getBirthday());
                            if (bpl != null) {
                                user.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                            }
                            ModelValidationEngine.get().fireImportValidate(this, impBP, user, 40);
                            if (user.save()) {
                                this.log.finest("Insert BP Contact - " + user.getAD_User_ID());
                                impBP.setAD_User_ID(user.getAD_User_ID());
                            } else {
                                this.rollback();
                                --noInsert;
                                sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPContact, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                continue;
                            }
                        }
                    }
                    if (impBP.getR_InterestArea_ID() != 0 && user != null) {
                        MContactInterest ci = MContactInterest.get(this.getCtx(), impBP.getR_InterestArea_ID(), user.getAD_User_ID(), true, this.get_TrxName());
                        ci.save();
                    }
                    String sAccName = impBP.getA_Name();
                    String sIBAN = impBP.getIBAN();
                    if (!Utils.isEmptyString(sIBAN)) {
                        MBPBankAccount mBPBankAccount = this.getBPBankAccountFromIBAN(bp.getC_BPartner_ID(), sIBAN);
                        if (mBPBankAccount == null && !Utils.isEmptyString(sAccName)) {
                            mBPBankAccount = new MBPBankAccount(this.getCtx(), 0, this.get_TrxName());
                            mBPBankAccount.setC_BPartner_ID(bp.getC_BPartner_ID());
                            mBPBankAccount.set_CustomColumn("IBAN", sIBAN);
                        }
                        if (mBPBankAccount != null) {
                            int iAD_User_ID;
                            if (user != null && (iAD_User_ID = user.getAD_User_ID()) > 0) {
                                mBPBankAccount.setAD_User_ID(iAD_User_ID);
                            }
                            if (!Utils.isEmptyString(sAccName)) {
                                mBPBankAccount.setA_Name(sAccName);
                            }
                            mBPBankAccount.set_CustomColumn("WSC_Switch_Riba", impBP.isRiba());
                            ModelValidationEngine.get().fireImportValidate(this, impBP, mBPBankAccount, 40);
                            if (mBPBankAccount.save()) {
                                this.log.finest("Update BP BankAccount - " + mBPBankAccount.getC_BP_BankAccount_ID());
                                mBPBankAccount.setC_BP_BankAccount_ID(impBP.getC_BP_BankAccount_ID());
                            } else {
                                this.rollback();
                                --noInsert;
                                sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BP BankAccount, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                continue;
                            }
                        }
                    }
                    impBP.setI_IsImported(true);
                    impBP.setProcessed(true);
                    impBP.setProcessing(false);
                    impBP.saveEx();
                    this.commitEx();
                }
            }
            catch (SQLException e) {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            this.addLog(0, null, new BigDecimal(no), "@Errors@");
            this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
            this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
        return "";
    }

    @Override
    public String getWhereClause() {
        return " AND AD_Client_ID=" + this.m_AD_Client_ID;
    }

    @Override
    public String getImportTableName() {
        return "I_BPartner";
    }

    private void setTypeOfBPartner(X_I_BPartner impBP, MBPartner bp) {
        if (impBP.isVendor()) {
            bp.setIsVendor(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isEmployee()) {
            bp.setIsEmployee(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isCustomer()) {
            bp.setIsCustomer(true);
        }
    }

    protected MBPBankAccount getBPBankAccountFromIBAN(int C_BPartner_ID, String WSC_IBAN) {
        Query q = new Query(this.getCtx(), "C_BP_BankAccount", "C_BPartner_ID = ? AND WSC_IBAN = ?", this.get_TrxName()).setOnlyActiveRecords(true).setApplyAccessFilter(true).setParameters(C_BPartner_ID, WSC_IBAN);
        return (MBPBankAccount)q.first();
    }

    protected MBPBankAccount getBPBankAccountFromName(int C_BPartner_ID, String A_Name) {
        Query q = new Query(this.getCtx(), "C_BP_BankAccount", "C_BPartner_ID = ? AND A_Name = ?", this.get_TrxName()).setOnlyActiveRecords(true).setApplyAccessFilter(true).setParameters(C_BPartner_ID, A_Name);
        return (MBPBankAccount)q.first();
    }
}

