/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;

public class GridTabVO
implements Evaluatee,
Serializable {
    static final long serialVersionUID = 9160212869277319305L;
    public Properties ctx;
    public int WindowNo;
    public int AD_Window_ID;
    public int TabNo;
    public int AD_Tab_ID;
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public boolean IsSingleRow = false;
    public boolean IsReadOnly = false;
    public boolean IsInsertRecord = true;
    public boolean HasTree = false;
    public int AD_Table_ID;
    public int AD_Column_ID = 0;
    public int Parent_Column_ID = 0;
    public String TableName;
    public boolean IsView = false;
    public String AccessLevel;
    public boolean IsSecurityEnabled = false;
    public boolean IsDeleteable = false;
    public boolean IsHighVolume = false;
    public int AD_Process_ID = 0;
    public String CommitWarning;
    public String WhereClause;
    public String OrderByClause;
    public String ReadOnlyLogic;
    public String DisplayLogic;
    public int TabLevel = 0;
    public int AD_Image_ID = 0;
    public int Included_Tab_ID = 0;
    public String ReplicationType = "L";
    public boolean IsSortTab = false;
    public int AD_ColumnSortOrder_ID = 0;
    public int AD_ColumnSortYesNo_ID = 0;
    public boolean onlyCurrentRows = true;
    public int onlyCurrentDays = 0;
    private ArrayList<GridFieldVO> Fields = null;
    private boolean initFields = false;

    public static GridTabVO create(GridWindowVO wVO, int TabNo, ResultSet rs, boolean isRO, boolean onlyCurrentRows) {
        CLogger.get().config("#" + TabNo);
        GridTabVO vo = new GridTabVO(wVO.ctx, wVO.WindowNo);
        vo.AD_Window_ID = wVO.AD_Window_ID;
        vo.TabNo = TabNo;
        if (!GridTabVO.loadTabDetails(vo, rs)) {
            return null;
        }
        if (isRO) {
            CLogger.get().fine("Tab is ReadOnly");
            vo.IsReadOnly = true;
        }
        vo.onlyCurrentRows = onlyCurrentRows;
        if (vo.IsSortTab) {
            vo.Fields = new ArrayList();
        }
        return vo;
    }

    private static boolean loadTabDetails(GridTabVO vo, ResultSet rs) {
        block35: {
            MRole role;
            block34: {
                block33: {
                    boolean showAcct;
                    block32: {
                        boolean showAdvanced;
                        block31: {
                            role = MRole.getDefault(vo.ctx, false);
                            boolean showTrl = "Y".equals(Env.getContext(vo.ctx, "#ShowTrl"));
                            showAcct = "Y".equals(Env.getContext(vo.ctx, "#ShowAcct"));
                            showAdvanced = "Y".equals(Env.getContext(vo.ctx, "#ShowAdvanced"));
                            try {
                                vo.AD_Tab_ID = rs.getInt("AD_Tab_ID");
                                Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Tab_ID", String.valueOf(vo.AD_Tab_ID));
                                vo.Name = rs.getString("Name");
                                Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_Name", vo.Name);
                                if (!rs.getString("IsTranslationTab").equals("Y")) break block31;
                                vo.TableName = rs.getString("TableName");
                                if (!Env.isBaseTranslation(vo.TableName) && !Env.isMultiLingualDocument(vo.ctx)) {
                                    showTrl = false;
                                }
                                if (showTrl) break block31;
                                CLogger.get().config("TrlTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + "=" + vo.Name + ", Table=" + vo.TableName + ", BaseTrl=" + Env.isBaseTranslation(vo.TableName) + ", MultiLingual=" + Env.isMultiLingualDocument(vo.ctx));
                                return false;
                            }
                            catch (SQLException ex) {
                                CLogger.get().log(Level.SEVERE, "", ex);
                                return false;
                            }
                        }
                        if (showAdvanced || !rs.getString("IsAdvancedTab").equals("Y")) break block32;
                        CLogger.get().config("AdvancedTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                        return false;
                    }
                    if (showAcct || !rs.getString("IsInfoTab").equals("Y")) break block33;
                    CLogger.get().fine("AcctTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                    return false;
                }
                vo.DisplayLogic = rs.getString("DisplayLogic");
                vo.AccessLevel = rs.getString("AccessLevel");
                if (role.canView(vo.ctx, vo.AccessLevel)) break block34;
                CLogger.get().fine("No Role Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                return false;
            }
            Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AccessLevel", vo.AccessLevel);
            vo.AD_Table_ID = rs.getInt("AD_Table_ID");
            Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Table_ID", String.valueOf(vo.AD_Table_ID));
            if (role.isTableAccess(vo.AD_Table_ID, true)) break block35;
            CLogger.get().config("No Table Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            return false;
        }
        if (rs.getString("IsReadOnly").equals("Y")) {
            vo.IsReadOnly = true;
        }
        vo.ReadOnlyLogic = rs.getString("ReadOnlyLogic");
        if (rs.getString("IsInsertRecord").equals("N")) {
            vo.IsInsertRecord = false;
        }
        vo.Description = rs.getString("Description");
        if (vo.Description == null) {
            vo.Description = "";
        }
        vo.Help = rs.getString("Help");
        if (vo.Help == null) {
            vo.Help = "";
        }
        if (rs.getString("IsSingleRow").equals("Y")) {
            vo.IsSingleRow = true;
        }
        if (rs.getString("HasTree").equals("Y")) {
            vo.HasTree = true;
        }
        vo.AD_Table_ID = rs.getInt("AD_Table_ID");
        vo.TableName = rs.getString("TableName");
        if (rs.getString("IsView").equals("Y")) {
            vo.IsView = true;
        }
        vo.AD_Column_ID = rs.getInt("AD_Column_ID");
        vo.Parent_Column_ID = rs.getInt("Parent_Column_ID");
        if (rs.getString("IsSecurityEnabled").equals("Y")) {
            vo.IsSecurityEnabled = true;
        }
        if (rs.getString("IsDeleteable").equals("Y")) {
            vo.IsDeleteable = true;
        }
        if (rs.getString("IsHighVolume").equals("Y")) {
            vo.IsHighVolume = true;
        }
        vo.CommitWarning = rs.getString("CommitWarning");
        if (vo.CommitWarning == null) {
            vo.CommitWarning = "";
        }
        vo.WhereClause = rs.getString("WhereClause");
        if (vo.WhereClause == null) {
            vo.WhereClause = "";
        }
        if (vo.WhereClause.indexOf("=null") > 0) {
            vo.WhereClause.replaceAll("=null", " IS NULL ");
        }
        if (vo.WhereClause.trim().length() > 0) {
            vo.WhereClause = "(" + vo.WhereClause + ")";
        }
        vo.OrderByClause = rs.getString("OrderByClause");
        if (vo.OrderByClause == null) {
            vo.OrderByClause = "";
        }
        vo.AD_Process_ID = rs.getInt("AD_Process_ID");
        if (rs.wasNull()) {
            vo.AD_Process_ID = 0;
        }
        vo.AD_Image_ID = rs.getInt("AD_Image_ID");
        if (rs.wasNull()) {
            vo.AD_Image_ID = 0;
        }
        vo.Included_Tab_ID = rs.getInt("Included_Tab_ID");
        if (rs.wasNull()) {
            vo.Included_Tab_ID = 0;
        }
        vo.TabLevel = rs.getInt("TabLevel");
        if (rs.wasNull()) {
            vo.TabLevel = 0;
        }
        vo.IsSortTab = rs.getString("IsSortTab").equals("Y");
        if (vo.IsSortTab) {
            vo.AD_ColumnSortOrder_ID = rs.getInt("AD_ColumnSortOrder_ID");
            vo.AD_ColumnSortYesNo_ID = rs.getInt("AD_ColumnSortYesNo_ID");
        }
        try {
            int index = rs.findColumn("ReplicationType");
            vo.ReplicationType = rs.getString(index);
            if ("R".equals(vo.ReplicationType)) {
                vo.IsReadOnly = true;
            }
        }
        catch (Exception index) {}
        return true;
    }

    private static boolean createFields(GridTabVO mTabVO) {
        mTabVO.Fields = new ArrayList();
        String sql = GridFieldVO.getSQL(mTabVO.ctx);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, mTabVO.AD_Tab_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                GridFieldVO voF = GridFieldVO.create(mTabVO.ctx, mTabVO.WindowNo, mTabVO.TabNo, mTabVO.AD_Window_ID, mTabVO.AD_Tab_ID, mTabVO.IsReadOnly, rs);
                if (voF == null) continue;
                mTabVO.Fields.add(voF);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            CLogger.get().log(Level.SEVERE, "", e);
            return false;
        }
        mTabVO.initFields = true;
        return mTabVO.Fields.size() != 0;
    }

    protected static String getSQL(Properties ctx) {
        MClient client = MClient.get(ctx);
        String ASPFilter = "";
        if (client.isUseASP()) {
            ASPFilter = "     AND (   AD_Tab_ID IN (               SELECT t.AD_Tab_ID                 FROM ASP_Tab t, ASP_Window w, ASP_Level l, ASP_ClientLevel cl                WHERE w.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND t.ASP_Window_ID = w.ASP_Window_ID " + "                 AND t.IsActive = 'Y' " + "                 AND w.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "                 AND t.ASP_Status = 'S') " + "        OR AD_Tab_ID IN ( " + "              SELECT AD_Tab_ID " + "                FROM ASP_ClientException ce " + "               WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y' " + "                 AND ce.AD_Tab_ID IS NOT NULL " + "                 AND ce.AD_Field_ID IS NULL " + "                 AND ce.ASP_Status = 'S') " + "       ) " + "   AND AD_Tab_ID NOT IN ( " + "          SELECT AD_Tab_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Tab_ID IS NOT NULL " + "             AND ce.AD_Field_ID IS NULL " + "             AND ce.ASP_Status = 'H')";
        }
        String sql = "SELECT * FROM AD_Tab_v WHERE AD_Window_ID=?" + ASPFilter + " ORDER BY SeqNo";
        if (!Env.isBaseLanguage(ctx, "AD_Window")) {
            sql = "SELECT * FROM AD_Tab_vt WHERE AD_Window_ID=? AND AD_Language='" + Env.getAD_Language(ctx) + "'" + ASPFilter + " ORDER BY SeqNo";
        }
        return sql;
    }

    private GridTabVO(Properties Ctx, int windowNo) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
    }

    public ArrayList<GridFieldVO> getFields() {
        if (!this.initFields) {
            GridTabVO.createFields(this);
        }
        return this.Fields;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        if (this.Fields != null) {
            int i = 0;
            while (i < this.Fields.size()) {
                GridFieldVO field = this.Fields.get(i);
                field.setCtx(newCtx);
                ++i;
            }
        }
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return Env.getContext(this.ctx, this.WindowNo, variableName, false);
    }

    protected GridTabVO clone(Properties Ctx, int windowNo) {
        GridTabVO clone = new GridTabVO(Ctx, windowNo);
        clone.AD_Window_ID = this.AD_Window_ID;
        clone.TabNo = this.TabNo;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AD_Tab_ID", String.valueOf(clone.AD_Tab_ID));
        clone.AD_Tab_ID = this.AD_Tab_ID;
        clone.Name = this.Name;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_Name", clone.Name);
        clone.Description = this.Description;
        clone.Help = this.Help;
        clone.IsSingleRow = this.IsSingleRow;
        clone.IsReadOnly = this.IsReadOnly;
        clone.IsInsertRecord = this.IsInsertRecord;
        clone.HasTree = this.HasTree;
        clone.AD_Table_ID = this.AD_Table_ID;
        clone.AD_Column_ID = this.AD_Column_ID;
        clone.Parent_Column_ID = this.Parent_Column_ID;
        clone.TableName = this.TableName;
        clone.IsView = this.IsView;
        clone.AccessLevel = this.AccessLevel;
        clone.IsSecurityEnabled = this.IsSecurityEnabled;
        clone.IsDeleteable = this.IsDeleteable;
        clone.IsHighVolume = this.IsHighVolume;
        clone.AD_Process_ID = this.AD_Process_ID;
        clone.CommitWarning = this.CommitWarning;
        clone.WhereClause = this.WhereClause;
        clone.OrderByClause = this.OrderByClause;
        clone.ReadOnlyLogic = this.ReadOnlyLogic;
        clone.DisplayLogic = this.DisplayLogic;
        clone.TabLevel = this.TabLevel;
        clone.AD_Image_ID = this.AD_Image_ID;
        clone.Included_Tab_ID = this.Included_Tab_ID;
        clone.ReplicationType = this.ReplicationType;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AccessLevel", clone.AccessLevel);
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AD_Table_ID", String.valueOf(clone.AD_Table_ID));
        clone.IsSortTab = this.IsSortTab;
        clone.AD_ColumnSortOrder_ID = this.AD_ColumnSortOrder_ID;
        clone.AD_ColumnSortYesNo_ID = this.AD_ColumnSortYesNo_ID;
        clone.onlyCurrentRows = true;
        clone.onlyCurrentDays = 0;
        clone.Fields = new ArrayList();
        int i = 0;
        while (i < this.Fields.size()) {
            GridFieldVO field = this.Fields.get(i);
            GridFieldVO cloneField = field.clone(Ctx, windowNo, this.TabNo, this.AD_Window_ID, this.AD_Tab_ID, this.IsReadOnly);
            if (cloneField == null) {
                return null;
            }
            clone.Fields.add(cloneField);
            ++i;
        }
        return clone;
    }

    public boolean isInitFields() {
        return this.initFields;
    }
}

