/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.LIT_Sequence;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MPNGEntryType;
import org.compiere.model.MPNGInvoice;
import org.compiere.model.MPNGJournal;
import org.compiere.model.MPNGJournalLine;
import org.compiere.model.MSequence;
import org.compiere.model.MTax;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutPNGJournal
extends CalloutEngine {
    public static final double CONVAMT_MIN_DELTA = 0.01;

    public String DocumentType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int EntryType_ID = (Integer)value;
        MPNGEntryType EntryT = new MPNGEntryType(ctx, EntryType_ID, null);
        mTab.setValue("C_DocType_ID", (Object)EntryT.getC_DocType_ID());
        Integer Doc_ID = (Integer)EntryT.get_Value("C_DocType_ID");
        MDocType doc = new MDocType(ctx, Doc_ID, null);
        mTab.setValue("DocBaseType", (Object)doc.getDocBaseType());
        mTab.setValue("GL_Category_ID", (Object)doc.getGL_Category_ID());
        mTab.setValue("IsSOTrx", (Object)doc.isSOTrx());
        mTab.setValue("Description", (Object)EntryT.getDescription());
        return "";
    }

    public String Period(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
        Timestamp DateAcct = (Timestamp)mTab.getValue("DateAcct");
        if (DateAcct == null) {
            DateAcct = new Timestamp(System.currentTimeMillis());
        }
        int C_Period_ID = 0;
        String sql = "SELECT C_Period_ID FROM C_Period WHERE C_Year_ID IN \t(SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID =  (SELECT C_Calendar_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)) AND ? BETWEEN StartDate AND EndDate AND IsActive='Y' AND PeriodType='S'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Client_ID);
                pstmt.setTimestamp(2, DateAcct);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    C_Period_ID = rs.getInt(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        if (C_Period_ID != 0) {
            mTab.setValue("C_Period_ID", (Object)new Integer(C_Period_ID));
        }
        return "";
    }

    public String AmountCR(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer Acc_id = (Integer)mTab.getValue("AccountCr_ID");
        BigDecimal Amt = (BigDecimal)mTab.getValue("Amount");
        BigDecimal AmtConv = (BigDecimal)mTab.getValue("AmountConv");
        if (Amt == null) {
            Amt = Env.ZERO;
        }
        if (AmtConv == null) {
            AmtConv = Env.ZERO;
        }
        if (Acc_id != null && Acc_id > 0 && mTab.getValue("AccountCr_ID") != null) {
            String sColumnName = mField.getColumnName();
            if (sColumnName.equals("AmountConv")) {
                mTab.setValue("AmtAcctCr", (Object)AmtConv);
            } else if (sColumnName.equals("Amount")) {
                mTab.setValue("AmtSourceCr", (Object)Amt);
            } else {
                mTab.setValue("AmtAcctCr", (Object)AmtConv);
                mTab.setValue("AmtSourceCr", (Object)Amt);
            }
            String tipoconto = DB.getSQLValueString(null, "SELECT ACCOUNTTYPE FROM C_ELEMENTVALUE EV WHERE EV.C_ELEMENTVALUE_ID=?", Acc_id);
            mTab.setValue("AccountTypeCr", (Object)tipoconto);
        } else {
            mTab.setValue("AmtAcctCr", (Object)Env.ZERO);
            mTab.setValue("AmtSourceCr", (Object)Env.ZERO);
        }
        return "";
    }

    public String AmountDR(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer Acc_id = (Integer)mTab.getValue("AccountDr_ID");
        BigDecimal Amt = (BigDecimal)mTab.getValue("Amount");
        BigDecimal AmtConv = (BigDecimal)mTab.getValue("AmountConv");
        if (Amt == null) {
            Amt = Env.ZERO;
        }
        if (AmtConv == null) {
            AmtConv = Env.ZERO;
        }
        if (Acc_id != null && Acc_id > 0 && mTab.getValue("AccountDr_ID") != null) {
            String sColumnName = mField.getColumnName();
            if (sColumnName.equals("AmountConv")) {
                mTab.setValue("AmtAcctDr", (Object)AmtConv);
            } else if (sColumnName.equals("Amount")) {
                mTab.setValue("AmtSourceDr", (Object)Amt);
            } else {
                mTab.setValue("AmtAcctDr", (Object)AmtConv);
                mTab.setValue("AmtSourceDr", (Object)Amt);
            }
            String tipoconto = DB.getSQLValueString(null, "SELECT ACCOUNTTYPE FROM C_ELEMENTVALUE EV WHERE EV.C_ELEMENTVALUE_ID=?", Acc_id);
            mTab.setValue("AccountTypeDr", (Object)tipoconto);
        } else {
            mTab.setValue("AmtAcctDr", (Object)Env.ZERO);
            mTab.setValue("AmtSourceDr", (Object)Env.ZERO);
        }
        return "";
    }

    public String AccountCR(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        SetGetModel mJournalLine = SetGetUtil.wrap(mTab);
        String sValue = "N";
        if (!MPNGJournalLine.isConvInput(mJournalLine) && value != null) {
            String sSQL = "select coalesce((select distinct('Y')  from C_ValidCombination vc, C_BP_Customer_Acct bpc  where vc.Account_ID = ?   and (bpc.C_Receivable_Acct = vc.C_ValidCombination_ID OR bpc.C_Receivable_Services_Acct = vc.C_ValidCombination_ID)),'N') AS IsInvEntryCr  from dual";
            sValue = DB.getSQLValueString(null, "select coalesce((select distinct('Y')  from C_ValidCombination vc, C_BP_Customer_Acct bpc  where vc.Account_ID = ?   and (bpc.C_Receivable_Acct = vc.C_ValidCombination_ID OR bpc.C_Receivable_Services_Acct = vc.C_ValidCombination_ID)),'N') AS IsInvEntryCr  from dual", (Integer)value);
        }
        mTab.setValue("IsInvEntryCr", (Object)sValue);
        return "";
    }

    public String AccountDR(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        SetGetModel mJournalLine = SetGetUtil.wrap(mTab);
        String sValue = "N";
        if (!MPNGJournalLine.isConvInput(mJournalLine) && value != null) {
            String sSQL = "SELECT coalesce((select distinct('Y')  FROM C_ValidCombination vc, C_BP_Vendor_Acct bpv  WHERE vc.Account_ID = ?  and (bpv.V_Liability_Acct = vc.C_ValidCombination_ID OR   bpv.V_Liability_Services_Acct = vc.C_ValidCombination_ID)),'N') AS IsInvEntryDr from dual";
            sValue = DB.getSQLValueString(null, "SELECT coalesce((select distinct('Y')  FROM C_ValidCombination vc, C_BP_Vendor_Acct bpv  WHERE vc.Account_ID = ?  and (bpv.V_Liability_Acct = vc.C_ValidCombination_ID OR   bpv.V_Liability_Services_Acct = vc.C_ValidCombination_ID)),'N') AS IsInvEntryDr from dual", (Integer)value);
        }
        mTab.setValue("IsInvEntryDr", (Object)sValue);
        return "";
    }

    public String PaymentTerm(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Integer bp_id = (Integer)mTab.getValue("C_BPartner_ID");
        Integer bpl_id = null;
        if (bp_id == null) {
            return "";
        }
        String sql = "SELECT l.C_BPartner_Location_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID AND l.IsBillTo='Y' AND l.IsActive='Y')  WHERE p.IsActive='Y' AND p.C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, bp_id);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    bpl_id = rs.getInt("C_BPartner_Location_ID");
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "bPartner", e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        mTab.setValue("C_BPartner_Location_ID", (Object)bpl_id);
        Integer jl_id = (Integer)mTab.getValue("PNG_Journal_ID");
        if (jl_id == null) {
            return "";
        }
        String issotrx = DB.getSQLValueString(null, "SELECT issotrx FROM PNG_Journal WHERE PNG_Journal_ID=?", jl_id);
        if (issotrx.equals("Y")) {
            String Payrule = DB.getSQLValueString(null, "SELECT PaymentRule FROM C_BPartner WHERE C_BPartner_ID=?", bp_id);
            mTab.setValue("PaymentRule", (Object)Payrule);
            String PayTerm = DB.getSQLValueString(null, "SELECT C_PaymentTerm_ID FROM C_BPartner WHERE C_BPartner_ID=?", bp_id);
            mTab.setValue("C_PaymentTerm_ID", (Object)PayTerm);
            String SalesRep = DB.getSQLValueString(null, "SELECT SalesRep_ID FROM C_BPartner WHERE C_BPartner_ID=?", bp_id);
            mTab.setValue("SalesRep_ID", (Object)SalesRep);
            String M_PriceList = DB.getSQLValueString(null, "SELECT M_PriceList_ID FROM C_BPartner WHERE C_BPartner_ID=?", bp_id);
            mTab.setValue("M_PriceList_ID", (Object)M_PriceList);
        } else {
            String Payrule = DB.getSQLValueString(null, "SELECT PaymentRulepo FROM C_BPartner WHERE C_BPartner_ID=?", bp_id);
            mTab.setValue("PaymentRule", (Object)Payrule);
            String PayTerm = DB.getSQLValueString(null, "SELECT PO_PaymentTerm_ID FROM C_BPartner WHERE C_BPartner_ID=?", bp_id);
            mTab.setValue("C_PaymentTerm_ID", (Object)PayTerm);
        }
        return "";
    }

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer jl_id1 = (Integer)mTab.getValue("PNG_Journal_ID");
        MPNGJournal jl1 = new MPNGJournal(ctx, jl_id1, null);
        MDocType doc = new MDocType(ctx, jl1.getC_DocType_ID(), null);
        Integer C_DocType_ID = doc.getC_DocType_ID();
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext, d.DocBaseType, s.StartNewYear, s.DateColumn, s.AD_Sequence_ID FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Env.setContext(ctx, WindowNo, "HasCharges", rs.getString(1));
                    if (rs.getString(3).equals("Y")) {
                        if ("Y".equals(rs.getString(6))) {
                            String dateColumn = rs.getString(7);
                            mTab.setValue("DocumentNo", (Object)("<" + MSequence.getPreliminaryNoByYear(mTab, rs.getInt(8), dateColumn, null) + ">"));
                        } else {
                            mTab.setValue("DocumentNo", (Object)("<" + rs.getString(4) + ">"));
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return "";
    }

    public String AccTypeInvoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Integer Acc_id = (Integer)mTab.getValue("Account_ID");
        String tipoconto = DB.getSQLValueString(null, "SELECT ACCOUNTTYPE FROM C_ELEMENTVALUE EV WHERE EV.C_ELEMENTVALUE_ID=?", Acc_id);
        mTab.setValue("AccountType", (Object)tipoconto);
        return "";
    }

    public String vat(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        MBPartner bp = new MBPartner(ctx, (Integer)value, null);
        mTab.setValue("IsSuspendedVAT", bp.get_Value("IsSuspendedVAT"));
        Integer jl_id = (Integer)mTab.getValue("PNG_Journal_ID");
        MPNGJournal jl = new MPNGJournal(ctx, jl_id, null);
        MDocType doc = new MDocType(ctx, jl.getC_DocType_ID(), null);
        String sql = "SELECT coalesce(de.IsIntraVAT,'N') as IsIntraVAT, coalesce(de.IsReverseCharge,'N') as IsReverseCharge FROM C_DocType d  LEFT OUTER JOIN LIT_DocTypeExt de on (d.LIT_DocTypeExt_ID = de.LIT_DocTypeExt_ID) WHERE C_DocType_ID=? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, doc.getC_DocType_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("IsIntraVAT", (Object)rs.getString(1));
                    mTab.setValue("IsReverseCharge", (Object)rs.getString(2));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int C_AcctSchema_ID = Env.getContextAsInt(ctx, WindowNo, "C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get(ctx, C_AcctSchema_ID);
        int StdPrecision = as.getStdPrecision();
        BigDecimal LineNetAmt = (BigDecimal)mTab.getValue("LineNetAmt");
        if (LineNetAmt.scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("amt = LineNetAmt=" + LineNetAmt);
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        MPNGInvoice invoice = new MPNGInvoice(ctx, (Integer)mTab.getValue("PNG_Invoice_ID"), null);
        BigDecimal TaxAmt = Env.ZERO;
        if (mField.getColumnName().equals("TaxAmt")) {
            TaxAmt = (BigDecimal)mTab.getValue("TaxAmt");
        } else {
            Integer taxID = (Integer)mTab.getValue("C_Tax_ID");
            if (taxID != null) {
                int C_Tax_ID = taxID;
                MTax tax = new MTax(ctx, C_Tax_ID, null);
                TaxAmt = tax.calculateTax(LineNetAmt, invoice.isTaxIncluded(), StdPrecision);
                mTab.setValue("TaxAmt", (Object)TaxAmt);
            }
            mTab.setValue("LineTotalAmt", (Object)LineNetAmt.add(TaxAmt));
        }
        return "";
    }

    public String VATLedgerNo(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive() || value == null || value.equals(oldValue)) {
            return "";
        }
        MPNGJournal journal = new MPNGJournal(ctx, (Integer)mTab.getValue("PNG_Journal_ID"), null);
        Integer doc_id = journal.getC_DocType_ID();
        if (doc_id == null || doc_id == 0) {
            return "";
        }
        String sql = "SELECT coalesce(vl.DocNoSequence_ID,0) as VatNoSeq_ID, s.DateColumn FROM C_DocType d  LEFT OUTER JOIN LIT_DocTypeExt de on (d.LIT_DocTypeExt_ID = de.LIT_DocTypeExt_ID) LEFT OUTER JOIN LIT_VatLedgerDef vl on (vl.LIT_VatLedgerDef_ID = de.LIT_VatLedgerDef_ID) LEFT OUTER JOIN AD_Sequence s on (vl.DocNoSequence_ID = s.AD_Sequence_ID) WHERE d.C_DocType_ID=? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                int seqID;
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, doc_id);
                rs = pstmt.executeQuery();
                if (rs.next() && (seqID = rs.getInt(1)) > 0) {
                    String dateColumn = rs.getString(2);
                    mTab.setValue("VATLedgerNo", (Object)("<" + LIT_Sequence.getPreliminaryNoByYear(mTab, seqID, dateColumn, null) + ">"));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String CopyDiff(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        int PNG_Journal_ID;
        if (value != null && (value.equals("Y") || value.toString().equals("true")) && (PNG_Journal_ID = Env.getContextAsInt(ctx, WindowNo, "PNG_Journal_ID")) > 0) {
            MPNGJournal mJournal = MPNGJournal.get(ctx, PNG_Journal_ID, null);
            BigDecimal bdCredit = mJournal.getTotalCr();
            BigDecimal bdDebit = mJournal.getTotalDr();
            BigDecimal bdDelta = bdDebit.subtract(bdCredit);
            int PNG_JournalLine_ID = Env.getContextAsInt(ctx, WindowNo, "PNG_JournalLine_ID");
            if (PNG_JournalLine_ID > 0) {
                MPNGJournalLine mJLine = MPNGJournalLine.getJournalLine(ctx, PNG_JournalLine_ID, null);
                bdDelta = bdDelta.add(mJLine.getAmtSourceCr()).subtract(mJLine.getAmtSourceDr());
            }
            mTab.setValue("Amount", (Object)bdDelta.abs());
        }
        return "";
    }

    public String amtToConv(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        SetGetModel mJournalLine = SetGetUtil.wrap(mTab);
        if (MPNGJournalLine.isConvInput(mJournalLine)) {
            MPNGJournal mJournal = MPNGJournalLine.getJournal(mJournalLine);
            int iPrecision = MCurrency.getStdPrecision(ctx, mJournal.getC_Currency_ID());
            BigDecimal bdAmt = (BigDecimal)value;
            BigDecimal bdAmtOld = (BigDecimal)oldValue;
            double dDelta = bdAmt.subtract(bdAmtOld).abs().doubleValue();
            if (dDelta > 0.01) {
                BigDecimal bdRate = mJournal.getPNGConversionRate();
                BigDecimal bdConvAmt = bdAmt.divide(bdRate, iPrecision, RoundingMode.HALF_UP);
                mTab.setValue("AmountConv", (Object)bdConvAmt);
            }
        } else {
            BigDecimal bdAmt = (BigDecimal)value;
            mTab.setValue("AmountConv", (Object)bdAmt);
        }
        return "";
    }

    public String convToAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        SetGetModel mJournalLine = SetGetUtil.wrap(mTab);
        if (MPNGJournalLine.isConvInput(mJournalLine)) {
            MPNGJournal mJournal = MPNGJournalLine.getJournal(mJournalLine);
            int iPrecision = MCurrency.getStdPrecision(ctx, mJournal.getC_Currency_ID());
            BigDecimal bdConvAmt = (BigDecimal)value;
            BigDecimal bdConvAmtOld = (BigDecimal)oldValue;
            double dDelta = bdConvAmt.subtract(bdConvAmtOld).abs().doubleValue();
            if (dDelta > 0.01) {
                BigDecimal bdRate = mJournal.getPNGConversionRate();
                BigDecimal bdAmt = bdConvAmt.multiply(bdRate).setScale(iPrecision, RoundingMode.HALF_UP);
                mTab.setValue("Amount", (Object)bdAmt);
            }
        } else {
            BigDecimal bdConvAmt = (BigDecimal)value;
            mTab.setValue("Amount", (Object)bdConvAmt);
        }
        return "";
    }

    public String currency(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Object oIsConvInput = mTab.getValue("ISConvInput");
        BigDecimal bdRate = Env.ZERO;
        if (oIsConvInput != null && (oIsConvInput.toString().equals("Y") || oIsConvInput.toString().equals("true"))) {
            bdRate = CalloutPNGJournal.getConversionRate(SetGetUtil.wrap(mTab));
        }
        mTab.setValue("PNGConversionRate", (Object)bdRate);
        mTab.setValue("CurrencyRate", (Object)bdRate);
        return "";
    }

    public static BigDecimal getConversionRate(SetGetModel model) {
        int C_Currency_ID = SetGetUtil.get_AttrValueAsInt(model, "C_Currency_ID");
        int C_ConversionType_ID = SetGetUtil.get_AttrValueAsInt(model, "C_ConversionType_ID");
        int AD_Client_ID = SetGetUtil.get_AttrValueAsInt(model, "AD_Client_ID");
        int AD_Org_ID = SetGetUtil.get_AttrValueAsInt(model, "AD_Org_ID");
        int C_AcctSchema_ID = SetGetUtil.get_AttrValueAsInt(model, "C_AcctSchema_ID");
        MAcctSchema mSchema = MAcctSchema.get(model.getCtx(), C_AcctSchema_ID);
        Timestamp tsDate = SetGetUtil.get_AttrValueAsDate(model, "DateAcct");
        BigDecimal bdRate = MConversionRate.getRate(mSchema.getC_Currency_ID(), C_Currency_ID, tsDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
        return bdRate;
    }
}

