/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigInteger;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccount;

public class CalloutBankAccount
extends CalloutEngine {
    public String bankAccount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int C_BankAccount_ID = (Integer)value;
        MBankAccount ba = MBankAccount.get(ctx, C_BankAccount_ID);
        mTab.setValue("BeginningBalance", (Object)ba.getCurrentBalance());
        return "";
    }

    public String iban(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || value.toString().length() < 5) {
            return "";
        }
        String iban = value.toString();
        int validIBANLength = this.getValidIBANLength(iban);
        if (iban.length() < validIBANLength) {
            return "";
        }
        if (validIBANLength == -1) {
            return "Codice Nazione non trovato";
        }
        if (iban.length() > validIBANLength) {
            return "Il codice iban \u00c3\u00a8 troppo lungo.";
        }
        if (!CalloutBankAccount.isCheckDigitValid((String)value)) {
            return "Codice Iban errato.";
        }
        return "";
    }

    public static boolean isCheckDigitValid(String iban) {
        BigInteger numericIBAN = CalloutBankAccount.getNumericIBAN(iban, false);
        int checkDigit = numericIBAN.mod(new BigInteger("97")).intValue();
        return checkDigit == 1;
    }

    public int getValidIBANLength(String countryCode) {
        String length = null;
        try {
            COUNTRY miao = COUNTRY.valueOf(COUNTRY.class, countryCode.substring(0, 2).toUpperCase());
            switch (miao) {
                case AD: {
                    length = "24";
                    break;
                }
                case AT: {
                    length = "20";
                    break;
                }
                case IT: {
                    length = "27";
                    break;
                }
                case IS: {
                    length = "26";
                    break;
                }
                case BE: {
                    length = "16";
                    break;
                }
                case BA: {
                    length = "20";
                    break;
                }
                case BG: {
                    length = "22";
                    break;
                }
                case CY: {
                    length = "28";
                    break;
                }
                case CZ: {
                    length = "24";
                    break;
                }
                case DE: {
                    length = "22";
                    break;
                }
                case DK: {
                    length = "18";
                    break;
                }
                case EE: {
                    length = "20";
                    break;
                }
                case ES: {
                    length = "24";
                    break;
                }
                case FO: {
                    length = "18";
                    break;
                }
                case FI: {
                    length = "18";
                    break;
                }
                case FR: {
                    length = "27";
                    break;
                }
                case GB: {
                    length = "22";
                    break;
                }
                case GI: {
                    length = "23";
                    break;
                }
                case GL: {
                    length = "18";
                    break;
                }
                case GR: {
                    length = "27";
                    break;
                }
                case HU: {
                    length = "28";
                    break;
                }
                case HR: {
                    length = "21";
                    break;
                }
                case LU: {
                    length = "20";
                    break;
                }
                case LT: {
                    length = "20";
                    break;
                }
                case IE: {
                    length = "22";
                    break;
                }
                case LI: {
                    length = "21";
                    break;
                }
                case LV: {
                    length = "21";
                    break;
                }
                case MA: {
                    length = "24";
                    break;
                }
                case MC: {
                    length = "27";
                    break;
                }
                case MK: {
                    length = "19";
                    break;
                }
                case MT: {
                    length = "31";
                    break;
                }
                case NL: {
                    length = "18";
                    break;
                }
                case NO: {
                    length = "15";
                    break;
                }
                case PL: {
                    length = "28";
                    break;
                }
                case PT: {
                    length = "25";
                    break;
                }
                case RO: {
                    length = "24";
                    break;
                }
                case CH: {
                    length = "21";
                    break;
                }
                case RS: {
                    length = "22";
                    break;
                }
                case SE: {
                    length = "24";
                    break;
                }
                case SI: {
                    length = "19";
                    break;
                }
                case SK: {
                    length = "24";
                    break;
                }
                case SM: {
                    length = "27";
                    break;
                }
                case TN: {
                    length = "24";
                    break;
                }
                case TR: {
                    length = "26";
                }
            }
            if (length == null) {
                return -1;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "IBAN: ", e);
            return -1;
        }
        return Integer.valueOf(length);
    }

    private static BigInteger getNumericIBAN(String iban, boolean isCheckDigitAtEnd) {
        String endCheckDigitIBAN = iban;
        if (!isCheckDigitAtEnd) {
            endCheckDigitIBAN = String.valueOf(iban.substring(4)) + iban.substring(0, 4);
        }
        StringBuffer numericIBAN = new StringBuffer();
        int i = 0;
        while (i < endCheckDigitIBAN.length()) {
            if (Character.isDigit(endCheckDigitIBAN.charAt(i))) {
                numericIBAN.append(endCheckDigitIBAN.charAt(i));
            } else {
                numericIBAN.append(10 + CalloutBankAccount.getAlphabetPosition(endCheckDigitIBAN.charAt(i)));
            }
            ++i;
        }
        return new BigInteger(numericIBAN.toString());
    }

    private static int getAlphabetPosition(char letter) {
        return Character.valueOf(Character.toUpperCase(letter)).compareTo(Character.valueOf('A'));
    }

    public static enum COUNTRY {
        AD,
        AT,
        IT,
        IS,
        BE,
        BA,
        BG,
        CH,
        CY,
        CZ,
        DE,
        DK,
        EE,
        ES,
        FO,
        FI,
        FR,
        GB,
        GI,
        GL,
        GR,
        HU,
        HR,
        IE,
        LI,
        LT,
        LU,
        LV,
        MA,
        MC,
        MK,
        MT,
        NL,
        NO,
        PL,
        PT,
        RO,
        RS,
        SE,
        SI,
        SK,
        SM,
        TN,
        TR;

    }
}

