/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.Adempiere;
import org.compiere.install.TranslationHandler;
import org.compiere.model.MLanguage;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class Translation {
    public static final String DTD = "<!DOCTYPE adempiereTrl PUBLIC \"-//ComPiere, Inc.//DTD Adempiere Translation 1.0//EN\" \"http://www.adempiere.com/dtd/adempiereTrl.dtd\">";
    public static final String XML_TAG = "adempiereTrl";
    public static final String XML_TAG2 = "compiereTrl";
    public static final String XML_ATTRIBUTE_TABLE = "table";
    public static final String XML_ATTRIBUTE_LANGUAGE = "language";
    public static final String XML_ROW_TAG = "row";
    public static final String XML_ROW_ATTRIBUTE_ID = "id";
    public static final String XML_ROW_ATTRIBUTE_TRANSLATED = "trl";
    public static final String XML_VALUE_TAG = "value";
    public static final String XML_VALUE_ATTRIBUTE_COLUMN = "column";
    public static final String XML_VALUE_ATTRIBUTE_ORIGINAL = "original";
    private boolean m_IsCentrallyMaintained = false;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx = null;

    public Translation(Properties ctx) {
        this.m_ctx = ctx;
    }

    public String importTrl(String directory, int AD_Client_ID, String AD_Language, String Trl_Table) {
        String fileName = directory + File.separator + Trl_Table + "_" + AD_Language + ".xml";
        this.log.info(fileName);
        File in = new File(fileName);
        if (!in.exists()) {
            String msg = "File does not exist: " + fileName;
            this.log.log(Level.SEVERE, msg);
            return msg;
        }
        try {
            TranslationHandler handler = new TranslationHandler(AD_Client_ID);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)handler);
            this.log.info("Updated=" + handler.getUpdateCount());
            return Msg.getMsg(this.m_ctx, "Updated") + "=" + handler.getUpdateCount();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "importTrl", e);
            return e.toString();
        }
    }

    public String exportTrl(String directory, int AD_Client_ID, String AD_Language, String Trl_Table) {
        String fileName = directory + File.separator + Trl_Table + "_" + AD_Language + ".xml";
        this.log.info(fileName);
        File out = new File(fileName);
        boolean isBaseLanguage = Language.isBaseLanguage(AD_Language);
        String tableName = Trl_Table;
        int pos = tableName.indexOf("_Trl");
        String Base_Table = Trl_Table.substring(0, pos);
        if (isBaseLanguage) {
            tableName = Base_Table;
        }
        String keyColumn = Base_Table + "_ID";
        String[] trlColumns = this.getTrlColumns(Base_Table);
        StringBuffer sql = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.appendChild(document.createComment(Adempiere.getSummaryAscii()));
            document.appendChild(document.createComment(DTD));
            Element root = document.createElement(XML_TAG);
            root.setAttribute(XML_ATTRIBUTE_LANGUAGE, AD_Language);
            root.setAttribute(XML_ATTRIBUTE_TABLE, Base_Table);
            document.appendChild(root);
            sql = new StringBuffer("SELECT ");
            if (isBaseLanguage) {
                sql.append("'Y',");
            } else {
                sql.append("t.IsTranslated,");
            }
            sql.append("t.").append(keyColumn);
            for (int i = 0; i < trlColumns.length; ++i) {
                sql.append(", t.").append(trlColumns[i]).append(",o.").append(trlColumns[i]).append(" AS ").append(trlColumns[i]).append("O");
            }
            sql.append(" FROM ").append(tableName).append(" t").append(" INNER JOIN ").append(Base_Table).append(" o ON (t.").append(keyColumn).append("=o.").append(keyColumn).append(")");
            boolean haveWhere = false;
            if (!isBaseLanguage) {
                sql.append(" WHERE t.AD_Language=?");
                haveWhere = true;
            }
            if (this.m_IsCentrallyMaintained) {
                sql.append(haveWhere ? " AND " : " WHERE ").append("o.IsCentrallyMaintained='N'");
                haveWhere = true;
            }
            if (AD_Client_ID >= 0) {
                sql.append(haveWhere ? " AND " : " WHERE ").append("o.AD_Client_ID=").append(AD_Client_ID);
            }
            sql.append(" ORDER BY t.").append(keyColumn);
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            if (!isBaseLanguage) {
                pstmt.setString(1, AD_Language);
            }
            ResultSet rs = pstmt.executeQuery();
            int rows = 0;
            while (rs.next()) {
                Element row = document.createElement(XML_ROW_TAG);
                row.setAttribute(XML_ROW_ATTRIBUTE_ID, String.valueOf(rs.getInt(2)));
                row.setAttribute(XML_ROW_ATTRIBUTE_TRANSLATED, rs.getString(1));
                for (int i = 0; i < trlColumns.length; ++i) {
                    String valueString;
                    Element value = document.createElement(XML_VALUE_TAG);
                    value.setAttribute(XML_VALUE_ATTRIBUTE_COLUMN, trlColumns[i]);
                    String origString = rs.getString(trlColumns[i] + "O");
                    if (origString == null) {
                        origString = "";
                    }
                    if ((valueString = rs.getString(trlColumns[i])) == null) {
                        valueString = "";
                    }
                    value.setAttribute(XML_VALUE_ATTRIBUTE_ORIGINAL, origString);
                    if (valueString.indexOf("<") != -1 || valueString.indexOf(">") != -1 || valueString.indexOf("&") != -1) {
                        value.appendChild(document.createCDATASection(valueString));
                    } else {
                        value.appendChild(document.createTextNode(valueString));
                    }
                    row.appendChild(value);
                }
                root.appendChild(row);
                ++rows;
            }
            rs.close();
            pstmt.close();
            this.log.info("Records=" + rows + ", DTD=" + document.getDoctype() + " - " + Trl_Table);
            DOMSource source = new DOMSource(document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setAttribute("indent-number", 1);
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            out.createNewFile();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "utf-8");
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            ((Writer)writer).close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
            return e.toString();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            return e.toString();
        }
        return "";
    }

    private String[] getTrlColumns(String Base_Table) {
        this.m_IsCentrallyMaintained = false;
        String sql = "SELECT TableName FROM AD_Table t INNER JOIN AD_Column c ON (c.AD_Table_ID=t.AD_Table_ID AND c.ColumnName='IsCentrallyMaintained') WHERE t.TableName=? AND c.IsActive='Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, Base_Table);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_IsCentrallyMaintained = true;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        sql = "SELECT ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=? AND c.AD_Reference_ID IN (10,14) ORDER BY IsMandatory DESC, ColumnName";
        ArrayList<String> list = new ArrayList<String>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, Base_Table + "_Trl");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String s = rs.getString(1);
                list.add(s);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String validateLanguage(String AD_Language) {
        String sql = "SELECT * FROM AD_Language WHERE AD_Language=?";
        MLanguage language = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, AD_Language);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                language = new MLanguage(this.m_ctx, rs, null);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return e.toString();
        }
        if (language == null) {
            this.log.log(Level.SEVERE, "Language does not exist: " + AD_Language);
            return "Language does not exist: " + AD_Language;
        }
        if (language.isActive()) {
            if (language.isBaseLanguage()) {
                return "";
            }
        } else {
            this.log.log(Level.SEVERE, "Language not active or not system language: " + AD_Language);
            return "Language not active or not system language: " + AD_Language;
        }
        this.log.info("Start Validating ... " + language);
        language.maintain(true);
        return "";
    }

    private void process(String directory, String AD_Language, String mode) {
        String sql = "SELECT Name, TableName FROM AD_Table WHERE TableName LIKE '%_Trl' ORDER BY Name";
        ArrayList<String> trlTables = new ArrayList<String>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                trlTables.add(rs.getString(2));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        for (int i = 0; i < trlTables.size(); ++i) {
            String table2 = (String)trlTables.get(i);
            File dir = new File(directory);
            if (mode.equals("import")) {
                if (!dir.exists() || !dir.isDirectory()) {
                    System.out.println("The language cannot be imported from " + directory + " as this directory does not exist.");
                    System.exit(1);
                }
                this.importTrl(directory, -1, AD_Language, table2);
                continue;
            }
            if (mode.equals("export")) {
                if (!dir.exists()) {
                    dir.mkdir();
                }
                if (!(dir = new File(directory)).exists()) {
                    System.out.println("Cannot create directory " + directory + " to export the language to it.");
                    System.exit(1);
                }
                this.exportTrl(directory, -1, AD_Language, table2);
                continue;
            }
            System.out.println("Just import and export are supported as modes.");
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("format : java Translation directory AD_Language import|export");
            System.out.println("example: java Translation /Adempiere/data/de_DE de_DE import");
            System.out.println("example: java Translation /Adempiere/data/fr_FR fr_FR export");
            System.exit(1);
        }
        Login.initTest(false);
        String directory = args[0];
        String AD_Language = args[1];
        String mode = args[2];
        Translation trl = new Translation(Env.getCtx());
        String msg = trl.validateLanguage(AD_Language);
        if (msg.length() > 0) {
            System.err.println(msg);
        } else {
            trl.process(directory, AD_Language, mode);
        }
        System.exit(0);
    }
}

