/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import com.f3p.adempiere.grid.ed.VAbstract;
import com.f3p.adempiere.rma.model.F3PMRmaLine;
import com.f3p.adempiere.rma.model.MRMALine;
import com.f3p.adempiere.util.IDResolver;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.logging.Level;
import javax.swing.JComboBox;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridField;
import org.compiere.model.MAsset;
import org.compiere.model.MInOut;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRMA;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.swing.CComboBox;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VMRMA
extends VAbstract
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String SQL_DOC_TYPE = "SELECT C_DocType_ID, Name FROM C_DocType WHERE C_DocType.ISACTIVE='Y' AND DocBaseType='SOO' AND DocSubTypeSO='RM'";
    private static final String SQL_SALES_REP = "SELECT AD_User_ID, Name FROM AD_User WHERE EXISTS (SELECT * FROM C_BPartner bp WHERE AD_User.C_BPartner_ID=bp.C_BPartner_ID AND bp.IsSalesRep='Y')";
    private static final String SQL_MINOUTLINE = "SELECT M_INOUTLINE_ID FROM M_INOUTLINE WHERE ISACTIVE = 'Y' AND M_INOUT_ID = ? AND M_PRODUCT_ID = ?";
    private static final String MSG_RMA_NAME = "F3P_RMA_Name";
    private MRMA m_rma = null;
    private static CLogger log = CLogger.getCLogger(VMRMA.class);
    private VLookup m_fBPartner;
    private VLookup m_fRMAType;
    private VLookup m_fInOut;
    private VLookup m_fProduct;
    private VLookup m_fAsset;
    private JComboBox m_fDocType;
    private JComboBox m_fSalesRep;
    private Object[] m_oDocTypeTarget;
    private Object[] m_oSalesRep;

    public VMRMA(Frame frame, GridField gridField, VLookup parentLookup, int WindowNo) {
        super(frame, Msg.translate(Env.getCtx(), "M_RMA_ID"), true);
        this.m_WindowNo = WindowNo;
        this.m_gridField = gridField;
        this.m_parentLookup = parentLookup;
        this.m_readOnly = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MRMA.Table_ID, 0, false);
        log.info("R/O=" + this.m_readOnly);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.initMRMA();
        AEnv.positionCenterWindow(frame, this);
    }

    private void initMRMA() {
        this.dynInit();
        this.m_oDocTypeTarget = this.getDocType();
        this.m_fDocType = new CComboBox(this.m_oDocTypeTarget);
        this.m_fDocType.setSelectedIndex(0);
        this.createLine(this.m_fDocType, "C_DocType_ID", true, true);
        MLookup lookupRMAType = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, IDResolver.getAD_Column_ID("M_RMAType", "M_RMAType_ID"), 19);
        this.m_fRMAType = new VLookup("M_RMAType_ID", true, false, true, lookupRMAType);
        this.createLine(this.m_fRMAType, "M_RMAType_ID", true, true);
        MInOut mInOut = null;
        int M_InOut_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_InOut_ID");
        MLookup lookupInOut = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, IDResolver.getAD_Column_ID("M_InOut", "M_InOut_ID"), 30);
        this.m_fInOut = new VLookup("M_InOut_ID", false, false, true, lookupInOut);
        if (M_InOut_ID != 0 && (mInOut = new MInOut(Env.getCtx(), M_InOut_ID, null)).isSOTrx()) {
            this.m_fInOut.setValue(M_InOut_ID);
        }
        this.createLine(this.m_fInOut, "M_InOut_ID", true, true);
        int C_BPartner_ID = 0;
        if (mInOut != null) {
            C_BPartner_ID = mInOut.getC_BPartner_ID();
        }
        if (C_BPartner_ID < 1) {
            C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_BPartner_ID");
        }
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, IDResolver.getAD_Column_ID("C_BPartner", "C_BPartner_ID"), 30);
        this.m_fBPartner = new VLookup("C_BPartner_ID", true, false, true, lookupBP);
        if (C_BPartner_ID != 0) {
            this.m_fBPartner.setValue(C_BPartner_ID);
        }
        this.createLine(this.m_fBPartner, "C_BPartner_ID", true, true);
        int SalesRep_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "SalesRep_ID");
        this.m_oSalesRep = this.getSalesRep();
        this.m_fSalesRep = new CComboBox(this.m_oSalesRep);
        if (SalesRep_ID != 0 && SalesRep_ID != 100) {
            this.m_fSalesRep.setSelectedItem(new KeyNamePair(SalesRep_ID, MUser.getNameOfUser(SalesRep_ID)));
        }
        this.createLine(this.m_fSalesRep, "SalesRep_ID", true, true);
        int M_Product_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_Product_ID");
        MLookup lookupProduct = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, IDResolver.getAD_Column_ID("M_Product", "M_Product_ID"), 30);
        this.m_fProduct = new VLookup("M_Product_ID", false, false, true, lookupProduct);
        if (M_Product_ID != 0) {
            this.m_fProduct.setValue(M_Product_ID);
        }
        this.createLine(this.m_fProduct, "M_Product_ID", true, true);
        int A_Asset_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "A_Asset_ID");
        MLookup lookupAsset = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, IDResolver.getAD_Column_ID("A_Asset", "A_Asset_ID"), 30);
        this.m_fAsset = new VLookup("A_Asset_ID", false, false, true, lookupAsset);
        if (A_Asset_ID != 0) {
            this.m_fAsset.setValue(A_Asset_ID);
        }
        this.createLine(this.m_fAsset, "A_Asset_ID", true, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_readOnly) {
            this.dispose();
        } else if (e.getActionCommand().equals("Ok")) {
            try {
                if (this.actionSave()) {
                    this.dispose();
                    this.m_parentLookup.requestFocus();
                    this.m_parentLookup.setValue(this.m_rma.getM_RMA_ID());
                    this.m_parentLookup.actionZoom(null);
                }
            }
            catch (Exception ex) {
                ADialog.error(this.m_WindowNo, this, ex.getMessage());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private boolean actionSave() {
        boolean bSuccess;
        log.config("");
        boolean bMandatory = true;
        if (this.m_fRMAType.getValue() == null) {
            this.m_fRMAType.setBackground(AdempierePLAF.getFieldBackground_Error());
            bMandatory = false;
        }
        if (this.m_fBPartner.getValue() == null && this.m_fInOut.getValue() == null) {
            this.m_fBPartner.setBackground(AdempierePLAF.getFieldBackground_Error());
            bMandatory = false;
        }
        if (!bMandatory) {
            return bMandatory;
        }
        this.m_rma = new MRMA(Env.getCtx(), 0, null);
        this.m_rma.setC_BPartner_ID(((Number)this.m_fBPartner.getValue()).intValue());
        String sName = String.valueOf(Msg.getMsg(Env.getCtx(), MSG_RMA_NAME)) + " " + Env.getContext(Env.getCtx(), this.m_WindowNo, 0, "_TabInfo_Name", true) + " " + Env.getContext(Env.getCtx(), this.m_WindowNo, 0, "DocumentNo", true);
        this.m_rma.setName(sName);
        String sDesc = (String)this.m_gridField.getGridTab().getValue("Summary");
        if (sDesc == null) {
            sDesc = this.m_gridField.getGridTab().getDescription();
        }
        if (sDesc != null) {
            this.m_rma.setDescription(sDesc);
        }
        this.m_rma.setC_DocType_ID(((KeyNamePair)this.m_fDocType.getSelectedItem()).getKey());
        this.m_rma.setM_RMAType_ID(((Number)this.m_fRMAType.getValue()).intValue());
        this.m_rma.setSalesRep_ID(((KeyNamePair)this.m_fSalesRep.getSelectedItem()).getKey());
        this.m_rma.setIsSOTrx(true);
        if (this.m_fInOut.getValue() != null) {
            this.m_rma.setM_InOut_ID(((Number)this.m_fInOut.getValue()).intValue());
        }
        if ((bSuccess = this.m_rma.save()) && (this.m_fAsset.getValue() != null || this.m_fProduct.getValue() != null)) {
            MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, null);
            if (this.m_fAsset.getValue() != null) {
                int A_Asset_ID = ((Number)this.m_fAsset.getValue()).intValue();
                MAsset asset = new MAsset(Env.getCtx(), A_Asset_ID, null);
                F3PMRmaLine.setA_Asset_ID(rmaLine, asset.getA_Asset_ID());
            } else if (this.m_fProduct.getValue() != null) {
                int M_InOutLine_ID;
                int M_Product_ID = ((Number)this.m_fProduct.getValue()).intValue();
                int M_InOut_ID = this.m_fInOut.getValue() == null ? 0 : ((Number)this.m_fInOut.getValue()).intValue();
                boolean bLineCreated = false;
                if (M_InOut_ID != 0 && (M_InOutLine_ID = DB.getSQLValue(null, SQL_MINOUTLINE, M_InOut_ID, M_Product_ID)) > 0) {
                    rmaLine.setM_InOutLine_ID(M_InOutLine_ID);
                    bLineCreated = true;
                }
                if (!bLineCreated) {
                    F3PMRmaLine.setM_Product_ID(rmaLine, M_Product_ID);
                }
            }
            rmaLine.setM_RMA_ID(this.m_rma.getM_RMA_ID());
            rmaLine.setLine(10);
            rmaLine.setQtyDelivered(BigDecimal.ZERO);
            bSuccess = rmaLine.save();
        }
        return bSuccess;
    }

    protected Object[] getDocType() {
        String sql = MRole.getDefault().addAccessSQL(SQL_DOC_TYPE, "C_DocType", false, false);
        return DB.getKeyNamePairs(sql, false);
    }

    protected Object[] getSalesRep() {
        String sql = MRole.getDefault().addAccessSQL(SQL_SALES_REP, "AD_User", false, false);
        return DB.getKeyNamePairs(sql, false);
    }

    public int getM_RMA_ID() {
        if (this.m_rma == null) {
            return 0;
        }
        return this.m_rma.getM_RMA_ID();
    }
}

