/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import com.f3p.adempiere.grid.ed.LookupActionFactory;
import com.f3p.adempiere.grid.ed.LookupActionItem;
import com.f3p.adempiere.grid.ed.LookupActionUI;
import com.f3p.adempiere.util.GridFieldInfoFactory;
import com.f3p.adempiere.util.InfoFactoryRegistry;
import com.f3p.adempiere.util.ModelFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.InfoBPartner;
import org.compiere.apps.search.InfoFactory;
import org.compiere.apps.search.InfoProduct;
import org.compiere.grid.ed.AutoCompletion;
import org.compiere.grid.ed.VBPartner;
import org.compiere.grid.ed.VCOrder;
import org.compiere.grid.ed.VCOrderCopy;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VMRMA;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPrice;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.I_PP_Product_BOMLine;

public class VLookup
extends JComponent
implements VEditor,
ActionListener,
FocusListener {
    private static final long serialVersionUID = -104909868954609498L;
    public static String MSG_COPY_ORDER = "F3P_Copy_Order";
    public static final int DISPLAY_LENGTH = 15;
    public static int FIELD_HIGHT = 0;
    private CTextField m_text = new CTextField(15);
    private CButton m_button = new CButton();
    protected VComboBox m_combo = new VComboBox();
    private volatile boolean m_settingValue = false;
    private volatile boolean m_settingFocus = false;
    private volatile boolean m_haveFocus = false;
    private volatile boolean m_inserting = false;
    private String m_lastDisplay = "";
    private String m_columnName;
    private Lookup m_lookup;
    private boolean m_comboActive = true;
    private Object m_value;
    private boolean m_stopediting = false;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mZoom;
    private CMenuItem mRefresh;
    private CMenuItem mBPartnerNew;
    private CMenuItem mBPartnerUpd;
    private CMenuItem m_COrderNew;
    private CMenuItem m_COrderCopy;
    private CMenuItem m_MRMANew;
    private VLookup_mouseAdapter mouseAdapter;
    private GridField m_mField = null;
    private static CLogger log = CLogger.getCLogger(VLookup.class);
    private String m_tableName = null;
    private String m_keyColumnName = null;

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getSource() == this.m_combo || e.getSource() == this.m_text || e.getSource() == this) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        JComponent editorComp = null;
        editorComp = this.m_lookup != null && this.m_lookup.getDisplayType() != 30 ? this.m_combo : this.m_text;
        InputMap map = editorComp.getInputMap(condition);
        ActionMap am = editorComp.getActionMap();
        if (map != null && am != null && this.isEnabled()) {
            Action action;
            Object binding = map.get(ks);
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                return SwingUtilities.notifyAction(action, ks, e, editorComp, e.getModifiers());
            }
        }
        return false;
    }

    public static VLookup createBPartner(int WindowNo) {
        int AD_Column_ID = 3499;
        try {
            MLookup lookup = MLookupFactory.get(Env.getCtx(), WindowNo, 0, AD_Column_ID, 30);
            return new VLookup("C_BPartner_ID", false, false, true, lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public static VLookup createProduct(int WindowNo) {
        int AD_Column_ID = 3840;
        try {
            MLookup lookup = MLookupFactory.get(Env.getCtx(), WindowNo, 0, AD_Column_ID, 30);
            return new VLookup("M_Product_ID", false, false, true, lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public static VLookup createUser(int WindowNo) {
        int AD_Column_ID = 10443;
        try {
            MLookup lookup = MLookupFactory.get(Env.getCtx(), WindowNo, 0, AD_Column_ID, 30);
            return new VLookup("AD_User_ID", false, false, true, lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public VLookup(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        super.setName(columnName);
        this.m_combo.setName(columnName);
        this.m_columnName = columnName;
        this.setMandatory(mandatory);
        this.m_lookup = lookup;
        if (this.m_lookup != null) {
            this.m_lookup.setMandatory(mandatory);
        }
        this.setLayout(new BorderLayout());
        this.mouseAdapter = new VLookup_mouseAdapter(this);
        this.m_text.addActionListener(this);
        this.m_text.addFocusListener(this);
        this.m_text.addMouseListener(this.mouseAdapter);
        this.m_button.addActionListener(this);
        this.m_button.addMouseListener(this.mouseAdapter);
        this.m_button.setFocusable(false);
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        if (columnName.equals("C_BPartner_ID")) {
            this.m_button.setIcon(Env.getImageIcon("BPartner10.gif"));
        } else if (columnName.equals("M_Product_ID")) {
            this.m_button.setIcon(Env.getImageIcon("Product10.gif"));
        } else {
            this.m_button.setIcon(Env.getImageIcon("PickOpen10.gif"));
        }
        if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            if (!isReadOnly && isUpdateable) {
                this.m_lookup.fillComboBox(this.isMandatory(), true, true, false);
            }
            this.m_combo.setModel(this.m_lookup);
            AutoCompletion.enable(this.m_combo);
            this.m_combo.addActionListener(this);
            this.m_combo.getEditor().getEditorComponent().addMouseListener(this.mouseAdapter);
            this.m_combo.addFocusListener(this);
            this.m_combo.getEditor().getEditorComponent().addFocusListener(this);
        }
        this.setUI(true);
        if (isReadOnly || !isUpdateable || this.m_lookup == null) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        if (this.m_lookup != null) {
            if (this.m_lookup.getDisplayType() == 17 && Env.getContextAsInt(Env.getCtx(), "#AD_Role_ID") == 0 || this.m_lookup.getDisplayType() != 17) {
                this.mZoom = new CMenuItem(Msg.getMsg(Env.getCtx(), "Zoom"), Env.getImageIcon("Zoom16.gif"));
                this.mZoom.addActionListener(this);
                this.popupMenu.add(this.mZoom);
            }
            this.mRefresh = new CMenuItem(Msg.getMsg(Env.getCtx(), "Refresh"), Env.getImageIcon("Refresh16.gif"));
            this.mRefresh.addActionListener(this);
            this.popupMenu.add(this.mRefresh);
        }
        if (columnName.equals("C_BPartner_ID")) {
            this.mBPartnerNew = new CMenuItem(Msg.getMsg(Env.getCtx(), "New"), Env.getImageIcon("InfoBPartner16.gif"));
            this.mBPartnerNew.addActionListener(this);
            this.mBPartnerNew.setVisible(this.isReadWrite());
            this.popupMenu.add(this.mBPartnerNew);
            this.mBPartnerUpd = new CMenuItem(Msg.getMsg(Env.getCtx(), "Update"), Env.getImageIcon("InfoBPartner16.gif"));
            this.mBPartnerUpd.addActionListener(this);
            this.popupMenu.add(this.mBPartnerUpd);
        } else if (columnName.equals("C_Order_ID")) {
            this.m_COrderNew = new CMenuItem(Msg.getMsg(Env.getCtx(), "New"), Env.getImageIcon("InfoBPartner16.gif"));
            this.m_COrderNew.addActionListener(this);
            this.m_COrderNew.setVisible(this.isReadWrite());
            this.popupMenu.add(this.m_COrderNew);
            this.m_COrderCopy = new CMenuItem(Msg.getMsg(Env.getCtx(), MSG_COPY_ORDER), Env.getImageIcon("Copy16.gif"));
            this.m_COrderCopy.addActionListener(this);
            this.m_COrderCopy.setVisible(this.isReadWrite());
            this.popupMenu.add(this.m_COrderCopy);
        } else if (columnName.equals("M_RMA_ID")) {
            this.m_MRMANew = new CMenuItem(Msg.getMsg(Env.getCtx(), "New"), Env.getImageIcon("InfoBPartner16.gif"));
            this.m_MRMANew.addActionListener(this);
            this.m_MRMANew.setVisible(this.isReadWrite());
            this.popupMenu.add(this.m_MRMANew);
        }
        for (LookupActionUI al : LookupActionFactory.getAllActions(VLookup.class.getClassLoader())) {
            if (!al.isAvailableFor(this.m_columnName)) continue;
            LookupActionItem item = al.getMenuItem();
            item.addActionListener(this);
            this.popupMenu.add(item);
        }
        if (this.m_lookup != null && this.m_lookup.getZoom() == 0) {
            this.mZoom.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_lookup = null;
        this.m_mField = null;
        this.m_combo.getEditor().getEditorComponent().removeFocusListener(this);
        this.m_combo.getEditor().getEditorComponent().removeMouseListener(this.mouseAdapter);
        this.m_combo.removeFocusListener(this);
        this.m_combo.removeActionListener(this);
        this.m_combo.setModel(new DefaultComboBoxModel());
        this.m_combo = null;
    }

    private void setUI(boolean initial) {
        if (initial) {
            Dimension size = this.m_text.getPreferredSize();
            this.setPreferredSize(new Dimension(size));
            this.m_combo.setPreferredSize(new Dimension(size));
            this.setMinimumSize(new Dimension(30, size.height));
            FIELD_HIGHT = size.height;
            this.m_text.setBorder(null);
            Dimension bSize = new Dimension(size.height, size.height);
            this.m_button.setPreferredSize(bSize);
        }
        this.remove(this.m_combo);
        this.remove(this.m_button);
        this.remove(this.m_text);
        if (!this.isReadWrite()) {
            LookAndFeel.installBorder(this, "TextField.border");
            this.add((Component)this.m_text, "Center");
            this.m_text.setReadWrite(false);
            this.m_combo.setReadWrite(false);
            this.m_comboActive = false;
        } else if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            this.setBorder(null);
            this.add((Component)this.m_combo, "Center");
            this.m_comboActive = true;
        } else {
            LookAndFeel.installBorder(this, "TextField.border");
            this.add((Component)this.m_text, "Center");
            this.add((Component)this.m_button, "East");
            this.m_text.setReadWrite(true);
            this.m_comboActive = false;
        }
    }

    @Override
    public void setReadWrite(boolean value) {
        boolean rw = value;
        if (this.m_lookup == null) {
            rw = false;
        }
        if (this.m_combo.isReadWrite() != value) {
            this.m_combo.setReadWrite(rw);
            this.setUI(false);
            if (value && this.m_comboActive) {
                this.m_settingValue = true;
                this.refresh();
                this.m_settingValue = false;
            }
            if (this.m_comboActive) {
                this.setValue(this.m_value);
            }
        }
        if (this.mBPartnerNew != null) {
            this.mBPartnerNew.setVisible(value);
        }
    }

    @Override
    public boolean isReadWrite() {
        return this.m_combo.isReadWrite();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_combo.setMandatory(mandatory);
        this.m_text.setMandatory(mandatory);
    }

    @Override
    public boolean isMandatory() {
        return this.m_combo.isMandatory();
    }

    @Override
    public void setBackground(Color color) {
        this.m_text.setBackground(color);
        this.m_combo.setBackground(color);
    }

    @Override
    public void setBackground(boolean error) {
        this.m_text.setBackground(error);
        this.m_combo.setBackground(error);
    }

    @Override
    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
        this.m_combo.setForeground(fg);
    }

    @Override
    public void requestFocus() {
        if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            this.m_combo.requestFocus();
        } else {
            this.m_text.requestFocus();
        }
    }

    @Override
    public void setValue(Object value) {
        log.fine(String.valueOf(this.m_columnName) + "=" + value);
        this.m_settingValue = true;
        this.m_value = value;
        if (value == null) {
            this.m_combo.setValue(value);
            this.m_text.setText(null);
            this.m_lastDisplay = "";
            this.m_settingValue = false;
            return;
        }
        if (this.m_lookup == null) {
            this.m_combo.setValue(value);
            this.m_text.setText(value.toString());
            this.m_lastDisplay = value.toString();
            this.m_settingValue = false;
            return;
        }
        this.m_lastDisplay = this.m_lookup.getDisplay(value);
        this.m_combo.setValue(value);
        if (this.m_lastDisplay.equals("<-1>")) {
            this.m_lastDisplay = "";
            this.m_value = null;
        }
        boolean notFound = this.m_lastDisplay.startsWith("<") && this.m_lastDisplay.endsWith(">");
        this.m_text.setText(this.m_lastDisplay);
        this.m_text.setCaretPosition(0);
        if (this.m_combo.getSelectedItem() == null && (this.m_comboActive || this.m_inserting && this.m_lookup.getDisplayType() != 30)) {
            NamePair pp;
            if (notFound) {
                log.finest(String.valueOf(this.m_columnName) + "=" + value + ": Not found - " + this.m_lastDisplay);
                this.m_lookup.refresh();
                this.m_combo.setValue(value);
                this.m_lastDisplay = this.m_lookup.getDisplay(value);
                this.m_text.setText(this.m_lastDisplay);
                this.m_text.setCaretPosition(0);
                boolean bl = notFound = this.m_lastDisplay.startsWith("<") && this.m_lastDisplay.endsWith(">");
            }
            if (notFound) {
                this.m_value = null;
                this.actionCombo(null);
                log.fine(String.valueOf(this.m_columnName) + "=" + value + ": Not found");
            } else if (this.m_combo.getSelectedItem() == null && (pp = this.m_lookup.get(value)) != null) {
                log.fine(String.valueOf(this.m_columnName) + " added to combo - " + pp);
                boolean bForceValue = false;
                this.m_lookup.fillComboBox(this.isMandatory(), true, true, false);
                this.m_combo.setValue(value);
                if (this.m_combo.getSelectedItem() == null) {
                    bForceValue = true;
                }
                if (bForceValue) {
                    this.m_combo.addItem(pp);
                    this.m_combo.setValue(value);
                }
            }
            if (this.m_combo.getSelectedItem() == null) {
                log.info(String.valueOf(this.m_columnName) + "=" + value + ": not in Lookup - set to NULL");
                this.actionCombo(null);
                this.m_value = null;
            }
        }
        this.m_settingValue = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.m_stopediting) {
            return;
        }
        if (evt.getPropertyName().equals("FieldValue")) {
            this.m_inserting = "FieldValueInserting".equals(evt.getOldValue());
            this.setValue(evt.getNewValue());
            this.m_inserting = false;
        }
    }

    @Override
    public Object getValue() {
        if (this.m_comboActive) {
            return this.m_combo.getValue();
        }
        return this.m_value;
    }

    @Override
    public String getDisplay() {
        String retValue = null;
        retValue = this.m_comboActive ? this.m_combo.getDisplay() : (this.m_lookup == null ? (this.m_value == null ? null : this.m_value.toString()) : this.m_lookup.getDisplay(this.m_value));
        return retValue;
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null && MRole.getDefault().isShowPreference()) {
            ValuePreference.addMenu(this, this.popupMenu);
        }
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LookupActionItem item;
        Object result;
        boolean bNeedSave;
        if (this.m_settingValue || this.m_settingFocus || this.m_stopediting) {
            return;
        }
        log.config(String.valueOf(this.m_columnName) + " - " + e.getActionCommand() + ", ComboValue=" + this.m_combo.getSelectedItem());
        if (e.getActionCommand().equals("ValuePreference")) {
            if (MRole.getDefault().isShowPreference()) {
                ValuePreference.start(this.m_mField, this.getValue(), this.getDisplay());
            }
            return;
        }
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        if (e.getSource() == this.m_combo) {
            String s;
            Object value = this.getValue();
            Object o = this.m_combo.getSelectedItem();
            if (o != null && (s = o.toString()).startsWith("~") && s.endsWith("~")) {
                log.info(String.valueOf(this.m_columnName) + " - selection inactive set to NULL");
                value = null;
            }
            this.actionCombo(value);
        } else if (e.getSource() == this.m_button) {
            this.actionButton("");
        } else if (e.getSource() == this.m_text) {
            this.actionText(false);
        } else if (e.getSource() == this.mZoom) {
            this.actionZoom(this.m_combo.getSelectedItem());
        } else if (e.getSource() == this.mRefresh) {
            this.actionRefresh();
        } else if (e.getSource() == this.mBPartnerNew) {
            this.actionBPartner(true);
        } else if (e.getSource() == this.mBPartnerUpd) {
            this.actionBPartner(false);
        } else if (e.getSource() == this.m_COrderNew) {
            this.actionCOrder(this.m_mField, false);
        } else if (e.getSource() == this.m_COrderCopy) {
            this.actionCOrder(this.m_mField, true);
        } else if (e.getSource() == this.m_MRMANew) {
            this.actionMRMA(this.m_mField);
        } else if (e.getSource() instanceof LookupActionItem && (!(bNeedSave = this.m_mField.getGridTab().needSave(true, true)) || bNeedSave && this.m_mField.getGridTab().dataSave(true)) && (result = (item = (LookupActionItem)e.getSource()).doAction(this)) != null) {
            this.m_lookup.getDirect(result, false, true);
            this.actionCombo(result);
            this.m_mField.getGridTab().dataSave(true);
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.m_combo.addActionListener(listener);
        this.m_text.addActionListener(listener);
    }

    private void actionCombo(Object value) {
        log.fine("Value=" + value);
        try {
            this.fireVetoableChange(this.m_columnName, null, value);
        }
        catch (PropertyVetoException pve) {
            log.log(Level.SEVERE, this.m_columnName, pve);
        }
        boolean updated = false;
        Object updatedValue = value;
        if (updatedValue instanceof Object[] && ((Object[])updatedValue).length > 0) {
            updatedValue = ((Object[])updatedValue)[0];
        }
        if (updatedValue == null && this.m_value == null) {
            updated = true;
        } else if (updatedValue != null && value.equals(this.m_value)) {
            updated = true;
        }
        if (!updated) {
            log.fine(String.valueOf(this.m_columnName) + " - Value explicitly set - new=" + updatedValue + ", old=" + this.m_value);
            this.setValue(updatedValue);
        }
    }

    private void actionButton(String queryValue) {
        this.m_button.setEnabled(false);
        if (this.m_lookup == null) {
            return;
        }
        this.m_text.requestFocus();
        JFrame frame = Env.getFrame(this);
        Object[] result = null;
        boolean cancelled = false;
        boolean multipleSelection = false;
        String col = this.m_lookup.getColumnName();
        if (col.indexOf(46) != -1) {
            col = col.substring(col.indexOf(46) + 1);
        }
        String whereClause = this.getWhereClause();
        log.fine(String.valueOf(col) + ", Zoom=" + this.m_lookup.getZoom() + " (" + whereClause + ")");
        boolean resetValue = false;
        String infoFactoryClass = this.m_lookup.getInfoFactoryClass();
        if (infoFactoryClass == null || infoFactoryClass.trim().length() == 0) {
            if (this.m_keyColumnName == null || this.m_keyColumnName.trim().length() == 0) {
                this.m_keyColumnName = MQuery.getZoomColumnName(this.m_columnName);
            }
            infoFactoryClass = InfoFactoryRegistry.getFactoryClass(this.m_keyColumnName);
        }
        if (infoFactoryClass != null && infoFactoryClass.trim().length() > 0) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(infoFactoryClass);
                InfoFactory factory = (InfoFactory)clazz.newInstance();
                if (this.m_tableName == null) {
                    this.getDirectAccessSQL("*");
                }
                Info ig = null;
                ig = factory instanceof GridFieldInfoFactory ? ((GridFieldInfoFactory)factory).create(frame, true, this.m_lookup.getWindowNo(), this.m_tableName, this.m_keyColumnName, queryValue, false, whereClause, this.m_mField) : factory.create(frame, true, this.m_lookup.getWindowNo(), this.m_tableName, this.m_keyColumnName, queryValue, false, whereClause);
                ig.setVisible(true);
                cancelled = ig.isCancelled();
                result = ig.getSelectedKeys();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load custom InfoFactory - " + e.getLocalizedMessage(), e);
            }
        } else if (col.equals("M_Product_ID")) {
            this.resetTabInfo();
            if (queryValue.length() == 0 && this.m_text.getText().length() > 0) {
                queryValue = "@" + this.m_text.getText() + "@";
            }
            int M_Warehouse_ID = Env.getContextAsInt(Env.getCtx(), this.m_lookup.getWindowNo(), "M_Warehouse_ID");
            int M_PriceList_ID = Env.getContextAsInt(Env.getCtx(), this.m_lookup.getWindowNo(), "M_PriceList_ID");
            if (this.m_mField != null) {
                int AD_Table_ID = MColumn.getTable_ID(Env.getCtx(), this.m_mField.getAD_Column_ID(), null);
                multipleSelection = MOrderLine.Table_ID == AD_Table_ID || MInvoiceLine.Table_ID == AD_Table_ID || I_PP_Product_BOMLine.Table_ID == AD_Table_ID || MProductPrice.Table_ID == AD_Table_ID;
            }
            InfoProduct ip = new InfoProduct(frame, true, this.m_lookup.getWindowNo(), M_Warehouse_ID, M_PriceList_ID, queryValue, multipleSelection, whereClause);
            ip.setVisible(true);
            cancelled = ip.isCancelled();
            result = ip.getSelectedKeys();
            resetValue = true;
        } else if (col.equals("C_BPartner_ID")) {
            if (queryValue.length() == 0 && this.m_text.getText().length() > 0) {
                queryValue = this.m_text.getText();
            }
            boolean isSOTrx = true;
            if (Env.getContext(Env.getCtx(), this.m_lookup.getWindowNo(), "IsSOTrx").equals("N")) {
                isSOTrx = false;
            }
            InfoBPartner ip = new InfoBPartner((Frame)frame, true, this.m_lookup.getWindowNo(), queryValue, isSOTrx, multipleSelection, whereClause);
            ip.setVisible(true);
            cancelled = ip.isCancelled();
            result = ip.getSelectedKeys();
        } else {
            if (this.m_tableName == null) {
                this.getDirectAccessSQL("*");
            }
            Info ig = Info.create(frame, true, this.m_lookup.getWindowNo(), this.m_tableName, this.m_keyColumnName, queryValue, multipleSelection, whereClause);
            ig.setVisible(true);
            cancelled = ig.isCancelled();
            result = ig.getSelectedKeys();
        }
        if (result != null && result.length > 0) {
            log.config(String.valueOf(this.m_columnName) + " - Result = " + result.toString() + " (" + result.getClass().getName() + ")");
            this.m_lookup.getDirect(result[0], false, true);
            if (resetValue) {
                this.actionCombo(null);
            }
            if (result.length > 1) {
                this.actionCombo(result);
            } else {
                this.actionCombo(result[0]);
            }
        } else if (cancelled) {
            log.config(String.valueOf(this.m_columnName) + " - Result = null (cancelled)");
            this.actionCombo(null);
        } else {
            log.config(String.valueOf(this.m_columnName) + " - Result = null (not cancelled)");
            this.setValue(this.m_value);
        }
        this.m_button.setEnabled(true);
        this.m_text.requestFocus();
    }

    private String getWhereClause() {
        String validation;
        String whereClause = "";
        if (this.m_lookup == null) {
            return "";
        }
        if (this.m_lookup.getZoomQuery() != null) {
            whereClause = this.m_lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = this.m_lookup.getValidation()) == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = String.valueOf(whereClause) + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            GridTab gridTab;
            String validated = null;
            if (this.m_mField != null && (gridTab = this.m_mField.getGridTab()) != null) {
                int iTabNo = gridTab.getTabNo();
                validated = Env.parseContext(Env.getCtx(), this.m_lookup.getWindowNo(), iTabNo, whereClause, false);
            }
            if (validated == null) {
                validated = Env.parseContext(Env.getCtx(), this.m_lookup.getWindowNo(), whereClause, false);
            }
            if (validated.length() == 0) {
                log.severe(String.valueOf(this.m_columnName) + " - Cannot Parse=" + whereClause);
            } else {
                log.fine(String.valueOf(this.m_columnName) + " - Parsed: " + validated);
                return validated;
            }
        }
        return whereClause;
    }

    private String getExtraWhereClause(String text) {
        StringBuffer sql = new StringBuffer();
        this.m_tableName = this.m_columnName.substring(0, this.m_columnName.length() - 3);
        this.m_keyColumnName = this.m_columnName;
        if (this.m_columnName.equals("M_Product_ID")) {
            this.resetTabInfo();
            sql.append(" AND (UPPER(p.Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(p.Name) LIKE ").append(DB.TO_STRING(text)).append(" OR p.SKU LIKE ").append(DB.TO_STRING(text)).append(")");
        }
        return sql.toString();
    }

    private void actionText(boolean bLeaving) {
        int id;
        String finalSQL;
        block23: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String text;
            block21: {
                text = this.m_text.getText();
                if (text != null && text.length() > 0 && text.equals(this.m_lastDisplay)) {
                    log.finest("Nothing entered [SKIP]");
                    return;
                }
                if (text == null || text.length() == 0 && bLeaving) {
                    this.actionCombo(null);
                    return;
                }
                if (text == null || text.length() == 0 || text.equals("%")) {
                    this.actionButton(text);
                    return;
                }
                text = text.toUpperCase();
                log.config(String.valueOf(this.m_columnName) + " - " + text);
                pstmt = null;
                rs = null;
                finalSQL = Msg.parseTranslation(Env.getCtx(), this.getDirectAccessSQL(text));
                id = -3;
                try {
                    try {
                        pstmt = DB.prepareStatement(finalSQL, null);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            id = rs.getInt(1);
                            if (rs.next()) {
                                id = -1;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, finalSQL, e);
                        id = -2;
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (id == -3 && !text.endsWith("%")) {
                text = String.valueOf(text) + "%";
                finalSQL = Msg.parseTranslation(Env.getCtx(), this.getDirectAccessSQL(text));
                try {
                    try {
                        pstmt = DB.prepareStatement(finalSQL, null);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            id = rs.getInt(1);
                            if (rs.next()) {
                                id = -1;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, finalSQL, e);
                        id = -2;
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        if (id <= 0) {
            if (id == -3) {
                log.fine(String.valueOf(this.m_columnName) + " - Not Found - " + finalSQL);
            } else {
                log.fine(String.valueOf(this.m_columnName) + " - Not Unique - " + finalSQL);
            }
            this.m_value = null;
            this.actionButton(this.m_text.getText());
            return;
        }
        log.fine(String.valueOf(this.m_columnName) + " - Unique ID=" + id);
        this.m_value = null;
        this.resetTabInfo();
        this.actionCombo(new Integer(id));
        if (id <= 0) {
            this.m_text.requestFocus();
        }
    }

    private String getDirectAccessSQL(String text) {
        StringBuffer sql;
        block36: {
            int AD_Reference_ID;
            sql = new StringBuffer();
            this.m_tableName = MQuery.getZoomTableName(this.m_columnName);
            this.m_keyColumnName = MQuery.getZoomColumnName(this.m_columnName);
            if (this.m_columnName.equals("M_Product_ID")) {
                this.resetTabInfo();
                sql.append("SELECT M_Product_ID FROM M_Product WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING(text)).append(" OR SKU LIKE ").append(DB.TO_STRING(text)).append(" OR UPC LIKE ").append(DB.TO_STRING(text)).append(")");
            } else if (this.m_columnName.equals("C_BPartner_ID")) {
                sql.append("SELECT C_BPartner_ID FROM C_BPartner WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING(text)).append(")");
            } else if (this.m_columnName.equals("C_Order_ID")) {
                sql.append("SELECT C_Order_ID FROM C_Order WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
            } else if (this.m_columnName.equals("C_Invoice_ID")) {
                sql.append("SELECT C_Invoice_ID FROM C_Invoice WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
            } else if (this.m_columnName.equals("M_InOut_ID")) {
                sql.append("SELECT M_InOut_ID FROM M_InOut WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
            } else if (this.m_columnName.equals("C_Payment_ID")) {
                sql.append("SELECT C_Payment_ID FROM C_Payment WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
            } else if (this.m_columnName.equals("GL_JournalBatch_ID")) {
                sql.append("SELECT GL_JournalBatch_ID FROM GL_JournalBatch WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
            } else if (this.m_columnName.equals("SalesRep_ID")) {
                sql.append("SELECT AD_User_ID FROM AD_User WHERE UPPER(Name) LIKE ").append(DB.TO_STRING(text));
                this.m_tableName = "AD_User";
                this.m_keyColumnName = "AD_User_ID";
            }
            if (sql.length() > 0) {
                String wc = this.getWhereClause();
                if (wc != null && wc.length() > 0) {
                    sql.append(" AND ").append(wc);
                }
                sql.append(" AND IsActive='Y'");
                log.finest(String.valueOf(this.m_columnName) + " (predefined) " + sql.toString());
                return MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
            }
            if (this.m_lookup != null && this.m_lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)this.m_lookup).getAD_Reference_Value_ID()) != 0) {
                String displayColumnName;
                block34: {
                    String query = "SELECT kc.ColumnName, dc.ColumnName, t.TableName FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Column dc ON (rt.AD_Display=dc.AD_Column_ID) INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
                    displayColumnName = null;
                    CPreparedStatement pstmt = null;
                    ResultSet rs2 = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement(query, null);
                            pstmt.setInt(1, AD_Reference_ID);
                            rs2 = pstmt.executeQuery();
                            if (rs2.next()) {
                                this.m_keyColumnName = rs2.getString(1);
                                displayColumnName = rs2.getString(2);
                                this.m_tableName = rs2.getString(3);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, query, e);
                            DB.close(rs2, pstmt);
                            rs2 = null;
                            pstmt = null;
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs2, pstmt);
                        rs2 = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs2, pstmt);
                    rs2 = null;
                    pstmt = null;
                }
                if (displayColumnName != null) {
                    sql = new StringBuffer();
                    sql.append("SELECT ").append(this.m_keyColumnName).append(" FROM ").append(this.m_tableName).append(" WHERE UPPER(").append(displayColumnName).append(") LIKE ").append(DB.TO_STRING(text)).append(" AND IsActive='Y'");
                    String wc = this.getWhereClause();
                    if (wc != null && wc.length() > 0) {
                        sql.append(" AND ").append(wc);
                    }
                    log.finest(String.valueOf(this.m_columnName) + " (Table) " + sql.toString());
                    return MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
                }
            }
            String query = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID AND t.IsView='N') WHERE (c.ColumnName IN ('DocumentNo', 'Value', 'Name') OR c.IsIdentifier='Y') AND c.AD_Reference_ID IN (10,14) AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.IsKey='Y' AND cc.ColumnName=?)";
            sql = new StringBuffer();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(query, null);
                    pstmt.setString(1, this.m_keyColumnName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (sql.length() != 0) {
                            sql.append(" OR ");
                        }
                        this.m_tableName = rs.getString(1);
                        sql.append("UPPER(").append(rs.getString(2)).append(") LIKE ").append(DB.TO_STRING(text));
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, query, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block36;
                }
            }
            catch (Throwable rs2) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw rs2;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (sql.length() == 0) {
            log.log(Level.SEVERE, String.valueOf(this.m_columnName) + " (TableDir) - no standard/identifier columns");
            return "";
        }
        StringBuffer retValue = new StringBuffer("SELECT ").append(this.m_columnName).append(" FROM ").append(this.m_tableName).append(" WHERE (").append(sql).append(")").append(" AND IsActive='Y'");
        String wc = this.getWhereClause();
        if (wc != null && wc.length() > 0) {
            retValue.append(" AND ").append(wc);
        }
        log.finest(String.valueOf(this.m_columnName) + " (TableDir) " + sql.toString());
        return MRole.getDefault().addAccessSQL(retValue.toString(), this.m_tableName, false, false);
    }

    private void actionBPartner(boolean newRecord) {
        VBPartner vbp = new VBPartner((Frame)Env.getFrame(this), this.m_lookup.getWindowNo());
        int BPartner_ID = 0;
        if (!newRecord) {
            if (this.m_value instanceof Integer) {
                BPartner_ID = (Integer)this.m_value;
            } else if (this.m_value != null) {
                BPartner_ID = Integer.parseInt(this.m_value.toString());
            }
        }
        vbp.loadBPartner(BPartner_ID);
        vbp.setVisible(true);
        int result = vbp.getC_BPartner_ID();
        if (result == 0 && result == BPartner_ID) {
            return;
        }
        this.m_lookup.getDirect(new Integer(result), false, true);
        this.actionCombo(new Integer(result));
    }

    private void actionCOrder(GridField gridField, boolean bCopy) {
        int result = 0;
        int C_order_ID = 0;
        boolean bNeedSave = gridField.getGridTab().needSave(true, true);
        if (!bNeedSave || bNeedSave && gridField.getGridTab().dataSave(true)) {
            if (!bCopy) {
                VCOrder vOrd = new VCOrder((Frame)Env.getFrame(this), this, this.m_lookup.getWindowNo());
                vOrd.setVisible(true);
                result = vOrd.getC_Order_ID();
            } else {
                VCOrderCopy vOrdCopy = new VCOrderCopy((Frame)Env.getFrame(this), this, this.m_lookup.getWindowNo());
                vOrdCopy.setVisible(true);
                result = vOrdCopy.getC_Order_ID();
            }
            if (result == 0 && result == C_order_ID) {
                return;
            }
            this.m_lookup.getDirect(new Integer(result), false, true);
            this.actionCombo(new Integer(result));
            gridField.getGridTab().dataSave(true);
        }
    }

    private void actionMRMA(GridField gridField) {
        boolean bNeedSave = gridField.getGridTab().needSave(true, true);
        if (!bNeedSave || bNeedSave && gridField.getGridTab().dataSave(true)) {
            VMRMA vRma = new VMRMA((Frame)Env.getFrame(this), gridField, this, this.m_lookup.getWindowNo());
            int M_RMA_ID = 0;
            vRma.setVisible(true);
            int result = vRma.getM_RMA_ID();
            if (result == 0 && result == M_RMA_ID) {
                return;
            }
            this.m_lookup.getDirect(new Integer(result), false, true);
            this.actionCombo(new Integer(result));
            gridField.getGridTab().dataSave(true);
        }
    }

    public void actionZoom(Object selectedItem) {
        if (this.m_lookup == null) {
            return;
        }
        MQuery zoomQuery = this.m_lookup.getZoomQuery();
        Object value = this.getValue();
        if (value == null) {
            value = selectedItem;
        }
        if (zoomQuery == null || value != null) {
            String keyColumnName;
            String keyTableName;
            block18: {
                int AD_Reference_ID;
                zoomQuery = new MQuery();
                keyTableName = null;
                keyColumnName = null;
                if (this.m_lookup != null && this.m_lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)this.m_lookup).getAD_Reference_Value_ID()) != 0) {
                    String query = "SELECT kc.ColumnName, kt.TableName FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Table kt ON (rt.AD_Table_ID=kt.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement(query, null);
                            pstmt.setInt(1, AD_Reference_ID);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                keyColumnName = rs.getString(1);
                                keyTableName = rs.getString(2);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, query, e);
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            if (keyColumnName != null && keyColumnName.length() != 0) {
                zoomQuery.addRestriction(keyColumnName, "=", value);
                zoomQuery.setZoomColumnName(keyColumnName);
                zoomQuery.setZoomTableName(keyTableName);
            } else {
                zoomQuery.addRestriction(this.m_columnName, "=", value);
                if (this.m_columnName.indexOf(".") > 0) {
                    zoomQuery.setZoomColumnName(this.m_columnName.substring(this.m_columnName.indexOf(".") + 1));
                    zoomQuery.setZoomTableName(this.m_columnName.substring(0, this.m_columnName.indexOf(".")));
                } else {
                    zoomQuery.setZoomColumnName(this.m_columnName);
                    zoomQuery.setZoomTableName(this.m_columnName.substring(0, this.m_columnName.length() - 3));
                }
            }
            zoomQuery.setZoomValue(value);
            zoomQuery.setRecordCount(1);
        }
        int AD_Window_ID = this.m_lookup.getZoom(zoomQuery);
        log.info(String.valueOf(this.m_columnName) + " - AD_Window_ID=" + AD_Window_ID + " - Query=" + zoomQuery + " - Value=" + value);
        this.setCursor(Cursor.getPredefinedCursor(3));
        AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, zoomQuery)) {
            this.setCursor(Cursor.getDefaultCursor());
            ValueNamePair pp = CLogger.retrieveError();
            String msg = pp == null ? "AccessTableNoView" : pp.getValue();
            ADialog.error(this.m_lookup.getWindowNo(), this, msg, pp == null ? "" : pp.getName());
        } else {
            AEnv.addToWindowManager(frame);
            if (Ini.isPropertyBool("OpenWindowMaximized")) {
                AEnv.showMaximized(frame);
            } else {
                AEnv.showCenterScreen(frame);
            }
        }
        frame = null;
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void actionRefresh() {
        if (this.m_lookup == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object obj = this.m_combo.getSelectedItem();
        log.info(String.valueOf(this.m_columnName) + " #" + this.m_lookup.getSize() + ", Selected=" + obj);
        if (!this.isReadWrite()) {
            this.m_settingValue = true;
            this.m_lookup.removeAllElements();
            this.m_lastDisplay = this.m_lookup.getDisplay(this.m_value);
            this.m_text.setText(this.m_lastDisplay);
            this.m_text.setCaretPosition(0);
            this.m_settingValue = false;
        } else {
            this.m_lookup.refresh();
            this.m_lookup.fillComboBox(this.isMandatory(), true, true, false);
            this.m_combo.setSelectedItem(obj);
        }
        this.setCursor(Cursor.getDefaultCursor());
        log.info(String.valueOf(this.m_columnName) + " #" + this.m_lookup.getSize() + ", Selected=" + this.m_combo.getSelectedItem());
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.m_combo == null || this.m_combo.getEditor() == null) {
            return;
        }
        if (e.getSource() != this.m_combo && e.getSource() != this.m_combo.getEditor().getEditorComponent() || e.isTemporary() || this.m_haveFocus || this.m_lookup == null) {
            return;
        }
        if (this.m_lookup.isValidated() && this.m_lookup.isLoaded()) {
            this.m_haveFocus = true;
            return;
        }
        this.m_haveFocus = true;
        this.m_settingFocus = true;
        Object obj = this.m_lookup.getSelectedItem();
        log.config(String.valueOf(this.m_columnName) + " - Start    Count=" + this.m_combo.getItemCount() + ", Selected=" + obj);
        boolean popupVisible = this.m_combo.isPopupVisible();
        this.m_lookup.fillComboBox(this.isMandatory(), true, true, false);
        if (popupVisible) {
            this.m_combo.hidePopup();
            this.m_combo.showPopup();
        }
        log.config(String.valueOf(this.m_columnName) + " - Update   Count=" + this.m_combo.getItemCount() + ", Selected=" + this.m_lookup.getSelectedItem());
        this.m_lookup.setSelectedItem(obj);
        log.config(String.valueOf(this.m_columnName) + " - Selected Count=" + this.m_combo.getItemCount() + ", Selected=" + this.m_lookup.getSelectedItem());
        this.m_settingFocus = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary() || this.m_lookup == null || !this.m_button.isEnabled()) {
            return;
        }
        if (e.getSource() == this.m_text) {
            String text = this.m_text.getText();
            log.config(String.valueOf(this.m_columnName) + " (Text) " + this.m_columnName + " = " + this.m_value + " - " + text);
            this.m_haveFocus = false;
            if (this.m_value == null && this.m_text.getText().length() == 0) {
                return;
            }
            if (this.m_lastDisplay.equals(text)) {
                return;
            }
            this.actionText(true);
            return;
        }
        if (e.getSource() != this.m_combo && e.getSource() != this.m_combo.getEditor().getEditorComponent()) {
            return;
        }
        if (this.m_lookup.isValidated() && !this.m_lookup.hasInactive()) {
            this.m_haveFocus = false;
            return;
        }
        this.m_settingFocus = true;
        log.config(String.valueOf(this.m_columnName) + " = " + this.m_combo.getSelectedItem());
        Object obj = this.m_combo.getSelectedItem();
        if (obj != null) {
            this.m_combo.setSelectedItem(obj);
            if (!this.m_combo.getSelectedItem().equals(obj)) {
                log.fine(String.valueOf(this.m_columnName) + " - added to combo - " + obj);
                this.m_combo.addItem(obj);
                this.m_combo.setSelectedItem(obj);
            }
        }
        this.m_settingFocus = false;
        this.m_haveFocus = false;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.m_button.setToolTipText(text);
        this.m_text.setToolTipText(text);
        this.m_combo.setToolTipText(text);
    }

    private void resetTabInfo() {
        if (this.m_lookup == null) {
            return;
        }
        String columnName = this.m_columnName;
        String[] infoNames = "M_Product_ID".equals(columnName) ? new String[]{"M_Product_ID", "M_AttributeSetInstance_ID", "M_Locator_ID", "M_Lookup_ID"} : new String[]{};
        String[] stringArray = infoNames;
        int n = infoNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Env.setContext(Env.getCtx(), this.m_lookup.getWindowNo(), 1113, name, null);
            ++n2;
        }
    }

    public int refresh() {
        if (this.m_lookup == null) {
            return -1;
        }
        if (!this.isReadWrite()) {
            this.m_lookup.removeAllElements();
            return 0;
        }
        return this.m_lookup.refresh();
    }

    public void setStopEditing(boolean stopediting) {
        this.m_stopediting = stopediting;
    }

    public Lookup getLookup() {
        return this.m_lookup;
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    final class VLookup_mouseAdapter
    extends MouseAdapter {
        private VLookup m_adaptee;

        VLookup_mouseAdapter(VLookup adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                if (VLookup.this.m_columnName.equals("C_Order_ID")) {
                    if (VLookup.this.getValue() == null) {
                        VLookup.this.m_COrderCopy.setVisible(false);
                    } else {
                        int iC_Order_ID = (Integer)VLookup.this.getValue();
                        MOrder order = ModelFactory.getOrder(Env.getCtx(), iC_Order_ID, null);
                        String sDocStatus = order.getDocStatus();
                        if (order.isSOTrx() && (sDocStatus.equalsIgnoreCase("IP") || sDocStatus.equalsIgnoreCase("CO"))) {
                            VLookup.this.m_COrderCopy.setVisible(true);
                        } else {
                            VLookup.this.m_COrderCopy.setVisible(false);
                        }
                    }
                }
                Component[] componentArray = this.m_adaptee.popupMenu.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component cmp = componentArray[n2];
                    if (cmp instanceof LookupActionItem) {
                        LookupActionItem item = (LookupActionItem)cmp;
                        if (item.isActionActive(this.m_adaptee)) {
                            item.setVisible(true);
                        } else {
                            item.setVisible(false);
                        }
                    }
                    ++n2;
                }
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            } else {
                this.m_adaptee.popupMenu.setVisible(false);
            }
        }
    }
}

