/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import org.compiere.apps.AEnv;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.model.MChart;
import org.compiere.model.MQuery;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;

public class VChart
extends CPanel
implements ChartMouseListener,
VEditor {
    private static final long serialVersionUID = 1L;
    ChartPanel chartPanel;
    MChart chartModel;

    public VChart() {
        this.setLayout(new BorderLayout());
    }

    public VChart(int AD_Chart_ID, int windowNo) {
        this();
        this.chartModel = new MChart(Env.getCtx(), AD_Chart_ID, null);
        this.chartModel.setWindowNo(windowNo);
    }

    public void createChart() {
        JFreeChart chart = this.chartModel.createChart();
        if (this.chartPanel != null) {
            this.remove((Component)this.chartPanel);
        }
        this.chartPanel = new ChartPanel(chart);
        Dimension size = this.getSize();
        size.height = this.chartModel.getWinHeight();
        this.chartPanel.setPreferredSize(size);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.add((Component)this.chartPanel, "Center");
        this.setMinimumSize(size);
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getName() {
        return this.chartModel.getName();
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        if (event.getEntity() != null && event.getTrigger().getClickCount() > 1) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Comparable sectionKey;
                CategoryItemEntity item;
                ChartEntity entity = event.getEntity();
                String key = null;
                String seriesName = null;
                if (entity instanceof CategoryItemEntity) {
                    item = (CategoryItemEntity)entity;
                    Comparable colKey = item.getColumnKey();
                    Comparable rowKey = item.getRowKey();
                    if (colKey != null && rowKey != null) {
                        key = colKey.toString();
                        seriesName = rowKey.toString();
                    }
                } else if (entity instanceof PieSectionEntity && (sectionKey = ((PieSectionEntity)entity).getSectionKey()) != null) {
                    key = sectionKey.toString();
                }
                if (entity instanceof XYItemEntity && (item = (XYItemEntity)entity).getDataset() instanceof TimeSeriesCollection) {
                    TimeSeriesCollection data = (TimeSeriesCollection)item.getDataset();
                    TimeSeries series = data.getSeries(item.getSeriesIndex());
                    TimeSeriesDataItem dataitem = series.getDataItem(item.getItem());
                    seriesName = series.getKey().toString();
                    key = dataitem.getPeriod().toString();
                }
                if (key == null) {
                    return;
                }
                MQuery query = this.chartModel.getQuery(seriesName == null ? key : String.valueOf(seriesName) + "__" + key);
                if (query != null) {
                    AEnv.zoom(query);
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void chartMouseMoved(ChartMouseEvent arg0) {
    }

    @Override
    public void setField(GridField mField) {
    }

    @Override
    public String getDisplay() {
        return null;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isReadWrite() {
        return false;
    }

    @Override
    public void setBackground(boolean error) {
    }

    @Override
    public void setMandatory(boolean mandatory) {
    }

    @Override
    public void setReadWrite(boolean rw) {
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public GridField getField() {
        return null;
    }
}

