/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import com.f3p.adempiere.grid.ed.VAbstract;
import com.f3p.adempiere.model.OrderCopyOperation;
import com.f3p.adempiere.util.DialogHelper;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.JComboBox;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.AEnv;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MRole;
import org.compiere.swing.CComboBox;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class VCOrderCopy
extends VAbstract
implements ActionListener {
    private static final long serialVersionUID = -3743011058394480038L;
    private MOrder m_order = null;
    private JComboBox m_fDocTypeTarget;
    private Object[] m_oDocTypeTarget;
    private VDate m_fDate;
    private VCheckBox m_fClose;
    private static CLogger log = CLogger.getCLogger(VCOrderCopy.class);
    private static final String SQL_DOC_TYPE_TARGET = "SELECT C_DocType_ID, Name FROM C_DocType WHERE C_DocType.ISACTIVE='Y' AND C_DocType.DocBaseType ='SOO' AND C_DocType.IsSOTrx='Y' AND COALESCE(C_DocType.DocSubTypeSO,' ')<>'RM' ORDER BY C_DocType.IsDefault DESC";
    private static final String MSG_CLOSE_ORDER = "F3P_Close_Order";

    public VCOrderCopy(Frame frame, VLookup parentLookup, int WindowNo) {
        super(frame, Msg.translate(Env.getCtx(), "C_Order_ID"), true);
        this.m_WindowNo = WindowNo;
        this.m_parentLookup = parentLookup;
        this.m_readOnly = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MOrder.Table_ID, 0, false);
        log.info("R/O=" + this.m_readOnly);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.initCOrder();
        AEnv.positionCenterWindow(frame, this);
    }

    private void initCOrder() {
        this.dynInit();
        this.m_oDocTypeTarget = this.getDocTypeTarget();
        this.m_fDocTypeTarget = new CComboBox(this.m_oDocTypeTarget);
        this.m_fDocTypeTarget.setSelectedIndex(0);
        this.createLine(this.m_fDocTypeTarget, "C_DocType_ID", true, true);
        this.m_fDate = new VDate("DateOrdered", true, false, true, 15, "DateOrdered");
        this.createLine(this.m_fDate, "DateOrdered", true, true);
        this.m_fClose = new VCheckBox(MSG_CLOSE_ORDER, false, false, true, Msg.translate(Env.getCtx(), MSG_CLOSE_ORDER), "", false);
        this.createLine(this.m_fClose, Msg.translate(Env.getCtx(), MSG_CLOSE_ORDER), true, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_readOnly) {
            this.dispose();
        } else if (e.getActionCommand().equals("Ok")) {
            try {
                if (this.actionSave()) {
                    this.dispose();
                    this.m_parentLookup.requestFocus();
                    this.m_parentLookup.setValue(this.m_order.getC_Order_ID());
                    this.m_parentLookup.actionZoom(null);
                }
            }
            catch (Exception ex) {
                DialogHelper.error(this.m_WindowNo, this, ex.getMessage());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private boolean actionSave() {
        log.config("");
        Timestamp tsDate = this.m_fDate.getTimestamp();
        if (tsDate == null) {
            this.m_fDate.setBackground(true);
            return false;
        }
        String sTrxName = Trx.createTrxName();
        int iC_Order_ID = (Integer)this.m_parentLookup.getValue();
        int iC_DocType_ID = ((KeyNamePair)this.m_fDocTypeTarget.getSelectedItem()).getKey();
        MDocType dt = MDocType.get(Env.getCtx(), iC_DocType_ID);
        MOrder from = new MOrder(Env.getCtx(), iC_Order_ID, sTrxName);
        this.m_order = OrderCopyOperation.copyFrom(from, tsDate, dt.getC_DocType_ID(), dt.isSOTrx(), false, true, sTrxName);
        this.m_order.setC_DocTypeTarget_ID(iC_DocType_ID);
        if (this.m_fClose.isSelected()) {
            String sDocStatus = from.getDocStatus();
            if (!sDocStatus.equals("CO")) {
                from.setDocAction("CO");
                from.processIt("CO");
                from.saveEx(sTrxName);
            }
            from.setDocAction("CL");
            from.processIt("CL");
            from.saveEx(sTrxName);
        }
        boolean bSaved = this.m_order.save();
        try {
            if (bSaved) {
                DB.commit(true, sTrxName);
            } else {
                DB.rollback(true, sTrxName);
            }
        }
        catch (SQLException e) {
            throw new AdempiereException(e);
        }
        return bSaved;
    }

    public int getC_Order_ID() {
        if (this.m_order == null) {
            return 0;
        }
        return this.m_order.getC_Order_ID();
    }

    protected Object[] getDocTypeTarget() {
        String sql = MRole.getDefault().addAccessSQL(SQL_DOC_TYPE_TARGET, "C_DocType", false, false);
        return DB.getKeyNamePairs(sql, false);
    }
}

