/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import com.f3p.adempiere.grid.ed.VAbstract;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.util.ModelFactory;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.logging.Level;
import javax.swing.JComboBox;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.swing.CComboBox;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;

public final class VCOrder
extends VAbstract
implements ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String SQL_BP_LOCATION = "SELECT C_BPartner_Location_ID, Name FROM C_BPartner_Location WHERE C_BPartner_ID = ? AND IsShipTo='Y' ORDER BY 2";
    private static final String SQL_DOC_TYPE_TARGET = "SELECT C_DocType_ID, Name FROM C_DocType WHERE C_DocType.ISACTIVE='Y' AND C_DocType.DocBaseType ='SOO' AND C_DocType.IsSOTrx='Y' AND COALESCE(C_DocType.DocSubTypeSO,' ')<>'RM' ORDER BY C_DocType.IsDefault DESC";
    private static final String SQL_SALES_REP = "SELECT AD_User_ID, Name FROM AD_User WHERE EXISTS (SELECT * FROM C_BPartner bp WHERE AD_User.C_BPartner_ID=bp.C_BPartner_ID AND bp.IsSalesRep='Y')";
    private MOrder m_order = null;
    private static CLogger log = CLogger.getCLogger(VCOrder.class);
    private VLookup m_fBPartner;
    private JComboBox m_fBPLocations;
    private JComboBox m_fDocTypeTarget;
    private JComboBox m_fSalesRep;
    private Object[] m_oBPLocations;
    private Object[] m_oDocTypeTarget;
    private Object[] m_oSalesRep;

    public VCOrder(Frame frame, VLookup parentLookup, int WindowNo) {
        super(frame, Msg.translate(Env.getCtx(), "C_Order_ID"), true);
        this.m_WindowNo = WindowNo;
        this.m_parentLookup = parentLookup;
        this.m_readOnly = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MOrder.Table_ID, 0, false);
        log.info("R/O=" + this.m_readOnly);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.initCOrder();
        AEnv.positionCenterWindow(frame, this);
    }

    private void initCOrder() {
        this.dynInit();
        int C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_BPartner_ID");
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, IDResolver.getAD_Column_ID("C_BPartner", "C_BPartner_ID"), 30);
        this.m_fBPartner = new VLookup("C_BPartner_ID", true, false, true, lookupBP);
        if (C_BPartner_ID != 0) {
            this.m_fBPartner.setValue(C_BPartner_ID);
        }
        this.createLine(this.m_fBPartner, "C_BPartner_ID", true, true);
        this.m_fBPartner.addVetoableChangeListener(this);
        if (C_BPartner_ID != 0) {
            this.m_oBPLocations = this.getBPLocation(C_BPartner_ID);
            int C_BPartnerLocation_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_BPartner_Location_ID");
            this.m_fBPLocations = new CComboBox(this.m_oBPLocations);
            int index = this.getIndex(this.m_oBPLocations, String.valueOf(C_BPartnerLocation_ID));
            if (index >= 0 && this.m_oBPLocations.length > 0) {
                this.m_fBPLocations.setSelectedIndex(index);
            }
        } else {
            this.m_fBPLocations = new CComboBox();
        }
        this.createLine(this.m_fBPLocations, "C_BPartner_Location_ID", true, true);
        this.m_oDocTypeTarget = this.getDocTypeTarget();
        this.m_fDocTypeTarget = new CComboBox(this.m_oDocTypeTarget);
        this.m_fDocTypeTarget.setSelectedIndex(0);
        this.createLine(this.m_fDocTypeTarget, "C_DocType_ID", true, true);
        int SalesRep_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "SalesRep_ID");
        this.m_oSalesRep = this.getSalesRep();
        this.m_fSalesRep = new CComboBox(this.m_oSalesRep);
        if (SalesRep_ID != 0 && SalesRep_ID != 100) {
            this.m_fSalesRep.setSelectedItem(new KeyNamePair(SalesRep_ID, MUser.getNameOfUser(SalesRep_ID)));
        }
        this.createLine(this.m_fSalesRep, "SalesRep_ID", true, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_readOnly) {
            this.dispose();
        } else if (e.getActionCommand().equals("Ok")) {
            try {
                if (this.actionSave()) {
                    this.dispose();
                    this.m_parentLookup.requestFocus();
                    this.m_parentLookup.setValue(this.m_order.getC_Order_ID());
                    this.m_parentLookup.actionZoom(null);
                }
            }
            catch (Exception ex) {
                ADialog.error(this.m_WindowNo, this, ex.getMessage());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private boolean actionSave() {
        String sSODesc;
        int M_PriceList_ID;
        MBPartnerLocation loc;
        int n;
        int n2;
        MBPartnerLocation[] mBPartnerLocationArray;
        log.config("");
        boolean bMandatory = true;
        if (this.m_fBPartner.getValue() == null) {
            this.m_fBPartner.setBackground(AdempierePLAF.getFieldBackground_Error());
            bMandatory = false;
        }
        if (this.m_fBPLocations.getSelectedItem() == null) {
            this.m_fBPLocations.setBackground(AdempierePLAF.getFieldBackground_Error());
            bMandatory = false;
        }
        if (!bMandatory) {
            return bMandatory;
        }
        this.m_order = new MOrder(Env.getCtx(), 0, null);
        int C_BPartner_ID = ((Number)this.m_fBPartner.getValue()).intValue();
        this.m_order.setC_BPartner_ID(C_BPartner_ID);
        int iLocID = ((KeyNamePair)this.m_fBPLocations.getSelectedItem()).getKey();
        MBPartnerLocation mBPLoc = ModelFactory.getPartnerLocation(Env.getCtx(), iLocID, null);
        boolean bIsShipTo = mBPLoc.isShipTo();
        boolean bIsBillTo = mBPLoc.isBillTo();
        MBPartner bp = MBPartner.get(Env.getCtx(), C_BPartner_ID);
        MBPartnerLocation[] bpLocs = bp.getLocations(true);
        if (bIsShipTo) {
            this.m_order.setC_BPartner_Location_ID(iLocID);
        } else {
            mBPartnerLocationArray = bpLocs;
            n2 = bpLocs.length;
            n = 0;
            while (n < n2) {
                loc = mBPartnerLocationArray[n];
                if (loc.isShipTo()) {
                    this.m_order.setC_BPartner_Location_ID(loc.getC_BPartner_Location_ID());
                    break;
                }
                ++n;
            }
        }
        if (bIsBillTo) {
            this.m_order.setBill_Location_ID(iLocID);
        } else {
            mBPartnerLocationArray = bpLocs;
            n2 = bpLocs.length;
            n = 0;
            while (n < n2) {
                loc = mBPartnerLocationArray[n];
                if (loc.isBillTo()) {
                    this.m_order.setBill_Location_ID(loc.getC_BPartner_Location_ID());
                    break;
                }
                ++n;
            }
        }
        this.m_order.setC_DocTypeTarget_ID(((KeyNamePair)this.m_fDocTypeTarget.getSelectedItem()).getKey());
        this.m_order.setSalesRep_ID(((KeyNamePair)this.m_fSalesRep.getSelectedItem()).getKey());
        int AD_User_ID = Env.getContextAsInt(this.m_order.getCtx(), this.m_WindowNo, "AD_User_ID", true);
        if (AD_User_ID > 0) {
            this.m_order.setAD_User_ID(AD_User_ID);
        }
        if ((M_PriceList_ID = bp.getM_PriceList_ID()) > 0) {
            this.m_order.setM_PriceList_ID(M_PriceList_ID);
        } else {
            int i = Env.getContextAsInt(Env.getCtx(), "#M_PriceList_ID");
            if (i != 0) {
                this.m_order.setM_PriceList_ID(i);
            }
        }
        this.m_order.setBill_BPartner_ID(C_BPartner_ID);
        String sPORef = bp.getPOReference();
        if (sPORef != null && sPORef.trim().length() != 0) {
            this.m_order.setPOReference(sPORef);
        }
        if ((sSODesc = bp.getSO_Description()) != null && sSODesc.trim().length() != 0) {
            this.m_order.setDescription(sSODesc);
        }
        this.m_order.setIsDiscountPrinted(bp.isDiscountPrinted());
        String sOrderType = Env.getContext(this.m_order.getCtx(), this.m_WindowNo, "OrderType");
        this.m_order.setInvoiceRule("D");
        this.m_order.setDeliveryRule("A");
        this.m_order.setPaymentRule("P");
        if (sOrderType.equals("PR")) {
            this.m_order.setInvoiceRule("I");
            this.m_order.setDeliveryRule("R");
        } else if (sOrderType.equals("WR")) {
            this.m_order.setPaymentRule("B");
        } else {
            String sDeliveryViaRule;
            String sFreightCostRule;
            String sDeliveryRule;
            String sInvoiceRule;
            int C_PaymentTerm_ID;
            String sPaymentRule = null;
            boolean bIsSOTrx = this.m_order.isSOTrx();
            sPaymentRule = bIsSOTrx ? bp.getPaymentRule() : bp.getPaymentRulePO();
            if (sPaymentRule != null && sPaymentRule.length() != 0) {
                if (sPaymentRule.equals("B")) {
                    sPaymentRule = "P";
                }
                if (bIsSOTrx && (sPaymentRule.equals("S") || sPaymentRule.equals("U"))) {
                    sPaymentRule = "P";
                }
                this.m_order.setPaymentRule(sPaymentRule);
            }
            if ((C_PaymentTerm_ID = bIsSOTrx ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID()) > 0) {
                this.m_order.setC_PaymentTerm_ID(C_PaymentTerm_ID);
            }
            if ((sInvoiceRule = bp.getInvoiceRule()) != null && sInvoiceRule.trim().length() != 0) {
                this.m_order.setInvoiceRule(sInvoiceRule);
            }
            if ((sDeliveryRule = bp.getDeliveryRule()) != null && sDeliveryRule.trim().length() != 0) {
                this.m_order.setDeliveryRule(sDeliveryRule);
            }
            if ((sFreightCostRule = bp.getFreightCostRule()) != null && sFreightCostRule.trim().length() != 0) {
                this.m_order.setFreightCostRule(sFreightCostRule);
            }
            if ((sDeliveryViaRule = bp.getDeliveryViaRule()) != null && sDeliveryViaRule.trim().length() != 0) {
                this.m_order.setDeliveryViaRule(sDeliveryViaRule);
            }
        }
        this.m_order.setDocAction("CO");
        return this.m_order.save();
    }

    protected Object[] getBPLocation(int C_BPartner_ID) {
        String sql = MRole.getDefault().addAccessSQL(SQL_BP_LOCATION, "C_BPartner_Location", false, false);
        return DB.getKeyNamePairs(sql, false, C_BPartner_ID);
    }

    protected Object[] getDocTypeTarget() {
        String sql = MRole.getDefault().addAccessSQL(SQL_DOC_TYPE_TARGET, "C_DocType", false, false);
        return DB.getKeyNamePairs(sql, false);
    }

    protected Object[] getSalesRep() {
        String sql = MRole.getDefault().addAccessSQL(SQL_SALES_REP, "AD_User", false, false);
        return DB.getKeyNamePairs(sql, false);
    }

    protected int getIndex(Object[] items, String sKey) {
        int index = 0;
        int i = 0;
        while (i < items.length) {
            Object item = items[i];
            if (item != null) {
                boolean found = false;
                found = item instanceof NamePair ? ((NamePair)item).getID().equals(sKey) : item.toString().equals(sKey);
                if (found) {
                    index = i;
                    break;
                }
            }
            ++i;
        }
        return index;
    }

    public int getC_Order_ID() {
        if (this.m_order == null) {
            return 0;
        }
        return this.m_order.getC_Order_ID();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() == this.m_fBPartner) {
            Object[] items;
            int C_BPartner_ID = ((Number)evt.getNewValue()).intValue();
            this.m_fBPLocations.removeAllItems();
            Object[] objectArray = items = this.getBPLocation(C_BPartner_ID);
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                this.m_fBPLocations.addItem(item);
                ++n2;
            }
        }
    }
}

