/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CButton;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;

public final class VButton
extends CButton
implements VEditor {
    private static final long serialVersionUID = -5979521568246908136L;
    private char m_savedMnemonic = '\u0000';
    private String m_columnName;
    private String m_text;
    private boolean m_mandatory;
    private Object m_value;
    private ActionListener m_actionListener;
    private HashMap<String, String> m_values = null;
    private String m_description = "";
    private String m_help;
    private int m_AD_Process_ID;
    private MLookup m_lookup;
    private static CLogger log = CLogger.getCLogger(VButton.class);

    public VButton(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, String text, String description, String help, int AD_Process_ID) {
        super(text);
        super.setName(columnName);
        super.setActionCommand(columnName);
        this.m_text = text;
        this.m_columnName = columnName;
        this.setMandatory(mandatory);
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        if (columnName.equals("PaymentRule")) {
            this.readReference(195);
            this.setForeground(Color.blue);
            this.setIcon(Env.getImageIcon("Payment16.gif"));
        } else if (columnName.equals("DocAction")) {
            this.readReference(135);
            this.setForeground(Color.blue);
            this.setIcon(Env.getImageIcon("Process16.gif"));
        } else if (columnName.equals("CreateFrom")) {
            this.setIcon(Env.getImageIcon("Copy16.gif"));
        } else if (columnName.equals("Record_ID")) {
            this.setIcon(Env.getImageIcon("Zoom16.gif"));
            this.setText(Msg.getMsg(Env.getCtx(), "ZoomDocument"));
        } else if (columnName.equals("Posted")) {
            this.readReference(234);
            this.setForeground(Color.magenta);
            this.setIcon(Env.getImageIcon("InfoAccount16.gif"));
        }
        this.m_description = description;
        if (description == null || description.length() == 0) {
            this.m_description = " ";
        } else {
            this.setToolTipText(this.m_description);
        }
        this.m_help = help;
        if (help == null) {
            this.m_help = "";
        }
        this.m_AD_Process_ID = AD_Process_ID;
    }

    @Override
    public void dispose() {
        this.m_actionListener = null;
        if (this.m_values != null) {
            this.m_values.clear();
        }
        this.m_values = null;
    }

    @Override
    public void setValue(Object value) {
        this.m_value = value;
        String text = this.m_text;
        if (value != null && !this.m_columnName.equals("Record_ID")) {
            NamePair pp;
            if (this.m_values != null) {
                text = this.m_values.get(value);
            } else if (this.m_lookup != null && (pp = this.m_lookup.get(value)) != null) {
                text = pp.getName();
            }
        }
        this.setText(text != null ? text : "");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public String getDisplay() {
        return this.m_value.toString();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setBackground(boolean error) {
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getHelp() {
        return this.m_help;
    }

    public int getProcess_ID() {
        return this.m_AD_Process_ID;
    }

    @Override
    public void addActionListener(ActionListener aListener) {
        this.m_actionListener = aListener;
        super.addActionListener(aListener);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("VButton[");
        sb.append(this.m_columnName);
        sb.append("=").append(this.m_value).append("]");
        return sb.toString();
    }

    private void readReference(int AD_Reference_ID) {
        this.m_values = new HashMap();
        String SQL = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=?" : "SELECT l.Value, t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "'" + " AND l.AD_Reference_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, AD_Reference_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String value = rs.getString(1);
                String name = rs.getString(2);
                this.m_values.put(value, name);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
    }

    public HashMap getValues() {
        return this.m_values;
    }

    @Override
    public void setField(GridField mField) {
        if (mField.getColumnName().endsWith("_ID") && !mField.getColumnName().equals("Record_ID")) {
            this.m_lookup = MLookupFactory.get(Env.getCtx(), mField.getWindowNo(), 0, mField.getAD_Column_ID(), 30);
        } else if (mField.getAD_Reference_Value_ID() != 0) {
            this.m_lookup = MLookupFactory.get(Env.getCtx(), mField.getWindowNo(), 0, mField.getAD_Column_ID(), 17);
        }
    }

    public char getSavedMnemonic() {
        return this.m_savedMnemonic;
    }

    public void setSavedMnemonic(char savedMnemonic) {
        this.m_savedMnemonic = savedMnemonic;
    }
}

