/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VButton;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.GridTab;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.ValueNamePair;

public class VPayment
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = -7931457502030396154L;
    private int m_WindowNo = 0;
    private GridTab m_mTab;
    private String m_DocStatus = null;
    private String m_PaymentRule = "";
    private int m_C_PaymentTerm_ID = 0;
    private Timestamp m_DateAcct = null;
    private int m_C_Payment_ID = 0;
    private MPayment m_mPayment = null;
    private MPayment m_mPaymentOriginal = null;
    private int m_C_CashLine_ID = 0;
    private MCashLine m_cashLine = null;
    private String m_CCType = "";
    private int m_C_BankAccount_ID = 0;
    private int m_C_CashBook_ID = 0;
    private boolean m_isSOTrx = true;
    private int m_C_Currency_ID = 0;
    private int m_AD_Client_ID = 0;
    private boolean m_Cash_As_Payment = true;
    private int m_AD_Org_ID = 0;
    private int m_C_BPartner_ID = 0;
    private BigDecimal m_Amount = Env.ZERO;
    private boolean m_initOK = false;
    private boolean m_onlyRule = false;
    private static Hashtable<Integer, KeyNamePair> s_Currencies = null;
    private boolean m_needSave = false;
    private static CLogger log = CLogger.getCLogger(VPayment.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private CPanel centerPanel = new CPanel();
    private FlowLayout northLayout = new FlowLayout();
    private CComboBox paymentCombo = new CComboBox();
    private CLabel paymentLabel = new CLabel();
    private CardLayout centerLayout = new CardLayout();
    private CPanel bPanel = new CPanel();
    private CPanel kPanel = new CPanel();
    private GridBagLayout kLayout = new GridBagLayout();
    private CLabel kTypeLabel = new CLabel();
    private CComboBox kTypeCombo = new CComboBox();
    private CLabel kNumberLabel = new CLabel();
    private CTextField kNumberField = new CTextField();
    private CLabel kNameLabel = new CLabel();
    private CTextField kNameField = new CTextField();
    private CLabel kExpLabel = new CLabel();
    private CTextField kExpField = new CTextField();
    private CLabel kApprovalLabel = new CLabel();
    private CTextField kApprovalField = new CTextField();
    private CLabel kAmountLabel = new CLabel();
    private VNumber kAmountField = new VNumber();
    private CPanel tPanel = new CPanel();
    private CLabel tAccountLabel = new CLabel();
    private CComboBox tAccountCombo = new CComboBox();
    private CPanel sPanel = new CPanel();
    private GridBagLayout sPanelLayout = new GridBagLayout();
    private CLabel sNumberLabel = new CLabel();
    private CTextField sNumberField = new CTextField();
    private CLabel sRoutingLabel = new CLabel();
    private CTextField sRoutingField = new CTextField();
    private CLabel sCurrencyLabel = new CLabel();
    private CComboBox sCurrencyCombo = new CComboBox();
    private CLabel bCurrencyLabel = new CLabel();
    private CComboBox bCurrencyCombo = new CComboBox();
    private CPanel pPanel = new CPanel();
    private CLabel pTermLabel = new CLabel();
    private CComboBox pTermCombo = new CComboBox();
    private GridBagLayout bPanelLayout = new GridBagLayout();
    private CLabel bAmountLabel = new CLabel();
    private VNumber bAmountField = new VNumber();
    private CLabel sAmountLabel = new CLabel();
    private VNumber sAmountField = new VNumber();
    private VDate bDateField;
    private CLabel bDateLabel = new CLabel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CTextField sCheckField = new CTextField();
    private CLabel sCheckLabel = new CLabel();
    private CButton kOnline = new CButton();
    private CButton sOnline = new CButton();
    private CComboBox sBankAccountCombo = new CComboBox();
    private CLabel sBankAccountLabel = new CLabel();
    private GridBagLayout pPanelLayout = new GridBagLayout();
    private CLabel bCashBookLabel = new CLabel();
    private CComboBox bCashBookCombo = new CComboBox();
    private GridBagLayout tPanelLayout = new GridBagLayout();
    private CButton tOnline = new CButton();
    private CLabel kStatus = new CLabel();
    private CTextField tRoutingField = new CTextField();
    private CTextField tNumberField = new CTextField();
    private CLabel tStatus = new CLabel();
    private CLabel tRoutingText = new CLabel();
    private CLabel tNumberText = new CLabel();
    private CLabel sStatus = new CLabel();
    protected static final String SQL_PAYMENT_TERM = "SELECT C_PaymentTerm_ID, Name FROM C_PaymentTerm WHERE IsActive='Y' AND (paymentRule is null or paymentRule = ? ) ORDER BY Name";

    public VPayment(int WindowNo, GridTab mTab, VButton button) {
        super(Env.getWindow(WindowNo), Msg.getMsg(Env.getCtx(), "Payment"), true);
        this.m_WindowNo = WindowNo;
        this.m_isSOTrx = "Y".equals(Env.getContext(Env.getCtx(), WindowNo, "IsSOTrx"));
        this.m_mTab = mTab;
        try {
            this.bDateField = new VDate("DateAcct", false, false, true, 15, "DateAcct");
            this.jbInit();
            this.m_initOK = this.dynInit(button);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VPayment", ex);
            this.m_initOK = false;
        }
        AEnv.positionCenterWindow(Env.getWindow(WindowNo), this);
    }

    private void jbInit() throws Exception {
        this.centerPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.northPanel.setLayout(this.northLayout);
        this.paymentLabel.setText(Msg.translate(Env.getCtx(), "PaymentRule"));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.paymentLabel, null);
        this.northPanel.add((Component)this.paymentCombo, null);
        this.centerPanel.setLayout(this.centerLayout);
        this.kPanel.setLayout(this.kLayout);
        this.kNumberField.setPreferredSize(new Dimension(160, 21));
        this.kNameField.setPreferredSize(new Dimension(160, 21));
        this.kExpField.setPreferredSize(new Dimension(40, 21));
        this.kApprovalField.setPreferredSize(new Dimension(120, 21));
        this.kTypeLabel.setText(Msg.translate(Env.getCtx(), "CreditCardType"));
        this.kNumberLabel.setText(Msg.translate(Env.getCtx(), "CreditCardNumber"));
        this.kNameLabel.setText(Msg.translate(Env.getCtx(), "Name"));
        this.kExpLabel.setText(Msg.getMsg(Env.getCtx(), "Expires"));
        this.kApprovalLabel.setText(Msg.translate(Env.getCtx(), "VoiceAuthCode"));
        this.kAmountLabel.setText(Msg.getMsg(Env.getCtx(), "Amount"));
        this.kOnline.setText(Msg.getMsg(Env.getCtx(), "Online"));
        this.kOnline.addActionListener(this);
        this.kStatus.setText(" ");
        this.centerPanel.add((Component)this.kPanel, "kPanel");
        this.centerLayout.addLayoutComponent(this.kPanel, "kPanel");
        this.kPanel.add((Component)this.kTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.kPanel.add((Component)this.kTypeCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.kPanel.add((Component)this.kNumberLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.kPanel.add((Component)this.kNumberField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 5, 2, 5), 0, 0));
        this.kPanel.add((Component)this.kNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.kPanel.add((Component)this.kNameField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 5, 2, 5), 0, 0));
        this.kPanel.add((Component)this.kExpLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.kPanel.add((Component)this.kExpField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.kPanel.add((Component)this.kAmountLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 5, 0), 0, 0));
        this.kPanel.add((Component)this.kAmountField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 5), 0, 0));
        this.kPanel.add((Component)this.kApprovalLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.kPanel.add((Component)this.kApprovalField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.kPanel.add((Component)this.kStatus, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.kPanel.add((Component)this.kOnline, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tPanel.setLayout(this.tPanelLayout);
        this.tAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BP_BankAccount_ID"));
        this.tRoutingField.setColumns(8);
        this.tNumberField.setColumns(10);
        this.tRoutingText.setText(Msg.translate(Env.getCtx(), "RoutingNo"));
        this.tNumberText.setText(Msg.translate(Env.getCtx(), "AccountNo"));
        this.tOnline.setText(Msg.getMsg(Env.getCtx(), "Online"));
        this.tStatus.setText(" ");
        this.centerPanel.add((Component)this.tPanel, "tPanel");
        this.centerLayout.addLayoutComponent(this.tPanel, "tPanel");
        this.tPanel.add((Component)this.tAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.tPanel.add((Component)this.tAccountCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tPanel.add((Component)this.tRoutingField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.tPanel.add((Component)this.tNumberField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.tPanel.add((Component)this.tStatus, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tPanel.add((Component)this.tRoutingText, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.tPanel.add((Component)this.tNumberText, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.tPanel.add((Component)this.tOnline, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.sPanel.setLayout(this.sPanelLayout);
        this.sBankAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.sAmountLabel.setText(Msg.getMsg(Env.getCtx(), "Amount"));
        this.sRoutingLabel.setText(Msg.translate(Env.getCtx(), "RoutingNo"));
        this.sNumberLabel.setText(Msg.translate(Env.getCtx(), "AccountNo"));
        this.sCheckLabel.setText(Msg.translate(Env.getCtx(), "CheckNo"));
        this.sCheckField.setColumns(8);
        this.sCurrencyLabel.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.sNumberField.setPreferredSize(new Dimension(100, 21));
        this.sRoutingField.setPreferredSize(new Dimension(70, 21));
        this.sStatus.setText(" ");
        this.sOnline.setText(Msg.getMsg(Env.getCtx(), "Online"));
        this.centerPanel.add((Component)this.sPanel, "sPanel");
        this.centerLayout.addLayoutComponent(this.sPanel, "sPanel");
        this.sPanel.add((Component)this.sBankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sBankAccountCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.sPanel.add((Component)this.sCurrencyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sCurrencyCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.sPanel.add((Component)this.sAmountLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 5, 0), 0, 0));
        this.sPanel.add((Component)this.sAmountField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 5), 0, 0));
        this.sPanel.add((Component)this.sRoutingLabel, new GridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sRoutingField, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sNumberLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sNumberField, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sCheckLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sCheckField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sOnline, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.sPanel.add((Component)this.sStatus, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pPanel.setLayout(this.pPanelLayout);
        this.pTermLabel.setText(Msg.translate(Env.getCtx(), "C_PaymentTerm_ID"));
        this.centerPanel.add((Component)this.pPanel, "pPanel");
        this.centerLayout.addLayoutComponent(this.pPanel, "pPanel");
        this.pPanel.add((Component)this.pTermLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 0), 0, 0));
        this.pPanel.add((Component)this.pTermCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.bCurrencyLabel.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.bPanel.setLayout(this.bPanelLayout);
        this.bAmountLabel.setText(Msg.getMsg(Env.getCtx(), "Amount"));
        this.bDateLabel.setText(Msg.translate(Env.getCtx(), "DateAcct"));
        this.centerLayout.addLayoutComponent(this.bPanel, "bPanel");
        this.centerPanel.add((Component)this.bPanel, "bPanel");
        if (this.m_Cash_As_Payment) {
            this.sBankAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
            this.bPanel.add((Component)this.sBankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
            this.bPanel.add((Component)this.sBankAccountCombo, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        } else {
            this.bCashBookLabel.setText(Msg.translate(Env.getCtx(), "C_CashBook_ID"));
            this.bPanel.add((Component)this.bCashBookLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
            this.bPanel.add((Component)this.bCashBookCombo, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        }
        this.bPanel.add((Component)this.bCurrencyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.bPanel.add((Component)this.bCurrencyCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.bPanel.add((Component)this.bDateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.bPanel.add((Component)this.bDateField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.bPanel.add((Component)this.bAmountLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.bPanel.add((Component)this.bAmountField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
    }

    private boolean dynInit(VButton button) throws Exception {
        KeyNamePair pp;
        String name;
        CPreparedStatement pstmt;
        KeyNamePair kp;
        Integer C_Currency_ID;
        this.m_DocStatus = (String)this.m_mTab.getValue("DocStatus");
        log.config(this.m_DocStatus);
        if (this.m_mTab.getValue("C_BPartner_ID") == null) {
            ADialog.error(0, this, "SaveErrorRowNotFound");
            return false;
        }
        this.m_DocStatus = (String)this.m_mTab.getValue("DocStatus");
        if (this.m_DocStatus == null) {
            this.m_DocStatus = "";
        }
        if (this.m_DocStatus.equals("RE") || this.m_DocStatus.equals("VO") || this.m_DocStatus.equals("CL")) {
            return false;
        }
        this.m_onlyRule = !this.m_DocStatus.equals("CO") && !this.m_DocStatus.equals("WP");
        if (!this.m_onlyRule && !this.m_isSOTrx && this.m_mTab.getValue("M_Warehouse_ID") != null) {
            this.m_onlyRule = true;
        }
        this.centerPanel.setVisible(!this.m_onlyRule);
        this.m_Amount = (BigDecimal)this.m_mTab.getValue("GrandTotal");
        if (!this.m_onlyRule && this.m_Amount.compareTo(Env.ZERO) == 0) {
            ADialog.error(this.m_WindowNo, this, "PaymentZero");
            return false;
        }
        this.bAmountField.setValue(this.m_Amount);
        this.sAmountField.setValue(this.m_Amount);
        this.kAmountField.setValue(this.m_Amount);
        this.m_AD_Client_ID = (Integer)this.m_mTab.getValue("AD_Client_ID");
        this.m_Cash_As_Payment = MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.m_AD_Client_ID);
        this.m_AD_Org_ID = (Integer)this.m_mTab.getValue("AD_Org_ID");
        this.m_C_BPartner_ID = (Integer)this.m_mTab.getValue("C_BPartner_ID");
        this.m_PaymentRule = (String)this.m_mTab.getValue("PaymentRule");
        this.m_C_Currency_ID = (Integer)this.m_mTab.getValue("C_Currency_ID");
        this.m_DateAcct = (Timestamp)this.m_mTab.getValue("DateAcct");
        if (this.m_mTab.getValue("C_PaymentTerm_ID") != null) {
            this.m_C_PaymentTerm_ID = (Integer)this.m_mTab.getValue("C_PaymentTerm_ID");
        }
        if (this.m_mTab.getValue("C_Payment_ID") != null) {
            this.m_C_Payment_ID = (Integer)this.m_mTab.getValue("C_Payment_ID");
            if (this.m_C_Payment_ID != 0) {
                this.m_mPayment = new MPayment(Env.getCtx(), this.m_C_Payment_ID, null);
                this.m_mPaymentOriginal = new MPayment(Env.getCtx(), this.m_C_Payment_ID, null);
                this.m_CCType = this.m_mPayment.getCreditCardType();
                this.kNumberField.setText(this.m_mPayment.getCreditCardNumber());
                this.kNameField.setText(this.m_mPayment.getA_Name());
                this.kExpField.setText(this.m_mPayment.getCreditCardExp(null));
                this.kApprovalField.setText(this.m_mPayment.getVoiceAuthCode());
                this.kStatus.setText(this.m_mPayment.getR_PnRef());
                this.kAmountField.setValue(this.m_mPayment.getPayAmt());
                this.kTypeCombo.setReadWrite(!this.m_mPayment.isApproved());
                this.kNumberField.setReadWrite(!this.m_mPayment.isApproved());
                this.kNameField.setReadWrite(!this.m_mPayment.isApproved());
                this.kExpField.setReadWrite(!this.m_mPayment.isApproved());
                this.kApprovalField.setReadWrite(!this.m_mPayment.isApproved());
                this.kOnline.setReadWrite(!this.m_mPayment.isApproved());
                this.kAmountField.setReadWrite(!this.m_mPayment.isApproved());
                this.m_C_BankAccount_ID = this.m_mPayment.getC_BankAccount_ID();
                this.sRoutingField.setText(this.m_mPayment.getRoutingNo());
                this.sNumberField.setText(this.m_mPayment.getAccountNo());
                this.sCheckField.setText(this.m_mPayment.getCheckNo());
                this.sStatus.setText(this.m_mPayment.getR_PnRef());
                this.sAmountField.setValue(this.m_mPayment.getPayAmt());
                this.tRoutingField.setText(this.m_mPayment.getRoutingNo());
                this.tNumberField.setText(this.m_mPayment.getAccountNo());
                this.tStatus.setText(this.m_mPayment.getR_PnRef());
                this.bAmountField.setValue(this.m_mPayment.getPayAmt());
            }
        }
        if (this.m_mPayment == null) {
            this.m_mPayment = new MPayment(Env.getCtx(), 0, null);
            this.m_mPayment.setAD_Org_ID(this.m_AD_Org_ID);
            this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
        }
        this.m_cashLine = null;
        this.m_C_CashLine_ID = 0;
        if (this.m_mTab.getValue("C_CashLine_ID") != null) {
            this.m_C_CashLine_ID = (Integer)this.m_mTab.getValue("C_CashLine_ID");
            if (this.m_C_CashLine_ID == 0) {
                this.m_cashLine = null;
            } else {
                this.m_cashLine = new MCashLine(Env.getCtx(), this.m_C_CashLine_ID, null);
                this.m_DateAcct = this.m_cashLine.getStatementDate();
                this.m_C_CashBook_ID = this.m_cashLine.getCashBook().getC_CashBook_ID();
                this.bAmountField.setValue(this.m_cashLine.getAmount());
            }
        }
        this.bDateField.setValue(this.m_DateAcct);
        if (s_Currencies == null) {
            this.loadCurrencies();
        }
        if (s_Currencies.containsKey(C_Currency_ID = new Integer(this.m_C_Currency_ID))) {
            Enumeration<Integer> en = s_Currencies.keys();
            while (en.hasMoreElements()) {
                Integer key = en.nextElement();
                this.bCurrencyCombo.addItem(s_Currencies.get(key));
                this.sCurrencyCombo.addItem(s_Currencies.get(key));
            }
            this.sCurrencyCombo.addActionListener(this);
            this.sCurrencyCombo.setSelectedItem(s_Currencies.get(C_Currency_ID));
            this.bCurrencyCombo.addActionListener(this);
            this.bCurrencyCombo.setSelectedItem(s_Currencies.get(C_Currency_ID));
        } else {
            this.bCurrencyLabel.setVisible(false);
            this.bCurrencyCombo.setVisible(false);
            this.sCurrencyLabel.setVisible(false);
            this.sCurrencyCombo.setVisible(false);
        }
        if (this.m_PaymentRule == null) {
            this.m_PaymentRule = "";
        }
        ValueNamePair vp = null;
        HashMap values = button.getValues();
        Object[] a = values.keySet().toArray();
        int i = 0;
        while (i < a.length) {
            String PaymentRule = (String)a[i];
            if (!("D".equals(PaymentRule) && !this.m_isSOTrx || "T".equals(PaymentRule) && this.m_isSOTrx)) {
                ValueNamePair pp2 = new ValueNamePair(PaymentRule, (String)values.get(a[i]));
                this.paymentCombo.addItem(pp2);
                if (PaymentRule.toString().equals(this.m_PaymentRule)) {
                    vp = pp2;
                }
            }
            ++i;
        }
        this.paymentCombo.addActionListener(this);
        if (vp != null) {
            this.paymentCombo.setSelectedItem(vp);
        }
        if ((kp = this.refreshPaymentCombo(this.m_PaymentRule)) != null) {
            this.pTermCombo.setSelectedItem(kp);
        }
        String SQL = "SELECT a.C_BP_BankAccount_ID, NVL(b.Name, ' ')||a.AccountNo AS Acct FROM C_BP_BankAccount a,C_Bank b WHERE a.C_BPartner_ID=? AND a.IsActive='Y'";
        kp = null;
        try {
            CPreparedStatement pstmt2 = DB.prepareStatement(SQL, null);
            pstmt2.setInt(1, this.m_C_BPartner_ID);
            ResultSet rs = pstmt2.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                String name2 = rs.getString(2);
                KeyNamePair pp3 = new KeyNamePair(key, name2);
                this.tAccountCombo.addItem(pp3);
            }
            rs.close();
            pstmt2.close();
        }
        catch (SQLException eac) {
            log.log(Level.SEVERE, SQL, eac);
        }
        if (kp != null) {
            this.tAccountCombo.setSelectedItem(kp);
        }
        ValueNamePair[] ccs = this.m_mPayment.getCreditCards();
        vp = null;
        int i2 = 0;
        while (i2 < ccs.length) {
            this.kTypeCombo.addItem(ccs[i2]);
            if (ccs[i2].getValue().equals(this.m_CCType)) {
                vp = ccs[i2];
            }
            ++i2;
        }
        if (vp != null) {
            this.kTypeCombo.setSelectedItem(vp);
        }
        SQL = MRole.getDefault().addAccessSQL("SELECT C_BankAccount_ID, Name || ' ' || AccountNo, IsDefault FROM C_BankAccount ba INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) WHERE b.IsActive='Y'", "ba", true, false);
        kp = null;
        try {
            pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                name = rs.getString(2);
                pp = new KeyNamePair(key, name);
                this.sBankAccountCombo.addItem(pp);
                if (key == this.m_C_BankAccount_ID) {
                    kp = pp;
                }
                if (kp != null || !rs.getString(3).equals("Y")) continue;
                kp = pp;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException ept) {
            log.log(Level.SEVERE, SQL, ept);
        }
        if (kp != null) {
            this.sBankAccountCombo.setSelectedItem(kp);
        }
        SQL = MRole.getDefault().addAccessSQL("SELECT C_CashBook_ID, Name, AD_Org_ID FROM C_CashBook WHERE IsActive='Y'", "C_CashBook", false, false);
        kp = null;
        try {
            pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                name = rs.getString(2);
                pp = new KeyNamePair(key, name);
                this.bCashBookCombo.addItem(pp);
                if (key == this.m_C_CashBook_ID) {
                    kp = pp;
                }
                if (kp != null || key != this.m_AD_Org_ID) continue;
                kp = pp;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException epc) {
            log.log(Level.SEVERE, SQL, epc);
        }
        if (kp != null) {
            this.bCashBookCombo.setSelectedItem(kp);
            if (this.m_C_CashBook_ID == 0) {
                this.m_C_CashBook_ID = kp.getKey();
            }
        }
        return true;
    }

    public boolean isInitOK() {
        return this.m_initOK;
    }

    private void loadCurrencies() {
        s_Currencies = new Hashtable(12);
        String SQL = "SELECT C_Currency_ID, ISO_Code FROM C_Currency WHERE (IsEMUMember='Y' AND EMUEntryDate<SysDate) OR IsEuro='Y' ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                String name = rs.getString(2);
                s_Currencies.put(new Integer(id), new KeyNamePair(id, name));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.fine("VPayment.actionPerformed - " + e.getActionCommand());
        if (e.getActionCommand().equals("Ok")) {
            if (this.checkMandatory()) {
                this.saveChanges();
                this.dispose();
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getSource() == this.paymentCombo) {
            ValueNamePair pp = (ValueNamePair)this.paymentCombo.getSelectedItem();
            if (pp != null) {
                String s = pp.getValue().toLowerCase();
                if ("D".equalsIgnoreCase(s)) {
                    s = "T".toLowerCase();
                }
                if ("r".equalsIgnoreCase(s)) {
                    s = "P".toLowerCase();
                }
                if ("P".equalsIgnoreCase(s)) {
                    this.refreshPaymentCombo(pp.getValue());
                }
                s = String.valueOf(s) + "Panel";
                this.centerLayout.show(this.centerPanel, s);
                int C_Invoice_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_Invoice_ID");
                MInvoice invoice_tmp = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
                if (!invoice_tmp.isSOTrx()) {
                    this.bAmountField.setValue(this.m_Amount.negate());
                } else {
                    this.bAmountField.setValue(this.m_Amount);
                }
                invoice_tmp = null;
            }
        } else if (e.getSource() == this.sCurrencyCombo) {
            KeyNamePair pp = (KeyNamePair)this.sCurrencyCombo.getSelectedItem();
            BigDecimal amt = MConversionRate.convert(Env.getCtx(), this.m_Amount, this.m_C_Currency_ID, pp.getKey(), this.m_AD_Client_ID, this.m_AD_Org_ID);
            this.sAmountField.setValue(amt);
        } else if (e.getSource() == this.bCurrencyCombo) {
            KeyNamePair pp = (KeyNamePair)this.bCurrencyCombo.getSelectedItem();
            BigDecimal amt = MConversionRate.convert(Env.getCtx(), this.m_Amount, this.m_C_Currency_ID, pp.getKey(), this.m_AD_Client_ID, this.m_AD_Org_ID);
            this.bAmountField.setValue(amt);
        } else if (e.getSource() == this.kOnline || e.getSource() == this.sOnline) {
            this.processOnline();
        }
    }

    private boolean saveChanges() {
        final boolean[] success = new boolean[1];
        TrxRunnable r = new TrxRunnable(){

            @Override
            public void run(String trxName) {
                success[0] = VPayment.this.saveChangesInTrx(trxName);
            }
        };
        try {
            Trx.run(r);
        }
        catch (Throwable e) {
            success[0] = false;
            ADialog.error(this.m_WindowNo, this, "PaymentError", e.getLocalizedMessage());
        }
        if (this.m_cashLine != null) {
            this.m_cashLine.set_TrxName(null);
        }
        if (this.m_mPayment != null) {
            this.m_mPayment.set_TrxName(null);
        }
        if (this.m_mPaymentOriginal != null) {
            this.m_mPayment.set_TrxName(null);
        }
        return success[0];
    }

    private boolean saveChangesInTrx(String trxName) {
        KeyNamePair kp;
        String payTypes;
        if (this.m_cashLine != null) {
            this.m_cashLine.set_TrxName(trxName);
        }
        if (this.m_mPayment != null) {
            this.m_mPayment.set_TrxName(trxName);
        }
        if (this.m_mPaymentOriginal != null) {
            this.m_mPaymentOriginal.set_TrxName(trxName);
        }
        ValueNamePair vp = (ValueNamePair)this.paymentCombo.getSelectedItem();
        String newPaymentRule = vp.getValue();
        log.info("New Rule: " + newPaymentRule);
        if (this.m_onlyRule) {
            if (!newPaymentRule.equals(this.m_PaymentRule)) {
                this.m_mTab.setValue("PaymentRule", (Object)newPaymentRule);
            }
            return true;
        }
        Timestamp newDateAcct = this.m_DateAcct;
        int newC_PaymentTerm_ID = this.m_C_PaymentTerm_ID;
        int newC_CashLine_ID = this.m_C_CashLine_ID;
        int newC_CashBook_ID = this.m_C_CashBook_ID;
        String newCCType = this.m_CCType;
        int newC_BankAccount_ID = 0;
        String string = payTypes = this.m_Cash_As_Payment ? "KTSDB" : "KTSD";
        if (newPaymentRule.equals("B")) {
            if (this.m_Cash_As_Payment) {
                kp = (KeyNamePair)this.sBankAccountCombo.getSelectedItem();
                if (kp != null) {
                    newC_BankAccount_ID = kp.getKey();
                }
            } else {
                kp = (KeyNamePair)this.bCashBookCombo.getSelectedItem();
                if (kp != null) {
                    newC_CashBook_ID = kp.getKey();
                }
            }
            newDateAcct = (Timestamp)this.bDateField.getValue();
            this.m_mPayment.setAmount(this.m_C_Currency_ID, (BigDecimal)this.bAmountField.getValue());
            this.m_Amount = (BigDecimal)this.bAmountField.getValue();
        } else if (newPaymentRule.equals("K")) {
            vp = (ValueNamePair)this.kTypeCombo.getSelectedItem();
            if (vp != null) {
                newCCType = vp.getValue();
            }
        } else if (newPaymentRule.equals("T") || newPaymentRule.equals("D")) {
            this.tAccountCombo.getSelectedItem();
        } else if (newPaymentRule.equals("P") || newPaymentRule.equals("R")) {
            kp = (KeyNamePair)this.pTermCombo.getSelectedItem();
            if (kp != null) {
                newC_PaymentTerm_ID = kp.getKey();
            }
        } else if (newPaymentRule.equals("S")) {
            kp = (KeyNamePair)this.sBankAccountCombo.getSelectedItem();
            if (kp != null) {
                newC_BankAccount_ID = kp.getKey();
            }
        } else {
            return false;
        }
        if (!newPaymentRule.equals(this.m_PaymentRule)) {
            log.fine("Changed PaymentRule: " + this.m_PaymentRule + " -> " + newPaymentRule);
            if (this.m_PaymentRule.equals("B") && !this.m_Cash_As_Payment) {
                log.fine("Old Cash - " + this.m_cashLine);
                if (this.m_cashLine != null) {
                    MCashLine cl = this.m_cashLine.createReversal();
                    cl.saveEx();
                }
                newC_CashLine_ID = 0;
            } else if (payTypes.indexOf(this.m_PaymentRule) != -1 && payTypes.indexOf(newPaymentRule) != -1 && this.m_mPaymentOriginal != null) {
                log.fine("Old Payment(1) - " + this.m_mPaymentOriginal);
                this.m_mPaymentOriginal.setDocAction("RC");
                boolean ok = this.m_mPaymentOriginal.processIt("RC");
                this.m_mPaymentOriginal.saveEx();
                if (ok) {
                    log.info("Payment Cancelled - " + this.m_mPaymentOriginal);
                } else {
                    ADialog.error(this.m_WindowNo, this, "PaymentError", "PaymentNotCancelled " + this.m_mPaymentOriginal.getDocumentNo());
                }
                this.m_mPayment.resetNew();
            } else if (payTypes.indexOf(this.m_PaymentRule) != -1 && payTypes.indexOf(newPaymentRule) == -1) {
                log.fine("Old Payment(2) - " + this.m_mPaymentOriginal);
                if (this.m_mPaymentOriginal != null) {
                    this.m_mPaymentOriginal.setDocAction("RC");
                    boolean ok = this.m_mPaymentOriginal.processIt("RC");
                    this.m_mPaymentOriginal.saveEx();
                    if (ok) {
                        log.fine("PaymentCancelled " + this.m_mPayment.getDocumentNo());
                        this.m_mTab.getTableModel().dataSave(true);
                        this.m_mPayment.resetNew();
                        this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
                    } else {
                        ADialog.error(this.m_WindowNo, this, "PaymentError", "PaymentNotCancelled " + this.m_mPayment.getDocumentNo());
                    }
                }
            }
        }
        int C_Order_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_Order_ID");
        int C_Invoice_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_Invoice_ID");
        if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
            C_Invoice_ID = VPayment.getInvoiceID(C_Order_ID, trxName);
        }
        boolean negateAmt = false;
        MInvoice invoice = null;
        if (C_Invoice_ID != 0) {
            invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, trxName);
            negateAmt = invoice.isCreditMemo();
        }
        MOrder order = null;
        if (invoice == null && C_Order_ID != 0) {
            order = new MOrder(Env.getCtx(), C_Order_ID, trxName);
        }
        BigDecimal payAmount = this.m_Amount;
        if (negateAmt) {
            payAmount = this.m_Amount.negate();
        }
        log.config("C_Order_ID=" + C_Order_ID + ", C_Invoice_ID=" + C_Invoice_ID + ", NegateAmt=" + negateAmt);
        if (newPaymentRule.equals("B") && !this.m_Cash_As_Payment) {
            log.fine("Cash");
            if (C_Invoice_ID == 0 && order == null) {
                log.config("No Invoice!");
                ADialog.error(this.m_WindowNo, this, "PaymentError", "CashNotCreated");
            } else {
                payAmount = (BigDecimal)this.bAmountField.getValue();
                if (this.m_cashLine != null && payAmount.compareTo(this.m_cashLine.getAmount()) != 0) {
                    log.config("Changed CashBook Amount");
                    this.m_cashLine.setAmount((BigDecimal)this.bAmountField.getValue());
                    this.m_cashLine.saveEx();
                    log.config("CashAmt Changed");
                }
                if (!(this.m_cashLine == null || newC_CashBook_ID == this.m_C_CashBook_ID && TimeUtil.isSameDay(this.m_cashLine.getStatementDate(), newDateAcct))) {
                    log.config("Changed CashBook/Date: " + this.m_C_CashBook_ID + "->" + newC_CashBook_ID);
                    MCashLine reverse = this.m_cashLine.createReversal();
                    reverse.saveEx();
                    this.m_cashLine = null;
                }
                if (this.m_cashLine == null) {
                    log.config("New CashBook");
                    int C_Currency_ID = 0;
                    if (invoice != null) {
                        C_Currency_ID = invoice.getC_Currency_ID();
                    }
                    if (C_Currency_ID == 0 && order != null) {
                        C_Currency_ID = order.getC_Currency_ID();
                    }
                    MCash cash = null;
                    cash = newC_CashBook_ID != 0 ? MCash.get(Env.getCtx(), newC_CashBook_ID, newDateAcct, trxName) : MCash.get(Env.getCtx(), this.m_AD_Org_ID, newDateAcct, C_Currency_ID, trxName);
                    if (cash == null || cash.get_ID() == 0) {
                        ADialog.error(this.m_WindowNo, this, "PaymentError", CLogger.retrieveErrorString("CashNotCreated"));
                    } else {
                        MCashLine cl = new MCashLine(cash);
                        if (invoice != null) {
                            cl.setInvoice(invoice);
                        }
                        if (order != null) {
                            cl.setOrder(order, trxName);
                            this.m_needSave = true;
                        }
                        cl.setAmount((BigDecimal)this.bAmountField.getValue());
                        cl.saveEx();
                        log.config("CashCreated");
                        if (invoice == null && C_Invoice_ID != 0) {
                            invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, trxName);
                        }
                        if (invoice != null) {
                            invoice.setC_CashLine_ID(cl.getC_CashLine_ID());
                            invoice.saveEx(trxName);
                        }
                        if (order == null && C_Order_ID != 0) {
                            order = new MOrder(Env.getCtx(), C_Order_ID, trxName);
                        }
                        if (order != null) {
                            order.setC_CashLine_ID(cl.getC_CashLine_ID());
                            order.saveEx(trxName);
                        }
                        log.config("Update Order & Invoice with CashLine");
                    }
                }
            }
        }
        if ("KS".indexOf(newPaymentRule) != -1 || newPaymentRule.equals("B") && this.m_Cash_As_Payment) {
            log.fine("Payment - " + newPaymentRule);
            this.m_mPayment.setAmount(this.m_C_Currency_ID, payAmount);
            if (newPaymentRule.equals("K")) {
                this.m_mPayment.setCreditCard("S", newCCType, this.kNumberField.getText(), "", this.kExpField.getText());
                this.m_mPayment.setA_Name(this.kNameField.getText());
                this.m_mPayment.setAmount(this.m_C_Currency_ID, (BigDecimal)this.kAmountField.getValue());
                this.m_mPayment.setPaymentProcessor();
            } else if (newPaymentRule.equals("T") || newPaymentRule.equals("D")) {
                this.m_mPayment.setBankACH(newC_BankAccount_ID, this.m_isSOTrx, newPaymentRule, this.tRoutingField.getText(), this.tNumberField.getText());
                this.m_mPayment.setAmount(this.m_C_Currency_ID, payAmount);
            } else if (newPaymentRule.equals("S")) {
                this.m_mPayment.setBankCheck(newC_BankAccount_ID, this.m_isSOTrx, this.sRoutingField.getText(), this.sNumberField.getText(), this.sCheckField.getText());
                this.m_mPayment.setAmount(this.m_C_Currency_ID, (BigDecimal)this.sAmountField.getValue());
            } else if (newPaymentRule.equals("B")) {
                this.m_mPayment.setTenderType("X");
                this.m_mPayment.setBankCash(newC_BankAccount_ID, this.m_isSOTrx, "X");
                this.m_mPayment.setAmount(this.m_C_Currency_ID, payAmount);
            }
            this.m_mPayment.setC_BPartner_ID(this.m_C_BPartner_ID);
            this.m_mPayment.setC_Invoice_ID(C_Invoice_ID);
            if (order != null) {
                this.m_mPayment.setC_Order_ID(C_Order_ID);
                this.m_needSave = true;
            }
            this.m_mPayment.setDateTrx(this.m_DateAcct);
            this.m_mPayment.setDateAcct(this.m_DateAcct);
            this.m_mPayment.saveEx();
            if (this.m_mPayment.get_ID() > 0 && "DR".equals(this.m_mPayment.getDocStatus())) {
                boolean ok = this.m_mPayment.processIt("CO");
                this.m_mPayment.saveEx();
                if (ok) {
                    ADialog.info(this.m_WindowNo, this, "PaymentCreated", this.m_mPayment.getDocumentNo());
                } else {
                    ADialog.error(this.m_WindowNo, this, "PaymentError", "PaymentNotCreated");
                }
            } else {
                log.fine("NotDraft " + this.m_mPayment);
            }
        }
        log.config("Saving changes");
        if (!newPaymentRule.equals(this.m_PaymentRule)) {
            this.m_mTab.setValue("PaymentRule", (Object)newPaymentRule);
        }
        if (!newDateAcct.equals(this.m_DateAcct)) {
            this.m_mTab.setValue("DateAcct", (Object)newDateAcct);
        }
        if (newC_PaymentTerm_ID != this.m_C_PaymentTerm_ID) {
            this.m_mTab.setValue("C_PaymentTerm_ID", (Object)new Integer(newC_PaymentTerm_ID));
        }
        if (this.m_mPayment.getC_Payment_ID() != this.m_C_Payment_ID) {
            if (this.m_mPayment.getC_Payment_ID() == 0) {
                this.m_mTab.setValue("C_Payment_ID", null);
            } else {
                this.m_mTab.setValue("C_Payment_ID", (Object)new Integer(this.m_mPayment.getC_Payment_ID()));
            }
        }
        if (newC_CashLine_ID != this.m_C_CashLine_ID) {
            if (newC_CashLine_ID == 0) {
                this.m_mTab.setValue("C_CashLine_ID", null);
            } else {
                this.m_mTab.setValue("C_CashLine_ID", (Object)new Integer(newC_CashLine_ID));
            }
        }
        return true;
    }

    private boolean checkMandatory() {
        log.config("VPayment.checkMandatory");
        ValueNamePair vp = (ValueNamePair)this.paymentCombo.getSelectedItem();
        String PaymentRule = vp.getValue();
        if (this.m_onlyRule) {
            return true;
        }
        String CCType = this.m_CCType;
        int C_BankAccount_ID = 0;
        boolean dataOK = true;
        if (PaymentRule.equals("B")) {
            KeyNamePair kp;
            if (this.m_Cash_As_Payment && (kp = (KeyNamePair)this.sBankAccountCombo.getSelectedItem()) != null) {
                C_BankAccount_ID = kp.getKey();
            }
        } else if (PaymentRule.equals("K")) {
            vp = (ValueNamePair)this.kTypeCombo.getSelectedItem();
            if (vp != null) {
                CCType = vp.getValue();
            }
        } else if (PaymentRule.equals("T") || PaymentRule.equals("D")) {
            KeyNamePair bpba = (KeyNamePair)this.tAccountCombo.getSelectedItem();
            if (bpba == null) {
                this.tAccountCombo.setBackground(AdempierePLAF.getFieldBackground_Error());
                ADialog.error(this.m_WindowNo, this, "PaymentBPBankNotFound");
                dataOK = false;
            }
        } else if (!PaymentRule.equals("P") && !PaymentRule.equals("R")) {
            if (PaymentRule.equals("S")) {
                String error;
                KeyNamePair kp = (KeyNamePair)this.sBankAccountCombo.getSelectedItem();
                if (kp != null) {
                    C_BankAccount_ID = kp.getKey();
                }
                if ((error = MPaymentValidate.validateRoutingNo(this.sRoutingField.getText())).length() != 0) {
                    this.sRoutingField.setBackground(AdempierePLAF.getFieldBackground_Error());
                    ADialog.error(this.m_WindowNo, this, error);
                    dataOK = false;
                }
                if ((error = MPaymentValidate.validateAccountNo(this.sNumberField.getText())).length() != 0) {
                    this.sNumberField.setBackground(AdempierePLAF.getFieldBackground_Error());
                    ADialog.error(this.m_WindowNo, this, error);
                    dataOK = false;
                }
                if ((error = MPaymentValidate.validateCheckNo(this.sCheckField.getText())).length() != 0) {
                    this.sCheckField.setBackground(AdempierePLAF.getFieldBackground_Error());
                    ADialog.error(this.m_WindowNo, this, error);
                    dataOK = false;
                }
            } else {
                log.log(Level.SEVERE, "Unknown PaymentRule " + PaymentRule);
                ADialog.error(this.m_WindowNo, this, "Unknown PaymentRule " + PaymentRule);
                return false;
            }
        }
        if (("KTSD".indexOf(PaymentRule) != -1 || PaymentRule.equals("B") && this.m_Cash_As_Payment) && C_BankAccount_ID == 0 && (C_BankAccount_ID == 0 && PaymentRule.equals("S") || PaymentRule.equals("B") && this.m_Cash_As_Payment)) {
            ADialog.error(this.m_WindowNo, this, "PaymentNoProcessor");
            dataOK = false;
        }
        log.config("OK=" + dataOK);
        return dataOK;
    }

    private static int getInvoiceID(int C_Order_ID, String trxName) {
        int retValue = 0;
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=? ORDER BY C_Invoice_ID DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_Order_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        return retValue;
    }

    private void processOnline() {
        log.config("");
        if (!this.checkMandatory()) {
            return;
        }
        boolean approved = false;
        String info = "";
        ValueNamePair vp = (ValueNamePair)this.paymentCombo.getSelectedItem();
        String PaymentRule = vp.getValue();
        if (PaymentRule.equals("K")) {
            vp = (ValueNamePair)this.kTypeCombo.getSelectedItem();
            String CCType = vp.getValue();
            this.m_mPayment.setCreditCard("S", CCType, this.kNumberField.getText(), "", this.kExpField.getText());
            this.m_mPayment.setA_Name(this.kNameField.getText());
            this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
            this.m_mPayment.setPaymentProcessor();
            this.m_mPayment.setC_BPartner_ID(this.m_C_BPartner_ID);
            int C_Invoice_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_Invoice_ID");
            int C_Order_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_Order_ID");
            if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
                C_Invoice_ID = VPayment.getInvoiceID(C_Order_ID, null);
            }
            if (C_Invoice_ID != 0) {
                this.m_mPayment.setC_Invoice_ID(C_Invoice_ID);
            } else if (C_Order_ID != 0) {
                this.m_mPayment.setC_Order_ID(C_Order_ID);
            }
            this.m_mPayment.setDateTrx(this.m_DateAcct);
            this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
            if (!this.m_mPayment.save()) {
                ADialog.error(this.m_WindowNo, this, "PaymentError", "PaymentNotCreated");
            } else {
                approved = this.m_mPayment.processOnline();
                info = String.valueOf(this.m_mPayment.getR_RespMsg()) + " (" + this.m_mPayment.getR_AuthCode() + ") ID=" + this.m_mPayment.getR_PnRef();
                this.m_mPayment.save();
                if (approved) {
                    boolean ok = this.m_mPayment.processIt("CO");
                    this.m_mPayment.save();
                    if (ok) {
                        ADialog.info(this.m_WindowNo, this, "PaymentProcessed", String.valueOf(info) + "\n" + this.m_mPayment.getDocumentNo());
                    } else {
                        ADialog.error(this.m_WindowNo, this, "PaymentError", "PaymentNotCreated");
                    }
                    this.saveChanges();
                    this.dispose();
                } else {
                    ADialog.error(this.m_WindowNo, this, "PaymentNotProcessed", info);
                }
            }
        } else {
            ADialog.error(this.m_WindowNo, this, "PaymentNoProcessor");
        }
    }

    public boolean needSave() {
        return this.m_needSave;
    }

    protected KeyNamePair refreshPaymentCombo(String paymentRule) {
        this.pTermCombo.removeAllItems();
        String SQL = MRole.getDefault().addAccessSQL(SQL_PAYMENT_TERM, "C_PaymentTerm", false, false);
        KeyNamePair kp = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setString(1, paymentRule);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                String name = rs.getString(2);
                KeyNamePair pp = new KeyNamePair(key, name);
                this.pTermCombo.addItem(pp);
                if (key != this.m_C_PaymentTerm_ID) continue;
                kp = pp;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException ept) {
            log.log(Level.SEVERE, SQL, ept);
        }
        return kp;
    }
}

