/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.compiere.apps.AEnv;
import org.compiere.grid.CreateFromShipment;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLocator;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MLocator;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCreateFromShipmentUI
extends CreateFromShipment
implements ActionListener,
VetoableChangeListener {
    private static final int WINDOW_CUSTOMER_RETURN = 53097;
    private static final int WINDOW_RETURN_TO_VENDOR = 53098;
    private VCreateFromDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private JLabel bPartnerLabel = new JLabel();
    private VLookup bPartnerField;
    private JCheckBox oSoloOrdine = new JCheckBox();
    private JCheckBox oSoloTestata = new JCheckBox();
    private JLabel orderLabel = new JLabel();
    private JComboBox orderField = new JComboBox();
    private JLabel invoiceLabel = new JLabel();
    private JComboBox invoiceField = new JComboBox();
    private JLabel rmaLabel = new JLabel();
    private JComboBox rmaField = new JComboBox();
    private JLabel upcLabel = new JLabel();
    private JTextField upcField = new JTextField();
    private JCheckBox sameWarehouseCb = new JCheckBox();
    private JLabel locatorLabel = new JLabel();
    private VLocator locatorField = new VLocator();
    private Boolean IsSOTrx = true;
    private JLabel dataDocaLabel = new JLabel();
    private VDate dataDocaField = new VDate();
    private boolean m_actionActive = false;

    public VCreateFromShipmentUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow(Env.getWindow(this.p_WindowNo), this.dialog);
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.dialog.setTitle(this.getTitle());
        this.IsSOTrx = (Boolean)this.getGridTab().getValue("IsSOTrx");
        MLocatorLookup locator = new MLocatorLookup(Env.getCtx(), this.p_WindowNo);
        this.locatorField = new VLocator("M_Locator_ID", true, false, true, locator, this.p_WindowNo);
        this.sameWarehouseCb.setSelected(false);
        if (this.IsSOTrx.booleanValue()) {
            this.sameWarehouseCb.setSelected(true);
        }
        this.sameWarehouseCb.addActionListener(this);
        this.oSoloOrdine.setSelected(false);
        this.oSoloOrdine.addActionListener(this);
        this.oSoloTestata.setSelected(false);
        this.oSoloTestata.addActionListener(this);
        this.dataDocaField.setMandatory(true);
        this.dataDocaField.setValue(new Timestamp(System.currentTimeMillis()));
        this.dataDocaField.addActionListener(this);
        this.initBPartner(false);
        this.bPartnerField.addVetoableChangeListener(this);
        return true;
    }

    private void jbInit() throws Exception {
        boolean isRMAWindow = this.getGridTab().getAD_Window_ID() == 53098 || this.getGridTab().getAD_Window_ID() == 53097;
        this.bPartnerLabel.setText(Msg.getElement(Env.getCtx(), "C_BPartner_ID"));
        this.oSoloOrdine.setText("OrdiniTutti");
        this.oSoloOrdine.setToolTipText(Msg.getMsg(Env.getCtx(), "OrdiniTutti", false));
        this.orderLabel.setText(Msg.getElement(Env.getCtx(), "C_Order_ID", (boolean)this.IsSOTrx));
        this.locatorLabel.setText(Msg.translate(Env.getCtx(), "M_Locator_ID"));
        this.invoiceLabel.setText(Msg.getElement(Env.getCtx(), "C_Invoice_ID", (boolean)this.IsSOTrx));
        this.sameWarehouseCb.setText(Msg.getMsg(Env.getCtx(), "FromSameWarehouseOnly", true));
        this.sameWarehouseCb.setToolTipText(Msg.getMsg(Env.getCtx(), "FromSameWarehouseOnly", false));
        this.rmaLabel.setText(Msg.translate(Env.getCtx(), "M_RMA_ID"));
        this.upcLabel.setText(Msg.getElement(Env.getCtx(), "UPC", false));
        this.dataDocaLabel.setText("Data Doc A");
        this.dataDocaField.addActionListener(this);
        this.oSoloTestata.setText("SoloTestata");
        this.oSoloTestata.setToolTipText(Msg.getMsg(Env.getCtx(), "SoloTestata", false));
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout(new BorderLayout());
        CPanel parameterStdPanel = new CPanel(new GridBagLayout());
        parameterPanel.add((Component)parameterStdPanel, "Center");
        parameterStdPanel.add((Component)this.bPartnerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bPartnerField != null) {
            parameterStdPanel.add((Component)this.bPartnerField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        if (!isRMAWindow) {
            parameterStdPanel.add((Component)this.oSoloOrdine, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.orderLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.orderField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.invoiceLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.invoiceField, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterStdPanel.add((Component)this.locatorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.locatorField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.sameWarehouseCb, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.upcLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.upcField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.dataDocaLabel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.dataDocaField, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (isRMAWindow) {
            parameterStdPanel.add((Component)this.rmaLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.rmaField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        this.log.config("Action=" + e.getActionCommand());
        if (e.getSource().equals(this.oSoloOrdine)) {
            int C_Order_ID = 0;
            boolean soloOrdine = true;
            Timestamp DataDoca = (Timestamp)this.dataDocaField.getValue();
            this.orderField.setSelectedIndex(-1);
            this.rmaField.setSelectedIndex(-1);
            this.invoiceField.setSelectedIndex(-1);
            this.loadOrder(C_Order_ID, DataDoca, this.bPartnerField.getValue() != null ? (Integer)this.bPartnerField.getValue() : 0, false, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0, soloOrdine, this.IsSOTrx);
        }
        if (e.getSource().equals(this.orderField)) {
            KeyNamePair pp = (KeyNamePair)this.orderField.getSelectedItem();
            Timestamp DataDoca = (Timestamp)this.dataDocaField.getValue();
            int C_Order_ID = 0;
            if (pp != null) {
                C_Order_ID = pp.getKey();
            }
            boolean soloOrdine = false;
            this.oSoloOrdine.setSelected(false);
            this.rmaField.setSelectedIndex(-1);
            this.invoiceField.setSelectedIndex(-1);
            this.loadOrder(C_Order_ID, DataDoca, this.bPartnerField.getValue() != null ? (Integer)this.bPartnerField.getValue() : 0, false, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0, soloOrdine, this.IsSOTrx);
        } else if (e.getSource().equals(this.invoiceField)) {
            KeyNamePair pp = (KeyNamePair)this.invoiceField.getSelectedItem();
            int C_Invoice_ID = 0;
            if (pp != null) {
                C_Invoice_ID = pp.getKey();
            }
            this.orderField.setSelectedIndex(-1);
            this.rmaField.setSelectedIndex(-1);
            this.loadInvoice(C_Invoice_ID, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
        } else if (e.getSource().equals(this.rmaField)) {
            KeyNamePair pp = (KeyNamePair)this.rmaField.getSelectedItem();
            int M_RMA_ID = 0;
            if (pp != null) {
                M_RMA_ID = pp.getKey();
            }
            this.orderField.setSelectedIndex(-1);
            this.invoiceField.setSelectedIndex(-1);
            this.loadRMA(M_RMA_ID, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
        } else if (e.getSource().equals(this.sameWarehouseCb) || e.getSource().equals(this.oSoloTestata) || e.getSource().equals(this.dataDocaField)) {
            this.initBPOrderDetails((Integer)this.bPartnerField.getValue(), false);
        } else if (e.getSource().equals(this.upcField)) {
            this.checkProductUsingUPC();
        }
        this.m_actionActive = false;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            int C_BPartner_ID = (Integer)e.getNewValue();
            this.initBPOrderDetails(C_BPartner_ID, false);
        }
        this.dialog.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 30);
        this.bPartnerField = new VLookup("C_BPartner_ID", true, false, true, lookup);
        int C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
        this.bPartnerField.setValue(new Integer(C_BPartner_ID));
        this.initBPOrderDetails(C_BPartner_ID, forInvoice);
    }

    protected void initBPOrderDetails(int C_BPartner_ID, boolean forInvoice) {
        this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        KeyNamePair pp = new KeyNamePair(0, "");
        this.orderField.removeActionListener(this);
        this.orderField.removeAllItems();
        this.orderField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadOrderData(C_BPartner_ID, forInvoice, this.sameWarehouseCb.isSelected(), this.IsSOTrx);
        for (KeyNamePair knp : list) {
            this.orderField.addItem(knp);
        }
        this.orderField.setSelectedIndex(0);
        this.orderField.addActionListener(this);
        this.dialog.pack();
        this.initBPDetails(C_BPartner_ID);
    }

    public void initBPDetails(int C_BPartner_ID) {
        this.initBPInvoiceDetails(C_BPartner_ID);
        this.initBPRMADetails(C_BPartner_ID);
    }

    private void initBPInvoiceDetails(int C_BPartner_ID) {
        this.log.config("C_BPartner_ID" + C_BPartner_ID);
        this.invoiceField.removeActionListener(this);
        this.invoiceField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.invoiceField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadInvoiceData(C_BPartner_ID, this.IsSOTrx);
        for (KeyNamePair knp : list) {
            this.invoiceField.addItem(knp);
        }
        this.invoiceField.setSelectedIndex(0);
        this.invoiceField.addActionListener(this);
        this.upcField.addActionListener(this);
    }

    private void initBPRMADetails(int C_BPartner_ID) {
        this.rmaField.removeActionListener(this);
        this.rmaField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.rmaField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadRMAData(C_BPartner_ID, this.IsSOTrx);
        for (KeyNamePair knp : list) {
            this.rmaField.addItem(knp);
        }
        this.rmaField.setSelectedIndex(0);
        this.rmaField.addActionListener(this);
    }

    protected void loadOrder(int C_Order_ID, Timestamp dataa, int C_BPartner_ID, boolean forInvoice, int M_Locator_ID, boolean soloOrdine, boolean IsSOTrx) {
        this.loadTableOIS(this.getOrderData(C_Order_ID, dataa, C_BPartner_ID, forInvoice, M_Locator_ID, soloOrdine, IsSOTrx));
    }

    protected void loadRMA(int M_RMA_ID, int M_Locator_ID) {
        this.loadTableOIS(this.getRMAData(M_RMA_ID, M_Locator_ID));
    }

    protected void loadInvoice(int C_Invoice_ID, int M_Locator_ID) {
        this.loadTableOIS(this.getInvoiceData(C_Invoice_ID, M_Locator_ID));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }

    private void checkProductUsingUPC() {
        String upc = this.upcField.getText();
        DefaultTableModel model = (DefaultTableModel)this.dialog.getMiniTable().getModel();
        List<MProduct> products = MProduct.getByUPC(Env.getCtx(), upc, null);
        for (MProduct product : products) {
            int row = this.findProductRow(product.get_ID());
            if (row < 0) continue;
            BigDecimal qty = (BigDecimal)model.getValueAt(row, 1);
            model.setValueAt(qty, row, 1);
            model.setValueAt(Boolean.TRUE, row, 0);
            model.fireTableRowsUpdated(row, row);
        }
        this.upcField.setText("");
        this.upcField.requestFocusInWindow();
    }

    private int findProductRow(int M_Product_ID) {
        DefaultTableModel model = (DefaultTableModel)this.dialog.getMiniTable().getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            KeyNamePair kp = (KeyNamePair)model.getValueAt(i, 4);
            if (kp.getKey() == M_Product_ID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected void configureMiniTable(IMiniTable miniTable) {
        super.configureMiniTable(miniTable);
        MiniTable swingTable = (MiniTable)miniTable;
        TableColumn col = swingTable.getColumn(3);
        col.setCellEditor(new InnerLocatorTableCellEditor());
    }

    public class InnerLocatorTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -7143484413792778213L;
        KeyNamePair currentValue;
        JTextField editor;

        @Override
        public Object getCellEditorValue() {
            String locatorValue = this.editor.getText();
            MLocator loc = null;
            try {
                loc = (MLocator)new Query(Env.getCtx(), "M_Locator", "value=?", null).setParameters(locatorValue).setClient_ID().first();
                this.currentValue = VCreateFromShipmentUI.this.getLocatorKeyNamePair(loc.get_ID());
            }
            catch (Exception e) {
                String message = String.valueOf(Msg.getMsg(Env.getCtx(), "Invalid")) + " " + this.editor.getText();
                JOptionPane.showMessageDialog(null, message);
            }
            return this.currentValue;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = (KeyNamePair)value;
            this.editor = new JTextField();
            this.editor.setText(this.currentValue.getName());
            return this.editor;
        }
    }
}

