/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.grid.CreateFromInvoice;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridTab;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCreateFromInvoiceUI
extends CreateFromInvoice
implements ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = 1L;
    private VCreateFromDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private JCheckBox oSoloOrdine = new JCheckBox();
    private JCheckBox oSoloBolla = new JCheckBox();
    private JCheckBox oSoloTestata = new JCheckBox();
    private JLabel bPartnerLabel = new JLabel();
    private VLookup bPartnerField;
    private JLabel orderLabel = new JLabel();
    private JComboBox orderField = new JComboBox();
    private JLabel shipmentLabel = new JLabel();
    private JComboBox shipmentField = new JComboBox();
    private JLabel dataDocaLabel = new JLabel();
    private VDate dataDocaField = new VDate();
    private JLabel rmaLabel = new JLabel();
    private JComboBox rmaField = new JComboBox();
    private Boolean IsSOTrx = true;
    private boolean m_actionActive = false;

    public VCreateFromInvoiceUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow(Env.getWindow(this.p_WindowNo), this.dialog);
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.dialog.setTitle(this.getTitle());
        this.IsSOTrx = (Boolean)this.getGridTab().getValue("IsSOTrx");
        Integer docTypeId = (Integer)this.getGridTab().getValue("C_DocTypeTarget_ID");
        MDocType docType = MDocType.get(Env.getCtx(), docTypeId);
        if (!"APC".equals(docType.getDocBaseType())) {
            this.rmaLabel.setVisible(false);
            this.rmaField.setVisible(false);
        }
        this.oSoloOrdine.setSelected(false);
        this.oSoloOrdine.addActionListener(this);
        this.oSoloBolla.setSelected(false);
        this.oSoloBolla.addActionListener(this);
        this.oSoloTestata.setSelected(false);
        this.oSoloTestata.addActionListener(this);
        this.dataDocaField.setMandatory(true);
        this.dataDocaField.setValue(new Timestamp(System.currentTimeMillis()));
        this.dataDocaField.addActionListener(this);
        this.initBPartner(true);
        this.bPartnerField.addVetoableChangeListener(this);
        return true;
    }

    private void jbInit() throws Exception {
        this.bPartnerLabel.setText(Msg.getElement(Env.getCtx(), "C_BPartner_ID"));
        this.oSoloOrdine.setText("OrdiniTutti");
        this.oSoloOrdine.setToolTipText(Msg.getMsg(Env.getCtx(), "OrdiniTutti", false));
        this.orderLabel.setText(Msg.getElement(Env.getCtx(), "C_Order_ID", (boolean)this.IsSOTrx));
        this.oSoloBolla.setText("SpedizioniTutte");
        this.oSoloBolla.setToolTipText(Msg.getMsg(Env.getCtx(), "SpedizioniTutte", false));
        this.shipmentLabel.setText(Msg.getElement(Env.getCtx(), "M_InOut_ID", (boolean)this.IsSOTrx));
        this.rmaLabel.setText(Msg.translate(Env.getCtx(), "M_RMA_ID"));
        this.dataDocaLabel.setText("Data Doc A");
        this.dataDocaField.addActionListener(this);
        this.oSoloTestata.setText("SoloTestata");
        this.oSoloTestata.setToolTipText(Msg.getMsg(Env.getCtx(), "SoloTestata", false));
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout(new BorderLayout());
        CPanel parameterStdPanel = new CPanel(new GridBagLayout());
        parameterPanel.add((Component)parameterStdPanel, "Center");
        parameterStdPanel.add((Component)this.bPartnerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bPartnerField != null) {
            parameterStdPanel.add((Component)this.bPartnerField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterStdPanel.add((Component)this.oSoloOrdine, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.orderLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.orderField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.oSoloBolla, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.shipmentLabel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.shipmentField, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.rmaLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.rmaField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.oSoloTestata, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.dataDocaLabel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.dataDocaField, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean retValue;
        boolean retValue2;
        boolean soloTestata;
        this.log.config("Action=" + e.getActionCommand());
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        this.log.config("Action=" + e.getActionCommand());
        if (e.getSource().equals(this.oSoloOrdine)) {
            int C_Order_ID = 0;
            Timestamp DataDoca = (Timestamp)this.dataDocaField.getValue();
            soloTestata = false;
            retValue2 = this.oSoloTestata.isSelected();
            if (retValue2) {
                soloTestata = true;
            }
            boolean soloOrdine = true;
            this.orderField.setSelectedIndex(-1);
            this.rmaField.setSelectedIndex(-1);
            this.oSoloBolla.setSelected(false);
            this.shipmentField.setSelectedIndex(-1);
            this.loadOrder(C_Order_ID, DataDoca, true, soloOrdine, this.IsSOTrx, this.bPartnerField.getValue() != null ? (Integer)this.bPartnerField.getValue() : 0, soloTestata);
        }
        if (e.getSource().equals(this.orderField)) {
            KeyNamePair pp = (KeyNamePair)this.orderField.getSelectedItem();
            boolean soloOrdine = false;
            int C_Order_ID = 0;
            Timestamp DataDoca = (Timestamp)this.dataDocaField.getValue();
            boolean soloTestata2 = false;
            retValue = this.oSoloTestata.isSelected();
            if (retValue) {
                soloTestata2 = true;
            }
            if (pp != null) {
                C_Order_ID = pp.getKey();
            }
            this.rmaField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.oSoloBolla.setSelected(false);
            this.oSoloOrdine.setSelected(false);
            this.loadOrder(C_Order_ID, DataDoca, true, soloOrdine, this.IsSOTrx, this.bPartnerField.getValue() != null ? (Integer)this.bPartnerField.getValue() : 0, soloTestata2);
        }
        if (e.getSource().equals(this.oSoloBolla)) {
            int M_InOut_ID = 0;
            boolean soloBolla = true;
            soloTestata = false;
            retValue2 = this.oSoloTestata.isSelected();
            if (retValue2) {
                soloTestata = true;
            }
            Timestamp DataDoca = (Timestamp)this.dataDocaField.getValue();
            this.orderField.setSelectedIndex(-1);
            this.rmaField.setSelectedIndex(-1);
            this.oSoloOrdine.setSelected(false);
            this.shipmentField.setSelectedIndex(-1);
            this.loadShipment(M_InOut_ID, soloBolla, DataDoca, this.IsSOTrx, this.bPartnerField.getValue() != null ? (Integer)this.bPartnerField.getValue() : 0, soloTestata);
        }
        if (e.getSource().equals(this.shipmentField)) {
            KeyNamePair pp = (KeyNamePair)this.shipmentField.getSelectedItem();
            boolean soloBolla = false;
            Timestamp DataDoca = (Timestamp)this.dataDocaField.getValue();
            int M_InOut_ID = 0;
            boolean soloTestata3 = false;
            retValue = this.oSoloTestata.isSelected();
            if (retValue) {
                soloTestata3 = true;
            }
            if (pp != null) {
                M_InOut_ID = pp.getKey();
            }
            this.orderField.setSelectedIndex(-1);
            this.rmaField.setSelectedIndex(-1);
            this.oSoloBolla.setSelected(false);
            this.oSoloOrdine.setSelected(false);
            this.loadShipment(M_InOut_ID, soloBolla, DataDoca, this.IsSOTrx, this.bPartnerField.getValue() != null ? (Integer)this.bPartnerField.getValue() : 0, soloTestata3);
        } else if (e.getSource().equals(this.rmaField)) {
            KeyNamePair pp = (KeyNamePair)this.rmaField.getSelectedItem();
            int M_RMA_ID = 0;
            if (pp != null) {
                M_RMA_ID = pp.getKey();
            }
            this.orderField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.oSoloBolla.setSelected(false);
            this.oSoloOrdine.setSelected(false);
            this.loadRMA(M_RMA_ID);
        } else if (e.getSource().equals(this.oSoloTestata) || e.getSource().equals(this.dataDocaField)) {
            this.initBPDetails((Integer)this.bPartnerField.getValue());
        }
        this.m_actionActive = false;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            int C_BPartner_ID = (Integer)e.getNewValue();
            this.initBPOrderDetails(C_BPartner_ID, true);
        }
        this.dialog.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 30);
        this.bPartnerField = new VLookup("C_BPartner_ID", true, false, true, lookup);
        int C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
        this.bPartnerField.setValue(new Integer(C_BPartner_ID));
        this.initBPOrderDetails(C_BPartner_ID, forInvoice);
    }

    protected void initBPOrderDetails(int C_BPartner_ID, boolean forInvoice) {
        this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        KeyNamePair pp = new KeyNamePair(0, "");
        this.orderField.removeActionListener(this);
        this.orderField.removeAllItems();
        this.orderField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadOrderData(C_BPartner_ID, forInvoice, false, this.IsSOTrx);
        for (KeyNamePair knp : list) {
            this.orderField.addItem(knp);
        }
        this.orderField.setSelectedIndex(0);
        this.orderField.addActionListener(this);
        this.dialog.pack();
        this.initBPDetails(C_BPartner_ID);
    }

    public void initBPDetails(int C_BPartner_ID) {
        this.initBPShipmentDetails(C_BPartner_ID);
        this.initBPRMADetails(C_BPartner_ID);
    }

    private void initBPShipmentDetails(int C_BPartner_ID) {
        this.log.config("C_BPartner_ID" + C_BPartner_ID);
        this.shipmentField.removeActionListener(this);
        this.shipmentField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.shipmentField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadShipmentData(C_BPartner_ID, this.IsSOTrx);
        for (KeyNamePair knp : list) {
            this.shipmentField.addItem(knp);
        }
        this.shipmentField.setSelectedIndex(0);
        this.shipmentField.addActionListener(this);
    }

    private void initBPRMADetails(int C_BPartner_ID) {
        this.rmaField.removeActionListener(this);
        this.rmaField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.rmaField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadRMAData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.rmaField.addItem(knp);
        }
        this.rmaField.setSelectedIndex(0);
        this.rmaField.addActionListener(this);
    }

    protected void loadOrder(int C_Order_ID, Timestamp datea, boolean forInvoice, boolean oSoloOrdine, boolean IsSOTrx, int C_BPartner_ID, boolean oSoloTesta) {
        this.loadTableOIS(this.getOrderData(C_Order_ID, datea, forInvoice, oSoloOrdine, IsSOTrx, C_BPartner_ID, oSoloTesta));
    }

    protected void loadRMA(int M_RMA_ID) {
        this.loadTableOIS(this.getRMAData(M_RMA_ID));
    }

    protected void loadShipment(int M_InOut_ID, boolean oSoloBolla, Timestamp datea, boolean IsSOTrx, int C_BPartner_ID, boolean oSoloTesta) {
        this.loadTableOIS(this.getShipmentData(M_InOut_ID, datea, oSoloBolla, IsSOTrx, C_BPartner_ID, oSoloTesta));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == 0) {
            this.calculateSelection();
        }
    }

    public void calculateSelection() {
        this.calculateSelection(this.dialog.getMiniTable());
    }
}

