/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.CreateFromBatch;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VString;
import org.compiere.model.GridTab;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.MPaymentProcessor;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VCreateFromBatchUI
extends CreateFromBatch
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private VCreateFromDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private JLabel bankAccountLabel = new JLabel();
    protected VLookup bankAccountField;
    private JLabel authorizationLabel = new JLabel();
    protected VString authorizationField = new VString();

    public VCreateFromBatchUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow(Env.getWindow(this.p_WindowNo), this.dialog);
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        CButton refreshButton = ConfirmPanel.createRefreshButton(false);
        refreshButton.setMargin(new Insets(1, 10, 0, 10));
        refreshButton.setDefaultCapable(true);
        refreshButton.addActionListener(this);
        this.dialog.getConfirmPanel().addButton(refreshButton);
        this.dialog.getRootPane().setDefaultButton(refreshButton);
        if (this.getGridTab().getValue("C_PaymentBatch_ID") == null) {
            ADialog.error(0, this.dialog, "SaveErrorRowNotFound");
            return false;
        }
        this.dialog.setTitle(this.getTitle());
        int C_PaymentProcessor_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_PaymentProcessor_ID");
        this.C_PaymentBatch_ID = (Integer)this.getGridTab().getValue("C_PaymentBatch_ID");
        this.m_batch = new MPaymentBatch(Env.getCtx(), this.C_PaymentBatch_ID, null);
        this.m_pprocessor = new MPaymentProcessor(Env.getCtx(), C_PaymentProcessor_ID, null);
        int AD_Column_ID = 4917;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 19);
        this.bankAccountField = new VLookup("C_BankAccount_ID", true, true, true, lookup);
        this.bankAccountField.setValue(new Integer(this.m_pprocessor.getC_BankAccount_ID()));
        this.authorizationField = new VString("authorization", false, false, true, 10, 30, null, null);
        this.authorizationField.addActionListener(this);
        this.loadPayments();
        return true;
    }

    private void jbInit() throws Exception {
        this.bankAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.authorizationLabel.setText(Msg.translate(Env.getCtx(), "R_AuthCode"));
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout(new BorderLayout());
        CPanel parameterBankPanel = new CPanel();
        parameterBankPanel.setLayout(new GridBagLayout());
        parameterPanel.add((Component)parameterBankPanel, "Center");
        parameterBankPanel.add((Component)this.bankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bankAccountField != null) {
            parameterBankPanel.add((Component)this.bankAccountField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.authorizationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.authorizationField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
        if (e.getActionCommand().equals("Refresh")) {
            Cursor.getPredefinedCursor(3);
            this.loadPayments();
            this.dialog.tableChanged(null);
            Cursor.getPredefinedCursor(0);
        }
    }

    protected void loadPayments() {
        this.loadTableOIS(this.getPaymentData(this.m_pprocessor.getC_BankAccount_ID(), this.authorizationField.getText()));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    @Override
    public void info() {
        DecimalFormat format = DisplayType.getNumberFormat(12);
        BigDecimal total = new BigDecimal(0.0);
        int rows = this.dialog.getMiniTable().getRowCount();
        int count = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)this.dialog.getMiniTable().getValueAt(i, 0)).booleanValue()) {
                total = total.add((BigDecimal)this.dialog.getMiniTable().getValueAt(i, 4));
                ++count;
            }
            ++i;
        }
        this.dialog.setStatusLine(count, String.valueOf(Msg.getMsg(Env.getCtx(), "Sum")) + "  " + format.format(total));
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }
}

