/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.apps.AppsAction;
import org.compiere.grid.GridSynchronizer;
import org.compiere.grid.VPanel;
import org.compiere.grid.VTable;
import org.compiere.grid.ed.VCellEditor;
import org.compiere.grid.ed.VCellRenderer;
import org.compiere.grid.ed.VChart;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VHeaderRenderer;
import org.compiere.grid.ed.VManagedEditor;
import org.compiere.grid.ed.VRowIDEditor;
import org.compiere.grid.ed.VRowIDRenderer;
import org.compiere.grid.ed.VString;
import org.compiere.grid.tree.VTreePanel;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CollapsiblePanel;
import org.compiere.swing.TableCellNone;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Trx;

public class GridController
extends CPanel
implements DataStatusListener,
ListSelectionListener,
Evaluatee,
VetoableChangeListener,
PropertyChangeListener,
MouseListener {
    private static final long serialVersionUID = 7308782933999556880L;
    private static CLogger log = CLogger.getCLogger(GridController.class);
    private BorderLayout mainLayout = new BorderLayout();
    private JSplitPane splitPane = new JSplitPane();
    private CPanel graphPanel = new CPanel();
    private BorderLayout graphLayout = new BorderLayout();
    private CPanel cardPanel = new CPanel();
    private CardLayout cardLayout = new CardLayout();
    private JScrollPane vPane = new JScrollPane();
    private CScrollPane mrPane = new CScrollPane();
    private CPanel xPanel = new CPanel();
    private BorderLayout xLayout = new BorderLayout();
    private VTable vTable = new VTable();
    private VPanel vPanel = null;
    private boolean detailGrid = false;
    private GridTab m_mTab = null;
    private int m_WindowNo;
    private boolean m_onlyMultiRow = false;
    private boolean m_singleRow = true;
    private boolean m_vetoActive = false;
    private VTreePanel m_tree;
    private APanel m_aPanel;
    private boolean init;
    private ArrayList<GridSynchronizer> synchronizerList = new ArrayList();
    GridController m_Parent;

    public GridController() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public String toString() {
        return "GridController for " + this.m_mTab;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setOpaque(false);
        this.graphPanel.setLayout(this.graphLayout);
        this.splitPane.add((Component)this.graphPanel, "left");
        this.splitPane.add((Component)this.cardPanel, "right");
        this.splitPane.setBorder(null);
        this.splitPane.setName("gc_splitPane");
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add((Component)this.vPane, "vPane");
        this.cardPanel.add((Component)this.mrPane, "mrPane");
        this.cardPanel.setBorder(null);
        this.cardPanel.setName("gc_cardPanel");
        this.xPanel.setLayout(this.xLayout);
        this.xPanel.setName("gc_xPanel");
        this.xPanel.setBorder(BorderFactory.createEmptyBorder());
        this.xLayout.setHgap(0);
        this.xLayout.setVgap(0);
        this.mrPane.setBorder(null);
        this.mrPane.getViewport().add((Component)this.vTable, null);
        this.mrPane.setName("gc_mrPane");
        this.graphPanel.setBorder(null);
        this.graphPanel.setName("gc_graphPanel");
        this.vPane.setBorder(BorderFactory.createEmptyBorder());
    }

    public void dispose() {
        log.config("(" + this.m_mTab.toString() + ")");
        this.stopEditor(false);
        if (this.m_mTab.isLoadComplete() && this.m_mTab.needSave(true, false)) {
            this.m_mTab.dataIgnore();
        }
        if (this.m_mTab.isLoadComplete()) {
            this.m_mTab.getTableModel().removeDataStatusListener(this);
            this.m_mTab.getTableModel().removeVetoableChangeListener(this);
        }
        this.vTable.getSelectionModel().removeListSelectionListener(this);
        this.m_mTab.removePropertyChangeListener(this.vTable);
        Component[] comp = this.vPanel.getComponentsRecursive();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] instanceof VEditor) {
                VEditor vEditor = (VEditor)((Object)comp[i]);
                vEditor.removeVetoableChangeListener(this);
                String columnName = comp[i].getName();
                GridField mField = this.m_mTab.getField(columnName);
                if (mField != null) {
                    mField.removePropertyChangeListener(vEditor);
                }
                vEditor.dispose();
            }
            ++i;
        }
        this.vTable.removeAll();
        this.vTable.setModel(new DefaultTableModel());
        this.vTable = null;
        this.vPanel.removeAll();
        this.vPanel = null;
        this.splitPane.removeAll();
        this.splitPane = null;
        this.m_mTab = null;
        this.m_tree = null;
        this.removeAll();
    }

    public boolean initGrid(GridTab mTab, boolean onlyMultiRow, int WindowNo, APanel aPanel, GridWindow mWindow) {
        return this.initGrid(mTab, onlyMultiRow, WindowNo, aPanel, mWindow, false);
    }

    public boolean initGrid(GridTab mTab, boolean onlyMultiRow, int WindowNo, APanel aPanel, GridWindow mWindow, boolean lazy) {
        log.config("(" + mTab.toString() + ")");
        this.m_mTab = mTab;
        this.m_WindowNo = WindowNo;
        this.m_onlyMultiRow = onlyMultiRow;
        this.m_aPanel = aPanel;
        this.setName("GC-" + mTab);
        this.vPanel = new VPanel(mTab.getName(), this.m_WindowNo);
        this.vPanel.putClientProperty("adempiere.hideIfOneTab", Boolean.TRUE);
        if (this.isDetailGrid()) {
            this.vPanel.setBorder(BorderFactory.createLineBorder(AdempierePLAF.getPrimary2()));
        }
        this.vPane.getViewport().add((Component)this.xPanel, null);
        this.xPanel.add((Component)this.vPanel, "Center");
        this.setTabLevel(this.m_mTab.getTabLevel());
        if (!lazy) {
            this.init();
        } else {
            this.m_mTab.initTab(false);
        }
        return true;
    }

    private void init() {
        this.vTable.setModel(this.m_mTab.getTableModel());
        int size = this.setupVTable(this.m_aPanel, this.m_mTab, this.vTable);
        if (!this.m_onlyMultiRow) {
            GridField mField;
            int i = 0;
            while (i < size) {
                mField = this.m_mTab.getField(i);
                if (mField.isDisplayed()) {
                    this.vPanel.setMnemonic(mField);
                }
                ++i;
            }
            i = 0;
            while (i < size) {
                mField = this.m_mTab.getField(i);
                if (mField.isDisplayed()) {
                    VEditor vEditor = VEditorFactory.getEditor(this.m_mTab, mField, false);
                    if (vEditor == null) {
                        log.warning("Editor not created for " + mField.getColumnName());
                    } else {
                        mField.addPropertyChangeListener(vEditor);
                        vEditor.addVetoableChangeListener(this);
                        this.vPanel.addFieldBuffered(vEditor, mField);
                        if (mField.getDisplayType() == 28 && this.m_aPanel != null) {
                            ((JButton)((Object)vEditor)).addActionListener(this.m_aPanel);
                        }
                    }
                }
                ++i;
            }
            this.vPanel.addFieldBuffered(null, null);
            this.mrPane.setPreferredSize(this.vPanel.getPreferredSize());
        }
        int AD_Tree_ID = 0;
        if (this.m_mTab.isTreeTab()) {
            AD_Tree_ID = MTree.getDefaultAD_Tree_ID(Env.getAD_Client_ID(Env.getCtx()), this.m_mTab.getKeyColumnName());
        }
        if (this.m_mTab.isTreeTab() && AD_Tree_ID != 0) {
            this.m_tree = new VTreePanel(this.m_WindowNo, false, true);
            if (this.m_mTab.getTabNo() == 0) {
                this.m_tree.initTree(AD_Tree_ID);
            }
            this.m_tree.addPropertyChangeListener("NodeSelected", this);
            this.graphPanel.add((Component)this.m_tree, "Center");
            this.splitPane.setDividerLocation(250);
        } else {
            this.graphPanel.setPreferredSize(new Dimension(0, 0));
            this.splitPane.setDividerSize(0);
            this.splitPane.setDividerLocation(0);
        }
        this.m_mTab.addDataStatusListener(this);
        this.m_mTab.getTableModel().addVetoableChangeListener(this);
        this.vTable.getSelectionModel().addListSelectionListener(this);
        this.m_mTab.addPropertyChangeListener(this.vTable);
        this.vTable.autoSize(true);
        if (this.m_onlyMultiRow || !this.m_mTab.isSingleRow()) {
            this.switchMultiRow();
        } else {
            this.switchSingleRow();
        }
        this.init = true;
    }

    public boolean isInit() {
        return this.init;
    }

    public boolean includeTab(GridController gc, APanel aPanel, GridSynchronizer sync) {
        GridController detail = gc;
        detail.setDetailGrid(true);
        detail.addMouseListener(detail);
        detail.enableEvents(32784L);
        this.vPanel.includeTab(detail);
        gc.setGCParent(this);
        gc.getGCParent().setPreferredSize(this.vPanel.getPreferredSize());
        this.synchronizerList.add(sync);
        return true;
    }

    public void setDetailGrid(boolean value) {
        this.detailGrid = value;
        if (this.detailGrid && this.vPanel != null) {
            this.vPanel.setBorder(BorderFactory.createLineBorder(AdempierePLAF.getPrimary2()));
        }
    }

    public boolean isDetailGrid() {
        return this.detailGrid;
    }

    public String getTitle() {
        return this.m_mTab.getName();
    }

    private int setupVTable(APanel aPanel, GridTab mTab, VTable table) {
        TableColumnModel tcm;
        if (!mTab.isDisplayed()) {
            return 0;
        }
        int size = mTab.getFieldCount();
        if (size != (tcm = table.getColumnModel()).getColumnCount()) {
            throw new IllegalStateException("TableColumn Size <> TableModel");
        }
        int i = 0;
        while (i < size) {
            GridField mField = mTab.getField(i);
            TableColumn tc = tcm.getColumn(i);
            tc.setMinWidth(30);
            if (mField.isHideInListView()) {
                this.vTable.setColumnVisibility(tc, false);
            }
            if (mField.getColumnName().equals(tc.getIdentifier().toString())) {
                TableCellNone tcn;
                if (mField.getIncluded_Tab_ID() > 0) {
                    tcn = new TableCellNone(mField.getColumnName());
                    tc.setCellRenderer(tcn);
                    tc.setCellEditor(tcn);
                    tc.setHeaderValue(null);
                    tc.setMinWidth(0);
                    tc.setMaxWidth(0);
                    tc.setPreferredWidth(0);
                } else if (mField.getDisplayType() == 26) {
                    tc.setCellRenderer(new VRowIDRenderer(false));
                    tc.setCellEditor(new VRowIDEditor(false));
                    tc.setHeaderValue("");
                    tc.setMaxWidth(2);
                } else if (mField.isDisplayed()) {
                    tc.setCellRenderer(new VCellRenderer(mField));
                    VCellEditor ce = new VCellEditor(mField);
                    tc.setCellEditor(ce);
                    tc.setHeaderValue(mField.getHeader());
                    tc.setPreferredWidth(Math.max(mField.getDisplayLength(), 30));
                    tc.setHeaderRenderer(new VHeaderRenderer(mField.getDisplayType()));
                    if (mField.getDisplayType() == 28) {
                        ce.setActionListener(aPanel);
                    }
                } else {
                    tcn = new TableCellNone(mField.getColumnName());
                    tc.setCellRenderer(tcn);
                    tc.setCellEditor(tcn);
                    tc.setHeaderValue(null);
                    tc.setMinWidth(0);
                    tc.setMaxWidth(0);
                    tc.setPreferredWidth(0);
                }
            } else {
                log.log(Level.SEVERE, "TableColumn " + tc.getIdentifier() + " <> MField " + mField.getColumnName() + mField.getHeader());
            }
            ++i;
        }
        return size;
    }

    public void activate() {
        if (!this.init) {
            this.init();
        }
        if (this.m_mTab.isTreeTab() && this.m_mTab.getTabNo() != 0) {
            String keyColumnName = this.m_mTab.getKeyColumnName();
            String treeName = "AD_Tree_ID";
            if (keyColumnName.startsWith("CM")) {
                if (keyColumnName.equals("CM_Container_ID")) {
                    treeName = "AD_TreeCMC_ID";
                } else if (keyColumnName.equals("CM_CStage_ID")) {
                    treeName = "AD_TreeCMS_ID";
                } else if (keyColumnName.equals("CM_Template_ID")) {
                    treeName = "AD_TreeCMT_ID";
                } else if (keyColumnName.equals("CM_Media_ID")) {
                    treeName = "AD_TreeCMM_ID";
                }
            }
            int AD_Tree_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, treeName, true);
            log.config(String.valueOf(keyColumnName) + " -> " + treeName + " = " + AD_Tree_ID);
            if (AD_Tree_ID == 0) {
                AD_Tree_ID = MTree.getDefaultAD_Tree_ID(Env.getAD_Client_ID(Env.getCtx()), this.m_mTab.getKeyColumnName());
            }
            if (this.m_tree != null) {
                this.m_tree.initTree(AD_Tree_ID);
            }
        }
        this.activateChilds();
    }

    private void activateChilds() {
        for (GridSynchronizer s : this.synchronizerList) {
            s.activateChild();
        }
    }

    public GridController findChild(GridTab gTab) {
        GridController gc = null;
        for (GridSynchronizer s : this.synchronizerList) {
            if (!s.getChild().getMTab().equals(gTab)) continue;
            gc = s.getChild();
            break;
        }
        return gc;
    }

    public void registerESCAction(AppsAction aIgnore) {
        int c = 1;
        this.vTable.getInputMap(c).put(KeyStroke.getKeyStroke(27, 0), aIgnore.getName());
        this.vTable.getActionMap().put(aIgnore.getName(), aIgnore);
    }

    public void query(boolean onlyCurrentRows, int onlyCurrentDays, int maxRows) {
        this.m_mTab.query(onlyCurrentRows, onlyCurrentDays, maxRows);
        if (!this.isSingleRow()) {
            this.vTable.autoSize(true);
        }
        this.activateChilds();
    }

    public void switchRowPresentation() {
        this.stopEditor(true);
        if (this.m_singleRow) {
            this.switchMultiRow();
        } else {
            this.switchSingleRow();
        }
    }

    public void switchSingleRow() {
        if (this.m_onlyMultiRow) {
            return;
        }
        this.cardLayout.first(this.cardPanel);
        this.m_singleRow = true;
        this.dynamicDisplay(0);
    }

    public void switchMultiRow() {
        this.cardLayout.last(this.cardPanel);
        this.m_singleRow = false;
        this.vTable.autoSize(true);
    }

    public boolean isSingleRow() {
        return this.m_singleRow;
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.m_mTab.removeDataStatusListener(l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.m_mTab.addDataStatusListener(l);
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        String msg;
        int col = e.getChangedColumn();
        log.config("(" + this.m_mTab + ") Col=" + col + ": " + e.toString());
        GridField mField = this.m_mTab.getField(col);
        if (mField != null && (mField.getCallout().length() > 0 || this.m_mTab.hasDependants(mField.getColumnName())) && (msg = this.m_mTab.processFieldChange(mField)).length() > 0) {
            ADialog.error(this.m_WindowNo, this, msg);
        }
        this.dynamicDisplay(col);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.m_mTab.getRowCount() == 0) {
            return;
        }
        int rowTable = this.vTable.getSelectedRow();
        int rowCurrent = this.m_mTab.getCurrentRow();
        log.config("(" + this.m_mTab.toString() + ") Row in Table=" + rowTable + ", in Model=" + rowCurrent);
        if (rowTable == -1) {
            if (rowCurrent >= 0) {
                this.vTable.setRowSelectionInterval(rowCurrent, rowCurrent);
                return;
            }
        } else {
            int t;
            if (rowTable != rowCurrent && (t = this.m_mTab.navigate(rowTable)) != rowTable) {
                rowTable = t;
                this.vTable.setRowSelectionInterval(rowTable, rowTable);
            }
            this.dynamicDisplay(0);
        }
        if (this.m_tree != null) {
            this.m_tree.setSelectedNode(this.m_mTab.getRecord_ID());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e == null) {
            return;
        }
        Object value = e.getNewValue();
        if (value == null) {
            return;
        }
        log.config(String.valueOf(e.getPropertyName()) + "=" + value + " - " + value.getClass().toString());
        if (!(value instanceof MTreeNode)) {
            return;
        }
        int nodeID = ((MTreeNode)value).getNode_ID();
        int size = this.m_mTab.getRowCount();
        int row = -1;
        int i = 0;
        while (i < size) {
            if (this.m_mTab.getKeyID(i) == nodeID) {
                row = i;
                break;
            }
            ++i;
        }
        if (row == -1) {
            if (nodeID > 0) {
                log.log(Level.WARNING, "Tab does not have ID with Node_ID=" + nodeID);
            }
            return;
        }
        this.m_mTab.navigate(row);
    }

    public void dynamicDisplay(int col) {
        Component comp;
        if (!this.isSingleRow() || this.m_onlyMultiRow) {
            return;
        }
        if (!this.m_mTab.isOpen()) {
            return;
        }
        if (col > 0) {
            GridField changedField = this.m_mTab.getField(col);
            String columnName = changedField.getColumnName();
            ArrayList<GridField> dependants = this.m_mTab.getDependantFields(columnName);
            log.config("(" + this.m_mTab.toString() + ") " + columnName + " - Dependents=" + dependants.size());
            if (dependants.size() == 0 && changedField.getCallout().length() > 0) {
                Component[] comp2 = this.vPanel.getComponentsRecursive();
                int i = 0;
                while (i < comp2.length) {
                    if (columnName.equals(comp2[i].getName()) && comp2[i] instanceof VEditor) {
                        boolean noValue;
                        VEditor ve = (VEditor)((Object)comp2[i]);
                        boolean manMissing = false;
                        boolean bl = noValue = changedField.getValue() == null || changedField.getValue().toString().length() == 0;
                        if (noValue && changedField.isEditable(true) && changedField.isMandatory(true)) {
                            manMissing = true;
                        }
                        ve.setBackground(manMissing || changedField.isError());
                        break;
                    }
                    ++i;
                }
                return;
            }
        }
        boolean noData = this.m_mTab.getRowCount() == 0;
        log.config(String.valueOf(this.m_mTab.toString()) + " - Rows=" + this.m_mTab.getRowCount());
        HashSet<String> hiddens = new HashSet<String>();
        Component[] comps = this.vPanel.getComponentsRecursive();
        int i = 0;
        while (i < comps.length) {
            GridField mField;
            comp = comps[i];
            String columnName = comp.getName();
            if (comp instanceof VChart && this.isSingleRow()) {
                ((VChart)comp).createChart();
            }
            if (columnName != null && columnName.length() > 0 && (mField = this.m_mTab.getField(columnName)) != null) {
                if (mField.isDisplayed(true)) {
                    VString vs;
                    if (!comp.isVisible()) {
                        comp.setVisible(true);
                    }
                    if (comp instanceof VString && ((vs = (VString)comp).getVFormat() != null && vs.getVFormat().length() > 0 && mField.getVFormat() == null || vs.getVFormat() == null && mField.getVFormat() != null && mField.getVFormat().length() > 0 || vs.getVFormat() != null && mField.getVFormat() != null && !vs.getVFormat().equals(mField.getVFormat()))) {
                        vs.setVFormat(mField.getVFormat());
                    }
                    if (comp instanceof VEditor) {
                        VEditor ve = (VEditor)((Object)comp);
                        if (noData) {
                            ve.setReadWrite(false);
                        } else {
                            boolean rw = mField.isEditable(true);
                            ve.setReadWrite(rw);
                            boolean manMissing = false;
                            if (rw && mField.getValue() == null && mField.isMandatory(true)) {
                                manMissing = true;
                            }
                            ve.setBackground(manMissing || mField.isError());
                        }
                    }
                } else {
                    if (comp.isVisible()) {
                        comp.setVisible(false);
                    }
                    hiddens.add(columnName);
                }
            }
            ++i;
        }
        i = 0;
        while (i < comps.length) {
            comp = comps[i];
            if (comp instanceof CollapsiblePanel && comp.getName() != null && !comp.getName().startsWith("IncludedTab#")) {
                boolean hasVisible = false;
                Component[] childs = ((CollapsiblePanel)comp).getCollapsiblePane().getContentPane().getComponents();
                int j = 0;
                while (j < childs.length) {
                    GridField mField;
                    String columnName;
                    if (childs[j].isVisible() && (columnName = childs[j].getName()) != null && columnName.length() > 0 && (mField = this.m_mTab.getField(columnName)) != null) {
                        hasVisible = true;
                        break;
                    }
                    ++j;
                }
                if (comp.isVisible() != hasVisible) {
                    comp.setVisible(hasVisible);
                }
            }
            ++i;
        }
        log.config(String.valueOf(this.m_mTab.toString()) + " - fini - " + (col <= 0 ? "complete" : "seletive"));
    }

    public void rowChanged(boolean save, int keyID) {
        if (this.m_tree == null || keyID <= 0) {
            return;
        }
        String name = (String)this.m_mTab.getValue("Name");
        String description = (String)this.m_mTab.getValue("Description");
        Boolean IsSummary = (Boolean)this.m_mTab.getValue("IsSummary");
        boolean summary = IsSummary != null && IsSummary != false;
        String imageIndicator = (String)this.m_mTab.getValue("Action");
        this.m_tree.nodeChanged(save, keyID, name, description, summary, imageIndicator);
    }

    protected void saveMultipleRecords(Properties ctx, String tableName, String columnName, int recordId, Integer[] values, String trxName) throws Exception {
        if (values == null) {
            return;
        }
        int oldRow = this.m_mTab.getCurrentRow();
        GridField lineField = this.m_mTab.getField("Line");
        int i = 0;
        while (i < values.length) {
            if (!this.m_mTab.dataNew(true)) {
                throw new IllegalStateException("Could not clone tab");
            }
            this.m_mTab.setValue(columnName, (Object)values[i]);
            if (lineField != null) {
                this.m_mTab.setValue(lineField, (Object)0);
            }
            if (!this.m_mTab.dataSave(false)) {
                throw new IllegalStateException("Could not update tab");
            }
            this.m_mTab.setCurrentRow(oldRow);
            ++i;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (this.m_mTab.isProcessed() || !this.m_mTab.isActive()) {
            Object source = e.getSource();
            if (source instanceof VEditor) {
                if (!((VEditor)source).isReadWrite()) {
                    log.config("(" + this.m_mTab.toString() + ") " + e.getPropertyName());
                    return;
                }
            } else {
                log.config("(" + this.m_mTab.toString() + ") " + e.getPropertyName());
                return;
            }
        }
        log.config("(" + this.m_mTab.toString() + ") " + e.getPropertyName() + "=" + e.getNewValue() + " (" + e.getOldValue() + ") " + (e.getOldValue() == null ? "" : e.getOldValue().getClass().getName()));
        if (e.getPropertyName().equals("MTable-RowSave")) {
            if (this.m_vetoActive) {
                this.m_vetoActive = false;
                return;
            }
            if (!(Env.isAutoCommit(Env.getCtx(), this.m_WindowNo) && this.m_mTab.getCommitWarning().length() <= 0 || ADialog.ask(this.m_WindowNo, this, "SaveChanges?", this.m_mTab.getCommitWarning()))) {
                this.m_vetoActive = true;
                throw new PropertyVetoException("UserDeniedSave", e);
            }
            return;
        }
        GridTable mTable = this.m_mTab.getTableModel();
        int row = this.m_mTab.getCurrentRow();
        int col = mTable.findColumn(e.getPropertyName());
        if (e.getNewValue() == null && e.getOldValue() != null && e.getOldValue().toString().length() > 0) {
            mTable.setChanged(true);
        } else {
            GridField mField;
            Object newValue = e.getNewValue();
            Integer[] newValues = null;
            if (newValue instanceof Integer[]) {
                newValues = (Integer[])newValue;
                newValue = newValues[0];
                if (newValues.length > 1) {
                    Integer[] valuesCopy = new Integer[newValues.length - 1];
                    System.arraycopy(newValues, 1, valuesCopy, 0, valuesCopy.length);
                    newValues = valuesCopy;
                } else {
                    newValues = null;
                }
            } else if (newValue instanceof Object[]) {
                log.severe("Multiple values can only be processed for IDs (Integer)");
                throw new PropertyVetoException("Multiple Selection values not available for this field", e);
            }
            mTable.setValueAt(newValue, row, col);
            if (e.getPropertyName().equals("S_ResourceAssignment_ID") && (mField = this.m_mTab.getField(col)) != null && mField.getCallout().length() > 0) {
                this.m_mTab.processFieldChange(mField);
            }
            if (newValues != null && newValues.length > 0) {
                if (!this.m_mTab.dataSave(false)) {
                    throw new PropertyVetoException("SaveError", e);
                }
                int recordId = this.m_mTab.getKeyID(this.m_mTab.getCurrentRow());
                Trx trx = Trx.get(Trx.createTrxName(), true);
                trx.start();
                try {
                    try {
                        this.saveMultipleRecords(Env.getCtx(), mTable.getTableName(), e.getPropertyName(), recordId, newValues, trx.getTrxName());
                        trx.commit();
                        this.m_mTab.dataRefreshAll();
                    }
                    catch (Exception ex) {
                        trx.rollback();
                        log.severe(ex.getMessage());
                        throw new PropertyVetoException("SaveError", e);
                    }
                }
                finally {
                    trx.close();
                }
            }
        }
    }

    public GridTab getMTab() {
        return this.m_mTab;
    }

    public String getDisplayLogic() {
        return this.m_mTab.getDisplayLogic();
    }

    public VTable getTable() {
        return this.vTable;
    }

    public void setMnemonics(boolean set) {
        if (this.vPanel != null) {
            this.vPanel.setMnemonics(set);
        }
    }

    public void stopEditor(boolean saveValue) {
        log.config("(" + this.m_mTab.toString() + ") TableEditing=" + this.vTable.isEditing());
        this.vTable.stopEditor(saveValue);
        if (this.m_singleRow) {
            this.vPanel.transferFocus();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest(this + " - " + e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest(this + " - " + e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest(this + " - " + e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest(this + " - " + e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (CLogMgt.isLevelFinest()) {
            log.finest(this + " - " + e);
        }
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return Env.getContext(Env.getCtx(), this.m_WindowNo, variableName);
    }

    public boolean isCurrent() {
        return this.m_mTab != null ? this.m_mTab.isCurrent() : false;
    }

    public VPanel getvPanel() {
        return this.vPanel;
    }

    public void setGCParent(GridController gc) {
        this.m_Parent = gc;
    }

    public GridController getGCParent() {
        return this.m_Parent;
    }

    public void refreshMTab(GridController includedTab) {
        int m_CurrentRowBeforeSave = includedTab.m_mTab.getCurrentRow();
        this.m_mTab.dataRefresh(this.m_mTab.getCurrentRow());
        includedTab.m_mTab.setCurrentRow(m_CurrentRowBeforeSave);
    }

    public void acceptEditorChanges() {
        Component c;
        if (this.isSingleRow() && (c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && this.isAncestorOf(c)) {
            Component t = c;
            while (t != null && t != this) {
                if (t instanceof VManagedEditor) {
                    ((VManagedEditor)((Object)t)).commitChanges();
                    return;
                }
                t = t.getParent();
            }
        }
    }
}

