/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MWarehouse;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromShipment
extends CreateFrom {
    private MInvoice m_invoice = null;
    private MRMA m_rma = null;
    private int defaultLocator_ID = 0;

    public CreateFromShipment(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle("Evasione Ordini o  .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID, boolean IsSOTrx) {
        ArrayList<KeyNamePair> list;
        block14: {
            String wIsSOTrx = "N";
            if (IsSOTrx) {
                wIsSOTrx = "Y";
            }
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE ISSOTRX=? AND r.DocStatus in ('CO', 'CL') AND r.C_BPartner_ID=? AND r.M_RMA_ID in (SELECT rl.M_RMA_ID FROM M_RMALine rl WHERE rl.M_RMA_ID=r.M_RMA_ID AND rl.QtyDelivered < rl.Qty) ";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt, null);
                    pstmt.setString(1, wIsSOTrx);
                    pstmt.setInt(2, C_BPartner_ID);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), e);
                    if (pstmt == null) break block14;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadOrderData(int C_BPartner_ID, boolean forInvoice, boolean sameWarehouseOnly, boolean IsSOTrx) {
        ArrayList<KeyNamePair> list;
        block10: {
            String wIsSOTrx = "N";
            if (IsSOTrx) {
                wIsSOTrx = "Y";
            }
            list = new ArrayList<KeyNamePair>();
            StringBuffer display = new StringBuffer("o.DocumentNo||' - ' ||").append(DB.TO_CHAR("o.DateOrdered", 15, Env.getAD_Language(Env.getCtx()))).append("||' - '||").append(DB.TO_CHAR("o.GrandTotal", 12, Env.getAD_Language(Env.getCtx())));
            String column = "ol.QtyDelivered - ol.QtyLostSales";
            if (forInvoice) {
                column = "ol.QtyInvoiced";
            }
            StringBuffer sql = new StringBuffer("SELECT o.C_Order_ID,").append(display).append(" FROM C_Order o WHERE o.C_BPartner_ID=? AND o.IsSOTrx=? AND o.DocStatus IN ('CL','CO') AND o.C_Order_ID IN (SELECT ol.C_Order_ID FROM C_OrderLine ol WHERE ol.QtyOrdered - ").append(column).append(" != 0) ");
            if (sameWarehouseOnly) {
                sql = sql.append(" AND o.M_Warehouse_ID=? ");
            }
            sql = sql.append("ORDER BY o.DateOrdered");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_BPartner_ID);
                    pstmt.setString(2, wIsSOTrx);
                    if (sameWarehouseOnly) {
                        pstmt.setInt(3, this.getM_Warehouse_ID());
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadInvoiceData(int C_BPartner_ID, boolean IsSOTrx) {
        String wIsSOTrx = "N";
        if (IsSOTrx) {
            wIsSOTrx = "Y";
        }
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        StringBuffer display = new StringBuffer("i.DocumentNo||' - '||").append(DB.TO_CHAR("DateInvoiced", 15, Env.getAD_Language(Env.getCtx()))).append("|| ' - ' ||").append(DB.TO_CHAR("GrandTotal", 12, Env.getAD_Language(Env.getCtx())));
        StringBuffer sql = new StringBuffer("SELECT i.C_Invoice_ID,").append(display).append(" FROM C_Invoice i WHERE i.C_BPartner_ID=? AND i.IsSOTrx=? AND i.DocStatus IN ('CL','CO') AND i.C_Invoice_ID IN (SELECT il.C_Invoice_ID FROM C_InvoiceLine il LEFT OUTER JOIN M_MatchInv mi ON (il.C_InvoiceLine_ID=mi.C_InvoiceLine_ID)  JOIN C_Invoice i2 ON (il.C_Invoice_ID = i2.C_Invoice_ID)  WHERE i2.C_BPartner_ID=? AND i2.IsSOTrx=? AND i2.DocStatus IN ('CL','CO') GROUP BY il.C_Invoice_ID,mi.C_InvoiceLine_ID,il.QtyInvoiced HAVING (il.QtyInvoiced<>SUM(mi.Qty) AND mi.C_InvoiceLine_ID IS NOT NULL) OR mi.C_InvoiceLine_ID IS NULL) ORDER BY i.DateInvoiced");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_BPartner_ID);
            pstmt.setString(2, wIsSOTrx);
            pstmt.setInt(3, C_BPartner_ID);
            pstmt.setString(4, wIsSOTrx);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return list;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, Timestamp dataa, int C_BPartner_ID, boolean forInvoice, boolean soloOrdine, boolean IsSOTrx) {
        Vector<Vector<Object>> data;
        block11: {
            int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
            this.log.config("C_Order_ID=" + C_Order_ID);
            this.p_order = new MOrder(Env.getCtx(), C_Order_ID, null);
            String wIsSOTrx = "N";
            if (IsSOTrx) {
                wIsSOTrx = "Y";
            }
            data = new Vector<Vector<Object>>();
            StringBuffer sql = new StringBuffer("SELECT ic.C_Order_ID, o.Name, dt.Name, ic.DocumentNo, bp.Name, ic.DateOrdered, ic.datepromised, ic.qtadeliver,ic.qtyordered,ic.qtydelivered,ic.m_product_id,ic.c_charge_id,ic.m_warehouse_id,ic.salesrep_id,ic.m_shipper_id,ic.c_bpartner_location_id,ic.c_orderline_id,ic.line,ic.c_uom_id,COALESCE(uom.UOMSymbol,uom.Name),p.name , c.Name , m.name , l.name,ic.paymentrule,ic.c_paymentterm_id FROM (((((M_InOut_Candidate_qta_v ic ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (ic.C_UOM_ID=uom.C_UOM_ID))");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (ic.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("'))");
            }
            sql.append("LEFT OUTER JOIN M_Product p ON p.M_Product_ID=ic.M_Product_ID )");
            sql.append("LEFT OUTER JOIN C_Charge c ON c.C_charge_ID=ic.C_charge_ID) ");
            sql.append("LEFT OUTER JOIN M_shipper m ON m.M_shipper_ID=ic.M_shipper_ID) ");
            sql.append("LEFT OUTER JOIN c_bpartner_location l ON l.c_bpartner_location_ID=ic.c_bpartner_location_ID ");
            sql.append("), AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.IsSOTrx=? AND ic.AD_Client_ID=? and ic.C_BPartner_ID= ? and ic.DateOrdered <= ? ");
            if (!soloOrdine) {
                sql.append(" AND ic.C_Order_ID = ? ");
            }
            sql.append(" order by ic.c_order_id , c_bpartner_location_id , ic.m_shipper_id,ic.line");
            this.log.finer(sql.toString());
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setString(1, wIsSOTrx);
                    pstmt.setInt(2, AD_Client_ID);
                    pstmt.setInt(3, C_BPartner_ID);
                    pstmt.setTimestamp(4, dataa);
                    if (!soloOrdine) {
                        pstmt.setInt(5, C_Order_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(new Boolean(false));
                        BigDecimal qtyDaSpedire = rs.getBigDecimal(8);
                        line.add(qtyDaSpedire);
                        line.add(new Boolean(false));
                        BigDecimal qtyOrdered = rs.getBigDecimal(9);
                        line.add(qtyOrdered);
                        BigDecimal qtygiaspedita = rs.getBigDecimal(10);
                        line.add(qtygiaspedita);
                        line.add(this.getLocatorKeyNamePair(rs.getInt(13)));
                        line.add(new KeyNamePair(rs.getInt(11), rs.getString(21)));
                        line.add(new KeyNamePair(rs.getInt(12), rs.getString(22)));
                        line.add(rs.getString(4));
                        line.add(rs.getTimestamp(6));
                        line.add(rs.getTimestamp(7));
                        line.add(rs.getInt(14));
                        line.add(new KeyNamePair(rs.getInt(15), rs.getString(23)));
                        line.add(new KeyNamePair(rs.getInt(16), rs.getString(24)));
                        line.add(new KeyNamePair(rs.getInt(17), "."));
                        line.add(rs.getString(18));
                        line.add(new KeyNamePair(rs.getInt(1), "."));
                        line.add(new KeyNamePair(rs.getInt(19), rs.getString(20)));
                        line.add(rs.getString(25));
                        line.add(rs.getInt(26));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID) {
        Vector<Vector<Object>> data;
        block12: {
            this.m_invoice = null;
            this.p_order = null;
            int campo_vuoto = 0;
            this.m_rma = new MRMA(Env.getCtx(), M_RMA_ID, null);
            data = new Vector<Vector<Object>>();
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, iol.M_Product_ID, p.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ,p.value ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN M_InOutLine iol ON rl.M_InOutLine_ID=iol.M_InOutLine_ID ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=iol.C_UOM_ID) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=iol.C_UOM_ID AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append("LEFT OUTER JOIN M_Product p ON p.M_Product_ID=iol.M_Product_ID ");
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.M_INOUTLINE_ID IS NOT NULL");
            sqlStmt.append(" UNION ");
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, 0, c.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name), null ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN C_Charge c ON c.C_Charge_ID = rl.C_Charge_ID ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=100) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=100 AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.C_Charge_ID IS NOT NULL");
            sqlStmt.append(" UNION SELECT rl.M_RMALine_ID, rl.line, rl.Qty - COALESCE(rl.QtyDelivered,0),  rl.M_Product_ID, p.Name, uom.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name)  ,p.value  FROM M_RMALine rl LEFT OUTER JOIN M_Product p ON p.M_Product_ID      =rl.M_Product_ID");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append(" LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=p.C_UOM_ID) ");
            } else {
                sqlStmt.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=p.C_UOM_ID AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append(" WHERE rl.M_RMA_ID = ? AND rl.M_INOUTLINE_ID IS NULL AND rl.C_Charge_ID IS NULL");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt.toString(), null);
                    pstmt.setInt(1, M_RMA_ID);
                    pstmt.setInt(2, M_RMA_ID);
                    pstmt.setInt(3, M_RMA_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(7);
                        line.add(new Boolean(false));
                        line.add(rs.getBigDecimal(3));
                        line.add(new Boolean(false));
                        line.add(campo_vuoto);
                        line.add(campo_vuoto);
                        line.add(this.getLocatorKeyNamePair(0));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add(pp);
                        line.add(rs.getString(8));
                        line.add(null);
                        line.add(null);
                        line.add(null);
                        line.add(campo_vuoto);
                        line.add(new KeyNamePair(campo_vuoto, ""));
                        line.add(new KeyNamePair(campo_vuoto, ""));
                        line.add(campo_vuoto);
                        line.add(null);
                        line.add(campo_vuoto);
                        pp = new KeyNamePair(rs.getInt(6), rs.getString(7));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(pp);
                        line.add(campo_vuoto);
                        line.add(campo_vuoto);
                        line.add(campo_vuoto);
                        data.add(line);
                    }
                }
                catch (Exception ex) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected Vector<Vector<Object>> getInvoiceData(int C_Invoice_ID) {
        Vector<Vector<Object>> data;
        block10: {
            this.m_invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
            this.p_order = null;
            this.m_rma = null;
            int campo_vuoto = 0;
            data = new Vector<Vector<Object>>();
            StringBuffer sql = new StringBuffer("SELECT l.QtyInvoiced-SUM(NVL(mi.Qty,0)),l.QtyEntered/l.QtyInvoiced, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), p.M_Locator_ID, loc.Value,  l.M_Product_ID,p.Name, po.VendorProductNo, l.C_InvoiceLine_ID,l.Line, l.C_OrderLine_ID  ,p.value  FROM C_InvoiceLine l ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
            }
            sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID)").append(" LEFT OUTER JOIN M_Locator loc on (p.M_Locator_ID=loc.M_Locator_ID)").append(" INNER JOIN C_Invoice inv ON (l.C_Invoice_ID=inv.C_Invoice_ID)").append(" LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND inv.C_BPartner_ID = po.C_BPartner_ID)").append(" LEFT OUTER JOIN M_MatchInv mi ON (l.C_InvoiceLine_ID=mi.C_InvoiceLine_ID)").append(" WHERE l.C_Invoice_ID=? AND l.QtyInvoiced<>0 ").append("GROUP BY l.QtyInvoiced,l.QtyEntered/l.QtyInvoiced,l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name),p.M_Locator_ID, loc.Value, l.M_Product_ID,p.value,p.Name, po.VendorProductNo, l.C_InvoiceLine_ID,l.Line,l.C_OrderLine_ID ").append("ORDER BY l.Line");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(7);
                        line.add(new Boolean(false));
                        BigDecimal qtyInvoiced = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyInvoiced.multiply(multiplier);
                        line.add(qtyEntered);
                        line.add(new Boolean(false));
                        line.add(campo_vuoto);
                        line.add(campo_vuoto);
                        line.add(this.getLocatorKeyNamePair(rs.getInt(5)));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                        line.add(pp);
                        line.add(rs.getString(13));
                        line.add(rs.getString(9));
                        line.add(null);
                        line.add(null);
                        line.add(campo_vuoto);
                        line.add(new KeyNamePair(campo_vuoto, ""));
                        line.add(new KeyNamePair(campo_vuoto, ""));
                        int C_OrderLine_ID = rs.getInt(12);
                        if (rs.wasNull()) {
                            line.add(new KeyNamePair(campo_vuoto, ""));
                        } else {
                            line.add(new KeyNamePair(C_OrderLine_ID, "."));
                        }
                        line.add(null);
                        line.add(null);
                        pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        line.add(null);
                        pp = new KeyNamePair(rs.getInt(10), rs.getString(11));
                        line.add(pp);
                        line.add(campo_vuoto);
                        line.add(campo_vuoto);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected KeyNamePair getLocatorKeyNamePair(int M_Locator_ID) {
        MWarehouse wh;
        MLocator locator = null;
        if (M_Locator_ID > 0 && (locator = MLocator.get(Env.getCtx(), M_Locator_ID)) != null && locator.getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
            locator = null;
        }
        if (locator == null && this.p_order != null && this.p_order.getM_Warehouse_ID() == this.getM_Warehouse_ID() && (wh = MWarehouse.get(Env.getCtx(), this.p_order.getM_Warehouse_ID())) != null) {
            locator = wh.getDefaultLocator();
        }
        if (locator == null && this.defaultLocator_ID > 0) {
            locator = MLocator.get(Env.getCtx(), this.defaultLocator_ID);
        }
        if (locator == null || locator.getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
            locator = MWarehouse.get(Env.getCtx(), this.getM_Warehouse_ID()).getDefaultLocator();
        }
        KeyNamePair pp = null;
        if (locator != null) {
            pp = new KeyNamePair(locator.get_ID(), locator.getValue());
        }
        return pp;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, BigDecimal.class, false);
        miniTable.setColumnClass(2, Boolean.class, false);
        miniTable.setColumnClass(3, BigDecimal.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.setColumnClass(8, String.class, true);
        miniTable.setColumnClass(9, Timestamp.class, true);
        miniTable.setColumnClass(10, Timestamp.class, true);
        miniTable.setColumnClass(11, String.class, true);
        miniTable.setColumnClass(12, String.class, true);
        miniTable.setColumnClass(13, String.class, true);
        miniTable.setColumnClass(14, String.class, true);
        miniTable.setColumnClass(15, String.class, true);
        miniTable.setColumnClass(16, String.class, true);
        miniTable.setColumnClass(17, String.class, true);
        miniTable.setColumnClass(18, String.class, true);
        miniTable.setColumnClass(19, String.class, true);
        miniTable.setColumnClass(20, String.class, true);
        miniTable.setColumnClass(21, Integer.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int M_Locator_ID = this.defaultLocator_ID;
        if (M_Locator_ID == 0) {
            return false;
        }
        int M_InOut_ID = (Integer)this.getGridTab().getValue("M_InOut_ID");
        MInOut inout = new MInOut(Env.getCtx(), M_InOut_ID, trxName);
        this.log.config(inout + ", C_Locator_ID=" + M_Locator_ID);
        boolean primo_ordine = false;
        String messaggio = "";
        int old_salesRep_id = 0;
        int old_shipper_id = 0;
        int old_locator_id = 0;
        int ult_salesRep_id = 0;
        int ult_shipper_id = 0;
        int ult_locator_id = 0;
        String old_rulepayment = "";
        String ult_rulepayment = "";
        String old_porto = "";
        String ult_porto = "";
        int old_term = 0;
        int ult_term = 0;
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp;
                if (!primo_ordine) {
                    old_salesRep_id = (Integer)miniTable.getValueAt(i, 11);
                    pp = (KeyNamePair)miniTable.getValueAt(i, 12);
                    if (pp != null) {
                        old_shipper_id = pp.getKey();
                    }
                    if ((pp = (KeyNamePair)miniTable.getValueAt(i, 13)) != null) {
                        old_locator_id = pp.getKey();
                    }
                    old_rulepayment = (String)miniTable.getValueAt(i, 20);
                    if ((String)miniTable.getValueAt(i, 21) != null) {
                        old_term = (Integer)miniTable.getValueAt(i, 21);
                    }
                    primo_ordine = true;
                }
                ult_salesRep_id = (Integer)miniTable.getValueAt(i, 11);
                pp = (KeyNamePair)miniTable.getValueAt(i, 12);
                if (pp != null) {
                    ult_shipper_id = pp.getKey();
                }
                if ((pp = (KeyNamePair)miniTable.getValueAt(i, 13)) != null) {
                    ult_locator_id = pp.getKey();
                }
                ult_rulepayment = (String)miniTable.getValueAt(i, 20);
                if ((String)miniTable.getValueAt(i, 21) != null) {
                    ult_term = (Integer)miniTable.getValueAt(i, 21);
                }
                if (i > 1) {
                    if (ult_salesRep_id != old_salesRep_id) {
                        messaggio = String.valueOf(messaggio) + " Agente Diverso ";
                    }
                    if (ult_shipper_id != old_shipper_id) {
                        messaggio = String.valueOf(messaggio) + " Trasportatore Diverso ";
                    }
                    if (ult_locator_id != old_locator_id) {
                        messaggio = String.valueOf(messaggio) + " Destinazione Diversa ";
                    }
                    if (ult_rulepayment != old_rulepayment) {
                        messaggio = String.valueOf(messaggio) + " Regola Pagamento Diversa ";
                    }
                    if (ult_term != old_term) {
                        messaggio = String.valueOf(messaggio) + " Condizione Pagamento Diversa ";
                    }
                }
            }
            ++i;
        }
        if (messaggio != "") {
            int risposta = JOptionPane.showConfirmDialog(null, messaggio, "Torvate differenze", 1);
            if (risposta == 0) {
                JOptionPane.showMessageDialog(null, "Continuo");
            }
            if (risposta == 1) {
                JOptionPane.showMessageDialog(null, "Annullo");
                return false;
            }
            if (risposta == 2) {
                JOptionPane.showMessageDialog(null, "Annullo");
                return false;
            }
        }
        boolean com_prima_volta = false;
        int i2 = 0;
        while (i2 < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i2, 0)).booleanValue()) {
                BigDecimal QtyEntered = (BigDecimal)miniTable.getValueAt(i2, 1);
                Boolean saldo = (boolean)((Boolean)miniTable.getValueAt(i2, 2));
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i2, 5);
                M_Locator_ID = pp != null && pp.getKey() != 0 ? pp.getKey() : this.defaultLocator_ID;
                int M_Product_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i2, 6);
                if (pp != null) {
                    M_Product_ID = pp.getKey();
                }
                int C_UOM_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i2, 17);
                if (pp != null) {
                    C_UOM_ID = pp.getKey();
                }
                int C_OrderLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i2, 14);
                if (pp != null) {
                    C_OrderLine_ID = pp.getKey();
                }
                int M_RMALine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i2, 18);
                if (pp != null) {
                    M_RMALine_ID = pp.getKey();
                }
                int C_InvoiceLine_ID = 0;
                if (miniTable.getValueAt(i2, 19) != null) {
                    C_InvoiceLine_ID = (Integer)miniTable.getValueAt(i2, 19);
                }
                MInvoiceLine il = null;
                if (C_InvoiceLine_ID != 0) {
                    il = new MInvoiceLine(Env.getCtx(), C_InvoiceLine_ID, trxName);
                }
                int precision = 2;
                if (M_Product_ID != 0) {
                    MProduct product = MProduct.get(Env.getCtx(), M_Product_ID);
                    precision = product.getUOMPrecision();
                }
                QtyEntered = QtyEntered.setScale(precision, 5);
                this.log.fine("Line QtyEntered=" + QtyEntered + ", Product=" + M_Product_ID + ", OrderLine=" + C_OrderLine_ID + ", InvoiceLine=" + C_InvoiceLine_ID);
                if (this.m_invoice != null && this.m_invoice.isCreditMemo()) {
                    QtyEntered = QtyEntered.negate();
                }
                MInOutLine iol = new MInOutLine(inout);
                iol.setM_Product_ID(M_Product_ID, C_UOM_ID);
                iol.setQty(QtyEntered);
                MOrderLine ol = null;
                MRMALine rmal = null;
                if (C_OrderLine_ID != 0) {
                    iol.setC_OrderLine_ID(C_OrderLine_ID);
                    ol = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                    if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                        iol.setMovementQty(QtyEntered.multiply(ol.getQtyOrdered()).divide(ol.getQtyEntered(), 12, 4));
                        iol.setC_UOM_ID(ol.getC_UOM_ID());
                    }
                    iol.setM_AttributeSetInstance_ID(ol.getM_AttributeSetInstance_ID());
                    iol.setDescription(ol.getDescription());
                    iol.setC_Project_ID(ol.getC_Project_ID());
                    iol.setC_ProjectPhase_ID(ol.getC_ProjectPhase_ID());
                    iol.setC_ProjectTask_ID(ol.getC_ProjectTask_ID());
                    iol.setC_Activity_ID(ol.getC_Activity_ID());
                    iol.setC_Campaign_ID(ol.getC_Campaign_ID());
                    iol.setAD_OrgTrx_ID(ol.getAD_OrgTrx_ID());
                    iol.setUser1_ID(ol.getUser1_ID());
                    iol.setUser2_ID(ol.getUser2_ID());
                    iol.set_ValueOfColumn("paymentrule", ol.get_Value("paymentrule"));
                    iol.set_ValueOfColumn("c_payment_term_ID", ol.get_Value("c_payment_term_ID"));
                    if (saldo.booleanValue()) {
                        ol.setQtyLostSales(ol.getQtyOrdered().subtract(ol.getQtyDelivered()).subtract(QtyEntered));
                    }
                } else if (il != null) {
                    if (il.getQtyEntered().compareTo(il.getQtyInvoiced()) != 0) {
                        iol.setQtyEntered(QtyEntered.multiply(il.getQtyInvoiced()).divide(il.getQtyEntered(), 12, 4));
                        iol.setC_UOM_ID(il.getC_UOM_ID());
                    }
                    iol.setDescription(il.getDescription());
                    iol.setC_Project_ID(il.getC_Project_ID());
                    iol.setC_ProjectPhase_ID(il.getC_ProjectPhase_ID());
                    iol.setC_ProjectTask_ID(il.getC_ProjectTask_ID());
                    iol.setC_Activity_ID(il.getC_Activity_ID());
                    iol.setC_Campaign_ID(il.getC_Campaign_ID());
                    iol.setAD_OrgTrx_ID(il.getAD_OrgTrx_ID());
                    iol.setUser1_ID(il.getUser1_ID());
                    iol.setUser2_ID(il.getUser2_ID());
                } else if (M_RMALine_ID != 0) {
                    rmal = new MRMALine(Env.getCtx(), M_RMALine_ID, trxName);
                    iol.setM_RMALine_ID(M_RMALine_ID);
                    iol.setQtyEntered(QtyEntered);
                    iol.setDescription(rmal.getDescription());
                    iol.setM_AttributeSetInstance_ID(rmal.getM_AttributeSetInstance_ID());
                    iol.setC_Project_ID(rmal.getC_Project_ID());
                    iol.setC_ProjectPhase_ID(rmal.getC_ProjectPhase_ID());
                    iol.setC_ProjectTask_ID(rmal.getC_ProjectTask_ID());
                    iol.setC_Activity_ID(rmal.getC_Activity_ID());
                    iol.setAD_OrgTrx_ID(rmal.getAD_OrgTrx_ID());
                    iol.setUser1_ID(rmal.getUser1_ID());
                    iol.setUser2_ID(rmal.getUser2_ID());
                }
                if (M_Product_ID == 0) {
                    if (ol != null && ol.getC_Charge_ID() != 0) {
                        iol.setC_Charge_ID(ol.getC_Charge_ID());
                    } else if (il != null && il.getC_Charge_ID() != 0) {
                        iol.setC_Charge_ID(il.getC_Charge_ID());
                    } else if (rmal != null && rmal.getC_Charge_ID() != 0) {
                        iol.setC_Charge_ID(rmal.getC_Charge_ID());
                    }
                }
                iol.setM_Locator_ID(M_Locator_ID);
                if (!iol.save()) {
                    this.log.log(Level.SEVERE, "Line NOT created #" + i2);
                }
                if (ol != null & saldo) {
                    ol.save();
                } else if (il != null) {
                    il.setM_InOutLine_ID(iol.getM_InOutLine_ID());
                    il.saveEx();
                }
                if (C_OrderLine_ID != 0 && !com_prima_volta && messaggio == "") {
                    MOrder testataOrdine = null;
                    int C_Order_ID = ((KeyNamePair)miniTable.getValueAt(i2, 16)).getKey();
                    testataOrdine = new MOrder(Env.getCtx(), C_Order_ID, trxName);
                    inout.setC_Order_ID(testataOrdine.getC_Order_ID());
                    inout.setAD_OrgTrx_ID(testataOrdine.getAD_OrgTrx_ID());
                    inout.setC_Project_ID(testataOrdine.getC_Project_ID());
                    inout.setIsSOTrx(testataOrdine.isSOTrx());
                    inout.setC_Campaign_ID(testataOrdine.getC_Campaign_ID());
                    inout.setC_Activity_ID(testataOrdine.getC_Activity_ID());
                    inout.setUser1_ID(testataOrdine.getUser1_ID());
                    inout.setUser2_ID(testataOrdine.getUser2_ID());
                    inout.setC_BPartner_Location_ID(testataOrdine.getC_BPartner_Location_ID());
                    inout.setM_Shipper_ID(testataOrdine.getM_Shipper_ID());
                    inout.setSalesRep_ID(testataOrdine.getSalesRep_ID());
                    inout.setDeliveryViaRule(testataOrdine.getDeliveryViaRule());
                    inout.set_ValueOfColumn("bp_porto", testataOrdine.get_Value("bp_porto"));
                    inout.set_ValueOfColumn("wsc_aspetto_beni", testataOrdine.get_Value("wsc_aspetto_beni"));
                    inout.set_ValueOfColumn("wsc_causale_trasporto", testataOrdine.get_Value("wsc_causale_trasporto"));
                    inout.set_ValueOfColumn("m_shipper2_id", testataOrdine.get_Value("m_shipper2_id"));
                    if (testataOrdine.isDropShip()) {
                        inout.setM_Warehouse_ID(testataOrdine.getM_Warehouse_ID());
                        inout.setIsDropShip(testataOrdine.isDropShip());
                        inout.setDropShip_BPartner_ID(testataOrdine.getDropShip_BPartner_ID());
                        inout.setDropShip_Location_ID(testataOrdine.getDropShip_Location_ID());
                        inout.setDropShip_User_ID(testataOrdine.getDropShip_User_ID());
                    }
                    inout.saveEx();
                    com_prima_volta = true;
                }
            }
            ++i2;
        }
        if (this.m_invoice != null && this.m_invoice.getC_Invoice_ID() != 0) {
            if (inout.getC_Order_ID() == 0) {
                inout.setC_Order_ID(this.m_invoice.getC_Order_ID());
            }
            inout.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
            inout.setIsSOTrx(this.m_invoice.isSOTrx());
            inout.setAD_OrgTrx_ID(this.m_invoice.getAD_OrgTrx_ID());
            inout.setC_Project_ID(this.m_invoice.getC_Project_ID());
            inout.setC_Campaign_ID(this.m_invoice.getC_Campaign_ID());
            inout.setC_Activity_ID(this.m_invoice.getC_Activity_ID());
            inout.setUser1_ID(this.m_invoice.getUser1_ID());
            inout.setUser2_ID(this.m_invoice.getUser2_ID());
        }
        if (this.m_rma != null && this.m_rma.getM_RMA_ID() != 0) {
            MInOut originalIO = this.m_rma.getShipment();
            inout.setIsSOTrx(this.m_rma.isSOTrx());
            inout.setC_Order_ID(0);
            inout.setC_Invoice_ID(0);
            inout.setM_RMA_ID(this.m_rma.getM_RMA_ID());
            if (originalIO != null) {
                inout.setAD_OrgTrx_ID(originalIO.getAD_OrgTrx_ID());
                inout.setC_Project_ID(originalIO.getC_Project_ID());
                inout.setC_Campaign_ID(originalIO.getC_Campaign_ID());
                inout.setC_Activity_ID(originalIO.getC_Activity_ID());
                inout.setUser1_ID(originalIO.getUser1_ID());
                inout.setUser2_ID(originalIO.getUser2_ID());
            }
        }
        inout.saveEx();
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "DaSpedire"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Saldo"));
        columnNames.add(Msg.translate(Env.getCtx(), "Quantity"));
        columnNames.add(Msg.translate(Env.getCtx(), "Spedita"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Locator_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Charge_ID"));
        columnNames.add(Msg.getElement(Env.getCtx(), "DocumentNo", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "dateordered", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "datepromised", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "salesRep_id", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "m_shipper_id", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "c_bpartner_location_id", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Orderline_id", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "line", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Order_id", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "c_uom_id", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "RMA", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "Invoice", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "RegolaPagamento", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "TerminePagamento", false));
        return columnNames;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, Timestamp dataa, int C_BPartner_ID, boolean forInvoice, int M_Locator_ID, boolean soloOrdine, boolean IsSOTrx) {
        this.defaultLocator_ID = M_Locator_ID;
        return this.getOrderData(C_Order_ID, dataa, C_BPartner_ID, forInvoice, soloOrdine, IsSOTrx);
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID, int M_Locator_ID) {
        this.defaultLocator_ID = M_Locator_ID;
        return this.getRMAData(M_RMA_ID);
    }

    protected Vector<Vector<Object>> getInvoiceData(int C_Invoice_ID, int M_Locator_ID) {
        this.defaultLocator_ID = M_Locator_ID;
        return this.getInvoiceData(C_Invoice_ID);
    }
}

