/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.X_M_InOut;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromInvoice
extends CreateFrom {
    private boolean wsSoloTesta = false;

    public CreateFromInvoice(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement(Env.getCtx(), "C_Invoice_ID", false)) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadShipmentData(int C_BPartner_ID, boolean IsSOTrx) {
        String wIsSOTrx = "N";
        if (IsSOTrx) {
            wIsSOTrx = "Y";
        }
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        StringBuffer display = new StringBuffer("s.DocumentNo||' - '||").append(DB.TO_CHAR("s.MovementDate", 15, Env.getAD_Language(Env.getCtx())));
        StringBuffer sql = new StringBuffer("SELECT s.M_InOut_ID,").append(display).append(" FROM M_InOut s WHERE s.C_BPartner_ID=? AND s.IsSOTrx=? AND s.DocStatus IN ('CL','CO') AND s.M_InOut_ID IN (SELECT sl.M_InOut_ID FROM M_InOutLine sl LEFT OUTER JOIN M_MatchInv mi ON (sl.M_InOutLine_ID=mi.M_InOutLine_ID)  JOIN M_InOut s2 ON (sl.M_InOut_ID=s2.M_InOut_ID)  WHERE s2.C_BPartner_ID=? AND s2.IsSOTrx=? AND s2.DocStatus IN ('CL','CO') GROUP BY sl.M_InOut_ID,mi.M_InOutLine_ID,sl.MovementQty HAVING (sl.MovementQty<>SUM(mi.Qty) AND mi.M_InOutLine_ID IS NOT NULL) OR mi.M_InOutLine_ID IS NULL) ORDER BY s.MovementDate");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_BPartner_ID);
            pstmt.setString(2, wIsSOTrx);
            pstmt.setInt(3, C_BPartner_ID);
            pstmt.setString(4, wIsSOTrx);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadOrderData(int C_BPartner_ID, boolean forInvoice, boolean sameWarehouseOnly, boolean IsSOTrx) {
        ArrayList<KeyNamePair> list;
        block10: {
            String wIsSOTrx = "N";
            if (IsSOTrx) {
                wIsSOTrx = "Y";
            }
            list = new ArrayList<KeyNamePair>();
            StringBuffer display = new StringBuffer("o.DocumentNo||' - ' ||").append(DB.TO_CHAR("o.DateOrdered", 15, Env.getAD_Language(Env.getCtx()))).append("||' - '||").append(DB.TO_CHAR("o.GrandTotal", 12, Env.getAD_Language(Env.getCtx())));
            String column = "ol.QtyDelivered - ol.QtyLostSales";
            if (forInvoice) {
                column = "ol.QtyInvoiced";
            }
            StringBuffer sql = new StringBuffer("SELECT o.C_Order_ID,").append(display).append(" FROM C_Order o WHERE o.C_BPartner_ID=? AND o.IsSOTrx=? AND o.DocStatus IN ('CL','CO') AND o.C_Order_ID IN (SELECT ol.C_Order_ID FROM C_OrderLine ol WHERE ol.QtyOrdered - ").append(column).append(" != 0) ");
            if (sameWarehouseOnly) {
                sql = sql.append(" AND o.M_Warehouse_ID=? ");
            }
            sql = sql.append("ORDER BY o.DateOrdered");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_BPartner_ID);
                    pstmt.setString(2, wIsSOTrx);
                    if (sameWarehouseOnly) {
                        pstmt.setInt(3, this.getM_Warehouse_ID());
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE  r.DocStatus in ('CO', 'CL') AND r.C_BPartner_ID=? AND NOT EXISTS (SELECT * FROM C_Invoice inv WHERE inv.M_RMA_ID=r.M_RMA_ID AND inv.DocStatus IN ('CO', 'CL'))";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    protected Vector<Vector<Object>> getShipmentData(int M_InOut_ID, Timestamp datea, boolean oSoloBolla, boolean IsSOTrx, int C_BPartner_ID, boolean oSoloTesta) {
        this.log.config("M_InOut_ID=" + M_InOut_ID);
        MInOut inout = new MInOut(Env.getCtx(), M_InOut_ID, null);
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String wIsSOTrx = "N";
        if (IsSOTrx) {
            wIsSOTrx = "Y";
        }
        this.p_order = null;
        if (inout.getC_Order_ID() != 0) {
            this.p_order = new MOrder(Env.getCtx(), inout.getC_Order_ID(), null);
        }
        this.wsSoloTesta = oSoloTesta;
        this.m_rma = null;
        if (inout.getM_RMA_ID() != 0) {
            this.m_rma = new MRMA(Env.getCtx(), inout.getM_RMA_ID(), null);
        }
        StringBuffer sql = null;
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        if (oSoloTesta) {
            sql = new StringBuffer("SELECT  sum((l.MovementQty) - (NVL(mi.Qty, 0))), sum(l.QtyEntered/l.MovementQty) , 0 , null as name , 0 ,  null as product , null as vendor , 0 , null as line , 0 \t, s2.DocumentNo , s2.MovementDate , s2.m_inout_id FROM M_InOutLine l ");
            sql.append(" LEFT OUTER JOIN M_InOut s2 ON (l.M_InOut_ID = s2.M_InOut_ID) LEFT OUTER JOIN M_MatchInv mi ON (l.M_InOutLine_ID=mi.M_InOutLine_ID)");
            sql.append(" WHERE s2.AD_Client_ID = ? and s2.C_BPartner_ID=? AND s2.IsSOTrx=? AND s2.DocStatus IN ('CL','CO') and s2.MovementDate <= ? ");
            if (!oSoloBolla) {
                sql.append(" and  l.M_InOut_ID=? ");
            }
            sql.append(" AND   l.MovementQty<>0 ");
            sql.append("\tGROUP BY s2.DocumentNo , s2.MovementDate , s2.m_inout_id ORDER BY s2.MovementDate,s2.DocumentNo");
        } else {
            sql = new StringBuffer("SELECT l.MovementQty-SUM(NVL(mi.Qty, 0)), l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID , s2.DocumentNo, s2.MovementDate , s2.m_inout_id FROM M_InOutLine l ");
            sql.append(" LEFT OUTER JOIN M_InOut s2 ON (l.M_InOut_ID = s2.M_InOut_ID) ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
            }
            sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID)").append(" INNER JOIN M_InOut io ON (l.M_InOut_ID=io.M_InOut_ID)").append(" LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND io.C_BPartner_ID = po.C_BPartner_ID)").append(" LEFT OUTER JOIN M_MatchInv mi ON (l.M_InOutLine_ID=mi.M_InOutLine_ID)");
            sql.append(" WHERE s2.AD_Client_ID = ? and s2.C_BPartner_ID=? AND s2.IsSOTrx=? AND s2.DocStatus IN ('CL','CO') and s2.MovementDate <= ? ");
            if (!oSoloBolla) {
                sql.append(" and  l.M_InOut_ID=? ");
            }
            sql.append(" AND   l.MovementQty<>0 ");
            sql.append("GROUP BY l.MovementQty, l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID ,s2.DocumentNo , s2.MovementDate, s2.m_inout_id");
            sql.append(" ORDER BY s2.MovementDate,s2.DocumentNo");
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, C_BPartner_ID);
            pstmt.setString(3, wIsSOTrx);
            pstmt.setTimestamp(4, datea);
            if (!oSoloBolla) {
                pstmt.setInt(5, M_InOut_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair pp;
                Vector<Object> line = new Vector<Object>(7);
                line.add(new Boolean(false));
                BigDecimal qtyMovement = rs.getBigDecimal(1);
                BigDecimal multiplier = rs.getBigDecimal(2);
                BigDecimal qtyEntered = qtyMovement.multiply(multiplier);
                line.add(qtyEntered);
                if (rs.getInt(3) == 0) {
                    line.add(null);
                } else {
                    pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                    line.add(pp);
                }
                if (rs.getInt(5) == 0) {
                    line.add(null);
                } else {
                    pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                    line.add(pp);
                }
                line.add(rs.getString(11));
                line.add(rs.getDate(12));
                line.add(rs.getString(7));
                int C_OrderLine_ID = rs.getInt(10);
                if (rs.wasNull()) {
                    line.add(null);
                } else {
                    line.add(new KeyNamePair(C_OrderLine_ID, "."));
                }
                if (rs.getInt(8) == 0) {
                    line.add(null);
                } else {
                    KeyNamePair pp2 = new KeyNamePair(rs.getInt(8), rs.getString(9));
                    line.add(pp2);
                }
                int M_Inout_ID = rs.getInt(13);
                if (this.wsSoloTesta) {
                    line.add(new KeyNamePair(M_Inout_ID, "."));
                } else {
                    line.add(null);
                }
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID) {
        Vector<Vector<Object>> data;
        block10: {
            this.p_order = null;
            data = new Vector<Vector<Object>>();
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - COALESCE(rl.QtyInvoiced, 0), iol.M_Product_ID, p.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN M_InOutLine iol ON rl.M_InOutLine_ID=iol.M_InOutLine_ID ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=iol.C_UOM_ID) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=iol.C_UOM_ID AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append("LEFT OUTER JOIN M_Product p ON p.M_Product_ID=iol.M_Product_ID ");
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.M_INOUTLINE_ID IS NOT NULL");
            sqlStmt.append(" UNION ");
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, 0, c.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN C_Charge c ON c.C_Charge_ID = rl.C_Charge_ID ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=100) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=100 AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.C_Charge_ID IS NOT NULL");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt.toString(), null);
                    pstmt.setInt(1, M_RMA_ID);
                    pstmt.setInt(2, M_RMA_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(7);
                        line.add(new Boolean(false));
                        line.add(rs.getBigDecimal(3));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(6), rs.getString(7));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add(pp);
                        line.add(null);
                        line.add(null);
                        line.add(null);
                        line.add(null);
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(null);
                        line.add(pp);
                        data.add(line);
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, Timestamp dataa, boolean forInvoice, boolean oSoloOrdine, boolean IsSOTrx, int C_BPartner_ID, boolean oSoloTesta) {
        Vector<Vector<Object>> data;
        block11: {
            this.log.config("C_Order_ID=" + C_Order_ID);
            this.p_order = new MOrder(Env.getCtx(), C_Order_ID, null);
            int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
            String wIsSOTrx = "N";
            if (IsSOTrx) {
                wIsSOTrx = "Y";
            }
            data = new Vector<Vector<Object>>();
            StringBuffer sql = new StringBuffer("SELECT l.QtyOrdered-SUM(COALESCE(m.Qty,0)),CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), COALESCE(l.M_Product_ID,0),COALESCE(p.Name,c.Name),po.VendorProductNo, l.C_OrderLine_ID,l.Line , o.DocumentNo , o.DateOrdered FROM C_OrderLine l LEFT OUTER JOIN C_Order o ON (l.C_Order_ID = o.C_Order_ID)  LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND l.C_BPartner_ID = po.C_BPartner_ID)  LEFT OUTER JOIN M_MatchPO m ON (l.C_OrderLine_ID=m.C_OrderLine_ID AND ");
            sql.append(forInvoice ? "m.C_InvoiceLine_ID" : "m.M_InOutLine_ID");
            sql.append(" IS NOT NULL)").append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge c ON (l.C_Charge_ID=c.C_Charge_ID)");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
            }
            sql.append("WHERE l.AD_Client_ID=? and l.C_BPartner_ID=? AND o.IsSOTrx=? AND o.DocStatus IN ('CL','CO') and o.DateOrdered <= ? ");
            if (!oSoloOrdine) {
                sql.append(" and l.C_Order_ID = ? ");
            }
            sql.append(" and (l.QtyOrdered - l.QtyDelivered - l.QtyLostSales ) > 0 ");
            sql.append("GROUP BY l.QtyOrdered,CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name),po.VendorProductNo, l.M_Product_ID,COALESCE(p.Name,c.Name), l.Line,l.C_OrderLine_ID , o.DocumentNo ,o.DateOrdered ORDER BY o.DateOrdered ");
            this.log.finer(sql.toString());
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, C_BPartner_ID);
                    pstmt.setString(3, wIsSOTrx);
                    pstmt.setTimestamp(4, dataa);
                    if (!oSoloOrdine) {
                        pstmt.setInt(5, C_Order_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(new Boolean(false));
                        BigDecimal qtyOrdered = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyOrdered.multiply(multiplier);
                        line.add(qtyEntered);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                        line.add(pp);
                        line.add(rs.getString(10));
                        line.add(rs.getDate(11));
                        line.add(rs.getString(7));
                        pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                        line.add(pp);
                        line.add(null);
                        line.add(null);
                        data.add(line);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, BigDecimal.class, false);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, Timestamp.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.setColumnClass(8, String.class, true);
        miniTable.setColumnClass(9, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        X_M_InOut inout;
        int C_Invoice_ID = (Integer)this.getGridTab().getValue("C_Invoice_ID");
        MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, trxName);
        this.log.config(invoice.toString());
        if (this.p_order != null) {
            invoice.setOrder(this.p_order);
            invoice.saveEx();
        }
        if (this.m_rma != null) {
            invoice.setM_RMA_ID(this.m_rma.getM_RMA_ID());
            invoice.saveEx();
        }
        if ((inout = null) != null && inout.getM_InOut_ID() != 0 && inout.getC_Invoice_ID() == 0) {
            inout.setC_Invoice_ID(C_Invoice_ID);
            inout.saveEx();
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp;
                if (this.wsSoloTesta) {
                    int M_InOut_ID = 0;
                    pp = (KeyNamePair)miniTable.getValueAt(i, 9);
                    if (pp != null) {
                        M_InOut_ID = pp.getKey();
                    }
                    StringBuffer sql = new StringBuffer("SELECT l.MovementQty-SUM(NVL(mi.Qty, 0)), l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID , s2.DocumentNo, s2.MovementDate  FROM M_InOutLine l ");
                    sql.append(" LEFT OUTER JOIN M_InOut s2 ON (l.M_InOut_ID = s2.M_InOut_ID) ");
                    if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                        sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
                    } else {
                        sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
                    }
                    sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID)").append(" INNER JOIN M_InOut io ON (l.M_InOut_ID=io.M_InOut_ID)").append(" LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND io.C_BPartner_ID = po.C_BPartner_ID)").append(" LEFT OUTER JOIN M_MatchInv mi ON (l.M_InOutLine_ID=mi.M_InOutLine_ID)");
                    sql.append(" WHERE ");
                    sql.append("  l.M_InOut_ID=? ");
                    sql.append(" AND   l.MovementQty<>0 ");
                    sql.append("GROUP BY l.MovementQty, l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID ,s2.DocumentNo , s2.MovementDate");
                    sql.append(" ORDER BY s2.MovementDate");
                    try {
                        CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
                        pstmt.setInt(1, M_InOut_ID);
                        ResultSet rs = pstmt.executeQuery();
                        while (rs.next()) {
                            BigDecimal qtyMovement = rs.getBigDecimal(1);
                            BigDecimal multiplier = rs.getBigDecimal(2);
                            BigDecimal qtyEntered = qtyMovement.multiply(multiplier);
                            int C_UOM_ID = rs.getInt(3);
                            int M_Product_ID = rs.getInt(5);
                            int C_OrderLine_ID = rs.getInt(10);
                            int M_InOutLine_ID = rs.getInt(8);
                            int precision = 2;
                            if (M_Product_ID != 0) {
                                MProduct product = MProduct.get(Env.getCtx(), M_Product_ID);
                                precision = product.getUOMPrecision();
                            }
                            qtyEntered = qtyEntered.setScale(precision, 5);
                            this.log.fine("Line QtyEntered=" + qtyEntered + ", Product_ID=" + M_Product_ID + ", OrderLine_ID=" + C_OrderLine_ID + ", InOutLine_ID=" + M_InOutLine_ID);
                            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
                            invoiceLine.setM_Product_ID(M_Product_ID, C_UOM_ID);
                            invoiceLine.setQty(qtyEntered);
                            MOrderLine orderLine = null;
                            if (C_OrderLine_ID != 0) {
                                orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                            }
                            Object rmaLine = null;
                            MInOutLine inoutLine = null;
                            if (M_InOutLine_ID != 0) {
                                inoutLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, trxName);
                                if (orderLine == null && inoutLine.getC_OrderLine_ID() != 0) {
                                    C_OrderLine_ID = inoutLine.getC_OrderLine_ID();
                                    orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                                }
                            }
                            if (inoutLine != null) {
                                invoiceLine.setShipLine(inoutLine);
                                if (inoutLine.sameOrderLineUOM()) {
                                    invoiceLine.setQtyInvoiced(qtyEntered);
                                } else {
                                    invoiceLine.setQtyInvoiced(inoutLine.getMovementQty());
                                }
                            } else {
                                this.log.fine("No Receipt Line");
                                if (orderLine != null) {
                                    invoiceLine.setOrderLine(orderLine);
                                    if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                                        invoiceLine.setQtyInvoiced(qtyEntered.multiply(orderLine.getQtyOrdered()).divide(orderLine.getQtyEntered(), 12, 4));
                                    }
                                } else {
                                    this.log.fine("No Order Line");
                                    invoiceLine.setPrice();
                                    invoiceLine.setTax();
                                }
                            }
                            invoiceLine.saveEx();
                        }
                        rs.close();
                        pstmt.close();
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql.toString(), e);
                    }
                } else {
                    MInOutLine line;
                    MInOutLine[] lines;
                    BigDecimal QtyEntered = (BigDecimal)miniTable.getValueAt(i, 1);
                    pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                    int C_UOM_ID = pp.getKey();
                    pp = (KeyNamePair)miniTable.getValueAt(i, 3);
                    int M_Product_ID = 0;
                    if (pp != null) {
                        M_Product_ID = pp.getKey();
                    }
                    int C_OrderLine_ID = 0;
                    pp = (KeyNamePair)miniTable.getValueAt(i, 7);
                    if (pp != null) {
                        C_OrderLine_ID = pp.getKey();
                    }
                    int M_InOutLine_ID = 0;
                    pp = (KeyNamePair)miniTable.getValueAt(i, 8);
                    if (pp != null) {
                        M_InOutLine_ID = pp.getKey();
                    }
                    int M_RMALine_ID = 0;
                    pp = (KeyNamePair)miniTable.getValueAt(i, 9);
                    if (pp != null) {
                        M_RMALine_ID = pp.getKey();
                    }
                    int precision = 2;
                    if (M_Product_ID != 0) {
                        MProduct product = MProduct.get(Env.getCtx(), M_Product_ID);
                        precision = product.getUOMPrecision();
                    }
                    QtyEntered = QtyEntered.setScale(precision, 5);
                    this.log.fine("Line QtyEntered=" + QtyEntered + ", Product_ID=" + M_Product_ID + ", OrderLine_ID=" + C_OrderLine_ID + ", InOutLine_ID=" + M_InOutLine_ID);
                    MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
                    invoiceLine.setM_Product_ID(M_Product_ID, C_UOM_ID);
                    invoiceLine.setQty(QtyEntered);
                    MOrderLine orderLine = null;
                    if (C_OrderLine_ID != 0) {
                        orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                    }
                    MRMALine rmaLine = null;
                    if (M_RMALine_ID > 0) {
                        rmaLine = new MRMALine(Env.getCtx(), M_RMALine_ID, null);
                    }
                    MInOutLine inoutLine = null;
                    if (M_InOutLine_ID != 0) {
                        inoutLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, trxName);
                        if (orderLine == null && inoutLine.getC_OrderLine_ID() != 0) {
                            C_OrderLine_ID = inoutLine.getC_OrderLine_ID();
                            orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                        }
                    } else if (C_OrderLine_ID > 0) {
                        String whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                        lines = MInOutLine.getOfOrderLine(Env.getCtx(), C_OrderLine_ID, whereClause, trxName);
                        this.log.fine("Receipt Lines with OrderLine = #" + lines.length);
                        if (lines.length > 0) {
                            int j = 0;
                            while (j < lines.length) {
                                line = lines[j];
                                if (line.getQtyEntered().compareTo(QtyEntered) == 0) {
                                    inoutLine = line;
                                    M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                                    break;
                                }
                                ++j;
                            }
                            if (inoutLine == null) {
                                inoutLine = lines[0];
                                M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                            }
                        }
                    } else if (M_RMALine_ID != 0) {
                        String whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                        lines = MInOutLine.getOfRMALine(Env.getCtx(), M_RMALine_ID, whereClause, null);
                        this.log.fine("Receipt Lines with RMALine = #" + lines.length);
                        if (lines.length > 0) {
                            int j = 0;
                            while (j < lines.length) {
                                line = lines[j];
                                if (rmaLine.getQty().compareTo(QtyEntered) == 0) {
                                    inoutLine = line;
                                    M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                                    break;
                                }
                                ++j;
                            }
                            if (rmaLine == null) {
                                inoutLine = lines[0];
                                M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                            }
                        }
                    }
                    if (inoutLine != null) {
                        invoiceLine.setShipLine(inoutLine);
                        if (inoutLine.sameOrderLineUOM()) {
                            invoiceLine.setQtyInvoiced(QtyEntered);
                        } else {
                            invoiceLine.setQtyInvoiced(inoutLine.getMovementQty());
                        }
                    } else {
                        this.log.fine("No Receipt Line");
                        if (orderLine != null) {
                            invoiceLine.setOrderLine(orderLine);
                            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                                invoiceLine.setQtyInvoiced(QtyEntered.multiply(orderLine.getQtyOrdered()).divide(orderLine.getQtyEntered(), 12, 4));
                            }
                        } else {
                            this.log.fine("No Order Line");
                            invoiceLine.setPrice();
                            invoiceLine.setTax();
                        }
                        if (rmaLine != null) {
                            invoiceLine.setRMALine(rmaLine);
                            invoiceLine.setQty(QtyEntered);
                        } else {
                            this.log.fine("No RMA Line");
                        }
                    }
                    invoiceLine.saveEx();
                }
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Quantity"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        columnNames.add("Num.Doc");
        columnNames.add("DataDoc");
        columnNames.add(Msg.getElement(Env.getCtx(), "VendorProductNo", false));
        columnNames.add("Ordine");
        columnNames.add(Msg.getElement(Env.getCtx(), "M_InOut_ID", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "M_RMA_ID", false));
        return columnNames;
    }

    public String calculateSelection(IMiniTable miniTable) {
        int m_noSelected = 0;
        BigDecimal invoiceAmt = new BigDecimal(0.0);
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id.isSelected()) {
                BigDecimal amt = (BigDecimal)miniTable.getValueAt(i, 1);
                if (amt != null) {
                    invoiceAmt = invoiceAmt.add(amt);
                }
                ++m_noSelected;
            }
            ++i;
        }
        StringBuffer info = new StringBuffer();
        info.append(m_noSelected).append(" ").append(Msg.getMsg(Env.getCtx(), "Selected")).append(" - ");
        return info.toString();
    }
}

