/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.MPaymentProcessor;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromBatch
extends CreateFrom {
    protected MPaymentBatch m_batch;
    protected MPaymentProcessor m_pprocessor;
    protected int C_PaymentBatch_ID;

    public CreateFromBatch(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.translate(Env.getCtx(), "C_PaymentBatch_ID")) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    protected Vector<Vector<Object>> getPaymentData(int C_BankAccount_ID, String R_AuthCode) {
        Timestamp ts;
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        String sql = "SELECT p.DateTrx,p.C_Payment_ID,p.DocumentNo, p.C_Currency_ID,c.ISO_Code, p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID,ba.C_Currency_ID,?,null,p.AD_Client_ID,p.AD_Org_ID), bp.Name FROM C_BankAccount ba INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) LEFT OUTER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID) WHERE p.Processed='Y' AND p.C_PaymentBatch_ID IS NULL  AND (p.IsPrepayment='Y' OR p.IsAllocated = 'Y') AND p.DocStatus IN ('CO','CL') AND p.PayAmt<>0 AND p.C_BankAccount_ID=?";
        if (R_AuthCode != null && !R_AuthCode.equals("")) {
            sql = String.valueOf(sql) + " AND p.R_AuthCode LIKE ?";
        }
        if ((ts = this.m_batch.getProcessingDate()) == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setTimestamp(1, ts);
            pstmt.setInt(2, C_BankAccount_ID);
            if (R_AuthCode != null && !R_AuthCode.equals("")) {
                pstmt.setString(3, R_AuthCode);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(6);
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                line.add(pp);
                pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                line.add(pp);
                line.add(rs.getBigDecimal(6));
                line.add(rs.getBigDecimal(7));
                line.add(rs.getString(8));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return data;
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, BigDecimal.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.autoSize();
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Payment_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        columnNames.add(Msg.translate(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        return columnNames;
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int C_PaymentBatch_ID = (Integer)this.getGridTab().getValue("C_PaymentBatch_ID");
        MPaymentBatch m_bBatch = new MPaymentBatch(Env.getCtx(), C_PaymentBatch_ID, trxName);
        this.log.config(m_bBatch.toString());
        int rows = miniTable.getRowCount();
        if (rows == 0) {
            return false;
        }
        this.log.config(this.m_batch.toString());
        int i = 0;
        while (i < rows) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                Timestamp trxDate = (Timestamp)miniTable.getValueAt(i, 1);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                int C_Payment_ID = pp.getKey();
                pp = (KeyNamePair)miniTable.getValueAt(i, 3);
                int C_Currency_ID = pp.getKey();
                BigDecimal TrxAmt = (BigDecimal)miniTable.getValueAt(i, 4);
                this.log.fine("Line Date=" + trxDate + ", Payment=" + C_Payment_ID + ", Currency=" + C_Currency_ID + ", Amt=" + TrxAmt);
                MPayment m_pay = new MPayment(Env.getCtx(), C_Payment_ID, null);
                m_pay.setC_PaymentBatch_ID(C_PaymentBatch_ID);
                if (!m_pay.save()) {
                    this.log.log(Level.SEVERE, "Line not created #" + i);
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public void info() {
    }
}

