/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.swing.JOptionPane;
import org.adempiere.as.ASFactory;
import org.adempiere.util.EmbeddedServerProxy;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnectionDialog;
import org.compiere.db.Database;
import org.compiere.db.SecurityPrincipal;
import org.compiere.interfaces.Server;
import org.compiere.interfaces.Status;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.ValueNamePair;

public class CConnection
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7893119456331485444L;
    private static CConnection s_cc = null;
    private static CLogger log = CLogger.getCLogger(CConnection.class);
    @Deprecated
    public static ValueNamePair[] CONNECTIONProfiles = new ValueNamePair[]{new ValueNamePair("L", "LAN")};
    @Deprecated
    public static final String PROFILE_LAN = "L";
    public static final String PROFILE_TERMINAL = "T";
    @Deprecated
    public static final String PROFILE_VPN = "V";
    @Deprecated
    public static final String PROFILE_WAN = "W";
    private static final String COMPONENT_NS = "java:comp/env";
    private boolean useComponentNamespace = !Ini.isClient();
    public static final String SERVER_EMBEDDED = "org.adempiere.server.embedded";
    private String m_name = "Standard";
    private String m_apps_host = "MyAppsServer";
    private int m_apps_port = ASFactory.getApplicationServer().getDefaultNamingServicePort();
    private String m_type = "";
    private String m_db_host = "MyDBServer";
    private int m_db_port = 0;
    private String m_db_name = "MyDBName";
    private String m_connectionProfile = "L";
    private boolean m_bequeath = false;
    private boolean m_firewall = false;
    private String m_fw_host = "";
    private int m_fw_port = 0;
    private String m_db_uid = "adempiere";
    private String m_db_pwd = "adempiere";
    private AdempiereDatabase m_db = null;
    private Exception m_dbException = null;
    private Exception m_appsException = null;
    private boolean m_okDB = false;
    private boolean m_okApps = false;
    private String[] m_info = new String[2];
    private String m_version = null;
    private DataSource m_ds = null;
    private Server m_server = null;
    private String m_dbInfo = null;
    private boolean m_queryAppsServer = false;
    private static final String SECURITY_PRINCIPAL = "org.adempiere.security.principal";
    private InitialContext m_iContext = null;
    private Hashtable m_env = null;

    public static CConnection get() {
        return CConnection.get(null);
    }

    public static CConnection get(String apps_host) {
        if (s_cc == null) {
            String attributes = Ini.getProperty("Connection");
            if (attributes == null || attributes.length() == 0) {
                CConnection cc = null;
                if (apps_host != null && Adempiere.isWebStartClient() && !CConnection.isServerEmbedded()) {
                    cc = new CConnection(apps_host);
                    cc.setConnectionProfile(PROFILE_LAN);
                    cc.setAppsPort(ASFactory.getApplicationServer().getDefaultNamingServicePort());
                    if (cc.testAppsServer() == null) {
                        s_cc = cc;
                        Ini.setProperty("Connection", cc.toStringLong());
                        Ini.saveProperties(Ini.isClient());
                    }
                }
                if (s_cc == null) {
                    CConnectionDialog ccd;
                    if (cc == null) {
                        cc = new CConnection(apps_host);
                    }
                    if (!(s_cc = (ccd = new CConnectionDialog(cc)).getConnection()).isDatabaseOK() && !ccd.isCancel()) {
                        s_cc.testDatabase(true);
                    }
                    Ini.setProperty("Connection", s_cc.toStringLong());
                    Ini.saveProperties(Ini.isClient());
                }
            } else {
                s_cc = new CConnection(null);
                s_cc.setAttributes(attributes);
            }
            log.fine(s_cc.toString());
        }
        return s_cc;
    }

    public static CConnection get(String type, String db_host, int db_port, String db_name) {
        return CConnection.get(type, db_host, db_port, db_name, null, null);
    }

    public static CConnection get(String type, String db_host, int db_port, String db_name, String db_uid, String db_pwd) {
        CConnection cc = new CConnection(db_host);
        cc.setAppsHost(db_host);
        cc.setType(type);
        cc.setDbHost(db_host);
        cc.setDbPort(db_port);
        cc.setDbName(db_name);
        if (db_uid != null) {
            cc.setDbUid(db_uid);
        }
        if (db_pwd != null) {
            cc.setDbPwd(db_pwd);
        }
        return cc;
    }

    public CConnection(String host) {
        if (host != null) {
            this.m_apps_host = host;
            this.m_db_host = host;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    protected void setName() {
        this.m_name = this.toString();
    }

    public String getAppsHost() {
        return this.m_apps_host;
    }

    public void setAppsHost(String apps_host) {
        this.m_apps_host = apps_host;
        this.m_name = this.toString();
        this.m_okApps = false;
        this.m_queryAppsServer = false;
    }

    public int getAppsPort() {
        return this.m_apps_port;
    }

    public void setAppsPort(int apps_port) {
        this.m_apps_port = apps_port;
        this.m_okApps = false;
        this.m_queryAppsServer = false;
    }

    public void setAppsPort(String apps_portString) {
        try {
            if (apps_portString != null && apps_portString.length() != 0) {
                this.setAppsPort(Integer.parseInt(apps_portString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public boolean isAppsServerOK(boolean tryContactAgain) {
        if (CConnection.isServerEmbedded()) {
            return true;
        }
        if (Ini.isClient() && !tryContactAgain && this.m_queryAppsServer) {
            return this.m_okApps;
        }
        if (this.getAppsHost().equalsIgnoreCase("MyAppsServer")) {
            log.warning(String.valueOf(this.getAppsHost()) + " ignored");
            return false;
        }
        this.m_queryAppsServer = true;
        try {
            Status status = (Status)this.lookup("adempiere/Status");
            this.m_version = status.getDateVersion();
            this.m_okApps = true;
        }
        catch (Exception ce) {
            this.m_okApps = false;
            String connect = (String)this.m_env.get("java.naming.provider.url");
            if (connect == null || connect.trim().length() == 0) {
                connect = String.valueOf(this.getAppsHost()) + ":" + this.getAppsPort();
            }
            log.warning(String.valueOf(connect) + "\n - " + ce.toString() + "\n - " + this.m_env);
            ce.printStackTrace();
        }
        catch (Throwable t) {
            this.m_okApps = false;
            String connect = (String)this.m_env.get("java.naming.provider.url");
            if (connect == null || connect.trim().length() == 0) {
                connect = String.valueOf(this.getAppsHost()) + ":" + this.getAppsPort();
            }
            log.warning(String.valueOf(connect) + "\n - " + t.toString() + "\n - " + this.m_env);
            t.printStackTrace();
        }
        return this.m_okApps;
    }

    public synchronized Exception testAppsServer() {
        return this.testAppsServer(false);
    }

    public synchronized Exception testAppsServer(boolean bForceIgnoreCache) {
        this.queryAppsServerInfo(bForceIgnoreCache);
        return this.getAppsServerException();
    }

    public Server getServer() {
        block5: {
            if (this.m_server == null || !Ini.isClient()) {
                if (CConnection.isServerEmbedded()) {
                    this.m_server = (Server)Proxy.newProxyInstance(Server.class.getClassLoader(), new Class[]{Server.class}, (InvocationHandler)new EmbeddedServerProxy());
                    return this.m_server;
                }
                try {
                    Server server = (Server)this.lookup("adempiere/Server");
                    if (server == null) break block5;
                    if (Ini.isClient()) {
                        this.m_server = server;
                        break block5;
                    }
                    return server;
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "", ex);
                    this.m_iContext = null;
                    throw new RuntimeException(ex);
                }
            }
        }
        return this.m_server;
    }

    public String getServerVersion() {
        return this.m_version;
    }

    public String getDbHost() {
        return this.m_db_host;
    }

    public void setDbHost(String db_host) {
        this.m_db_host = db_host;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public String getDbName() {
        return this.m_db_name;
    }

    public void setDbName(String db_name) {
        this.m_db_name = db_name;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public int getDbPort() {
        return this.m_db_port;
    }

    public void setDbPort(int db_port) {
        this.m_db_port = db_port;
        this.m_okDB = false;
    }

    public void setDbPort(String db_portString) {
        try {
            if (db_portString != null && db_portString.length() != 0) {
                this.setDbPort(Integer.parseInt(db_portString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getDbPwd() {
        return this.m_db_pwd;
    }

    public void setDbPwd(String db_pwd) {
        this.m_db_pwd = db_pwd;
        this.m_okDB = false;
    }

    public String getDbUid() {
        return this.m_db_uid;
    }

    public void setDbUid(String db_uid) {
        this.m_db_uid = db_uid;
        this.m_name = this.toString();
        this.m_okDB = false;
    }

    public boolean isRMIoverHTTP() {
        return false;
    }

    public void setConnectionProfile(ValueNamePair connectionProfile) {
        if (connectionProfile != null) {
            this.setConnectionProfile(PROFILE_LAN);
        }
    }

    public void setConnectionProfile(String connectionProfile) {
    }

    public String getConnectionProfile() {
        return PROFILE_LAN;
    }

    public String getConnectionProfileText(String connectionProfile) {
        int i = 0;
        while (i < CONNECTIONProfiles.length) {
            if (CONNECTIONProfiles[i].getValue().equals(connectionProfile)) {
                return CONNECTIONProfiles[i].getName();
            }
            ++i;
        }
        return CONNECTIONProfiles[0].getName();
    }

    public String getConnectionProfileText() {
        return this.getConnectionProfileText(this.getConnectionProfile());
    }

    public ValueNamePair getConnectionProfilePair() {
        int i = 0;
        while (i < CONNECTIONProfiles.length) {
            if (CONNECTIONProfiles[i].getValue().equals(this.getConnectionProfile())) {
                return CONNECTIONProfiles[i];
            }
            ++i;
        }
        return CONNECTIONProfiles[0];
    }

    public boolean isServerObjects() {
        return false;
    }

    public boolean isServerProcess() {
        return false;
    }

    public boolean isTerminalServer() {
        return false;
    }

    public boolean isViaFirewall() {
        return this.m_firewall;
    }

    public void setViaFirewall(boolean viaFirewall) {
        this.m_firewall = viaFirewall;
        this.m_okDB = false;
    }

    public void setViaFirewall(String viaFirewallString) {
        try {
            this.setViaFirewall(Boolean.valueOf(viaFirewallString));
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getFwHost() {
        return this.m_fw_host;
    }

    public void setFwHost(String fw_host) {
        this.m_fw_host = fw_host;
        this.m_okDB = false;
    }

    public int getFwPort() {
        return this.m_fw_port;
    }

    public void setFwPort(int fw_port) {
        this.m_fw_port = fw_port;
        this.m_okDB = false;
    }

    public void setFwPort(String fw_portString) {
        try {
            if (fw_portString != null && fw_portString.length() != 0) {
                this.setFwPort(Integer.parseInt(fw_portString));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public boolean isBequeath() {
        return this.m_bequeath;
    }

    public void setBequeath(boolean bequeath) {
        this.m_bequeath = bequeath;
        this.m_okDB = false;
    }

    public void setBequeath(String bequeathString) {
        try {
            this.setBequeath(Boolean.valueOf(bequeathString));
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        int i = 0;
        while (i < Database.DB_NAMES.length) {
            if (Database.DB_NAMES[i].equals(type)) {
                this.m_type = type;
                this.m_okDB = false;
                break;
            }
            ++i;
        }
        if (this.isOracle()) {
            if (this.getDbPort() != 1521) {
                this.setDbPort(1521);
            }
            this.setFwPort(1630);
        } else {
            this.setBequeath(false);
            this.setViaFirewall(false);
        }
        if (this.isPostgreSQL() && this.getDbPort() != 5432) {
            this.setDbPort(5432);
        }
    }

    public boolean supportsBLOB() {
        return this.m_db.supportsBLOB();
    }

    public boolean isOracle() {
        return Database.DB_ORACLE.equals(this.m_type);
    }

    public boolean isPostgreSQL() {
        return Database.DB_POSTGRESQL.equals(this.m_type);
    }

    public boolean isDatabaseOK() {
        return this.m_okDB;
    }

    public boolean setDataSource() {
        if (this.m_ds == null && Ini.isClient() && this.getDatabase() != null) {
            this.m_ds = this.getDatabase().getDataSource(this);
        }
        return this.m_ds != null;
    }

    public boolean setDataSource(DataSource ds) {
        if (ds == null && this.m_ds != null) {
            this.getDatabase().close();
        }
        this.m_ds = ds;
        return this.m_ds != null;
    }

    public DataSource getDataSource() {
        return this.m_ds;
    }

    public boolean isDataSource() {
        return this.m_ds != null;
    }

    public Exception testDatabase(boolean retest) {
        if (!retest && this.m_ds != null && this.m_okDB) {
            return null;
        }
        this.getDatabase().close();
        this.m_ds = null;
        this.setDataSource();
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                this.readInfo(conn);
                conn.close();
            }
            catch (Exception e) {
                log.severe(e.toString());
                return e;
            }
        }
        return this.m_dbException;
    }

    public void readInfo(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        this.m_info[0] = "Database=" + dbmd.getDatabaseProductName() + " - " + dbmd.getDatabaseProductVersion();
        this.m_info[0] = this.m_info[0].replace('\n', ' ');
        this.m_info[1] = "Driver  =" + dbmd.getDriverName() + " - " + dbmd.getDriverVersion();
        if (this.isDataSource()) {
            this.m_info[1] = String.valueOf(this.m_info[1]) + " - via DataSource";
        }
        this.m_info[1] = this.m_info[1].replace('\n', ' ');
        log.config(String.valueOf(this.m_info[0]) + " - " + this.m_info[1]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        return sb.toString();
    }

    public String toStringDetail() {
        StringBuffer sb = new StringBuffer(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                sb.append("\nDatabase=" + dbmd.getDatabaseProductName() + " - " + dbmd.getDatabaseProductVersion());
                sb.append("\nDriver  =" + dbmd.getDriverName() + " - " + dbmd.getDriverVersion());
                if (this.isDataSource()) {
                    sb.append(" - via DS");
                }
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        conn = null;
        return sb.toString();
    }

    public String getDBInfo() {
        if (this.m_dbInfo != null) {
            return this.m_dbInfo;
        }
        StringBuffer sb = new StringBuffer();
        Connection conn = this.getConnection(true, 2);
        if (conn != null) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                sb.append(dbmd.getDatabaseProductVersion()).append(";").append(dbmd.getDriverVersion());
                if (this.isDataSource()) {
                    sb.append(";DS");
                }
                conn.close();
                this.m_dbInfo = sb.toString();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", e);
                sb.append(e.getLocalizedMessage());
            }
        }
        conn = null;
        return sb.toString();
    }

    public String toStringLong() {
        StringBuffer sb = new StringBuffer("CConnection[");
        sb.append("name=").append(this.m_name).append(",AppsHost=").append(this.m_apps_host).append(",AppsPort=").append(this.m_apps_port).append(",type=").append(this.m_type).append(",DBhost=").append(this.m_db_host).append(",DBport=").append(this.m_db_port).append(",DBname=").append(this.m_db_name).append(",BQ=").append(this.m_bequeath).append(",FW=").append(this.m_firewall).append(",FWhost=").append(this.m_fw_host).append(",FWport=").append(this.m_fw_port).append(",UID=").append(this.m_db_uid).append(",PWD=").append(this.m_db_pwd);
        sb.append("]");
        return sb.toString();
    }

    private void setAttributes(String attributes) {
        try {
            this.setName(attributes.substring(attributes.indexOf("name=") + 5, attributes.indexOf(",AppsHost=")));
            this.setAppsHost(attributes.substring(attributes.indexOf("AppsHost=") + 9, attributes.indexOf(",AppsPort=")));
            int index = attributes.indexOf("AppsPort=");
            this.setAppsPort(attributes.substring(index + 9, attributes.indexOf(",", index)));
            this.setType(attributes.substring(attributes.indexOf("type=") + 5, attributes.indexOf(",DBhost=")));
            this.setDbHost(attributes.substring(attributes.indexOf("DBhost=") + 7, attributes.indexOf(",DBport=")));
            this.setDbPort(attributes.substring(attributes.indexOf("DBport=") + 7, attributes.indexOf(",DBname=")));
            this.setDbName(attributes.substring(attributes.indexOf("DBname=") + 7, attributes.indexOf(",BQ=")));
            this.setBequeath(attributes.substring(attributes.indexOf("BQ=") + 3, attributes.indexOf(",FW=")));
            this.setViaFirewall(attributes.substring(attributes.indexOf("FW=") + 3, attributes.indexOf(",FWhost=")));
            this.setFwHost(attributes.substring(attributes.indexOf("FWhost=") + 7, attributes.indexOf(",FWport=")));
            this.setFwPort(attributes.substring(attributes.indexOf("FWport=") + 7, attributes.indexOf(",UID=")));
            this.setDbUid(attributes.substring(attributes.indexOf("UID=") + 4, attributes.indexOf(",PWD=")));
            this.setDbPwd(attributes.substring(attributes.indexOf("PWD=") + 4, attributes.indexOf("]")));
        }
        catch (Exception e) {
            log.severe(String.valueOf(attributes) + " - " + e.toString());
        }
    }

    public boolean equals(Object o) {
        CConnection cc;
        return o instanceof CConnection && (cc = (CConnection)o).getAppsHost().equals(this.m_apps_host) && cc.getAppsPort() == this.m_apps_port && cc.getDbHost().equals(this.m_db_host) && cc.getDbPort() == this.m_db_port && cc.getDbName().equals(this.m_db_name) && cc.getType().equals(this.m_type) && cc.getDbUid().equals(this.m_db_uid) && cc.getDbPwd().equals(this.m_db_pwd);
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer(this.m_info[0] != null ? this.m_info[0] : "");
        sb.append(" - ").append(this.m_info[1] != null ? this.m_info[1] : "").append("\n").append(this.getDatabase().toString()).append("\nAppsServerOK=").append(this.isAppsServerOK(false)).append(", DatabaseOK=").append(this.isDatabaseOK());
        return sb.toString();
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public AdempiereDatabase getDatabase() {
        if (this.m_db != null && !this.m_db.getName().equals(this.m_type)) {
            this.m_db = null;
        }
        if (this.m_db == null) {
            try {
                int i = 0;
                while (i < Database.DB_NAMES.length) {
                    if (Database.DB_NAMES[i].equals(this.m_type)) {
                        this.m_db = (AdempiereDatabase)Database.DB_CLASSES[i].newInstance();
                        break;
                    }
                    ++i;
                }
                if (this.m_db != null) {
                    this.m_db.getDataSource(this);
                }
            }
            catch (NoClassDefFoundError ee) {
                System.err.println("Environment Error - Check Adempiere.properties - " + ee);
                if (Ini.isClient() && JOptionPane.showConfirmDialog(null, "There is a configuration error:\n" + ee + "\nDo you want to reset the saved configuration?", "Adempiere Configuration Error", 0, 0) == 0) {
                    Ini.deletePropertyFile();
                }
                System.exit(1);
            }
            catch (Exception e) {
                log.severe(e.toString());
            }
        }
        return this.m_db;
    }

    public String getConnectionURL() {
        this.getDatabase();
        if (this.m_db != null) {
            return this.m_db.getConnectionURL(this);
        }
        return "";
    }

    public Connection getServerConnection(boolean autoCommit, int trxLevel) {
        Connection conn = null;
        if (this.m_ds != null) {
            try {
                conn = this.m_ds.getConnection();
                conn.setAutoCommit(autoCommit);
                conn.setTransactionIsolation(trxLevel);
                this.m_okDB = true;
            }
            catch (SQLException ex) {
                this.m_dbException = ex;
                log.log(Level.SEVERE, "", ex);
            }
        }
        return conn;
    }

    public Connection getConnection(boolean autoCommit, int transactionIsolation) {
        Connection conn = null;
        this.m_dbException = null;
        this.m_okDB = false;
        this.getDatabase();
        if (this.m_db == null) {
            this.m_dbException = new IllegalStateException("No Database Connector");
            return null;
        }
        try {
            Exception ee = null;
            try {
                conn = this.m_db.getCachedConnection(this, autoCommit, transactionIsolation);
            }
            catch (Exception e) {
                ee = e;
            }
            if (conn != null) {
                if (conn.getTransactionIsolation() != transactionIsolation) {
                    conn.setTransactionIsolation(transactionIsolation);
                }
                if (conn.getAutoCommit() != autoCommit) {
                    conn.setAutoCommit(autoCommit);
                }
                this.m_okDB = true;
            }
        }
        catch (UnsatisfiedLinkError ule) {
            String msg = String.valueOf(ule.getLocalizedMessage()) + " -> Did you set the LD_LIBRARY_PATH ? - " + this.getConnectionURL();
            this.m_dbException = new Exception(msg);
            log.severe(msg);
        }
        catch (SQLException ex) {
            this.m_dbException = ex;
            if (conn == null) {
                System.err.println(String.valueOf(this.getConnectionURL()) + ", (1) AutoCommit=" + autoCommit + ",TrxIso=" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
            } else {
                try {
                    log.severe(String.valueOf(this.getConnectionURL()) + ", (2) AutoCommit=" + conn.getAutoCommit() + "->" + autoCommit + ", TrxIso=" + CConnection.getTransactionIsolationInfo(conn.getTransactionIsolation()) + "->" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
                }
                catch (Exception ee) {
                    log.severe(String.valueOf(this.getConnectionURL()) + ", (3) AutoCommit=" + autoCommit + ", TrxIso=" + CConnection.getTransactionIsolationInfo(transactionIsolation) + " - " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            this.m_dbException = ex;
            System.err.println(String.valueOf(this.getConnectionURL()) + " - " + ex.getLocalizedMessage());
        }
        return conn;
    }

    public Exception getDatabaseException() {
        return this.m_dbException;
    }

    public InitialContext getInitialContext(boolean useCache) {
        block5: {
            if (useCache && this.m_iContext != null) {
                return this.m_iContext;
            }
            if (this.m_env == null || !useCache) {
                SecurityPrincipal sp = (SecurityPrincipal)Env.getCtx().get(SECURITY_PRINCIPAL);
                String principal = sp != null ? sp.principal : null;
                String credential = sp != null ? sp.credential : null;
                this.m_env = this.getInitialEnvironment(this.getAppsHost(), this.getAppsPort(), false, principal, credential);
            }
            String connect = (String)this.m_env.get("java.naming.provider.url");
            Env.setContext(Env.getCtx(), "java.naming.provider.url", connect);
            this.m_iContext = null;
            try {
                this.m_iContext = new InitialContext(this.m_env);
            }
            catch (Exception ex) {
                this.m_okApps = false;
                this.m_appsException = ex;
                if (connect == null) {
                    connect = (String)this.m_env.get("java.naming.provider.url");
                }
                log.severe(String.valueOf(connect) + "\n - " + ex.toString() + "\n - " + this.m_env);
                if (!CLogMgt.isLevelFinest()) break block5;
                ex.printStackTrace();
            }
        }
        return this.m_iContext;
    }

    private Hashtable getInitialEnvironment(String AppsHost, int AppsPort, boolean RMIoverHTTP, String principal, String credential) {
        return ASFactory.getApplicationServer().getInitialContextEnvironment(AppsHost, AppsPort, principal, credential);
    }

    private boolean queryAppsServerInfo() {
        return this.queryAppsServerInfo(false);
    }

    private boolean queryAppsServerInfo(boolean bForceIgnoreCache) {
        log.finer(this.getAppsHost());
        long start = System.currentTimeMillis();
        this.m_okApps = false;
        this.m_queryAppsServer = true;
        this.m_appsException = null;
        if (this.getAppsHost().equalsIgnoreCase("MyAppsServer")) {
            log.warning(String.valueOf(this.getAppsHost()) + " ignored");
            return this.m_okApps;
        }
        try {
            Status status = (Status)this.lookup("adempiere/Status", bForceIgnoreCache);
            this.updateInfoFromServer(status);
            this.m_okApps = true;
        }
        catch (CommunicationException ce) {
            this.m_appsException = ce;
            String connect = (String)this.m_env.get("java.naming.provider.url");
            if (connect == null || connect.trim().length() == 0) {
                connect = String.valueOf(this.getAppsHost()) + ":" + this.getAppsPort();
            }
            log.warning(String.valueOf(connect) + "\n - " + ce.toString() + "\n - " + this.m_env);
            ce.printStackTrace();
        }
        catch (Exception e) {
            this.m_appsException = e;
            String connect = (String)this.m_env.get("java.naming.provider.url");
            if (connect == null || connect.trim().length() == 0) {
                connect = String.valueOf(this.getAppsHost()) + ":" + this.getAppsPort();
            }
            log.warning(String.valueOf(connect) + "\n - " + e.toString() + "\n - " + this.m_env);
            e.printStackTrace();
        }
        log.fine("Success=" + this.m_okApps + " - " + (System.currentTimeMillis() - start) + "ms");
        return this.m_okApps;
    }

    public Exception getAppsServerException() {
        return this.m_appsException;
    }

    private void updateInfoFromServer(Status svr) throws Exception {
        if (svr == null) {
            throw new IllegalArgumentException("AppsServer was NULL");
        }
        this.setType(svr.getDbType());
        this.setDbHost(svr.getDbHost());
        this.setDbPort(svr.getDbPort());
        this.setDbName(svr.getDbName());
        this.setDbUid(svr.getDbUid());
        this.setDbPwd(svr.getDbPwd());
        this.setBequeath(false);
        this.setFwHost(svr.getFwHost());
        this.setFwPort(svr.getFwPort());
        if (this.getFwHost().length() == 0) {
            this.setViaFirewall(false);
        }
        this.m_version = svr.getDateVersion();
        log.config("Server=" + this.getDbHost() + ", DB=" + this.getDbName());
    }

    public String convertStatement(String origStatement) throws Exception {
        if (this.m_db != null && !this.m_db.getName().equals(this.m_type)) {
            this.getDatabase();
        }
        if (this.m_db != null) {
            return this.m_db.convertStatement(origStatement);
        }
        throw new Exception("CConnection.convertStatement - No Converstion Database");
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer(this.m_apps_host);
        sb.append("{").append(this.m_db_host).append("-").append(this.m_db_name).append("-").append(this.m_db_uid).append("}");
        if (this.m_db != null) {
            sb.append(this.m_db.getStatus());
        }
        return sb.toString();
    }

    public static String getTransactionIsolationInfo(int transactionIsolation) {
        if (transactionIsolation == 0) {
            return "NONE";
        }
        if (transactionIsolation == 2) {
            return "READ_COMMITTED";
        }
        if (transactionIsolation == 1) {
            return "READ_UNCOMMITTED";
        }
        if (transactionIsolation == 4) {
            return "REPEATABLE_READ";
        }
        if (transactionIsolation == 2) {
            return "SERIALIZABLE";
        }
        return "<?" + transactionIsolation + "?>";
    }

    public static boolean isServerEmbedded() {
        return "true".equalsIgnoreCase(System.getProperty(SERVER_EMBEDDED));
    }

    public void setAppServerCredential(String principal, String credential) {
        SecurityPrincipal sp = new SecurityPrincipal();
        sp.principal = principal;
        sp.credential = credential;
        Env.getCtx().put(SECURITY_PRINCIPAL, sp);
        this.m_iContext = null;
        this.m_env = null;
        this.m_server = null;
    }

    public Object clone() throws CloneNotSupportedException {
        CConnection c = (CConnection)super.clone();
        String[] info = new String[]{this.m_info[0], this.m_info[1]};
        c.m_info = info;
        return c;
    }

    private Object lookup(String jndiName) throws NamingException {
        return this.lookup(jndiName, false);
    }

    private Object lookup(String jndiName, boolean bForceIgnoreCache) throws NamingException {
        InitialContext ctx = this.getInitialContext(Ini.isClient() && !bForceIgnoreCache);
        if (this.useComponentNamespace) {
            try {
                return ctx.lookup("java:comp/env/" + jndiName);
            }
            catch (Exception e) {
                log.warning("Component name space not available - " + e.getLocalizedMessage());
                this.useComponentNamespace = false;
            }
        }
        return ctx.lookup(jndiName);
    }

    public static void main(String[] args) {
        boolean server = true;
        if (args.length == 0) {
            System.out.println("CConnection <server|client>");
        } else {
            server = "server".equals(args[0]);
        }
        System.out.println("CConnection - " + (server ? "server" : "client"));
        if (server) {
            Adempiere.startup(false);
        } else {
            Adempiere.startup(true);
        }
        System.out.println("Connection = ");
        CConnection cc = CConnection.get();
        Connection con = cc.getConnection(false, 2);
        new CConnectionDialog(cc);
    }
}

