/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import com.f3p.adempiere.util.IDResolver;
import it.adempiere.maintenance.model.X_R_RequestAsset;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IDColumnRenderer;
import org.compiere.model.GridTab;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class InfoAsset
extends Info
implements VetoableChangeListener {
    private static final long serialVersionUID = 6014685562933753813L;
    protected static final int ASSET_ID_COLUMN_INDEX = 0;
    protected static final int PRODUCT_ID_COLUMN_INDEX = 1;
    protected static boolean m_bRequestAsset = false;
    protected static boolean m_bOrderLineAsset = false;
    protected VCheckBox m_vbSelectAll;
    private static String s_assetFROM = "ITMNT_ASSET_V a";
    private static final Info_Column[] s_assetLayout = new Info_Column[]{new Info_Column(" ", "a.A_Asset_ID", IDColumn.class, false, false, null), new Info_Column(" ", "a.M_ProductService_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "Value"), "a.Value", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Name"), "a.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "M_Product_ID"), "a.prodName", String.class), new Info_Column(Msg.translate(Env.getCtx(), "SerNo"), "a.SerNo", String.class), new Info_Column(Msg.translate(Env.getCtx(), "GuaranteeDate"), "a.GuaranteeDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "a.bpName", String.class), new Info_Column(Msg.translate(Env.getCtx(), "AD_User_ID"), "a.Username", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_Location_ID"), "a.BPLocName", String.class), new Info_Column(Msg.translate(Env.getCtx(), "LocationComment"), "a.LocationComment", String.class), new Info_Column(Msg.translate(Env.getCtx(), "NextMaintenanceDate"), "a.NextMaintenanceDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "itmnt.product.type.service"), "a.ServiceName", String.class), new Info_Column(Msg.translate(Env.getCtx(), "order.no"), "a.OrdDocNo", String.class), new Info_Column(Msg.translate(Env.getCtx(), "ValidTo"), "a.ValidTo", Timestamp.class)};
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lProduct_ID = new CLabel(Msg.translate(Env.getCtx(), "Product"));
    private VLookup fProduct_ID;
    private CLabel lSerNo = new CLabel(Msg.translate(Env.getCtx(), "SerNo"));
    private CTextField fSerNo = new CTextField(10);
    private CLabel lProductService = new CLabel(Msg.translate(Env.getCtx(), "itmnt.product.type.service"));
    private VLookup fProductService;
    private CLabel lDateExpireIn = new CLabel(Msg.translate(Env.getCtx(), "NextMaintenanceDate"));
    private VDate fDateExpireIn;
    private VCheckBox fIsOrdered;
    private CLabel lOrder = new CLabel(Msg.translate(Env.getCtx(), "Order"));
    private VLookup fOrder;

    public InfoAsset(Frame frame, boolean modal, int WindowNo, int A_Asset_ID, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "a", "A_Asset_ID", InfoAsset.isMultiSelectable(WindowNo, multiSelection), whereClause);
        this.log.info(String.valueOf(value) + ", ID=" + A_Asset_ID + ", WHERE=" + whereClause);
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoAsset"));
        this.statInit();
        this.initInfo(value, A_Asset_ID, whereClause);
        this.p_table.setShowTotals(false);
        int no = this.p_table.getRowCount();
        this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0 || this.fProductService.getValue() != null) {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        int M_Product_ID;
        this.labelValue.setText(Msg.getMsg(Env.getCtx(), "Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener(this);
        this.labelName.setText(Msg.getMsg(Env.getCtx(), "Name"));
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 8065, 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fProduct_ID = new VLookup("M_Product_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 8047, 30));
        this.lProduct_ID.setLabelFor(this.fProduct_ID);
        this.fProduct_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.lSerNo.setLabelFor(this.fSerNo);
        this.fSerNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fSerNo.addActionListener(this);
        int iServiceColumnId = IDResolver.getAD_Column_ID("R_RequestAsset", "M_Product_ID");
        this.fProductService = new VLookup("M_ProductService_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, iServiceColumnId, 30));
        this.lProductService.setLabelFor(this.fProductService);
        this.fProductService.setBackground(AdempierePLAF.getInfoBackground());
        if (m_bOrderLineAsset && (M_Product_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "M_Product_ID")) > 0) {
            this.fProductService.setValue(M_Product_ID);
        }
        this.fDateExpireIn = new VDate("DateExpire", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
        this.lDateExpireIn.setLabelFor(this.fDateExpireIn);
        this.fDateExpireIn.setBackground(AdempierePLAF.getInfoBackground());
        this.fIsOrdered = new VCheckBox("IsOrdered", false, false, true, Msg.translate(Env.getCtx(), "itmnt.ordered"), "", false);
        this.fIsOrdered.setSelected(false);
        this.fIsOrdered.addActionListener(this);
        int iOrderColumnId = IDResolver.getAD_Column_ID("C_Order", "C_Order_ID");
        this.fOrder = new VLookup("C_Order_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, iOrderColumnId, 30));
        this.lOrder.setLabelFor(this.fOrder);
        this.fOrder.setBackground(AdempierePLAF.getInfoBackground());
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.labelValue, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fieldValue, null);
        this.parameterPanel.add((Component)this.labelName, null);
        this.parameterPanel.add((Component)this.fieldName, null);
        this.parameterPanel.add((Component)this.lSerNo, null);
        this.parameterPanel.add((Component)this.fSerNo, null);
        this.parameterPanel.add((Component)this.lProduct_ID, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fProduct_ID, null);
        this.parameterPanel.add((Component)this.lProductService, null);
        this.parameterPanel.add((Component)this.fProductService, null);
        this.parameterPanel.add((Component)this.lDateExpireIn, null);
        this.parameterPanel.add((Component)this.fDateExpireIn, null);
        this.parameterPanel.add((Component)this.lBPartner_ID, new ALayoutConstraint(2, 0));
        this.parameterPanel.add((Component)this.fBPartner_ID, null);
        this.parameterPanel.add((Component)this.lOrder, null);
        this.parameterPanel.add((Component)this.fOrder, null);
        this.parameterPanel.add((Component)this.fIsOrdered, new ALayoutConstraint(2, 5));
        if (this.p_multiSelection) {
            this.m_vbSelectAll = new VCheckBox();
            this.m_vbSelectAll.setText(Msg.getMsg(Env.getCtx(), "select.all"));
            this.m_vbSelectAll.setSelected(false);
            this.m_vbSelectAll.addVetoableChangeListener(this);
            this.parameterPanel.add((Component)this.m_vbSelectAll, new ALayoutConstraint(3, 0));
        }
    }

    private void initInfo(String value, int A_Asset_ID, String whereClause) {
        String order;
        String bp = Env.getContext(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
        if (bp != null && bp.length() != 0) {
            this.fBPartner_ID.setValue(new Integer(bp));
        }
        if ((order = Env.getContext(Env.getCtx(), this.p_WindowNo, "C_Order_ID")) != null && order.length() != 0) {
            this.fOrder.setValue(new Integer(order));
        }
        StringBuffer where = new StringBuffer();
        where.append("a.IsActive='Y'");
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        this.prepareTable(s_assetLayout, s_assetFROM, where.toString(), "a.Value, a.ServiceName");
        this.p_table.getColumn(1).setCellRenderer(new IDColumnRenderer(false));
        if (value == null) {
            value = "%";
        }
        if (!value.endsWith("%")) {
            value = String.valueOf(value) + "%";
        }
        this.fieldValue.setText(value);
    }

    @Override
    protected String getSQLWhere() {
        Integer C_Order_ID;
        Timestamp expired;
        Integer M_ProductService_ID;
        String sSerNo;
        Integer M_Product_ID;
        Integer C_BPartner_ID;
        String name;
        StringBuffer sql = new StringBuffer();
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            sql.append(" AND UPPER(a.Value) LIKE ?");
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            sql.append(" AND UPPER(a.Name) LIKE ?");
        }
        if ((C_BPartner_ID = (Integer)this.fBPartner_ID.getValue()) != null) {
            sql.append(" AND a.C_BPartner_ID=").append(C_BPartner_ID);
        }
        if ((M_Product_ID = (Integer)this.fProduct_ID.getValue()) != null) {
            sql.append(" AND a.M_Product_ID=").append(M_Product_ID);
        }
        if (!(sSerNo = this.fSerNo.getText().toUpperCase()).equals("") && !sSerNo.equals("%")) {
            sql.append(" AND UPPER(a.SerNo) LIKE ?");
        }
        if ((M_ProductService_ID = (Integer)this.fProductService.getValue()) != null) {
            sql.append(" AND a.M_ProductService_ID=").append(M_ProductService_ID);
        }
        if (this.fDateExpireIn.getValue() != null && (expired = (Timestamp)this.fDateExpireIn.getValue()) != null) {
            sql.append(" AND TRUNC(a.NextMaintenanceDate) <= ?");
        }
        if (this.fIsOrdered.isSelected()) {
            sql.append(" AND a.OrdDocNo IS NOT NULL");
        }
        if ((C_Order_ID = (Integer)this.fOrder.getValue()) != null) {
            sql.append(" AND a.C_Order_ID=").append(C_Order_ID);
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        String serNo;
        String name;
        int index = 1;
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            pstmt.setString(index++, value);
            this.log.fine("Value: " + value);
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            if (!name.endsWith("%")) {
                name = String.valueOf(name) + "%";
            }
            pstmt.setString(index++, name);
            this.log.fine("Name: " + name);
        }
        if (!(serNo = this.fSerNo.getText().toUpperCase()).equals("") && !serNo.equals("%")) {
            if (!serNo.endsWith("%")) {
                serNo = String.valueOf(serNo) + "%";
            }
            pstmt.setString(index++, serNo);
            this.log.fine("SerNo: " + serNo);
        }
        Timestamp expired = null;
        if (this.fDateExpireIn.getValue() != null) {
            expired = (Timestamp)this.fDateExpireIn.getValue();
            this.log.fine("Expired In=" + expired);
        }
        if (expired != null) {
            pstmt.setTimestamp(index++, expired);
        }
    }

    @Override
    public void saveSelectionDetail() {
        int row = this.p_table.getSelectedRow();
        if (row == -1) {
            return;
        }
        Integer ID2 = this.getSelectedRowKey();
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "A_Asset_ID", ID2 == null ? "0" : ID2.toString());
    }

    @Override
    protected void showHistory() {
        this.log.info("InfoAsset.showHistory");
    }

    @Override
    protected boolean hasHistory() {
        return false;
    }

    @Override
    protected void zoom() {
        this.log.info("InfoAsset.zoom");
        Integer A_Asset_ID = this.getSelectedRowKey();
        if (A_Asset_ID == null) {
            return;
        }
        MQuery query = new MQuery("A_Asset");
        query.addRestriction("A_Asset_ID", "=", A_Asset_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("A_Asset", true);
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected void customize() {
        this.log.info("InfoAsset.customize");
    }

    @Override
    protected boolean hasCustomize() {
        return false;
    }

    protected static boolean isMultiSelectable(int WindowNo, boolean oldValue) {
        boolean bMultiSelection = false;
        int iTabNo = Env.getContextAsInt(Env.getCtx(), WindowNo, VLookup.CURRENT_TAB_NO);
        String sKeyColumnName = Env.getContext(Env.getCtx(), WindowNo, iTabNo, "_TabInfo_KeyColumnName");
        if (sKeyColumnName.equals("R_RequestAsset_ID")) {
            bMultiSelection = true;
            m_bRequestAsset = true;
        } else if (sKeyColumnName.equals("C_OrderLineAsset_ID")) {
            bMultiSelection = true;
            m_bOrderLineAsset = true;
        }
        Env.setContext(Env.getCtx(), WindowNo, VLookup.CURRENT_TAB_NO, null);
        return bMultiSelection || oldValue;
    }

    @Override
    protected ArrayList<Integer> getSelectedRowKeys() {
        ArrayList<Integer> selectedDataList;
        if (m_bOrderLineAsset) {
            selectedDataList = super.getSelectedRowKeys();
        } else if (this.isOkPressed() && this.p_table.isMultiSelection()) {
            int R_Request_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "R_Request_ID");
            int iA_Asset_ID = -1;
            int iM_Product_ID = -1;
            boolean bFirstSelected = true;
            int rows = this.p_table.getRowCount();
            int row = 0;
            while (row < rows) {
                if (!this.p_table.getShowTotals() || row != rows - 1) {
                    int A_Asset_ID = this.getAssetID(row);
                    int M_Product_ID = -1;
                    if (A_Asset_ID != -1) {
                        M_Product_ID = this.getProductID(row);
                        if (bFirstSelected) {
                            iA_Asset_ID = A_Asset_ID;
                            iM_Product_ID = M_Product_ID;
                            bFirstSelected = false;
                        } else {
                            String sTrxName = Trx.createTrxName("CreateRequestAsset");
                            boolean bCommit = false;
                            try {
                                X_R_RequestAsset mRequestAsset = new X_R_RequestAsset(Env.getCtx(), 0, sTrxName);
                                mRequestAsset.setA_Asset_ID(A_Asset_ID);
                                mRequestAsset.setR_Request_ID(R_Request_ID);
                                if (M_Product_ID > 0) {
                                    mRequestAsset.setM_Product_ID(M_Product_ID);
                                }
                                mRequestAsset.saveEx(sTrxName);
                                bCommit = true;
                            }
                            finally {
                                try {
                                    if (bCommit) {
                                        DB.commit(true, sTrxName);
                                    } else {
                                        DB.rollback(true, sTrxName);
                                    }
                                }
                                catch (SQLException e) {
                                    throw new AdempiereException(e);
                                }
                            }
                        }
                    }
                }
                ++row;
            }
            Object obj = Env.getCtx().get(String.valueOf(this.p_WindowNo) + VLookup.CURRENT_GRID_TAB);
            if (obj != null) {
                GridTab currentGridTab = (GridTab)obj;
                if (iA_Asset_ID > 0) {
                    currentGridTab.setValue("A_Asset_ID", (Object)iA_Asset_ID);
                    if (iM_Product_ID > 0) {
                        currentGridTab.setValue("M_Product_ID", (Object)iM_Product_ID);
                    }
                    currentGridTab.dataSave(false);
                }
                currentGridTab.dataRefreshAll();
                Env.setContext(Env.getCtx(), this.p_WindowNo, VLookup.CURRENT_GRID_TAB, null);
            }
            this.p_table.clearSelection();
            selectedDataList = new ArrayList();
        } else {
            selectedDataList = super.getSelectedRowKeys();
        }
        return selectedDataList;
    }

    protected int getAssetID(int row) {
        int A_Asset_ID = -1;
        Object asset = this.p_table.getModel().getValueAt(row, this.getKeyColumnIndex());
        if (asset instanceof IDColumn) {
            IDColumn assetColumn = (IDColumn)asset;
            if (assetColumn.isSelected()) {
                A_Asset_ID = assetColumn.getRecord_ID();
            }
        } else {
            this.log.severe("For multiple selection, IDColumn should be key column for selection");
        }
        return A_Asset_ID;
    }

    protected int getProductID(int row) {
        int M_Product_ID = -1;
        Object product = this.p_table.getModel().getValueAt(row, 1);
        if (product instanceof IDColumn) {
            IDColumn productColumn = (IDColumn)product;
            M_Product_ID = productColumn.getRecord_ID();
        }
        return M_Product_ID;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() == this.m_vbSelectAll) {
            boolean bCheck = (Boolean)evt.getNewValue();
            int iRows = this.p_table.getRowCount();
            int i = 0;
            while (i < iRows) {
                IDColumn idc = (IDColumn)this.p_table.getValueAt(i, 0);
                if (idc != null) {
                    idc.setSelected(bCheck);
                    this.p_table.setValueAt(idc, i, 0);
                }
                ++i;
            }
        }
    }
}

