/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.search.FindCellEditor;
import org.compiere.apps.search.FindValueEditor;
import org.compiere.apps.search.FindValueRenderer;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MUserQuery;
import org.compiere.model.X_AD_Column;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTable;
import org.compiere.swing.CTextField;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public final class Find
extends CDialog
implements ActionListener,
ChangeListener,
DataStatusListener {
    private static final long serialVersionUID = -5064336990363669996L;
    private int m_AD_Tab_ID;
    private int m_targetWindowNo;
    private int m_AD_Table_ID;
    private String m_tableName;
    private String m_whereExtended;
    private GridField[] m_findFields;
    private MQuery m_query = null;
    private boolean m_isCancel = false;
    private static CLogger log = CLogger.getCLogger(Find.class);
    private int m_total;
    private PreparedStatement m_pstmt;
    private boolean hasValue = false;
    private boolean hasDocNo = false;
    private boolean hasName = false;
    private boolean hasDescription = false;
    private int m_sLine = 6;
    private ArrayList<VEditor> m_sEditors = new ArrayList();
    private Hashtable<Integer, GridField> m_targetFields = new Hashtable();
    public static final int TABNO = 99;
    public static final int FIELDLENGTH = 20;
    public static final int AD_REFERENCE_ID_YESNO = 319;
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private StatusBar statusBar = new StatusBar();
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel advancedPanel = new CPanel();
    private BorderLayout advancedLayout = new BorderLayout();
    private ConfirmPanel confirmPanelA = new ConfirmPanel(true, true, false, false, false, false, true);
    private CButton bIgnore = new CButton();
    private JToolBar toolBar = new JToolBar();
    private CComboBox fQueryName = new CComboBox();
    private CButton bSave = new CButton();
    private CButton bNew = new CButton();
    private CButton bDelete = new CButton();
    private ConfirmPanel confirmPanelS = new ConfirmPanel(true);
    private BorderLayout simpleLayout = new BorderLayout();
    private CPanel scontentPanel = new CPanel();
    private GridBagLayout scontentLayout = new GridBagLayout();
    private CPanel simplePanel = new CPanel();
    private CLabel valueLabel = new CLabel();
    private CLabel nameLabel = new CLabel();
    private CLabel descriptionLabel = new CLabel();
    private CTextField valueField = new CTextField();
    private CTextField nameField = new CTextField();
    private CTextField descriptionField = new CTextField();
    private CLabel docNoLabel = new CLabel();
    private CTextField docNoField = new CTextField();
    private Component spaceE;
    private Component spaceN;
    private Component spaceW;
    private Component spaceS;
    private JScrollPane advancedScrollPane = new JScrollPane();
    private CTable advancedTable = new CTable(){
        private static final long serialVersionUID = -6201749159307529032L;

        @Override
        public boolean isCellEditable(int row, int column) {
            boolean editable;
            boolean bl = editable = column == 2 || column == 3 || column == 0 || column == 1 || column == 6;
            if (!editable && row >= 0) {
                String columnName = null;
                Object value = this.getModel().getValueAt(row, 2);
                if (value != null) {
                    columnName = value instanceof ValueNamePair ? ((ValueNamePair)value).getValue() : value.toString();
                }
                boolean bl2 = editable = Find.this.getTargetMField(columnName) != null;
            }
            if (column == 0 && row == 0) {
                editable = false;
            }
            return editable;
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            super.columnMoved(e);
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            if (this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            super.columnMarginChanged(e);
        }
    };
    public static final int INDEX_ANDOR = 0;
    public static final int INDEX_LEFTBRACKET = 1;
    public static final int INDEX_COLUMNNAME = 2;
    public static final int INDEX_OPERATOR = 3;
    public static final int INDEX_VALUE = 4;
    public static final int INDEX_VALUE2 = 5;
    public static final int INDEX_RIGHTBRACKET = 6;
    public CComboBox columns = null;
    public CComboBox operators = null;
    private MUserQuery[] userQueries;
    private ValueNamePair[] columnValueNamePairs;
    private CComboBox leftBrackets;
    private CComboBox rightBrackets;
    private CComboBox andOr;
    private static final String FIELD_SEPARATOR = "<^>";
    private static final String SEGMENT_SEPARATOR = "<~>";

    public Find(Frame owner, int targetWindowNo, String title, int AD_Tab_ID, int AD_Table_ID, String tableName, String whereExtended, GridField[] findFields, int minRecords) {
        super(owner, String.valueOf(Msg.getMsg(Env.getCtx(), "Find")) + ": " + title, true);
        log.info(title);
        this.m_targetWindowNo = targetWindowNo;
        this.m_AD_Tab_ID = AD_Tab_ID;
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_tableName = tableName;
        this.m_whereExtended = whereExtended;
        this.m_findFields = findFields;
        this.m_query = new MQuery(tableName);
        this.m_query.addRestriction(Env.parseContext(Env.getCtx(), this.m_targetWindowNo, whereExtended, false));
        Env.setContext(Env.getCtx(), this.m_targetWindowNo, "Find_Table_ID", this.m_AD_Table_ID);
        Env.setContext(Env.getCtx(), 1110, "Find_Table_ID", this.m_AD_Table_ID);
        try {
            this.jbInit();
            this.initFind();
            if (this.m_total < minRecords) {
                this.dispose();
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Find", e);
        }
        this.getRootPane().setDefaultButton(this.confirmPanelS.getOKButton());
        AEnv.showCenterWindow(owner, this);
    }

    private void jbInit() throws Exception {
        this.spaceE = Box.createHorizontalStrut(8);
        this.spaceN = Box.createVerticalStrut(8);
        this.spaceW = Box.createHorizontalStrut(8);
        this.spaceS = Box.createVerticalStrut(8);
        this.bIgnore.setIcon(new ImageIcon(Adempiere.class.getResource("images/Ignore24.gif")));
        this.bIgnore.setMargin(new Insets(2, 2, 2, 2));
        this.bIgnore.setToolTipText(Msg.getMsg(Env.getCtx(), "Ignore"));
        this.bIgnore.addActionListener(this);
        this.fQueryName.setToolTipText(Msg.getMsg(Env.getCtx(), "QueryName"));
        this.fQueryName.setEditable(true);
        this.fQueryName.addActionListener(this);
        this.bSave.setIcon(new ImageIcon(Adempiere.class.getResource("images/Save24.gif")));
        this.bSave.setMargin(new Insets(2, 2, 2, 2));
        this.bSave.setToolTipText(Msg.getMsg(Env.getCtx(), "Save"));
        this.bSave.addActionListener(this);
        this.bNew.setIcon(new ImageIcon(Adempiere.class.getResource("images/New24.gif")));
        this.bNew.setMargin(new Insets(2, 2, 2, 2));
        this.bNew.setToolTipText(Msg.getMsg(Env.getCtx(), "New"));
        this.bNew.addActionListener(this);
        this.bDelete.setIcon(new ImageIcon(Adempiere.class.getResource("images/Delete24.gif")));
        this.bDelete.setMargin(new Insets(2, 2, 2, 2));
        this.bDelete.setToolTipText(Msg.getMsg(Env.getCtx(), "Delete"));
        this.bDelete.addActionListener(this);
        this.southPanel.setLayout(this.southLayout);
        this.valueLabel.setLabelFor(this.valueField);
        this.valueLabel.setText(Msg.translate(Env.getCtx(), "Value"));
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(Msg.translate(Env.getCtx(), "Name"));
        this.descriptionLabel.setLabelFor(this.descriptionField);
        this.descriptionLabel.setText(Msg.translate(Env.getCtx(), "Description"));
        this.valueField.setText("%");
        this.valueField.setColumns(20);
        this.nameField.setText("%");
        this.nameField.setColumns(20);
        this.descriptionField.setText("%");
        this.descriptionField.setColumns(20);
        this.scontentPanel.setToolTipText(Msg.getMsg(Env.getCtx(), "FindTip"));
        this.docNoLabel.setLabelFor(this.docNoField);
        this.docNoLabel.setText(Msg.translate(Env.getCtx(), "DocumentNo"));
        this.docNoField.setText("%");
        this.docNoField.setColumns(20);
        this.advancedScrollPane.setPreferredSize(new Dimension(540, 410));
        this.southPanel.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.scontentPanel.setLayout(this.scontentLayout);
        this.simplePanel.setLayout(this.simpleLayout);
        this.simplePanel.add((Component)this.confirmPanelS, "South");
        this.simplePanel.add((Component)this.scontentPanel, "Center");
        this.scontentPanel.add((Component)this.valueLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.nameLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.descriptionLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 5, 5), 0, 0));
        this.scontentPanel.add((Component)this.valueField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.descriptionField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.scontentPanel.add((Component)this.docNoLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.nameField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.docNoField, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add(this.spaceE, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceN, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceW, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceS, new GridBagConstraints(2, 15, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.tabbedPane.add((Component)this.simplePanel, Msg.getMsg(Env.getCtx(), "Find"));
        this.toolBar.add((Component)this.bIgnore, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.bNew, null);
        this.toolBar.add((Component)this.bDelete, null);
        this.toolBar.add((Component)this.fQueryName, null);
        this.toolBar.add((Component)this.bSave, null);
        this.advancedPanel.setLayout(this.advancedLayout);
        this.advancedPanel.add((Component)this.toolBar, "North");
        this.advancedPanel.add((Component)this.confirmPanelA, "South");
        this.advancedPanel.add((Component)this.advancedScrollPane, "Center");
        this.advancedScrollPane.getViewport().add((Component)this.advancedTable, null);
        this.tabbedPane.add((Component)this.advancedPanel, Msg.getMsg(Env.getCtx(), "Advanced"));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.confirmPanelA.addActionListener(this);
        this.confirmPanelS.addActionListener(this);
        CButton b = ConfirmPanel.createNewButton(true);
        this.confirmPanelS.addComponent(b);
        b.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Find.this.cmd_cancel();
            }
        });
    }

    private void initFind() {
        log.config("");
        int i = 0;
        while (i < this.m_findFields.length) {
            GridFieldVO vo;
            GridField mField = this.m_findFields[i];
            String columnName = mField.getColumnName();
            if (mField.getVO().displayType == 20) {
                GridField ynfield;
                vo = mField.getVO();
                GridFieldVO ynvo = vo.clone(vo.ctx, vo.WindowNo, vo.TabNo, vo.AD_Window_ID, vo.AD_Tab_ID, vo.tabReadOnly);
                ynvo.IsDisplayed = true;
                ynvo.displayType = 17;
                ynvo.AD_Reference_Value_ID = 319;
                ynvo.lookupInfo = MLookupFactory.getLookupInfo(ynvo.ctx, ynvo.WindowNo, ynvo.AD_Column_ID, ynvo.displayType, Env.getLanguage(ynvo.ctx), ynvo.ColumnName, ynvo.AD_Reference_Value_ID, ynvo.IsParent, ynvo.ValidationCode);
                ynvo.lookupInfo.InfoFactoryClass = ynvo.InfoFactoryClass;
                this.m_findFields[i] = ynfield = new GridField(ynvo);
                mField = ynfield;
            }
            if (mField.getVO().displayType == 28) {
                vo = mField.getVO();
                if (vo.AD_Reference_Value_ID > 0) {
                    GridField postedfield;
                    GridFieldVO postedvo = vo.clone(vo.ctx, vo.WindowNo, vo.TabNo, vo.AD_Window_ID, vo.AD_Tab_ID, vo.tabReadOnly);
                    postedvo.IsDisplayed = true;
                    postedvo.displayType = 17;
                    postedvo.lookupInfo = MLookupFactory.getLookupInfo(postedvo.ctx, postedvo.WindowNo, postedvo.AD_Column_ID, postedvo.displayType, Env.getLanguage(postedvo.ctx), postedvo.ColumnName, postedvo.AD_Reference_Value_ID, postedvo.IsParent, postedvo.ValidationCode);
                    postedvo.lookupInfo.InfoFactoryClass = postedvo.InfoFactoryClass;
                    this.m_findFields[i] = postedfield = new GridField(postedvo);
                    mField = postedfield;
                }
            }
            if (columnName.equals("Value")) {
                this.hasValue = true;
            } else if (columnName.equals("Name")) {
                this.hasName = true;
            } else if (columnName.equals("DocumentNo")) {
                this.hasDocNo = true;
            } else if (columnName.equals("Description")) {
                this.hasDescription = true;
            } else if (mField.isSelectionColumn()) {
                this.addSelectionColumn(mField);
            } else if (columnName.indexOf("Name") != -1) {
                this.addSelectionColumn(mField);
            }
            this.m_targetFields.put(new Integer(mField.getAD_Column_ID()), mField);
            ++i;
        }
        this.valueLabel.setVisible(this.hasValue);
        this.valueField.setVisible(this.hasValue);
        if (this.hasValue) {
            this.valueField.addActionListener(this);
        }
        this.docNoLabel.setVisible(this.hasDocNo);
        this.docNoField.setVisible(this.hasDocNo);
        if (this.hasDocNo) {
            this.docNoField.addActionListener(this);
        }
        this.nameLabel.setVisible(this.hasName);
        this.nameField.setVisible(this.hasName);
        if (this.hasName) {
            this.nameField.addActionListener(this);
        }
        this.descriptionLabel.setVisible(this.hasDescription);
        this.descriptionField.setVisible(this.hasDescription);
        if (this.hasDescription) {
            this.descriptionField.addActionListener(this);
        }
        this.m_total = this.getNoOfRecords(null, false);
        this.setStatusDB(this.m_total);
        this.statusBar.setStatusLine("");
        this.tabbedPane.addChangeListener(this);
        this.confirmPanelA.getOKButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryEnter"));
        this.confirmPanelA.getCancelButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryCancel"));
        this.confirmPanelS.getOKButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryEnter"));
        this.confirmPanelS.getCancelButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryCancel"));
    }

    private void addSelectionColumn(GridField mField) {
        log.config(mField.getHeader());
        int displayLength = mField.getDisplayLength();
        if (displayLength > 20) {
            mField.setDisplayLength(20);
        } else {
            displayLength = 0;
        }
        VEditor editor = null;
        if (mField.isLookup()) {
            VLookup vl = new VLookup(mField.getColumnName(), false, false, true, mField.getLookup());
            vl.setField(mField);
            vl.setName(mField.getColumnName());
            editor = vl;
        } else {
            editor = VEditorFactory.getEditor(mField, false);
            editor.setMandatory(false);
            editor.setReadWrite(true);
        }
        if (editor instanceof CTextField) {
            ((CTextField)((Object)editor)).addActionListener(this);
        }
        CLabel label = VEditorFactory.getLabel(mField);
        if (displayLength > 0) {
            mField.setDisplayLength(displayLength);
        }
        ++this.m_sLine;
        if (label != null) {
            this.scontentPanel.add((Component)label, new GridBagConstraints(1, this.m_sLine, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 5, 5), 0, 0));
        }
        this.scontentPanel.add((Component)((Object)editor), new GridBagConstraints(2, this.m_sLine, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.m_sEditors.add(editor);
    }

    private void initFindAdvanced() {
        log.config("");
        this.advancedTable.setModel(new DefaultTableModel(0, 7));
        this.advancedTable.setSelectionMode(0);
        this.advancedTable.setAutoResizeMode(4);
        this.advancedTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ProxyRenderer renderer = new ProxyRenderer(this.advancedTable.getDefaultRenderer(Object.class));
        this.advancedTable.setDefaultRenderer(Object.class, renderer);
        InputMap im = this.advancedTable.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        final Action tabAction = this.advancedTable.getActionMap().get(im.get(tab));
        AbstractAction tabActionWrapper = new AbstractAction(){
            private static final long serialVersionUID = -6868476640719619801L;

            @Override
            public void actionPerformed(ActionEvent e) {
                tabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                table.requestFocusInWindow();
            }
        };
        this.advancedTable.getActionMap().put(im.get(tab), tabActionWrapper);
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
        final Action shiftTabAction = this.advancedTable.getActionMap().get(im.get(shiftTab));
        AbstractAction shiftTabActionWrapper = new AbstractAction(){
            private static final long serialVersionUID = 5493691483070046620L;

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                table.requestFocusInWindow();
            }
        };
        this.advancedTable.getActionMap().put(im.get(shiftTab), shiftTabActionWrapper);
        ArrayList<ValueNamePair> items = new ArrayList<ValueNamePair>();
        int c = 0;
        while (c < this.m_findFields.length) {
            GridField field = this.m_findFields[c];
            String columnName = field.getColumnName();
            String header = field.getHeader();
            if (header != null && header.length() != 0 || (header = Msg.translate(Env.getCtx(), columnName)) != null && header.length() != 0) {
                if (field.isKey()) {
                    header = String.valueOf(header) + " (ID)";
                }
                ValueNamePair pp = new ValueNamePair(columnName, header);
                items.add(pp);
            }
            ++c;
        }
        this.columnValueNamePairs = new ValueNamePair[items.size()];
        items.toArray(this.columnValueNamePairs);
        Arrays.sort(this.columnValueNamePairs);
        this.columns = new CComboBox(this.columnValueNamePairs);
        this.columns.addActionListener(this);
        TableColumn tc = this.advancedTable.getColumnModel().getColumn(2);
        tc.setPreferredWidth(120);
        FindCellEditor dce = new FindCellEditor(this.columns);
        dce.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent ce) {
            }

            @Override
            public void editingStopped(ChangeEvent ce) {
                int col = Find.this.advancedTable.getSelectedColumn();
                int row = Find.this.advancedTable.getSelectedRow();
                if (col == 2 && row >= 0) {
                    Find.this.advancedTable.setValueAt(null, row, 4);
                    Find.this.advancedTable.setValueAt(null, row, 5);
                }
            }
        });
        tc.setCellEditor(dce);
        tc.setHeaderValue(Msg.translate(Env.getCtx(), "AD_Column_ID"));
        NamePair npAnd = this.getAndNP();
        NamePair npOr = this.getOrNP();
        this.andOr = new CComboBox(new NamePair[]{npAnd, npOr});
        tc = this.advancedTable.getColumnModel().getColumn(0);
        tc.setPreferredWidth(45);
        dce = new FindCellEditor(this.andOr);
        tc.setCellEditor(dce);
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "And/Or"));
        this.leftBrackets = new CComboBox(new String[]{"", "(", "((", "((("});
        tc = this.advancedTable.getColumnModel().getColumn(1);
        tc.setPreferredWidth(25);
        dce = new FindCellEditor(this.leftBrackets);
        tc.setCellEditor(dce);
        tc.setHeaderValue("(");
        this.operators = new CComboBox(MQuery.OPERATORS);
        tc = this.advancedTable.getColumnModel().getColumn(3);
        tc.setPreferredWidth(55);
        dce = new FindCellEditor(this.operators);
        tc.setCellEditor(dce);
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "Operator"));
        tc = this.advancedTable.getColumnModel().getColumn(4);
        FindValueEditor fve = new FindValueEditor(this, false);
        tc.setCellEditor(fve);
        tc.setPreferredWidth(120);
        tc.setCellRenderer(new ProxyRenderer(new FindValueRenderer(this, false)));
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "QueryValue"));
        tc = this.advancedTable.getColumnModel().getColumn(5);
        tc.setPreferredWidth(120);
        fve = new FindValueEditor(this, true);
        tc.setCellEditor(fve);
        tc.setCellRenderer(new ProxyRenderer(new FindValueRenderer(this, false)));
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "QueryValue2"));
        this.rightBrackets = new CComboBox(new String[]{"", ")", "))", ")))"});
        tc = this.advancedTable.getColumnModel().getColumn(6);
        tc.setPreferredWidth(25);
        dce = new FindCellEditor(this.rightBrackets);
        tc.setCellEditor(dce);
        tc.setHeaderValue(")");
        this.userQueries = MUserQuery.get(Env.getCtx(), this.m_AD_Tab_ID);
        String[] queries = new String[this.userQueries.length];
        int i = 0;
        while (i < this.userQueries.length) {
            queries[i] = this.userQueries[i].getName();
            ++i;
        }
        this.fQueryName.setModel(new DefaultComboBoxModel<String>(queries));
        this.fQueryName.setValue("");
        this.cmd_new();
    }

    @Override
    public void dispose() {
        log.config("");
        if (this.m_pstmt != null) {
            try {
                this.m_pstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.m_pstmt = null;
        for (VEditor editor : this.m_sEditors) {
            if (!(editor instanceof CTextField)) continue;
            ((CTextField)((Object)editor)).removeActionListener(this);
        }
        if (this.m_targetFields != null) {
            this.m_targetFields.clear();
        }
        this.m_targetFields = null;
        this.removeAll();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if (e.getActionCommand().equals("Cancel")) {
            this.cmd_cancel();
        } else if (e.getActionCommand().equals("Refresh")) {
            this.cmd_refresh();
        } else if (e.getActionCommand().equals("New")) {
            this.m_query = MQuery.getNoRecordQuery(this.m_tableName, true);
            this.m_total = 0;
            this.dispose();
        } else if (e.getSource() == this.bIgnore) {
            this.cmd_ignore();
        } else if (e.getSource() == this.bNew) {
            this.cmd_new();
        } else if (e.getSource() == this.bSave) {
            this.cmd_save(true);
        } else if (e.getSource() == this.bDelete) {
            this.cmd_delete();
        } else if (e.getSource() == this.columns) {
            String columnName = null;
            Object selected = this.columns.getSelectedItem();
            if (selected != null) {
                if (selected instanceof ValueNamePair) {
                    ValueNamePair column = (ValueNamePair)selected;
                    columnName = column.getValue();
                } else {
                    columnName = selected.toString();
                }
            }
            if (columnName != null) {
                log.config("Column: " + columnName);
                if (columnName.endsWith("_ID") || columnName.endsWith("_Acct")) {
                    this.operators.setModel(new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS_ID));
                } else if (columnName.startsWith("Is")) {
                    this.operators.setModel(new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS_YN));
                } else {
                    this.operators.setModel(new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS));
                }
            }
        } else if (e.getSource() == this.fQueryName) {
            Object o = this.fQueryName.getSelectedItem();
            if (this.userQueries != null && o != null) {
                String selected = o.toString();
                int i = 0;
                while (i < this.userQueries.length) {
                    if (this.userQueries[i].getName().equals(selected)) {
                        this.parseUserQuery(this.userQueries[i]);
                        return;
                    }
                    ++i;
                }
            }
        } else if (e.getSource() == this.confirmPanelA.getOKButton()) {
            this.cmd_ok_Advanced();
        } else if (e.getSource() == this.confirmPanelS.getOKButton()) {
            this.cmd_ok_Simple();
        } else if (e.getSource() instanceof JTextField && this.tabbedPane.getSelectedIndex() == 0) {
            this.cmd_ok_Simple();
        }
    }

    private void parseUserQuery(MUserQuery userQuery) {
        String code = userQuery.getCode();
        log.fine("Parse user query: " + code);
        String[] segments = code.split(Pattern.quote(SEGMENT_SEPARATOR), -1);
        this.advancedTable.stopEditor(true);
        DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
        int cnt = model.getRowCount();
        int i = cnt - 1;
        while (i >= 0) {
            model.removeRow(i);
            --i;
        }
        i = 0;
        while (i < segments.length) {
            String[] fields = segments[i].split(Pattern.quote(FIELD_SEPARATOR));
            Object[] objectArray = new Object[7];
            objectArray[0] = "";
            objectArray[1] = "";
            objectArray[3] = MQuery.OPERATORS[0];
            objectArray[6] = "";
            model.addRow(objectArray);
            String columnName = null;
            int j = 0;
            while (j < fields.length) {
                GridField field;
                ValueNamePair vnp;
                int n;
                ValueNamePair[] valueNamePairArray;
                if (j == 0) {
                    valueNamePairArray = this.columnValueNamePairs;
                    n = this.columnValueNamePairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        vnp = valueNamePairArray[n2];
                        if (vnp.getValue().equals(fields[j])) {
                            model.setValueAt(vnp, i, 2);
                            columnName = fields[j];
                            break;
                        }
                        ++n2;
                    }
                } else if (j == 1) {
                    valueNamePairArray = MQuery.OPERATORS;
                    n = MQuery.OPERATORS.length;
                    int n3 = 0;
                    while (n3 < n) {
                        vnp = valueNamePairArray[n3];
                        if (vnp.getValue().equals(fields[j])) {
                            model.setValueAt(vnp, i, 3);
                            break;
                        }
                        ++n3;
                    }
                } else if (j == 2 && fields[j].length() > 0) {
                    field = this.getTargetMField(columnName);
                    Object value = this.parseString(field, fields[j]);
                    model.setValueAt(value, i, 4);
                } else if (j == 3 && fields[j].length() > 0) {
                    field = this.getTargetMField(columnName);
                    Object value = this.parseString(field, fields[j]);
                    model.setValueAt(value, i, 5);
                } else if (j == 4 && fields[j].length() > 0) {
                    if (i != 0) {
                        model.setValueAt(this.getAndOrNP(fields[j]), i, 0);
                    }
                } else if (j == 5 && fields[j].length() > 0) {
                    model.setValueAt(fields[j], i, 1);
                } else if (j == 6 && fields[j].length() > 0) {
                    model.setValueAt(fields[j], i, 6);
                }
                ++j;
            }
            ++i;
        }
        this.advancedTable.invalidate();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.getRootPane().setDefaultButton(this.confirmPanelS.getOKButton());
        } else {
            this.initFindAdvanced();
            this.getRootPane().setDefaultButton(this.confirmPanelA.getOKButton());
            this.advancedTable.requestFocusInWindow();
        }
    }

    private void cmd_ok_Simple() {
        String value;
        this.m_query = new MQuery(this.m_tableName);
        this.m_query.addRestriction(Env.parseContext(Env.getCtx(), this.m_targetWindowNo, this.m_whereExtended, false));
        if (this.hasValue && !this.valueField.getText().equals("%") && this.valueField.getText().length() != 0) {
            value = this.valueField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            this.m_query.addRestriction("UPPER(Value)", " LIKE ", value, this.valueLabel.getText(), value);
        }
        if (this.hasDocNo && !this.docNoField.getText().equals("%") && this.docNoField.getText().length() != 0) {
            value = this.docNoField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            this.m_query.addRestriction("UPPER(DocumentNo)", " LIKE ", value, this.docNoLabel.getText(), value);
        }
        if (this.hasName && !this.nameField.getText().equals("%") && this.nameField.getText().length() != 0) {
            value = this.nameField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            this.m_query.addRestriction("UPPER(Name)", " LIKE ", value, this.nameLabel.getText(), value);
        }
        if (this.hasDescription && !this.descriptionField.getText().equals("%") && this.descriptionField.getText().length() != 0) {
            value = this.descriptionField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            this.m_query.addRestriction("UPPER(Description)", " LIKE ", value, this.descriptionLabel.getText(), value);
        }
        int i = 0;
        while (i < this.m_sEditors.size()) {
            VEditor ved = this.m_sEditors.get(i);
            Object value2 = ved.getValue();
            if (value2 != null && value2.toString().length() > 0) {
                String ColumnName = ((Component)((Object)ved)).getName();
                log.fine(String.valueOf(ColumnName) + "=" + value2);
                GridField field = this.getTargetMField(ColumnName);
                boolean isProductCategoryField = this.isProductCategoryField(field.getAD_Column_ID());
                String ColumnSQL = field.getColumnSQL(false);
                if (value2.toString().indexOf(37) != -1) {
                    this.m_query.addRestriction(ColumnSQL, " LIKE ", value2, ColumnName, ved.getDisplay());
                } else if (isProductCategoryField && value2 instanceof Integer) {
                    this.m_query.addRestriction(this.getSubCategoryWhereClause((Integer)value2));
                } else {
                    this.m_query.addRestriction(ColumnSQL, "=", value2, ColumnName, ved.getDisplay());
                }
            }
            ++i;
        }
        this.m_isCancel = false;
        if (this.getNoOfRecords(this.m_query, true) != 0) {
            this.dispose();
        }
    }

    private void cmd_ok_Advanced() {
        this.m_isCancel = false;
        if (this.bSave.isEnabled()) {
            this.cmd_save(false);
        }
        if (this.getNoOfRecords(this.m_query, true) != 0) {
            this.dispose();
        }
    }

    private void cmd_cancel() {
        this.advancedTable.stopEditor(false);
        log.info("");
        this.m_query = null;
        this.m_total = 999999;
        this.m_isCancel = true;
        this.dispose();
    }

    private void cmd_ignore() {
        log.info("");
    }

    private void cmd_new() {
        this.advancedTable.stopEditor(true);
        DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
        int rows = model.getRowCount();
        Object[] objectArray = new Object[7];
        objectArray[0] = rows == 0 ? "" : Msg.getMsg(Env.getCtx(), "AND");
        objectArray[1] = "";
        objectArray[3] = MQuery.OPERATORS[0];
        objectArray[6] = "";
        model.addRow(objectArray);
        this.advancedTable.requestFocusInWindow();
    }

    private void cmd_save(boolean saveQuery) {
        this.advancedTable.stopEditor(true);
        this.m_query = new MQuery(this.m_tableName);
        this.m_query.addRestriction(Env.parseContext(Env.getCtx(), this.m_targetWindowNo, this.m_whereExtended, false));
        StringBuffer code = new StringBuffer();
        int openBrackets = 0;
        int row = 0;
        while (row < this.advancedTable.getRowCount()) {
            block21: {
                Object value2;
                Object value;
                String Operator2;
                boolean and;
                String rBrackets;
                String lBrackets;
                String ColumnName;
                block24: {
                    String infoDisplay;
                    Object parsedValue;
                    String ColumnSQL;
                    String infoName;
                    block25: {
                        Object op;
                        boolean isProductCategoryField;
                        block23: {
                            GridField field;
                            block22: {
                                Object column = this.advancedTable.getValueAt(row, 2);
                                if (column == null) break block21;
                                ColumnName = column instanceof ValueNamePair ? ((ValueNamePair)column).getValue() : column.toString();
                                infoName = column.toString();
                                field = this.getTargetMField(ColumnName);
                                if (field == null) break block21;
                                isProductCategoryField = this.isProductCategoryField(field.getAD_Column_ID());
                                ColumnSQL = field.getColumnSQL(false);
                                lBrackets = (String)this.advancedTable.getValueAt(row, 1);
                                if (lBrackets != null) {
                                    openBrackets += lBrackets.length();
                                }
                                if ((rBrackets = (String)this.advancedTable.getValueAt(row, 6)) != null) {
                                    openBrackets -= rBrackets.length();
                                }
                                and = true;
                                if (row > 0) {
                                    Object andOr = this.advancedTable.getValueAt(row, 0);
                                    if (andOr instanceof NamePair) {
                                        NamePair npAndOr = (NamePair)andOr;
                                        and = !"OR".equals(npAndOr.getID());
                                    } else {
                                        boolean bl = and = !"OR".equals(andOr.toString());
                                    }
                                }
                                if ((op = this.advancedTable.getValueAt(row, 3)) == null) break block21;
                                Operator2 = ((ValueNamePair)op).getValue();
                                value = this.advancedTable.getValueAt(row, 4);
                                if (value != null) break block22;
                                if (MQuery.OPERATORS[0].equals(op) || MQuery.OPERATORS[1].equals(op)) {
                                    this.m_query.addRestriction(ColumnSQL, Operator2, null, infoName, null, and, openBrackets);
                                    if (code.length() > 0) {
                                        code.append(SEGMENT_SEPARATOR);
                                    }
                                    code.append(ColumnName).append(FIELD_SEPARATOR).append(Operator2).append(FIELD_SEPARATOR).append("").append(FIELD_SEPARATOR).append("").append(FIELD_SEPARATOR).append(and ? "AND" : "OR").append(FIELD_SEPARATOR).append(lBrackets != null ? lBrackets : "").append(FIELD_SEPARATOR).append(rBrackets != null ? rBrackets : "");
                                }
                                break block21;
                            }
                            parsedValue = this.parseValue(field, value);
                            if (parsedValue == null) break block21;
                            infoDisplay = value.toString();
                            if (field.isLookup()) {
                                infoDisplay = field.getLookup().getDisplay(value);
                            } else if (field.getDisplayType() == 20) {
                                infoDisplay = Msg.getMsg(Env.getCtx(), infoDisplay);
                            }
                            value2 = null;
                            if (!MQuery.OPERATORS[8].equals(op)) break block23;
                            value2 = this.advancedTable.getValueAt(row, 5);
                            if (value2 == null) break block21;
                            Object parsedValue2 = this.parseValue(field, value2);
                            String infoDisplay_to = value2.toString();
                            if (parsedValue2 == null) break block21;
                            this.m_query.addRangeRestriction(ColumnSQL, parsedValue, parsedValue2, infoName, infoDisplay, infoDisplay_to, and, openBrackets);
                            break block24;
                        }
                        if (!isProductCategoryField || !MQuery.OPERATORS[0].equals(op)) break block25;
                        if (!(parsedValue instanceof Integer)) break block21;
                        this.m_query.addRestriction(this.getSubCategoryWhereClause((Integer)parsedValue), and, openBrackets);
                        break block24;
                    }
                    this.m_query.addRestriction(ColumnSQL, Operator2, parsedValue, infoName, infoDisplay, and, openBrackets);
                }
                if (code.length() > 0) {
                    code.append(SEGMENT_SEPARATOR);
                }
                code.append(ColumnName).append(FIELD_SEPARATOR).append(Operator2).append(FIELD_SEPARATOR).append(value.toString()).append(FIELD_SEPARATOR).append(value2 != null ? value2.toString() : "").append(FIELD_SEPARATOR).append(and ? "AND" : "OR").append(FIELD_SEPARATOR).append(lBrackets != null ? lBrackets : "").append(FIELD_SEPARATOR).append(rBrackets != null ? rBrackets : "");
            }
            ++row;
        }
        Object selected = this.fQueryName.getSelectedItem();
        if (selected != null && saveQuery) {
            String name = selected.toString();
            if (Util.isEmpty(name, true)) {
                ADialog.warn(this.m_targetWindowNo, this, "FillMandatory", Msg.translate(Env.getCtx(), "Name"));
                return;
            }
            MUserQuery uq = MUserQuery.get(Env.getCtx(), this.m_AD_Tab_ID, name);
            if (uq == null && code.length() > 0) {
                uq = new MUserQuery(Env.getCtx(), 0, null);
                uq.setName(name);
                uq.setAD_Tab_ID(this.m_AD_Tab_ID);
                uq.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
            } else if (uq != null && code.length() == 0) {
                if (uq.delete(true)) {
                    ADialog.info(this.m_targetWindowNo, this, "Deleted", name);
                    this.refreshUserQueries();
                } else {
                    ADialog.warn(this.m_targetWindowNo, this, "DeleteError", name);
                }
                return;
            }
            uq.setCode(code.toString());
            uq.setAD_Table_ID(this.m_AD_Table_ID);
            if (uq.save()) {
                ADialog.info(this.m_targetWindowNo, this, "Saved", name);
                this.refreshUserQueries();
            } else {
                ADialog.warn(this.m_targetWindowNo, this, "SaveError", name);
            }
        }
    }

    private void refreshUserQueries() {
        Object selected = this.fQueryName.getSelectedItem();
        this.userQueries = MUserQuery.get(Env.getCtx(), this.m_AD_Tab_ID);
        String[] queries = new String[this.userQueries.length];
        int i = 0;
        while (i < this.userQueries.length) {
            queries[i] = this.userQueries[i].getName();
            ++i;
        }
        this.fQueryName.setModel(new DefaultComboBoxModel<String>(queries));
        this.fQueryName.setSelectedItem(selected);
        if (this.fQueryName.getSelectedIndex() < 0) {
            this.fQueryName.setValue("");
        }
    }

    private boolean isProductCategoryField(int columnId) {
        X_AD_Column col = new X_AD_Column(Env.getCtx(), columnId, null);
        if (col.get_ID() == 0) {
            return false;
        }
        return "M_Product_Category_ID".equals(col.getColumnName());
    }

    private String getSubCategoryWhereClause(int productCategoryId) {
        String retString;
        block8: {
            int subTreeRootParentId = 0;
            retString = " M_Product_Category_ID IN (";
            String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
            Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = DB.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    if (rs.getInt(1) == productCategoryId) {
                        subTreeRootParentId = rs.getInt(2);
                    }
                    categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
                }
                retString = String.valueOf(retString) + this.getSubCategoriesString(productCategoryId, categories, subTreeRootParentId);
                retString = String.valueOf(retString) + ") ";
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
                retString = "";
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                break block8;
            }
            catch (AdempiereSystemError e) {
                try {
                    log.log(Level.SEVERE, sql, e);
                    retString = "";
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                break block8;
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        return retString;
    }

    private String getSubCategoriesString(int productCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) throws AdempiereSystemError {
        String ret = "";
        for (SimpleTreeNode node : categories) {
            if (node.getParentId() != productCategoryId) continue;
            if (node.getNodeId() == loopIndicatorId) {
                throw new AdempiereSystemError("The product category tree contains a loop on categoryId: " + loopIndicatorId);
            }
            ret = String.valueOf(ret) + this.getSubCategoriesString(node.getNodeId(), categories, loopIndicatorId) + ",";
        }
        log.fine(ret);
        return String.valueOf(ret) + productCategoryId;
    }

    private Object parseValue(GridField field, Object in) {
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                if (in instanceof Integer) {
                    return in;
                }
                int i = Integer.parseInt(in.toString());
                return new Integer(i);
            }
            if (DisplayType.isNumeric(dt)) {
                if (in instanceof BigDecimal) {
                    return in;
                }
                return DisplayType.getNumberFormat(dt).parse(in.toString());
            }
            if (DisplayType.isDate(dt)) {
                if (in instanceof Timestamp) {
                    return in;
                }
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, in + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? "Y" : "N";
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, ex);
            String error = ex.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = ex.toString();
            }
            StringBuffer errMsg = new StringBuffer();
            errMsg.append(field.getColumnName()).append(" = ").append(in).append(" - ").append(error);
            ADialog.error(0, this, "ValidationError", errMsg.toString());
            return null;
        }
        return in;
    }

    private Object parseString(GridField field, String in) {
        log.log(Level.FINE, "Parse: " + field + ":" + in);
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                int i = Integer.parseInt(in);
                return new Integer(i);
            }
            if (DisplayType.isNumeric(dt)) {
                return DisplayType.getNumberFormat(dt).parse(in);
            }
            if (DisplayType.isDate(dt)) {
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, String.valueOf(in) + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in).getTime();
                    return new Timestamp(time);
                }
            }
            if (dt == 20) {
                return Boolean.valueOf(in);
            }
            return in;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, ex);
            return null;
        }
    }

    private void cmd_delete() {
        this.advancedTable.stopEditor(false);
        DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
        int row = this.advancedTable.getSelectedRow();
        if (row >= 0) {
            model.removeRow(row);
        }
        this.cmd_refresh();
        this.advancedTable.requestFocusInWindow();
    }

    private void cmd_refresh() {
        this.advancedTable.stopEditor(false);
        int records = this.getNoOfRecords(this.m_query, true);
        this.setStatusDB(records);
        this.statusBar.setStatusLine("");
    }

    public MQuery getQuery() {
        MRole role = MRole.getDefault();
        if (role.isQueryMax(this.getTotalRecords()) && !this.m_isCancel) {
            this.m_query = MQuery.getNoRecordQuery(this.m_tableName, false);
            this.m_total = 0;
            log.warning("Query - over max");
        } else {
            log.info("Query=" + this.m_query);
        }
        return this.m_query;
    }

    public int getTotalRecords() {
        return this.m_total;
    }

    private int getNoOfRecords(MQuery query, boolean alertZeroRecords) {
        block15: {
            log.config("" + query);
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ");
            sql.append(this.m_tableName);
            boolean hasWhere = false;
            if (this.m_whereExtended != null && this.m_whereExtended.length() > 0) {
                sql.append(" WHERE ").append(this.m_whereExtended);
                hasWhere = true;
            }
            if (query != null && query.isActive()) {
                if (hasWhere) {
                    sql.append(" AND ");
                } else {
                    sql.append(" WHERE ");
                }
                sql.append(query.getWhereClause());
            }
            String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
            finalSQL = Env.parseContext(Env.getCtx(), this.m_targetWindowNo, finalSQL, false);
            Env.setContext(Env.getCtx(), this.m_targetWindowNo, 99, "_TabInfo_FindSQL", finalSQL);
            this.m_total = 999999;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.createStatement();
                    rs = stmt.executeQuery(finalSQL);
                    if (rs.next()) {
                        this.m_total = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, finalSQL, e);
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        MRole role = MRole.getDefault();
        if (this.m_total == 0 && alertZeroRecords) {
            ADialog.info(this.m_targetWindowNo, this, "FindZeroRecords");
        } else if (query != null && role.isQueryMax(this.m_total)) {
            ADialog.error(this.m_targetWindowNo, this, "FindOverMax", String.valueOf(this.m_total) + " > " + role.getMaxQueryRecords());
            this.m_total = 0;
        } else {
            log.config("#" + this.m_total);
        }
        if (query != null) {
            this.statusBar.setStatusToolTip(query.getWhereClause());
        }
        return this.m_total;
    }

    private void setStatusDB(int currentCount) {
        String text = " " + currentCount + " / " + this.m_total + " ";
        this.statusBar.setStatusDB(text);
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        log.config(e.getMessage());
        boolean changed = e.isChanged();
        this.bIgnore.setEnabled(changed);
        this.bNew.setEnabled(!changed);
        this.bSave.setEnabled(changed);
        this.bDelete.setEnabled(!changed);
    }

    public GridField getTargetMField(String columnName) {
        if (columnName == null) {
            return null;
        }
        int c = 0;
        while (c < this.m_findFields.length) {
            GridField field = this.m_findFields[c];
            if (columnName.equals(field.getColumnName())) {
                return field;
            }
            ++c;
        }
        return null;
    }

    protected NamePair getAndOrNP(String sValue) {
        NamePair np = null;
        np = sValue.equals("AND") ? this.getAndNP() : this.getOrNP();
        return np;
    }

    protected NamePair getAndNP() {
        return new NamePair(Msg.getMsg(Env.getCtx(), "AND")){
            private static final long serialVersionUID = 1L;

            @Override
            public String getID() {
                return "AND";
            }
        };
    }

    protected NamePair getOrNP() {
        return new NamePair(Msg.getMsg(Env.getCtx(), "OR")){
            private static final long serialVersionUID = 1L;

            @Override
            public String getID() {
                return "OR";
            }
        };
    }

    private class ProxyRenderer
    implements TableCellRenderer {
        private TableCellRenderer m_renderer;

        public ProxyRenderer(TableCellRenderer renderer) {
            this.m_renderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component comp = this.m_renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (hasFocus && table.isCellEditable(row, col)) {
                table.editCellAt(row, col);
            }
            return comp;
        }
    }

    private class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

