/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.compiere.apps.search.FilterDesc;
import org.compiere.apps.search.IAbstractInfo;
import org.compiere.apps.search.UICallback;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class AbstractInfoSupport<E, L> {
    private boolean m_bQueryEndsWithWhere;
    private ArrayList<FilterDesc<E, L>> m_lstFilters = new ArrayList();
    private int m_iFilterField = -1;
    private ArrayList<Object> m_lstQueryParams = new ArrayList();
    private int m_iFirstSQLParameter = 1;
    private IAbstractInfo<E> m_info;
    private UICallback<E, L> m_valueCallback;

    public AbstractInfoSupport(IAbstractInfo<E> info, UICallback<E, L> valueCallback) {
        this.m_info = info;
        this.m_valueCallback = valueCallback;
    }

    public List<FilterDesc<E, L>> getFilters() {
        return this.m_lstFilters;
    }

    public int getFilterField() {
        return this.m_iFilterField;
    }

    public void setFilterField(int iFilterFieldIdx) {
        this.m_iFilterField = iFilterFieldIdx;
    }

    public boolean hasFilterFieldValue() {
        return this.m_iFilterField >= 0 && this.checkQueryParameter(this.getFilterValue(this.m_iFilterField));
    }

    public void setInitialFilterValue(Object value) {
        if (this.m_iFilterField >= 0) {
            if (value instanceof String) {
                String sval = (String)value;
                if (sval.startsWith("@")) {
                    sval = sval.substring(1);
                }
                if (sval.endsWith("@")) {
                    sval = sval.substring(0, sval.length() - 1);
                }
                value = sval;
            }
            this.setFilterValue(this.m_iFilterField, value);
        }
    }

    public void setFilterValue(int index, Object obj) {
        FilterDesc<E, L> filter = this.m_lstFilters.get(index);
        if (this.m_valueCallback.isLookup(filter.m_field)) {
            if (!(obj == null || obj instanceof String && ((String)obj).length() == 0)) {
                this.m_valueCallback.setValue(filter.m_field, obj);
            }
        } else {
            this.m_valueCallback.setValue(filter.m_field, obj);
        }
    }

    public Object getFilterValue(int index) {
        FilterDesc<E, L> filter = this.m_lstFilters.get(index);
        return this.m_valueCallback.getValue(filter.m_field);
    }

    public E getFilterEditor(int idx) {
        if (idx < 0 || idx >= this.m_lstFilters.size()) {
            return null;
        }
        FilterDesc<E, L> filter = this.m_lstFilters.get(idx);
        return filter.m_field;
    }

    public L getFilterLabel(int idx) {
        if (idx < 0 || idx >= this.m_lstFilters.size()) {
            return null;
        }
        FilterDesc<E, L> filter = this.m_lstFilters.get(idx);
        return filter.m_cLabel;
    }

    public void setFilterQuery(int idx, String sWhereClause) {
        FilterDesc<E, L> filter = this.m_lstFilters.get(idx);
        filter.m_sWhere = sWhereClause;
    }

    public int addFilter(String AD_Message, E component, String sWhereClause, boolean bValueField, boolean bTranslate) {
        FilterDesc filter = new FilterDesc();
        if (bValueField && this.m_iFilterField < 0) {
            this.m_iFilterField = this.m_lstFilters.size();
        }
        filter.m_sLabel = bTranslate ? Msg.translate(Env.getCtx(), AD_Message) : AD_Message;
        filter.m_cLabel = this.m_valueCallback.createLabel(filter.m_sLabel);
        filter.m_field = component;
        filter.m_sWhere = sWhereClause;
        filter.m_bValueField = bValueField;
        this.m_lstFilters.add(filter);
        return this.m_lstFilters.size() - 1;
    }

    public int addFilter(String AD_Message, E component, String sWhereClause, boolean bValueField) {
        return this.addFilter(AD_Message, component, sWhereClause, bValueField, true);
    }

    public int addUIElement(E ui, String sLabel, boolean bTranslate) {
        FilterDesc filter = new FilterDesc();
        filter.m_bUIOnly = true;
        filter.m_field = ui;
        if (sLabel != null) {
            filter.m_sLabel = bTranslate ? Msg.translate(Env.getCtx(), sLabel) : sLabel;
            filter.m_cLabel = this.m_valueCallback.createLabel(filter.m_sLabel);
        }
        this.m_lstFilters.add(filter);
        return this.m_lstFilters.size() - 1;
    }

    private boolean checkQueryParameter(Object oValue) {
        if (oValue != null) {
            if (oValue instanceof String) {
                return ((String)oValue).length() > 0;
            }
            return true;
        }
        return false;
    }

    public String getSQLWhere() {
        this.m_lstQueryParams.clear();
        StringBuffer sb = new StringBuffer();
        for (FilterDesc<E, L> desc : this.m_lstFilters) {
            Object oValue;
            if (desc.m_bUIOnly || !this.checkQueryParameter(oValue = this.m_valueCallback.getValue(desc.m_field))) continue;
            boolean bAsLike = true;
            if (oValue instanceof Boolean) {
                boolean bValue = (Boolean)oValue;
                if (desc.m_bIsBooleanField) {
                    if ((!bValue || desc.m_bNegateBoolean) && (bValue || !desc.m_bNegateBoolean)) continue;
                    sb.append(" AND ").append(desc.m_sWhere);
                    continue;
                }
                bAsLike = false;
                oValue = bValue ? "Y" : "N";
            }
            if (this.m_bQueryEndsWithWhere && sb.length() == 0) {
                sb.append(desc.m_sWhere);
            } else {
                sb.append(" and ").append(desc.m_sWhere);
            }
            if (oValue instanceof String && !this.m_valueCallback.isLookup(desc.m_field) && bAsLike) {
                String sValue = (String)oValue;
                if (!sValue.startsWith("%")) {
                    sValue = "%" + sValue;
                }
                if (!sValue.endsWith("%")) {
                    sValue = String.valueOf(sValue) + "%";
                }
                oValue = sValue.toLowerCase();
            }
            if (desc.m_bIsTranscoded) {
                oValue = this.m_info.transcodeParam(desc.m_field, oValue);
            }
            int nrp = 0;
            while (nrp < desc.m_iRepeatParam) {
                this.m_lstQueryParams.add(oValue);
                ++nrp;
            }
        }
        return sb.toString();
    }

    public void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int iParm = this.m_iFirstSQLParameter;
        for (Object param : this.m_lstQueryParams) {
            pstmt.setObject(iParm++, param);
        }
        this.m_lstQueryParams.clear();
    }

    public int getFirstSQLParameterIndex() {
        return this.m_iFirstSQLParameter;
    }

    public void setFirstSQLParameterIndex(int i) {
        this.m_iFirstSQLParameter = i;
    }

    public void setLineBreakOnFilter(int idx, boolean bLineBreak) {
        FilterDesc<E, L> filter = this.m_lstFilters.get(idx);
        filter.m_bLineBreak = bLineBreak;
    }

    public void setFilterAsUIOnly(int idx, boolean bLineBreak) {
        FilterDesc<E, L> filter = this.m_lstFilters.get(idx);
        filter.m_bUIOnly = bLineBreak;
    }

    public void setFilterAsBoolean(int idx, boolean bNegate) {
        FilterDesc<E, L> filter = this.m_lstFilters.get(idx);
        filter.m_bNegateBoolean = bNegate;
        filter.m_bIsBooleanField = true;
    }

    public void setFilterAsTranscoded(int idx, boolean bTranscoded) {
        FilterDesc<E, L> filter = this.m_lstFilters.get(idx);
        filter.m_bIsTranscoded = bTranscoded;
    }

    public void setFilterRepeatParam(int idx, int iRepeats) {
        FilterDesc<E, L> filter = this.m_lstFilters.get(idx);
        filter.m_iRepeatParam = iRepeats;
    }

    public Object transcodeParam(E field, Object value) {
        return value;
    }

    public boolean isQueryEndsWithWhere() {
        return this.m_bQueryEndsWithWhere;
    }

    public void setQueryEndsWithWhere(boolean bQueryEndsWithWhere) {
        this.m_bQueryEndsWithWhere = bQueryEndsWithWhere;
    }
}

