/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import com.f3p.adempiere.util.EnvHelper;
import com.f3p.adempiere.util.FieldHelper;
import com.f3p.adempiere.util.QueryRepo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.table.TableColumn;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.search.AbstractInfoSupport;
import org.compiere.apps.search.FilterDesc;
import org.compiere.apps.search.IAbstractInfo;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.UICallback;
import org.compiere.grid.ed.VCellEditor;
import org.compiere.grid.ed.VCellRenderer;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VString;
import org.compiere.grid.ed.VText;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridField;
import org.compiere.swing.CLabel;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public abstract class AbstractInfo
extends Info
implements VetoableChangeListener,
FormPanel,
IAbstractInfo<VEditor> {
    private static final SwingUICallback EDITOR_VALUE_CALLBACK = new SwingUICallback();
    private static final long serialVersionUID = 1L;
    private boolean m_bMulti = false;
    private boolean m_bShowTotals = true;
    private FormFrame m_formFrame = null;
    private boolean m_bDisableDoubleClick = false;
    private AbstractInfoSupport<VEditor, CLabel> m_aiSupport = new AbstractInfoSupport<VEditor, CLabel>(this, EDITOR_VALUE_CALLBACK);

    public AbstractInfo(Frame frame, boolean bModal, int WindowNo, boolean bMulti, String sWhere) {
        super(frame, bModal, WindowNo, null, null, bMulti, sWhere);
        this.p_tableName = this.getTableName();
        this.p_keyColumn = String.valueOf(this.getTableName()) + "_ID";
        this.p_table = this.createMiniTable();
        this.m_bMulti = bMulti;
    }

    public AbstractInfo() {
        this.p_table = this.createMiniTable();
    }

    @Override
    public abstract String getTableName();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_formFrame = frame;
        super.basicInit(WindowNo, this.getTableName(), String.valueOf(this.getTableName()) + "_ID", this.isMultiSelectable(), "");
        this.initialize();
        this.toFront();
        this.requestFocus();
    }

    @Override
    public Container getContentPane() {
        if (this.m_formFrame != null) {
            return this.m_formFrame.getContentPane();
        }
        return super.getContentPane();
    }

    public int getRecordId() {
        if (this.m_formFrame != null) {
            return this.m_formFrame.getProcessInfo().getRecord_ID();
        }
        return -1;
    }

    @Override
    protected ArrayList<Integer> getSelectedRowKeys() {
        ArrayList<Integer> selectedDataList = new ArrayList();
        if (!this.p_multiSelection) {
            selectedDataList = super.getSelectedRowKeys();
        } else {
            int rows = this.p_table.getRowCount();
            int row = 0;
            while (row < rows) {
                Object data = this.p_table.getModel().getValueAt(row, this.m_keyColumnIndex);
                if (data instanceof IDColumn) {
                    IDColumn dataColumn = (IDColumn)data;
                    if (dataColumn.isSelected()) {
                        selectedDataList.add(dataColumn.getRecord_ID());
                    }
                } else {
                    this.log.severe("For multiple selection, IDColumn should be key column for selection");
                }
                ++row;
            }
        }
        return selectedDataList;
    }

    @Override
    public void setTitle(String AD_Message) {
        String sTitle = Msg.translate(Env.getCtx(), AD_Message);
        if (this.m_formFrame != null) {
            this.m_formFrame.setTitle(sTitle);
        } else {
            super.setTitle(sTitle);
        }
    }

    public ConfirmPanel getConfirmPanel() {
        return this.confirmPanel;
    }

    public void removePrintButton() {
        this.m_printButton.getParent().remove(this.m_printButton);
    }

    public void initTableInfo(String sLQuery, String sOrderClause) {
        boolean bQueryEndsWithWhere = false;
        String sRawQuery = QueryRepo.getQuery(sLQuery);
        String query = EnvHelper.parseStringWithEnv(Env.getCtx(), sRawQuery, this.p_WindowNo, 0);
        this.prepareTable(this.getTableLayout(), "from", "where", sOrderClause);
        if (query.endsWith("WHERE")) {
            this.m_aiSupport.setQueryEndsWithWhere(true);
            bQueryEndsWithWhere = true;
        }
        if (this.p_whereClause != null && this.p_whereClause.length() > 0) {
            query = bQueryEndsWithWhere ? String.valueOf(query) + this.p_whereClause : String.valueOf(query) + " and " + this.p_whereClause;
        }
        int iSelect = query.indexOf("SELECT") + 6;
        int iFrom = query.indexOf("FROM");
        if (iFrom < 0 || iSelect < 0) {
            throw new RuntimeException("SELECT o FROM non trovate nella query, verificare che siano presenti e in maiuscolo");
        }
        String sCountQuery = String.valueOf(query.substring(0, iSelect + 1)) + "count('ok') " + query.substring(iFrom);
        this.setSqlMain(query);
        this.setSqlCount(sCountQuery);
    }

    public void setColumnClass(int index, int nColumnID) {
        TableColumn tc = this.p_table.getColumnModel().getColumn(index);
        if (tc == null) {
            return;
        }
        GridField gField = FieldHelper.getField(this.p_WindowNo, nColumnID, true);
        VCellEditor vc = new VCellEditor(gField);
        VCellRenderer vcRenderer = new VCellRenderer(gField);
        tc.setCellEditor(vc);
        tc.setCellRenderer(vcRenderer);
        tc.setMinWidth(100);
    }

    public MiniTable createMiniTable() {
        return this.p_table;
    }

    public void initialize() {
        this.parameterPanel.setLayout(new ALayout());
        int iBaseRow = 0;
        int iCol = 0;
        for (FilterDesc<VEditor, CLabel> desc : this.m_aiSupport.getFilters()) {
            Component field = (Component)desc.m_field;
            if (!desc.m_bUIOnly) {
                if (field instanceof VString) {
                    ((VEditor)((Object)field)).addActionListener(this);
                } else {
                    ((VEditor)desc.m_field).addVetoableChangeListener(this);
                }
            }
            if (desc.m_sLabel != null) {
                this.parameterPanel.add((Component)desc.m_cLabel, new ALayoutConstraint(iBaseRow, iCol));
                this.parameterPanel.add(field, new ALayoutConstraint(iBaseRow + 1, iCol++));
            } else {
                this.parameterPanel.add(field, new ALayoutConstraint(iBaseRow, iCol++));
            }
            if (!desc.m_bLineBreak) continue;
            iCol = 0;
            iBaseRow += 2;
        }
        this.initTableInfo(this.getQueryName(), this.getOrderBy());
        this.p_table.setShowTotals(this.m_bShowTotals);
        if (this.m_aiSupport.hasFilterFieldValue()) {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(this.getOwner(), this);
    }

    public FormFrame getFormFrame() {
        return this.m_formFrame;
    }

    public void setDisabledDoubleClick(boolean bVal) {
        this.m_bDisableDoubleClick = bVal;
    }

    @Override
    protected void executeQuery() {
        this.p_table.setRowCount(0);
        super.executeQuery();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
        this.executeQuery();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1 && this.m_bDisableDoubleClick) {
            return;
        }
        if (!this.m_bMulti) {
            super.mouseClicked(evt);
        }
    }

    @Override
    public void dispose() {
        if (this.m_formFrame != null) {
            this.m_formFrame.dispose();
        }
        super.dispose();
    }

    @Override
    public void dispose(boolean ok) {
        if (this.m_formFrame != null) {
            this.m_formFrame.dispose();
        }
        super.dispose(ok);
    }

    @Override
    public int getWindowNo() {
        return this.p_WindowNo;
    }

    @Override
    protected String getSQLWhere() {
        return this.m_aiSupport.getSQLWhere();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        this.m_aiSupport.setParameters(pstmt, forCount);
    }

    @Override
    public Object transcodeParam(VEditor field, Object value) {
        return value;
    }

    public void setShowTotals(boolean bValue) {
        this.m_bShowTotals = bValue;
    }

    public AbstractInfoSupport<VEditor, CLabel> getSupport() {
        return this.m_aiSupport;
    }

    public int addUIElement(FieldHelper.Editor editor) {
        return this.m_aiSupport.addUIElement(editor.getEditor(), editor.getLabel().getText(), false);
    }

    public int addFilter(int AD_Column_ID) {
        return this.addFilter(AD_Column_ID, true);
    }

    public int addFilter(int AD_Column_ID, boolean bValueField) {
        FieldHelper.Editor editor = FieldHelper.getEditor(this.getWindowNo(), AD_Column_ID);
        VEditor veditor = editor.getEditor();
        StringBuffer sbWhere = new StringBuffer();
        if (veditor instanceof VString || veditor instanceof VText) {
            sbWhere.append("LOWER(").append(this.p_tableName).append('.').append(veditor.getName()).append(") LIKE ?");
        } else {
            sbWhere.append(this.p_tableName).append('.').append(veditor.getName()).append(" = ?");
        }
        return this.m_aiSupport.addFilter(editor.getLabel().getText(), veditor, sbWhere.toString(), bValueField, false);
    }

    @Deprecated
    public CLabel getFilterLabel(int idx) {
        return this.m_aiSupport.getFilterLabel(idx);
    }

    @Deprecated
    public VEditor getFilterEditor(int idx) {
        return this.m_aiSupport.getFilterEditor(idx);
    }

    @Deprecated
    public void setFilterQuery(int idx, String sWhereClause) {
        this.m_aiSupport.setFilterQuery(idx, sWhereClause);
    }

    @Deprecated
    public void setFilterValue(int idx, Object obj) {
        this.m_aiSupport.setFilterValue(idx, obj);
    }

    @Deprecated
    public int addUIElement(VEditor ui, String sLabel, boolean bTranslate) {
        return this.m_aiSupport.addUIElement(ui, sLabel, bTranslate);
    }

    @Deprecated
    public void setLineBreakOnFilter(int idx, boolean bLineBreak) {
        this.m_aiSupport.setLineBreakOnFilter(idx, bLineBreak);
    }

    @Deprecated
    public void setFilterRepeatParam(int idx, int iRepeats) {
        this.m_aiSupport.setFilterRepeatParam(idx, iRepeats);
    }

    @Deprecated
    public void setFilterAsTranscoded(int idx, boolean bTranscoded) {
        this.m_aiSupport.setFilterAsTranscoded(idx, bTranscoded);
    }

    @Deprecated
    public Object getFilterValue(int index) {
        return this.m_aiSupport.getFilterValue(index);
    }

    @Deprecated
    public void setFilterAsUIOnly(int index, boolean bUIOnly) {
        this.m_aiSupport.setFilterAsUIOnly(index, true);
    }

    @Deprecated
    public int addFilter(String AD_Message, VEditor component, String sWhereClause, boolean bValueField) {
        return this.m_aiSupport.addFilter(AD_Message, component, sWhereClause, bValueField);
    }

    @Deprecated
    public void setFirstSQLParameterIndex(int i) {
        this.m_aiSupport.setFirstSQLParameterIndex(i);
    }

    @Deprecated
    public void setFilterAsBoolean(int idx, boolean bNegate) {
        this.m_aiSupport.setFilterAsBoolean(idx, bNegate);
    }

    public static class SwingUICallback
    implements UICallback<VEditor, CLabel> {
        @Override
        public Object getValue(VEditor editor) {
            return editor.getValue();
        }

        @Override
        public void setValue(VEditor editor, Object value) {
            editor.setValue(value);
        }

        @Override
        public CLabel createLabel(String sText) {
            return new CLabel(sText);
        }

        @Override
        public boolean isLookup(VEditor editor) {
            return editor instanceof VLookup;
        }
    }
}

