/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class createDistinct
extends GenForm {
    private static CLogger log = CLogger.getCLogger(createDistinct.class);
    public Object m_C_Bank_ID = null;
    public Timestamp RB_DataScadenzaDa = null;
    public Timestamp RB_DataScadenzaA = null;
    public Timestamp p_RB_DataPresentazione = null;
    public int p_C_Bank_ID;
    public int p_RB_distinct_number;

    @Override
    public void dynInit() throws Exception {
        this.setTitle("CreaDistintaManuale");
        this.setReportEngineType(1);
        this.setAskPrintMsg("PrintShipments");
    }

    @Override
    public void configureMiniTable(IMiniTable miniTable) {
        miniTable.addColumn("RB_Effects_ID");
        miniTable.addColumn("duedate");
        miniTable.addColumn("C_BPartner_ID");
        miniTable.addColumn("C_BP_BankAccount_ID");
        miniTable.addColumn("DiscountAmt");
        miniTable.addColumn("C_Invoice_ID");
        miniTable.addColumn("RB_Invoice_ID");
        miniTable.addColumn("DateInvoiced");
        miniTable.setMultiSelection(true);
        miniTable.setColumnClass(0, IDColumn.class, false, " ");
        miniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "duedate"));
        miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "C_BP_BankAccount_ID"));
        miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "DiscountAmt"));
        miniTable.setColumnClass(5, Timestamp.class, true, Msg.translate(Env.getCtx(), "C_Invoice_ID"));
        miniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "RB_Invoice_ID"));
        miniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "DateInvoiced"));
        miniTable.autoSize();
    }

    private String getOrderSQL() {
        StringBuffer sql = new StringBuffer("SELECT r.RB_Effects_ID, r.duedate,  bp.Name, r.C_BP_BankAccount_ID,b.Name,b.IBAN, r.DiscountAmt, r.c_invoice_id,f.DocumentNo,r.RB_Invoice_ID,r.DateInvoiced FROM (((RB_EFFECTS r ");
        sql.append("LEFT OUTER JOIN C_BPartner bp ON r.C_BPartner_ID=bp.C_BPartner_ID )");
        sql.append("LEFT OUTER JOIN C_BP_BankAccount b ON r.C_BP_BankAccount_ID=b.C_BP_BankAccount_ID) ");
        sql.append("LEFT OUTER JOIN C_Invoice f ON r.C_Invoice_ID=f.C_invoice_ID) ");
        sql.append("WHERE  r.AD_Client_ID=? and r.AD_Org_ID= ?  and Status='NEW' and (r.C_BANK_ID = 0 or r.C_BANK_ID is null) and (r.RB_distinct_number = 0 or r.RB_distinct_number is null)  and TRUNC(r.duedate) >= ?  and TRUNC(r.duedate) <= ? ");
        sql.append(" order by r.duedate , r.c_bpartner_id , r.C_BP_BankAccount_ID");
        return sql.toString();
    }

    public void executeQuery(IMiniTable miniTable) {
        log.info("");
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        int AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        String sql = "";
        if (this.RB_DataScadenzaA == null) {
            this.RB_DataScadenzaA = new Timestamp(System.currentTimeMillis());
        }
        sql = this.getOrderSQL();
        log.fine(sql);
        int row = 0;
        miniTable.setRowCount(row);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Org_ID);
            pstmt.setTimestamp(3, this.RB_DataScadenzaDa);
            pstmt.setTimestamp(4, this.RB_DataScadenzaA);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                miniTable.setRowCount(row + 1);
                miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                miniTable.setValueAt(rs.getTimestamp(2), row, 1);
                miniTable.setValueAt(rs.getString(3), row, 2);
                miniTable.setValueAt(rs.getString(5), row, 3);
                miniTable.setValueAt(rs.getBigDecimal(6), row, 4);
                miniTable.setValueAt(rs.getString(8), row, 5);
                miniTable.setValueAt(rs.getInt(9), row, 6);
                miniTable.setValueAt(rs.getTimestamp(10), row, 1);
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        miniTable.autoSize();
    }

    @Override
    public void saveSelection(IMiniTable miniTable) {
        log.info("");
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.setSelection(null);
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id != null && id.isSelected()) {
                results.add(id.getRecord_ID());
            }
            ++i;
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.setSelection(results);
    }

    public void setC_Bank_ID(Object value) {
        this.m_C_Bank_ID = value;
    }

    public int get_Bank_ID() {
        if (this.m_C_Bank_ID == null) {
            return -1;
        }
        return (Integer)this.m_C_Bank_ID;
    }

    public String generate(IStatusBar statusBar, String docActionSelected) {
        String info = "";
        log.info("C_Bank_ID=" + this.p_C_Bank_ID);
        String trxName = Trx.createTrxName("IOG");
        Trx trx = Trx.get(trxName, true);
        this.setSelectionActive(false);
        statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "CreaDistinta"));
        statusBar.setStatusDB(String.valueOf(this.getSelection().size()));
        int AD_Process_ID = 0;
        AD_Process_ID = 1;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            info = Msg.getMsg(Env.getCtx(), "ProcessNoInstance");
            return info;
        }
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : this.getSelection()) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(instance.getAD_PInstance_ID());
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter != 1000) continue;
            if (DB.executeUpdate(insert.toString(), trxName) < 0) {
                String msg = "No Effetti";
                log.config(msg);
                info = msg;
                trx.rollback();
                return info;
            }
            insert = new StringBuffer();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0 && DB.executeUpdate(insert.toString(), trxName) < 0) {
            String msg = "No Effetti";
            log.config(msg);
            info = msg;
            trx.rollback();
            return info;
        }
        ProcessInfo pi = new ProcessInfo("VCeateDistinct", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        if (!ip.save()) {
            String msg;
            info = msg = "No Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", docActionSelected);
        if (!ip.save()) {
            String msg;
            info = msg = "No DocACtion Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("C_Bank_ID", this.p_C_Bank_ID);
        if (!ip.save()) {
            String msg;
            info = msg = "No Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        this.setTrx(trx);
        this.setProcessInfo(pi);
        return info;
    }
}

