/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MMPJobStandardTask;
import org.compiere.model.MMPMaintain;
import org.compiere.model.MMPOTTask;
import org.compiere.model.Query;
import org.compiere.model.X_MP_JobStandar;
import org.compiere.model.X_MP_JobStandar_Resource;
import org.compiere.model.X_MP_OT;
import org.compiere.model.X_MP_OT_Resource;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class VMPRequestOT
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener,
ASyncProcess {
    private static final long serialVersionUID = -5322824600164192235L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VMPRequestOT.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private CPanel mainPanel = new CPanel();
    private CPanel parameterPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel allocationPanel = new CPanel();
    private MiniTable requestTable = new MiniTable();
    private CPanel infoPanel = new CPanel();
    private int m_A_Asset_ID = 0;
    private int m_Job_ID = 0;
    private CPanel requestPanel = new CPanel();
    private JLabel requestLabel = new JLabel();
    private BorderLayout requestLayout = new BorderLayout();
    private JLabel requestInfo = new JLabel();
    private JScrollPane requestScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton ProcessButton = new JButton();
    private JButton VoidButton = new JButton();
    private JButton searchButton = new JButton();
    private JButton addButton = new JButton();
    private JButton EnableButton = new JButton();
    private JButton ChangeButton = new JButton();
    private JLabel assetLabel = new JLabel();
    private JCheckBox selectall = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private VLookup assetSearch = null;
    private JLabel jobLabel = new JLabel();
    private VLookup jobSearch = null;
    private JButton jobButton = new JButton();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        this.m_C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.dateLabel.setText(Msg.getMsg(Env.getCtx(), "Date"));
        this.dateLabel.setToolTipText(Msg.getMsg(Env.getCtx(), "AllocDate", false));
        this.parameterPanel.setLayout(this.parameterLayout);
        this.allocationPanel.setLayout(this.allocationLayout);
        this.requestLabel.setRequestFocusEnabled(false);
        this.requestLabel.setText(Msg.getMsg(Env.getCtx(), "Request List"));
        this.requestPanel.setLayout(this.requestLayout);
        this.requestInfo.setHorizontalAlignment(4);
        this.requestInfo.setHorizontalTextPosition(4);
        this.requestInfo.setText(".");
        this.differenceLabel.setText(Msg.getMsg(Env.getCtx(), "Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.ProcessButton.setText(Msg.getMsg(Env.getCtx(), "Generate OT"));
        this.ProcessButton.addActionListener(this);
        this.VoidButton.setText(Msg.getMsg(Env.getCtx(), "Chiudi Richiesta"));
        this.VoidButton.addActionListener(this);
        this.searchButton.setText(Msg.getMsg(Env.getCtx(), "Search"));
        this.searchButton.addActionListener(this);
        this.addButton.setText(Msg.getMsg(Env.getCtx(), "Select"));
        this.addButton.addActionListener(this);
        this.EnableButton.setText(Msg.getMsg(Env.getCtx(), "Enable Editing"));
        this.EnableButton.addActionListener(this);
        this.ChangeButton.setText(Msg.getMsg(Env.getCtx(), "Apply Date"));
        this.ChangeButton.addActionListener(this);
        this.jobButton.setText("Assegnazione JobStandard");
        this.jobButton.addActionListener(this);
        this.jobLabel.setText("JobStandard");
        this.assetLabel.setText(Msg.translate(Env.getCtx(), "A_Asset_ID"));
        this.selectall.setText(Msg.getMsg(Env.getCtx(), "Select all"));
        this.selectall.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.requestScrollPane.setPreferredSize(new Dimension(300, 300));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.dateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.ChangeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetSearch, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.selectall, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.jobLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.jobSearch, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.jobButton, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.VoidButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.ProcessButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.requestPanel.add((Component)this.requestLabel, "North");
        this.requestPanel.add((Component)this.requestInfo, "South");
        this.requestPanel.add((Component)this.requestScrollPane, "Center");
        this.requestScrollPane.getViewport().add((Component)this.requestTable, null);
        this.mainPanel.add((Component)this.infoPanel, "Center");
        this.infoPanel.setLayout(new BorderLayout());
        this.infoPanel.add((Component)this.requestPanel, "Center");
        this.infoPanel.setPreferredSize(new Dimension(1000, 450));
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = MColumn.getColumn_ID("MP_Maintain", "A_Asset_ID");
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.assetSearch = new VLookup("A_Asset_ID", true, false, true, lookupBP);
        this.assetSearch.addVetoableChangeListener(this);
        AD_Column_ID = MColumn.getColumn_ID("MP_Maintain", "MP_JobStandar_ID");
        MLookup lookupjob = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.jobSearch = new VLookup("MP_JobStandar_ID", true, false, true, lookupjob);
        this.jobSearch.addVetoableChangeListener(this);
        this.dateField.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.statusBar.setStatusLine("Selezionare Documenti, Variare la data o Generare Ordini Direttamente");
        this.statusBar.setStatusDB("");
        this.loadMPs();
    }

    private void loadMPs() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select rt.DATEDOC,rt.DATEREQUIRED,rt.DOCUMENTNO,rt.MP_OT_REQUEST_ID, rt.AD_Org_ID, rt.AD_User_ID, rt.A_Asset_ID, rt.MP_JOBSTANDAR_ID, rt.Description, u.name, a.name as AssetName, jo.name as jobName,rl.name as PriorityRule, rt.OT_Request_Type from MP_OT_REQUEST rt inner join AD_User u on (rt.AD_User_ID=u.AD_User_ID) inner join A_Asset a on (rt.A_Asset_ID=a.A_Asset_ID) left outer join MP_JOBSTANDAR jo on (rt.MP_JOBSTANDAR_ID=jo.MP_JOBSTANDAR_ID) inner join AD_Ref_List rl on (rt.PriorityRule=rl.value and rl. AD_Reference_ID=154) where rt.DocStatus='WC' and rt.processed='Y'");
        log.config("Prognosis=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            String tipo = new String();
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                if (rs.getString(14).equals("RV")) {
                    tipo = "Revision";
                }
                if (rs.getString(14).equals("RP")) {
                    tipo = "Reparacion";
                }
                if (rs.getString(14).equals("CN")) {
                    tipo = "Completar Niveles";
                }
                line.add(tipo);
                line.add(rs.getTimestamp(2));
                KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(3));
                line.add(pp);
                line.add(rs.getTimestamp(1));
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(6), rs.getString(10));
                line.add(pp2);
                KeyNamePair pp3 = new KeyNamePair(rs.getInt(7), rs.getString(11));
                line.add(pp3);
                line.add(rs.getString(9));
                line.add(rs.getString(13));
                KeyNamePair pp4 = new KeyNamePair(rs.getInt(8), rs.getString(12));
                line.add(pp4);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.requestTable.getModel().removeTableModelListener(this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Selected"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Type"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Date Programed"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Request No"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Date Request"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AD_User_ID"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Asset"));
        columnNames.add("Descripcion");
        columnNames.add(Msg.getMsg(Env.getCtx(), "Priority"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Standard Job"));
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.requestTable.setModel(modelP);
        int i = 0;
        this.requestTable.setColumnClass(i++, Boolean.class, false);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, Timestamp.class, false);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, Timestamp.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.autoSize();
        this.requestTable.setColumnReadOnly(1, false);
        this.calculate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block9: {
            block12: {
                block11: {
                    block10: {
                        block8: {
                            log.config("");
                            if (!e.getSource().equals(this.ProcessButton)) break block8;
                            this.saveData();
                            break block9;
                        }
                        if (!e.getSource().equals(this.jobButton)) break block10;
                        TableModel prognosis = this.requestTable.getModel();
                        int rows = prognosis.getRowCount();
                        X_MP_JobStandar job = new X_MP_JobStandar(Env.getCtx(), this.m_Job_ID, null);
                        int i = 0;
                        while (i < rows) {
                            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                                KeyNamePair pp = new KeyNamePair(job.getMP_JobStandar_ID(), job.getName());
                                prognosis.setValueAt(pp, i, 9);
                            }
                            ++i;
                        }
                        break block9;
                    }
                    if (!e.getSource().equals(this.VoidButton)) break block11;
                    this.voidData();
                    break block9;
                }
                if (!e.getSource().equals(this.ChangeButton)) break block12;
                this.ProcessButton.setEnabled(true);
                TableModel prognosis = this.requestTable.getModel();
                int rows = prognosis.getRowCount();
                Timestamp DateTrx = (Timestamp)this.dateField.getValue();
                int i = 0;
                while (i < rows) {
                    if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                        prognosis.setValueAt(DateTrx, i, 2);
                    }
                    ++i;
                }
                break block9;
            }
            if (!e.getSource().equals(this.selectall)) break block9;
            TableModel prognosis = this.requestTable.getModel();
            int rows = prognosis.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.m_A_Asset_ID == 0) {
                    prognosis.setValueAt(this.selectall.isSelected(), i, 0);
                } else {
                    KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 6);
                    int Asset_ID = pp.getKey();
                    if (Asset_ID == this.m_A_Asset_ID) {
                        prognosis.setValueAt(this.selectall.isSelected(), i, 0);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("A_Asset_ID")) {
            this.assetSearch.setValue(value);
            this.m_A_Asset_ID = (Integer)value;
        } else if (name.equals("MP_JobStandar_ID")) {
            this.jobSearch.setValue(value);
            this.m_Job_ID = (Integer)value;
        }
    }

    private void saveData() {
        TableModel prognosis = this.requestTable.getModel();
        int rows = prognosis.getRowCount();
        Trx trx = Trx.get(Trx.createTrxName("AL"), true);
        int i = 0;
        while (i < rows) {
            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                int Req_ID = pp.getKey();
                pp = (KeyNamePair)prognosis.getValueAt(i, 6);
                int Asset_ID = pp.getKey();
                Timestamp Datetrx = (Timestamp)prognosis.getValueAt(i, 2);
                String description = (String)prognosis.getValueAt(i, 7);
                int job_id = 0;
                if (prognosis.getValueAt(i, 9) != null) {
                    pp = (KeyNamePair)prognosis.getValueAt(i, 9);
                    job_id = pp.getKey();
                }
                if (!this.createOT(job_id, Datetrx, description, Asset_ID, Req_ID)) {
                    log.log(Level.SEVERE, "OT not created #" + i);
                } else {
                    String sql = "Update MP_OT_REQUEST set DocStatus='AP',MP_JobStandar_ID=" + job_id + " where MP_OT_REQUEST_ID=" + Req_ID;
                    DB.executeUpdate(sql);
                }
            }
            ++i;
        }
        this.loadMPs();
    }

    private void voidData() {
        TableModel prognosis = this.requestTable.getModel();
        int rows = prognosis.getRowCount();
        Trx trx = Trx.get(Trx.createTrxName("AL"), true);
        int i = 0;
        while (i < rows) {
            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                int Req_ID = pp.getKey();
                String sql = "Update MP_OT_REQUEST set DocStatus='VO' where MP_OT_REQUEST_ID=" + Req_ID;
                DB.executeUpdate(sql);
            }
            ++i;
        }
        this.loadMPs();
    }

    public boolean createOT(int Job_ID, Timestamp Datetrx, String description, int Asset_ID, int Req_ID) {
        X_MP_OT newOT = new X_MP_OT(Env.getCtx(), 0, null);
        newOT.setDateTrx(Datetrx);
        newOT.setDescription(description);
        newOT.setA_Asset_ID(Asset_ID);
        newOT.setMP_JobStandar_ID(Job_ID);
        newOT.setDocStatus("DR");
        newOT.setDocAction("CO");
        newOT.setMP_OT_Request_ID(Req_ID);
        newOT.setC_DocType_ID(MDocType.getOfDocBaseType(Env.getCtx(), "MOF")[0].getC_DocType_ID());
        if (!newOT.save()) {
            return false;
        }
        return this.createOTTaskDetail(Job_ID, newOT);
    }

    public void lookChilds(int MP_ID, X_MP_OT OT) {
        List list = new Query(Env.getCtx(), "MP_Maintain", "MP_MaintainParent_ID=? AND IsChild=?", null).setParameters(MP_ID, Character.valueOf('Y')).list();
        for (MMPMaintain main : list) {
            this.createOTTaskDetail(main.getMP_Maintain_ID(), OT);
            this.lookChilds(main.getMP_Maintain_ID(), OT);
        }
    }

    public boolean createOTTaskDetail(int Job_ID, X_MP_OT OT) {
        List list = new Query(Env.getCtx(), "MP_JobStandar_Task", "MP_JobStandar_ID=?", null).setParameters(Job_ID).list();
        for (MMPJobStandardTask task : list) {
            MMPOTTask ta = new MMPOTTask(Env.getCtx(), 0, null);
            ta.setAD_Org_ID(task.getAD_Org_ID());
            ta.setMP_OT_ID(OT.getMP_OT_ID());
            ta.setDescription(task.getDescription());
            ta.setDuration(task.getDuration());
            ta.setC_UOM_ID(task.getC_UOM_ID());
            ta.setStatus("NS");
            ta.saveEx();
            this.createOTResourceDetail(task.getMP_JobStandar_Task_ID(), ta.getMP_OT_Task_ID());
        }
        return true;
    }

    public boolean createOTResourceDetail(int oldTask_ID, int newTask_ID) {
        List list = new Query(Env.getCtx(), "MP_JobStandar_Resource", "MP_JobStandar_Task_ID=?", null).setParameters("").list();
        for (X_MP_JobStandar_Resource job : list) {
            X_MP_OT_Resource re = new X_MP_OT_Resource(Env.getCtx(), 0, null);
            re.setAD_Org_ID(job.getAD_Org_ID());
            re.setMP_OT_Task_ID(newTask_ID);
            re.setCostAmt(job.getCostAmt());
            re.setS_Resource_ID(job.getS_Resource_ID());
            re.setM_BOM_ID(job.getM_BOM_ID());
            re.setResourceQty(job.getResourceQty());
            re.setResourceType(job.getResourceType());
            re.set_ValueOfColumn("M_Product_ID", (Object)job.getM_Product_ID());
            re.saveEx();
        }
        return true;
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public boolean isUILocked() {
        return this.isEnabled();
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }
}

