/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPGenerateOT;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class VMPGenerateOT
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener,
ASyncProcess {
    private static final long serialVersionUID = -5322824600164192235L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VMPGenerateOT.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private CPanel mainPanel = new CPanel();
    private CPanel parameterPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel allocationPanel = new CPanel();
    private MiniTable prognosisTable = new MiniTable();
    private CPanel infoPanel = new CPanel();
    private int m_A_Asset_ID = 0;
    private CPanel prognosisPanel = new CPanel();
    private CPanel selectedPanel = new CPanel();
    private JLabel prognosisLabel = new JLabel();
    private JLabel selectedLabel = new JLabel();
    private BorderLayout prognosisLayout = new BorderLayout();
    private BorderLayout selectedLayout = new BorderLayout();
    private JLabel prognosisInfo = new JLabel();
    private JScrollPane prognosisScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton ProcessButton = new JButton();
    private JButton searchButton = new JButton();
    private JButton addButton = new JButton();
    private JButton EnableButton = new JButton();
    private JButton ChangeButton = new JButton();
    private JLabel assetLabel = new JLabel();
    private JCheckBox selectall = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private VLookup assetSearch = null;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        this.m_C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.dateLabel.setText(Msg.getMsg(Env.getCtx(), "Date"));
        this.dateLabel.setToolTipText(Msg.getMsg(Env.getCtx(), "AllocDate", false));
        this.parameterPanel.setLayout(this.parameterLayout);
        this.allocationPanel.setLayout(this.allocationLayout);
        this.prognosisLabel.setRequestFocusEnabled(false);
        this.prognosisLabel.setText(Msg.getMsg(Env.getCtx(), "List of Mps"));
        this.selectedLabel.setRequestFocusEnabled(false);
        this.selectedLabel.setText(Msg.getMsg(Env.getCtx(), "Selected"));
        this.prognosisPanel.setLayout(this.prognosisLayout);
        this.selectedPanel.setLayout(this.selectedLayout);
        this.prognosisInfo.setHorizontalAlignment(4);
        this.prognosisInfo.setHorizontalTextPosition(4);
        this.prognosisInfo.setText(".");
        this.differenceLabel.setText(Msg.getMsg(Env.getCtx(), "Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.ProcessButton.setText(Msg.getMsg(Env.getCtx(), "Generate OT"));
        this.ProcessButton.addActionListener(this);
        this.searchButton.setText(Msg.getMsg(Env.getCtx(), "Search"));
        this.searchButton.addActionListener(this);
        this.addButton.setText(Msg.getMsg(Env.getCtx(), "Add Selected"));
        this.addButton.addActionListener(this);
        this.EnableButton.setText(Msg.getMsg(Env.getCtx(), "Enable Edition"));
        this.EnableButton.addActionListener(this);
        this.ChangeButton.setText(Msg.getMsg(Env.getCtx(), "Apply Date"));
        this.ChangeButton.addActionListener(this);
        this.assetLabel.setText(Msg.translate(Env.getCtx(), "A_Asset_ID"));
        this.selectall.setText(Msg.getMsg(Env.getCtx(), "Select All"));
        this.selectall.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.prognosisScrollPane.setPreferredSize(new Dimension(300, 300));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.dateLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.ChangeButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.selectall, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetSearch, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.ProcessButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.prognosisPanel.add((Component)this.prognosisLabel, "North");
        this.prognosisPanel.add((Component)this.prognosisInfo, "South");
        this.prognosisPanel.add((Component)this.prognosisScrollPane, "Center");
        this.prognosisScrollPane.getViewport().add((Component)this.prognosisTable, null);
        this.mainPanel.add((Component)this.infoPanel, "Center");
        this.infoPanel.setLayout(new BorderLayout());
        this.infoPanel.add((Component)this.prognosisPanel, "Center");
        this.infoPanel.setPreferredSize(new Dimension(1000, 450));
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = MColumn.getColumn_ID("MP_Maintain", "A_Asset_ID");
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.assetSearch = new VLookup("A_Asset_ID", true, false, true, lookupBP);
        this.assetSearch.addVetoableChangeListener(this);
        this.dateField.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.statusBar.setStatusLine("Selezionare Documenti, Variare la data o Generare Ordini Direttamente");
        this.statusBar.setStatusDB("");
        this.loadMPs();
    }

    private void loadMPs() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select p.AD_PINSTANCE_ID,p.AD_CLIENT_ID,p.AD_ORG_ID,p.A_ASSET_ID,p.MP_MAINTAIN_ID,p.DESCRIPTION,p.PROGRAMMINGTYPE,p.CICLO,p.DATETRX,mp.DOCUMENTNO||'-'||mp.Description as MP_name,a.name as assetname   from MP_Prognosis p Inner Join MP_MainTain mp on (p.MP_MAINTAIN_ID=mp.MP_MAINTAIN_ID) Inner Join A_Asset a on (p.A_ASSET_ID=a.A_ASSET_ID) where p.Processed='N' and p.Selected='N'  order by p.DATETRX asc");
        log.config("Prognosis=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getInt(8));
                line.add(rs.getTimestamp(9));
                KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(11));
                line.add(pp);
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(5), rs.getString(10));
                line.add(pp2);
                line.add(rs.getString(7));
                line.add(rs.getString(6));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.prognosisTable.getModel().removeTableModelListener(this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Selezione");
        columnNames.add(Msg.getMsg(Env.getCtx(), "Cycle"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "Asset")));
        columnNames.add(Msg.getMsg(Env.getCtx(), "MP"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Programing Type"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Description"));
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.prognosisTable.setModel(modelP);
        int i = 0;
        this.prognosisTable.setColumnClass(i++, Boolean.class, false);
        this.prognosisTable.setColumnClass(i++, Integer.class, true);
        this.prognosisTable.setColumnClass(i++, Timestamp.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.autoSize();
        this.prognosisTable.setColumnReadOnly(1, false);
        this.calculate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        log.config("");
                        if (!e.getSource().equals(this.ProcessButton)) break block6;
                        this.saveData();
                        break block7;
                    }
                    if (!e.getSource().equals(this.EnableButton)) break block8;
                    this.prognosisTable.setColumnReadOnly(1, false);
                    this.prognosisTable.setColumnReadOnly(2, false);
                    this.prognosisTable.setColumnReadOnly(3, false);
                    break block7;
                }
                if (!e.getSource().equals(this.ChangeButton)) break block9;
                this.ProcessButton.setEnabled(true);
                TableModel prognosis = this.prognosisTable.getModel();
                int rows = prognosis.getRowCount();
                Timestamp DateTrx = (Timestamp)this.dateField.getValue();
                int i = 0;
                while (i < rows) {
                    if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                        prognosis.setValueAt(DateTrx, i, 2);
                    }
                    ++i;
                }
                break block7;
            }
            if (!e.getSource().equals(this.selectall)) break block7;
            TableModel prognosis = this.prognosisTable.getModel();
            int rows = prognosis.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.m_A_Asset_ID == 0) {
                    prognosis.setValueAt(this.selectall.isSelected(), i, 0);
                } else {
                    KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                    int Asset_ID = pp.getKey();
                    if (Asset_ID == this.m_A_Asset_ID) {
                        prognosis.setValueAt(this.selectall.isSelected(), i, 0);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("A_Asset_ID")) {
            this.assetSearch.setValue(value);
            this.m_A_Asset_ID = (Integer)value;
        }
    }

    private void saveData() {
        MPGenerateOT mp = new MPGenerateOT();
        TableModel prognosis = this.prognosisTable.getModel();
        int rows = prognosis.getRowCount();
        int i = 0;
        while (i < rows) {
            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 4);
                int MP_ID = pp.getKey();
                pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                int Asset_ID = pp.getKey();
                Timestamp Datetrx = (Timestamp)prognosis.getValueAt(i, 2);
                String description = (String)prognosis.getValueAt(i, 6);
                int ciclo = (Integer)prognosis.getValueAt(i, 1);
                String ProgramingType = (String)prognosis.getValueAt(i, 5);
                if (!mp.createOT(MP_ID, Datetrx, description, Asset_ID, null)) {
                    log.log(Level.SEVERE, "OT not created #" + i);
                } else {
                    mp.updateMP(MP_ID, Datetrx, description);
                    String sql = "Update MP_Prognosis set Processed='Y' where ciclo=" + ciclo + " and MP_MAINTAIN_ID=" + MP_ID + " and A_Asset_ID=" + Asset_ID + " and PROGRAMMINGTYPE='" + ProgramingType + "'";
                    DB.executeUpdate(sql);
                }
            }
            ++i;
        }
        this.loadMPs();
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public boolean isUILocked() {
        return this.isEnabled();
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }
}

