/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.DistintaManuale;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MClient;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.ASyncProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.jfree.util.Log;

public class VDistintaManuale
extends DistintaManuale
implements FormPanel,
ActionListener,
TableModelListener,
ASyncProcess {
    public static final String RBEFFECTS_TABLE_NAME = "RB_Effects";
    public static final String PRINTFORMAT_NAME = "WSC_Genera_distinta";
    private static int s_iAD_Table_ID_RBEffects = -1;
    private static int s_iAD_Print_Format = -1;
    private CPanel panel = new CPanel();
    private FormFrame m_frame;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel newPanel = new CPanel();
    private TitledBorder newBorder;
    private GridBagLayout newLayout = new GridBagLayout();
    private CLabel cBanckLabel = new CLabel();
    private VComboBox cBanckField = new VComboBox();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel dataStatus = new JLabel();
    private JScrollPane dataPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private CPanel commandPanel = new CPanel();
    private TitledBorder accountBorder;
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private JButton bGenerate = ConfirmPanel.createProcessButton(true);
    private FlowLayout commandLayout = new FlowLayout();
    private JButton bRefresh = ConfirmPanel.createRefreshButton(true);
    private CLabel dataDistintaLabel = new CLabel();
    private VDate dataDistintaField = new VDate();
    private JLabel scadenzadaLabel = new JLabel();
    private VDate scadenzadaField = new VDate();
    private JLabel scadenzaaLabel = new JLabel();
    private VDate scadenzaaField = new VDate();
    private JLabel dataDocdaLabel = new JLabel();
    private VDate dataDocdaField = new VDate();
    private JLabel dataDocaLabel = new JLabel();
    private VDate dataDocaField = new VDate();
    private MiniTable dataTable = new MiniTable();
    private JLabel ndistintaLabel = new JLabel();
    private VNumber ndistintaField = new VNumber();
    private AbstractButton parameterPanel;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.commandPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.panel);
        this.mainPanel.setLayout(this.mainLayout);
        this.newPanel.setLayout(this.parameterLayout);
        this.newBorder = new TitledBorder("");
        this.accountBorder = new TitledBorder("");
        this.mainPanel.setLayout(this.mainLayout);
        this.newPanel.setLayout(this.parameterLayout);
        this.newPanel.setBorder(this.newBorder);
        this.newPanel.setLayout(this.newLayout);
        this.newBorder.setTitle("CreaDistinta");
        this.cBanckLabel.setText(Msg.translate(Env.getCtx(), "C_Bank_ID"));
        this.cBanckField.addActionListener(this);
        this.bRefresh.addActionListener(this);
        this.dataDistintaLabel.setText("DataDistinta");
        this.dataDistintaField.addActionListener(this);
        this.ndistintaLabel.setText("Numero");
        this.ndistintaField.addActionListener(this);
        this.scadenzadaLabel.setText("Scadenza Dal");
        this.scadenzadaField.addActionListener(this);
        this.scadenzaaLabel.setText("Scadenza A");
        this.scadenzaaField.addActionListener(this);
        this.dataDocdaLabel.setText("Data Fattura Dal");
        this.dataDocdaField.addActionListener(this);
        this.dataDocaLabel.setText("Data Fattura A");
        this.dataDocaField.addActionListener(this);
        this.bGenerate.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.mainPanel.add((Component)this.newPanel, "North");
        this.newPanel.add((Component)this.cBanckLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.cBanckField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.dataDistintaLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.dataDistintaField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.newPanel.add((Component)this.ndistintaLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.ndistintaField, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.scadenzadaLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.scadenzadaField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.dataDocdaLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.dataDocdaField, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.scadenzaaLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.scadenzaaField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.dataDocaLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.dataDocaField, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.bRefresh, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.dataStatus, "South");
        this.mainPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.miniTable, null);
        this.commandPanel.setLayout(this.commandLayout);
        this.commandLayout.setAlignment(2);
        this.commandLayout.setHgap(10);
        this.commandPanel.add((Component)this.bCancel, null);
        this.commandPanel.add((Component)this.bGenerate, null);
    }

    @Override
    public void dynInit() throws Exception {
        ArrayList<DistintaManuale.BankInfo> bankAccountData = this.getBankAccountData();
        for (DistintaManuale.BankInfo bi : bankAccountData) {
            this.cBanckField.addItem(bi);
        }
        if (this.cBanckField.getItemCount() == 0) {
            ADialog.error(this.m_WindowNo, this.panel, "VDistintaManuale");
        } else {
            this.cBanckField.setSelectedIndex(0);
        }
        this.dataDistintaField.setMandatory(true);
        this.dataDistintaField.setValue(new Timestamp(System.currentTimeMillis()));
        this.scadenzadaField.setMandatory(true);
        this.scadenzadaField.setValue(new Timestamp(System.currentTimeMillis()));
        this.scadenzaaField.setMandatory(true);
        this.scadenzaaField.setValue(Timestamp.valueOf("2070-12-31 24:59:59"));
        this.dataDocdaField.setMandatory(true);
        this.dataDocdaField.setValue(Timestamp.valueOf("2001-01-01 00:00:00"));
        this.dataDocaField.setMandatory(true);
        this.dataDocaField.setValue(Timestamp.valueOf("2070-12-31 24:59:59"));
        this.prepareTable(this.miniTable);
        this.miniTable.getModel().addTableModelListener(this);
    }

    private void loadTableInfo() {
        Timestamp distDate = (Timestamp)this.dataDistintaField.getValue();
        this.miniTable.setColorCompare(distDate);
        log.config("distDate=" + distDate);
        Timestamp DateDa = (Timestamp)this.scadenzadaField.getValue();
        this.miniTable.setColorCompare(DateDa);
        log.config("DateScadDa=" + DateDa);
        Timestamp Datea = (Timestamp)this.scadenzaaField.getValue();
        this.miniTable.setColorCompare(Datea);
        log.config("DateScada=" + Datea);
        Timestamp DataDocDa = (Timestamp)this.dataDocdaField.getValue();
        this.miniTable.setColorCompare(DataDocDa);
        log.config("DataDocDa=" + DataDocDa);
        Timestamp DataDoca = (Timestamp)this.dataDocaField.getValue();
        this.miniTable.setColorCompare(DataDoca);
        log.config("DataDoca=" + DataDoca);
        DistintaManuale.BankInfo bi = (DistintaManuale.BankInfo)this.cBanckField.getSelectedItem();
        this.loadTableInfo(bi, DateDa, Datea, DataDocDa, DataDoca, this.miniTable);
        this.calculateSelection();
    }

    private void loadBankInfo() {
        DistintaManuale.BankInfo bi = (DistintaManuale.BankInfo)this.cBanckField.getSelectedItem();
        if (bi == null) {
            return;
        }
        BigDecimal num = this.cercaDistinta(bi);
        this.ndistintaField.setValue(num);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cBanckField) {
            this.loadBankInfo();
        } else if (e.getSource() == this.bGenerate) {
            this.generateDistSelect();
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.dataDocaField || e.getSource() == this.bRefresh) {
            this.loadTableInfo();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == 0) {
            this.calculateSelection();
        }
    }

    public void calculateSelection() {
        this.dataStatus.setText(this.calculateSelection(this.miniTable));
        this.bGenerate.setEnabled(this.m_noSelected != 0);
    }

    private void generateDistSelect() {
        this.miniTable.stopEditor(true);
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.miniTable.setRowSelectionInterval(0, 0);
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        BigDecimal NumDist = (BigDecimal)this.ndistintaField.getValue();
        String msg = this.generateDistSelect(this.miniTable, this.dataDistintaField.getTimestamp(), (DistintaManuale.BankInfo)this.cBanckField.getSelectedItem(), NumDist);
        if (msg != null && msg.length() > 0) {
            ADialog.error(this.m_WindowNo, this.panel, "SaveError", msg);
            return;
        }
        this.postProcesso(this.dataDistintaField.getTimestamp(), (DistintaManuale.BankInfo)this.cBanckField.getSelectedItem(), NumDist);
    }

    protected void postProcesso(Timestamp dataDistintaField, DistintaManuale.BankInfo bi, BigDecimal NumDist) {
        MClient client = MClient.get(Env.getCtx());
        if (s_iAD_Table_ID_RBEffects < 0) {
            MTable mTableEffects = MTable.get(Env.getCtx(), RBEFFECTS_TABLE_NAME);
            s_iAD_Table_ID_RBEffects = mTableEffects.getAD_Table_ID();
        }
        if (s_iAD_Print_Format < 0) {
            s_iAD_Print_Format = MPrintFormat.getPrintFormat_ID(PRINTFORMAT_NAME, s_iAD_Table_ID_RBEffects, client.getAD_Client_ID());
        }
        int p_Banck_id = bi.C_Bank_ID;
        int p_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        String sqlx = " RB_Effects.Status='PRT' ";
        sqlx = String.valueOf(sqlx) + " and RB_Effects.C_BANK_ID = " + p_Banck_id;
        sqlx = String.valueOf(sqlx) + " and RB_Effects.RB_distinct_number = " + NumDist;
        sqlx = String.valueOf(sqlx) + " and RB_Effects.AD_Org_ID = " + p_AD_Org_ID;
        int rb_effects_ID = 0;
        MPrintFormat format = null;
        int C_BPartner_ID = 0;
        int copies = 1;
        if (copies == 0) {
            copies = 1;
        }
        String DocumentNo = "Distinta";
        String documentDir = client.getDocumentDir();
        if (documentDir == null || documentDir.length() == 0) {
            documentDir = ".";
        }
        MQuery query = new MQuery(RBEFFECTS_TABLE_NAME);
        query.addRestriction(sqlx);
        PrintInfo info = new PrintInfo(DocumentNo, s_iAD_Table_ID_RBEffects, rb_effects_ID, C_BPartner_ID);
        info.setCopies(copies);
        if (s_iAD_Print_Format == 0) {
            Log.info((Object)(rb_effects_ID + " " + DocumentNo + " No Print Format"));
        } else {
            format = MPrintFormat.get(Env.getCtx(), s_iAD_Print_Format, false);
        }
        ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info);
        ReportCtl.preview(re);
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.panel.setEnabled(false);
        this.m_isLocked = true;
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
    }

    @Override
    public boolean isUILocked() {
        return this.m_isLocked;
    }

    @Override
    public void executeASync(ProcessInfo pi) {
        log.config("-");
    }
}

